// Copyright 2024-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/plugin/check/v1/annotation.proto

//go:build !protoopaque

package checkv1

import (
	v1 "buf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/descriptor/v1"
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An annotation representing a Rule failure.
//
// Annotations are propagated back to Buf and returned as lint or breaking change failures.
type Annotation struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The ID of the Rule that failed.
	//
	// Required.
	//
	// This must match an ID that the plugin has declared via its list rules RPC.
	RuleId string `protobuf:"bytes,1,opt,name=rule_id,json=ruleId,proto3" json:"rule_id,omitempty"`
	// A user-displayable message that explains the rule failure.
	//
	// Optional.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// The location of the failure in a FileDescriptor within the file_descriptors list.
	//
	// Optional.
	FileLocation *v1.FileLocation `protobuf:"bytes,3,opt,name=file_location,json=fileLocation,proto3" json:"file_location,omitempty"`
	// The location of the failure in a FileDescriptor in the against_file_descriptors list.
	//
	// Optional.
	//
	// This may be present even if file_location is not present. For example, if a file was deleted,
	// this may reference the deleted FileDescriptor in against_file_descriptors, while file_location
	// will not be present.
	AgainstFileLocation *v1.FileLocation `protobuf:"bytes,4,opt,name=against_file_location,json=againstFileLocation,proto3" json:"against_file_location,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Annotation) Reset() {
	*x = Annotation{}
	mi := &file_buf_plugin_check_v1_annotation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotation) ProtoMessage() {}

func (x *Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_annotation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Annotation) GetRuleId() string {
	if x != nil {
		return x.RuleId
	}
	return ""
}

func (x *Annotation) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Annotation) GetFileLocation() *v1.FileLocation {
	if x != nil {
		return x.FileLocation
	}
	return nil
}

func (x *Annotation) GetAgainstFileLocation() *v1.FileLocation {
	if x != nil {
		return x.AgainstFileLocation
	}
	return nil
}

func (x *Annotation) SetRuleId(v string) {
	x.RuleId = v
}

func (x *Annotation) SetMessage(v string) {
	x.Message = v
}

func (x *Annotation) SetFileLocation(v *v1.FileLocation) {
	x.FileLocation = v
}

func (x *Annotation) SetAgainstFileLocation(v *v1.FileLocation) {
	x.AgainstFileLocation = v
}

func (x *Annotation) HasFileLocation() bool {
	if x == nil {
		return false
	}
	return x.FileLocation != nil
}

func (x *Annotation) HasAgainstFileLocation() bool {
	if x == nil {
		return false
	}
	return x.AgainstFileLocation != nil
}

func (x *Annotation) ClearFileLocation() {
	x.FileLocation = nil
}

func (x *Annotation) ClearAgainstFileLocation() {
	x.AgainstFileLocation = nil
}

type Annotation_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the Rule that failed.
	//
	// Required.
	//
	// This must match an ID that the plugin has declared via its list rules RPC.
	RuleId string
	// A user-displayable message that explains the rule failure.
	//
	// Optional.
	Message string
	// The location of the failure in a FileDescriptor within the file_descriptors list.
	//
	// Optional.
	FileLocation *v1.FileLocation
	// The location of the failure in a FileDescriptor in the against_file_descriptors list.
	//
	// Optional.
	//
	// This may be present even if file_location is not present. For example, if a file was deleted,
	// this may reference the deleted FileDescriptor in against_file_descriptors, while file_location
	// will not be present.
	AgainstFileLocation *v1.FileLocation
}

func (b0 Annotation_builder) Build() *Annotation {
	m0 := &Annotation{}
	b, x := &b0, m0
	_, _ = b, x
	x.RuleId = b.RuleId
	x.Message = b.Message
	x.FileLocation = b.FileLocation
	x.AgainstFileLocation = b.AgainstFileLocation
	return m0
}

var File_buf_plugin_check_v1_annotation_proto protoreflect.FileDescriptor

const file_buf_plugin_check_v1_annotation_proto_rawDesc = "" +
	"\n" +
	"$buf/plugin/check/v1/annotation.proto\x12\x13buf.plugin.check.v1\x1a,buf/plugin/descriptor/v1/file_location.proto\x1a\x1bbuf/validate/validate.proto\"\x94\x02\n" +
	"\n" +
	"Annotation\x12C\n" +
	"\arule_id\x18\x01 \x01(\tB*\xbaH'\xc8\x01\x01r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\x06ruleId\x12\x18\n" +
	"\amessage\x18\x02 \x01(\tR\amessage\x12K\n" +
	"\rfile_location\x18\x03 \x01(\v2&.buf.plugin.descriptor.v1.FileLocationR\ffileLocation\x12Z\n" +
	"\x15against_file_location\x18\x04 \x01(\v2&.buf.plugin.descriptor.v1.FileLocationR\x13againstFileLocationBTZRbuf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/check/v1;checkv1b\x06proto3"

var file_buf_plugin_check_v1_annotation_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_plugin_check_v1_annotation_proto_goTypes = []any{
	(*Annotation)(nil),      // 0: buf.plugin.check.v1.Annotation
	(*v1.FileLocation)(nil), // 1: buf.plugin.descriptor.v1.FileLocation
}
var file_buf_plugin_check_v1_annotation_proto_depIdxs = []int32{
	1, // 0: buf.plugin.check.v1.Annotation.file_location:type_name -> buf.plugin.descriptor.v1.FileLocation
	1, // 1: buf.plugin.check.v1.Annotation.against_file_location:type_name -> buf.plugin.descriptor.v1.FileLocation
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_buf_plugin_check_v1_annotation_proto_init() }
func file_buf_plugin_check_v1_annotation_proto_init() {
	if File_buf_plugin_check_v1_annotation_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_plugin_check_v1_annotation_proto_rawDesc), len(file_buf_plugin_check_v1_annotation_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_plugin_check_v1_annotation_proto_goTypes,
		DependencyIndexes: file_buf_plugin_check_v1_annotation_proto_depIdxs,
		MessageInfos:      file_buf_plugin_check_v1_annotation_proto_msgTypes,
	}.Build()
	File_buf_plugin_check_v1_annotation_proto = out.File
	file_buf_plugin_check_v1_annotation_proto_goTypes = nil
	file_buf_plugin_check_v1_annotation_proto_depIdxs = nil
}
