"""
Display salt-key output
=======================

The ``salt-key`` command makes use of this outputter to format its output.
"""

import salt.output
import salt.transport
import salt.utils.color
import salt.utils.data


def output(data, **kwargs):  # pylint: disable=unused-argument
    """
    Read in the dict structure generated by the salt key API methods and
    print the structure.
    """
    color = salt.utils.color.get_colors(
        __opts__.get("color"), __opts__.get("color_theme")
    )
    strip_colors = __opts__.get("strip_colors", True)
    ident = 0
    if __opts__.get("__multi_key"):
        ident = 4
    if __opts__["transport"] in salt.transport.TRANSPORTS:
        acc = "minions"
        pend = "minions_pre"
        den = "minions_denied"
        rej = "minions_rejected"

        cmap = {
            pend: color["RED"],
            acc: color["GREEN"],
            den: color["MAGENTA"],
            rej: color["BLUE"],
            "local": color["MAGENTA"],
        }

        trans = {
            pend: "{}{}Unaccepted Keys:{}".format(
                " " * ident, color["LIGHT_RED"], color["ENDC"]
            ),
            acc: "{}{}Accepted Keys:{}".format(
                " " * ident, color["LIGHT_GREEN"], color["ENDC"]
            ),
            den: "{}{}Denied Keys:{}".format(
                " " * ident, color["LIGHT_MAGENTA"], color["ENDC"]
            ),
            rej: "{}{}Rejected Keys:{}".format(
                " " * ident, color["LIGHT_BLUE"], color["ENDC"]
            ),
            "local": "{}{}Local Keys:{}".format(
                " " * ident, color["LIGHT_MAGENTA"], color["ENDC"]
            ),
        }
    else:
        acc = "accepted"
        pend = "pending"
        rej = "rejected"

        cmap = {
            pend: color["RED"],
            acc: color["GREEN"],
            rej: color["BLUE"],
            "local": color["MAGENTA"],
        }

        trans = {
            pend: "{}{}Unaccepted Keys:{}".format(
                " " * ident, color["LIGHT_RED"], color["ENDC"]
            ),
            acc: "{}{}Accepted Keys:{}".format(
                " " * ident, color["LIGHT_GREEN"], color["ENDC"]
            ),
            rej: "{}{}Rejected Keys:{}".format(
                " " * ident, color["LIGHT_BLUE"], color["ENDC"]
            ),
            "local": "{}{}Local Keys:{}".format(
                " " * ident, color["LIGHT_MAGENTA"], color["ENDC"]
            ),
        }

    ret = ""

    for status in sorted(data):
        ret += "{}\n".format(trans[status])
        for key in sorted(data[status]):
            key = salt.utils.data.decode(key)
            skey = salt.output.strip_esc_sequence(key) if strip_colors else key
            if isinstance(data[status], list):
                ret += "{}{}{}{}\n".format(
                    " " * ident, cmap[status], skey, color["ENDC"]
                )
            if isinstance(data[status], dict):
                ret += "{}{}{}:  {}{}\n".format(
                    " " * ident, cmap[status], skey, data[status][key], color["ENDC"]
                )
    return ret
