import type { ComponentType, Ref } from 'react';
import type { GroupBase, Props as SelectProps, SelectInstance } from 'react-select';
import { useAsyncPaginate } from './useAsyncPaginate';
import { useComponents } from './useComponents';
import type { AsyncPaginateProps, WithAsyncPaginateType } from './types';
export declare type Props<OptionType, Group extends GroupBase<OptionType>, Additional, IsMulti extends boolean> = AsyncPaginateProps<OptionType, Group, Additional, IsMulti> & {
    useComponents?: typeof useComponents;
    useAsyncPaginate?: typeof useAsyncPaginate;
};
export declare function withAsyncPaginate(SelectComponent: ComponentType<SelectProps<any, boolean, any> & {
    ref?: Ref<SelectInstance<any, boolean, any>>;
}>): WithAsyncPaginateType;
