"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapMenuList = exports.CHECK_TIMEOUT = void 0;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _react = require("react");

var _composeReactRefs = _interopRequireDefault(require("@seznam/compose-react-refs"));

var _jsxRuntime = require("react/jsx-runtime");

var CHECK_TIMEOUT = 300;
exports.CHECK_TIMEOUT = CHECK_TIMEOUT;

// eslint-disable-next-line @typescript-eslint/naming-convention
var wrapMenuList = function wrapMenuList(MenuList) {
  var WrappedMenuList = function WrappedMenuList(props) {
    var _props$selectProps = props.selectProps,
        handleScrolledToBottom = _props$selectProps.handleScrolledToBottom,
        shouldLoadMore = _props$selectProps.shouldLoadMore,
        innerRef = props.innerRef,
        useEffectProp = props.useEffect,
        useRefProp = props.useRef,
        useCallbackProp = props.useCallback,
        setTimeoutProp = props.setTimeout,
        clearTimeoutProp = props.clearTimeout;
    var checkTimeoutRef = useRefProp(null);
    var menuListRef = useRefProp(null);
    var shouldHandle = useCallbackProp(function () {
      var el = menuListRef.current; // menu not rendered

      if (!el) {
        return false;
      }

      var scrollTop = el.scrollTop,
          scrollHeight = el.scrollHeight,
          clientHeight = el.clientHeight;
      return shouldLoadMore(scrollHeight, clientHeight, scrollTop);
    }, [shouldLoadMore]);
    var checkAndHandle = useCallbackProp(function () {
      if (shouldHandle()) {
        if (handleScrolledToBottom) {
          handleScrolledToBottom();
        }
      }
    }, [shouldHandle, handleScrolledToBottom]);
    var setCheckAndHandleTimeout = useCallbackProp(function () {
      checkAndHandle();
      checkTimeoutRef.current = setTimeoutProp(setCheckAndHandleTimeout, CHECK_TIMEOUT);
    }, [checkAndHandle]);
    useEffectProp(function () {
      setCheckAndHandleTimeout();
      return function () {
        if (checkTimeoutRef.current) {
          clearTimeoutProp(checkTimeoutRef.current);
        }
      };
    }, []);
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(MenuList, (0, _objectSpread2["default"])((0, _objectSpread2["default"])({}, props), {}, {
      innerRef: (0, _composeReactRefs["default"])(innerRef, menuListRef)
    }));
  };

  WrappedMenuList.defaultProps = {
    useEffect: _react.useEffect,
    useRef: _react.useRef,
    useCallback: _react.useCallback,
    setTimeout: setTimeout,
    clearTimeout: clearTimeout
  };
  return WrappedMenuList;
};

exports.wrapMenuList = wrapMenuList;