'use strict';

module.exports = {
    ach: {
        name: 'Acholi',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    af: {
        name: 'Afrikaans',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ak: {
        name: 'Akan',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    am: {
        name: 'Amharic',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    an: {
        name: 'Aragonese',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ar: {
        name: 'Arabic',
        examples: [{
            plural: 0,
            sample: 0
        }, {
            plural: 1,
            sample: 1
        }, {
            plural: 2,
            sample: 2
        }, {
            plural: 3,
            sample: 3
        }, {
            plural: 4,
            sample: 11
        }, {
            plural: 5,
            sample: 100
        }],
        nplurals: 6,
        pluralsText: 'nplurals = 6; plural = (n === 0 ? 0 : n === 1 ? 1 : n === 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5)',
        pluralsFunc: function(n) {
            return (n === 0 ? 0 : n === 1 ? 1 : n === 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5);
        }
    },
    arn: {
        name: 'Mapudungun',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    ast: {
        name: 'Asturian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ay: {
        name: 'Aymará',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    az: {
        name: 'Azerbaijani',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    be: {
        name: 'Belarusian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    bg: {
        name: 'Bulgarian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    bn: {
        name: 'Bengali',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    bo: {
        name: 'Tibetan',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    br: {
        name: 'Breton',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    brx: {
        name: 'Bodo',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    bs: {
        name: 'Bosnian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    ca: {
        name: 'Catalan',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    cgg: {
        name: 'Chiga',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    cs: {
        name: 'Czech',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n === 1 ? 0 : (n >= 2 && n <= 4) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : (n >= 2 && n <= 4) ? 1 : 2);
        }
    },
    csb: {
        name: 'Kashubian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n === 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    cy: {
        name: 'Welsh',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 3
        }, {
            plural: 3,
            sample: 8
        }],
        nplurals: 4,
        pluralsText: 'nplurals = 4; plural = (n === 1 ? 0 : n === 2 ? 1 : (n !== 8 && n !== 11) ? 2 : 3)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : n === 2 ? 1 : (n !== 8 && n !== 11) ? 2 : 3);
        }
    },
    da: {
        name: 'Danish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    de: {
        name: 'German',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    doi: {
        name: 'Dogri',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    dz: {
        name: 'Dzongkha',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    el: {
        name: 'Greek',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    en: {
        name: 'English',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    eo: {
        name: 'Esperanto',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    es: {
        name: 'Spanish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    et: {
        name: 'Estonian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    eu: {
        name: 'Basque',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    fa: {
        name: 'Persian',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    ff: {
        name: 'Fulah',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    fi: {
        name: 'Finnish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    fil: {
        name: 'Filipino',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    fo: {
        name: 'Faroese',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    fr: {
        name: 'French',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    fur: {
        name: 'Friulian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    fy: {
        name: 'Frisian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ga: {
        name: 'Irish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 3
        }, {
            plural: 3,
            sample: 7
        }, {
            plural: 4,
            sample: 11
        }],
        nplurals: 5,
        pluralsText: 'nplurals = 5; plural = (n === 1 ? 0 : n === 2 ? 1 : n < 7 ? 2 : n < 11 ? 3 : 4)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : n === 2 ? 1 : n < 7 ? 2 : n < 11 ? 3 : 4);
        }
    },
    gd: {
        name: 'Scottish Gaelic',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 3
        }, {
            plural: 3,
            sample: 20
        }],
        nplurals: 4,
        pluralsText: 'nplurals = 4; plural = ((n === 1 || n === 11) ? 0 : (n === 2 || n === 12) ? 1 : (n > 2 && n < 20) ? 2 : 3)',
        pluralsFunc: function(n) {
            return ((n === 1 || n === 11) ? 0 : (n === 2 || n === 12) ? 1 : (n > 2 && n < 20) ? 2 : 3);
        }
    },
    gl: {
        name: 'Galician',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    gu: {
        name: 'Gujarati',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    gun: {
        name: 'Gun',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    ha: {
        name: 'Hausa',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    he: {
        name: 'Hebrew',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    hi: {
        name: 'Hindi',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    hne: {
        name: 'Chhattisgarhi',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    hr: {
        name: 'Croatian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    hu: {
        name: 'Hungarian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    hy: {
        name: 'Armenian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    id: {
        name: 'Indonesian',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    is: {
        name: 'Icelandic',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n % 10 !== 1 || n % 100 === 11)',
        pluralsFunc: function(n) {
            return (n % 10 !== 1 || n % 100 === 11);
        }
    },
    it: {
        name: 'Italian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ja: {
        name: 'Japanese',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    jbo: {
        name: 'Lojban',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    jv: {
        name: 'Javanese',
        examples: [{
            plural: 0,
            sample: 0
        }, {
            plural: 1,
            sample: 1
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 0)',
        pluralsFunc: function(n) {
            return (n !== 0);
        }
    },
    ka: {
        name: 'Georgian',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    kk: {
        name: 'Kazakh',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    km: {
        name: 'Khmer',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    kn: {
        name: 'Kannada',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ko: {
        name: 'Korean',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    ku: {
        name: 'Kurdish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    kw: {
        name: 'Cornish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 3
        }, {
            plural: 3,
            sample: 4
        }],
        nplurals: 4,
        pluralsText: 'nplurals = 4; plural = (n === 1 ? 0 : n === 2 ? 1 : n === 3 ? 2 : 3)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : n === 2 ? 1 : n === 3 ? 2 : 3);
        }
    },
    ky: {
        name: 'Kyrgyz',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    lb: {
        name: 'Letzeburgesch',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ln: {
        name: 'Lingala',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    lo: {
        name: 'Lao',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    lt: {
        name: 'Lithuanian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 10
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    lv: {
        name: 'Latvian',
        examples: [{
            plural: 2,
            sample: 0
        }, {
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n !== 0 ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n % 10 === 1 && n % 100 !== 11 ? 0 : n !== 0 ? 1 : 2);
        }
    },
    mai: {
        name: 'Maithili',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    mfe: {
        name: 'Mauritian Creole',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    mg: {
        name: 'Malagasy',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    mi: {
        name: 'Maori',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    mk: {
        name: 'Macedonian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n === 1 || n % 10 === 1 ? 0 : 1)',
        pluralsFunc: function(n) {
            return (n === 1 || n % 10 === 1 ? 0 : 1);
        }
    },
    ml: {
        name: 'Malayalam',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    mn: {
        name: 'Mongolian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    mni: {
        name: 'Manipuri',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    mnk: {
        name: 'Mandinka',
        examples: [{
            plural: 0,
            sample: 0
        }, {
            plural: 1,
            sample: 1
        }, {
            plural: 2,
            sample: 2
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n === 0 ? 0 : n === 1 ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n === 0 ? 0 : n === 1 ? 1 : 2);
        }
    },
    mr: {
        name: 'Marathi',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ms: {
        name: 'Malay',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    mt: {
        name: 'Maltese',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 11
        }, {
            plural: 3,
            sample: 20
        }],
        nplurals: 4,
        pluralsText: 'nplurals = 4; plural = (n === 1 ? 0 : n === 0 || ( n % 100 > 1 && n % 100 < 11) ? 1 : (n % 100 > 10 && n % 100 < 20 ) ? 2 : 3)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : n === 0 || (n % 100 > 1 && n % 100 < 11) ? 1 : (n % 100 > 10 && n % 100 < 20) ? 2 : 3);
        }
    },
    my: {
        name: 'Burmese',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    nah: {
        name: 'Nahuatl',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    nap: {
        name: 'Neapolitan',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    nb: {
        name: 'Norwegian Bokmal',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ne: {
        name: 'Nepali',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    nl: {
        name: 'Dutch',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    nn: {
        name: 'Norwegian Nynorsk',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    no: {
        name: 'Norwegian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    nso: {
        name: 'Northern Sotho',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    oc: {
        name: 'Occitan',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    or: {
        name: 'Oriya',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    pa: {
        name: 'Punjabi',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    pap: {
        name: 'Papiamento',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    pl: {
        name: 'Polish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n === 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    pms: {
        name: 'Piemontese',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ps: {
        name: 'Pashto',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    pt: {
        name: 'Portuguese',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    rm: {
        name: 'Romansh',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ro: {
        name: 'Romanian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 20
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n === 1 ? 0 : (n === 0 || (n % 100 > 0 && n % 100 < 20)) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : (n === 0 || (n % 100 > 0 && n % 100 < 20)) ? 1 : 2);
        }
    },
    ru: {
        name: 'Russian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    rw: {
        name: 'Kinyarwanda',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    sah: {
        name: 'Yakut',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    sat: {
        name: 'Santali',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    sco: {
        name: 'Scots',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    sd: {
        name: 'Sindhi',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    se: {
        name: 'Northern Sami',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    si: {
        name: 'Sinhala',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    sk: {
        name: 'Slovak',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n === 1 ? 0 : (n >= 2 && n <= 4) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n === 1 ? 0 : (n >= 2 && n <= 4) ? 1 : 2);
        }
    },
    sl: {
        name: 'Slovenian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 3
        }, {
            plural: 3,
            sample: 5
        }],
        nplurals: 4,
        pluralsText: 'nplurals = 4; plural = (n % 100 === 1 ? 0 : n % 100 === 2 ? 1 : n % 100 === 3 || n % 100 === 4 ? 2 : 3)',
        pluralsFunc: function(n) {
            return (n % 100 === 1 ? 0 : n % 100 === 2 ? 1 : n % 100 === 3 || n % 100 === 4 ? 2 : 3);
        }
    },
    so: {
        name: 'Somali',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    son: {
        name: 'Songhay',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    sq: {
        name: 'Albanian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    sr: {
        name: 'Serbian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    su: {
        name: 'Sundanese',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    sv: {
        name: 'Swedish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    sw: {
        name: 'Swahili',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    ta: {
        name: 'Tamil',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    te: {
        name: 'Telugu',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    tg: {
        name: 'Tajik',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    th: {
        name: 'Thai',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    ti: {
        name: 'Tigrinya',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    tk: {
        name: 'Turkmen',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    tr: {
        name: 'Turkish',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    tt: {
        name: 'Tatar',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    ug: {
        name: 'Uyghur',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    uk: {
        name: 'Ukrainian',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }, {
            plural: 2,
            sample: 5
        }],
        nplurals: 3,
        pluralsText: 'nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)',
        pluralsFunc: function(n) {
            return (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
        }
    },
    ur: {
        name: 'Urdu',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    uz: {
        name: 'Uzbek',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    vi: {
        name: 'Vietnamese',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    wa: {
        name: 'Walloon',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n > 1)',
        pluralsFunc: function(n) {
            return (n > 1);
        }
    },
    wo: {
        name: 'Wolof',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    },
    yo: {
        name: 'Yoruba',
        examples: [{
            plural: 0,
            sample: 1
        }, {
            plural: 1,
            sample: 2
        }],
        nplurals: 2,
        pluralsText: 'nplurals = 2; plural = (n !== 1)',
        pluralsFunc: function(n) {
            return (n !== 1);
        }
    },
    zh: {
        name: 'Chinese',
        examples: [{
            plural: 0,
            sample: 1
        }],
        nplurals: 1,
        pluralsText: 'nplurals = 1; plural = 0',
        pluralsFunc: function() {
            return 0;
        }
    }
};
