// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AlertStateInfoDTO alert state info DTO
//
// swagger:model AlertStateInfoDTO
type AlertStateInfoDTO struct {

	// dashboard Id
	DashboardID int64 `json:"dashboardId,omitempty"`

	// id
	ID int64 `json:"id,omitempty"`

	// new state date
	// Format: date-time
	NewStateDate strfmt.DateTime `json:"newStateDate,omitempty"`

	// panel Id
	PanelID int64 `json:"panelId,omitempty"`

	// state
	State AlertStateType `json:"state,omitempty"`
}

// Validate validates this alert state info DTO
func (m *AlertStateInfoDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNewStateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertStateInfoDTO) validateNewStateDate(formats strfmt.Registry) error {
	if swag.IsZero(m.NewStateDate) { // not required
		return nil
	}

	if err := validate.FormatOf("newStateDate", "body", "date-time", m.NewStateDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AlertStateInfoDTO) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if err := m.State.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("state")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("state")
		}
		return err
	}

	return nil
}

// ContextValidate validate this alert state info DTO based on the context it is used
func (m *AlertStateInfoDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertStateInfoDTO) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.State) { // not required
		return nil
	}

	if err := m.State.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("state")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("state")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AlertStateInfoDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AlertStateInfoDTO) UnmarshalBinary(b []byte) error {
	var res AlertStateInfoDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
