// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by client-gen. DO NOT EDIT.

package v0alpha1

import (
	http "net/http"

	servicev0alpha1 "github.com/grafana/grafana/pkg/apis/service/v0alpha1"
	scheme "github.com/grafana/grafana/pkg/generated/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type ServiceV0alpha1Interface interface {
	RESTClient() rest.Interface
	ExternalNamesGetter
}

// ServiceV0alpha1Client is used to interact with features provided by the service.grafana.app group.
type ServiceV0alpha1Client struct {
	restClient rest.Interface
}

func (c *ServiceV0alpha1Client) ExternalNames(namespace string) ExternalNameInterface {
	return newExternalNames(c, namespace)
}

// NewForConfig creates a new ServiceV0alpha1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*ServiceV0alpha1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new ServiceV0alpha1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*ServiceV0alpha1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &ServiceV0alpha1Client{client}, nil
}

// NewForConfigOrDie creates a new ServiceV0alpha1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *ServiceV0alpha1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new ServiceV0alpha1Client for the given RESTClient.
func New(c rest.Interface) *ServiceV0alpha1Client {
	return &ServiceV0alpha1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := servicev0alpha1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = rest.CodecFactoryForGeneratedClient(scheme.Scheme, scheme.Codecs).WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *ServiceV0alpha1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
