// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`Sign`](crate::operation::sign::builders::SignFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::sign::builders::SignFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::sign::builders::SignFluentBuilder::set_key_id):<br>required: **true**<br><p>Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric KMS key to sign the message. The <code>KeyUsage</code> type of the KMS key must be <code>SIGN_VERIFY</code>. To find the <code>KeyUsage</code> of a KMS key, use the <code>DescribeKey</code> operation.</p> <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Alias name: <code>alias/ExampleAlias</code></p></li>  <li>   <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p><br>
    ///   - [`message(Blob)`](crate::operation::sign::builders::SignFluentBuilder::message) / [`set_message(Option<Blob>)`](crate::operation::sign::builders::SignFluentBuilder::set_message):<br>required: **true**<br><p>Specifies the message or message digest to sign. Messages can be 0-4096 bytes. To sign a larger message, provide a message digest.</p> <p>If you provide a message digest, use the <code>DIGEST</code> value of <code>MessageType</code> to prevent the digest from being hashed again while signing.</p><br>
    ///   - [`message_type(MessageType)`](crate::operation::sign::builders::SignFluentBuilder::message_type) / [`set_message_type(Option<MessageType>)`](crate::operation::sign::builders::SignFluentBuilder::set_message_type):<br>required: **false**<br><p>Tells KMS whether the value of the <code>Message</code> parameter should be hashed as part of the signing algorithm. Use <code>RAW</code> for unhashed messages; use <code>DIGEST</code> for message digests, which are already hashed.</p> <p>When the value of <code>MessageType</code> is <code>RAW</code>, KMS uses the standard signing algorithm, which begins with a hash function. When the value is <code>DIGEST</code>, KMS skips the hashing step in the signing algorithm.</p><important>  <p>Use the <code>DIGEST</code> value only when the value of the <code>Message</code> parameter is a message digest. If you use the <code>DIGEST</code> value with an unhashed message, the security of the signing operation can be compromised.</p> </important> <p>When the value of <code>MessageType</code>is <code>DIGEST</code>, the length of the <code>Message</code> value must match the length of hashed messages for the specified signing algorithm.</p> <p>You can submit a message digest and omit the <code>MessageType</code> or specify <code>RAW</code> so the digest is hashed again while signing. However, this can cause verification failures when verifying with a system that assumes a single hash.</p> <p>The hashing algorithm in that <code>Sign</code> uses is based on the <code>SigningAlgorithm</code> value.</p> <ul>  <li>   <p>Signing algorithms that end in SHA_256 use the SHA_256 hashing algorithm.</p></li>  <li>   <p>Signing algorithms that end in SHA_384 use the SHA_384 hashing algorithm.</p></li>  <li>   <p>Signing algorithms that end in SHA_512 use the SHA_512 hashing algorithm.</p></li>  <li>   <p>SM2DSA uses the SM3 hashing algorithm. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification">Offline verification with SM2 key pairs</a>.</p></li> </ul><br>
    ///   - [`grant_tokens(impl Into<String>)`](crate::operation::sign::builders::SignFluentBuilder::grant_tokens) / [`set_grant_tokens(Option<Vec::<String>>)`](crate::operation::sign::builders::SignFluentBuilder::set_grant_tokens):<br>required: **false**<br><p>A list of grant tokens.</p> <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`signing_algorithm(SigningAlgorithmSpec)`](crate::operation::sign::builders::SignFluentBuilder::signing_algorithm) / [`set_signing_algorithm(Option<SigningAlgorithmSpec>)`](crate::operation::sign::builders::SignFluentBuilder::set_signing_algorithm):<br>required: **true**<br><p>Specifies the signing algorithm to use when signing the message.</p> <p>Choose an algorithm that is compatible with the type and size of the specified asymmetric KMS key. When signing with RSA key pairs, RSASSA-PSS algorithms are preferred. We include RSASSA-PKCS1-v1_5 algorithms for compatibility with existing applications.</p><br>
    ///   - [`dry_run(bool)`](crate::operation::sign::builders::SignFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::sign::builders::SignFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`SignOutput`](crate::operation::sign::SignOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::operation::sign::SignOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    ///   - [`signature(Option<Blob>)`](crate::operation::sign::SignOutput::signature): <p>The cryptographic signature that was generated for the message.</p> <ul>  <li>   <p>When used with the supported RSA signing algorithms, the encoding of this value is defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC 8017</a>.</p></li>  <li>   <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as defined by ANSI X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>. This is the most commonly used signature format and is appropriate for most uses.</p></li> </ul> <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`signing_algorithm(Option<SigningAlgorithmSpec>)`](crate::operation::sign::SignOutput::signing_algorithm): <p>The signing algorithm that was used to sign the message.</p>
    /// - On failure, responds with [`SdkError<SignError>`](crate::operation::sign::SignError)
    pub fn sign(&self) -> crate::operation::sign::builders::SignFluentBuilder {
        crate::operation::sign::builders::SignFluentBuilder::new(self.handle.clone())
    }
}
