package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_GenerationStatus = map[string]string{
	"":               "GenerationStatus keeps track of the generation for a given resource so that decisions about forced updates can be made.",
	"group":          "group is the group of the thing you're tracking",
	"resource":       "resource is the resource type of the thing you're tracking",
	"namespace":      "namespace is where the thing you're tracking is",
	"name":           "name is the name of the thing you're tracking",
	"lastGeneration": "lastGeneration is the last generation of the workload controller involved",
	"hash":           "hash is an optional field set for resources without generation that are content sensitive like secrets and configmaps",
}

func (GenerationStatus) SwaggerDoc() map[string]string {
	return map_GenerationStatus
}

var map_MyOperatorResource = map[string]string{
	"": "MyOperatorResource is an example operator configuration type",
}

func (MyOperatorResource) SwaggerDoc() map[string]string {
	return map_MyOperatorResource
}

var map_NodeStatus = map[string]string{
	"":                         "NodeStatus provides information about the current state of a particular node managed by this operator.",
	"nodeName":                 "nodeName is the name of the node",
	"currentRevision":          "currentRevision is the generation of the most recently successful deployment",
	"targetRevision":           "targetRevision is the generation of the deployment we're trying to apply",
	"lastFailedRevision":       "lastFailedRevision is the generation of the deployment we tried and failed to deploy.",
	"lastFailedRevisionErrors": "lastFailedRevisionErrors is a list of the errors during the failed deployment referenced in lastFailedRevision",
}

func (NodeStatus) SwaggerDoc() map[string]string {
	return map_NodeStatus
}

var map_OperatorCondition = map[string]string{
	"": "OperatorCondition is just the standard condition fields.",
}

func (OperatorCondition) SwaggerDoc() map[string]string {
	return map_OperatorCondition
}

var map_OperatorSpec = map[string]string{
	"":                           "OperatorSpec contains common fields operators need.  It is intended to be anonymous included inside of the Spec struct for your particular operator.",
	"managementState":            "managementState indicates whether and how the operator should manage the component",
	"logLevel":                   "logLevel is an intent based logging for an overall component.  It does not give fine grained control, but it is a simple way to manage coarse grained logging choices that operators have to interpret for their operands.\n\nValid values are: \"Normal\", \"Debug\", \"Trace\", \"TraceAll\". Defaults to \"Normal\".",
	"operatorLogLevel":           "operatorLogLevel is an intent based logging for the operator itself.  It does not give fine grained control, but it is a simple way to manage coarse grained logging choices that operators have to interpret for themselves.\n\nValid values are: \"Normal\", \"Debug\", \"Trace\", \"TraceAll\". Defaults to \"Normal\".",
	"unsupportedConfigOverrides": "unsupportedConfigOverrides holds a sparse config that will override any previously set options.  It only needs to be the fields to override it will end up overlaying in the following order: 1. hardcoded defaults 2. observedConfig 3. unsupportedConfigOverrides",
	"observedConfig":             "observedConfig holds a sparse config that controller has observed from the cluster state.  It exists in spec because it is an input to the level for the operator",
}

func (OperatorSpec) SwaggerDoc() map[string]string {
	return map_OperatorSpec
}

var map_OperatorStatus = map[string]string{
	"observedGeneration": "observedGeneration is the last generation change you've dealt with",
	"conditions":         "conditions is a list of conditions and their status",
	"version":            "version is the level this availability applies to",
	"readyReplicas":      "readyReplicas indicates how many replicas are ready and at the desired state",
	"generations":        "generations are used to determine when an item needs to be reconciled or has changed in a way that needs a reaction.",
}

func (OperatorStatus) SwaggerDoc() map[string]string {
	return map_OperatorStatus
}

var map_StaticPodOperatorSpec = map[string]string{
	"":                        "StaticPodOperatorSpec is spec for controllers that manage static pods.",
	"forceRedeploymentReason": "forceRedeploymentReason can be used to force the redeployment of the operand by providing a unique string. This provides a mechanism to kick a previously failed deployment and provide a reason why you think it will work this time instead of failing again on the same config.",
	"failedRevisionLimit":     "failedRevisionLimit is the number of failed static pod installer revisions to keep on disk and in the api -1 = unlimited, 0 or unset = 5 (default)",
	"succeededRevisionLimit":  "succeededRevisionLimit is the number of successful static pod installer revisions to keep on disk and in the api -1 = unlimited, 0 or unset = 5 (default)",
}

func (StaticPodOperatorSpec) SwaggerDoc() map[string]string {
	return map_StaticPodOperatorSpec
}

var map_StaticPodOperatorStatus = map[string]string{
	"":                              "StaticPodOperatorStatus is status for controllers that manage static pods.  There are different needs because individual node status must be tracked.",
	"latestAvailableRevision":       "latestAvailableRevision is the deploymentID of the most recent deployment",
	"latestAvailableRevisionReason": "latestAvailableRevisionReason describe the detailed reason for the most recent deployment",
	"nodeStatuses":                  "nodeStatuses track the deployment values and errors across individual nodes",
}

func (StaticPodOperatorStatus) SwaggerDoc() map[string]string {
	return map_StaticPodOperatorStatus
}

var map_Authentication = map[string]string{
	"": "Authentication provides information to configure an operator to manage authentication.",
}

func (Authentication) SwaggerDoc() map[string]string {
	return map_Authentication
}

var map_AuthenticationList = map[string]string{
	"": "AuthenticationList is a collection of items",
}

func (AuthenticationList) SwaggerDoc() map[string]string {
	return map_AuthenticationList
}

var map_AuthenticationStatus = map[string]string{
	"managingOAuthAPIServer": "ManagingOAuthAPIServer indicates whether this operator is managing OAuth related APIs. Setting this field to true will cause OAS-O to step down. Note that this field will be removed in the future releases, once https://github.com/openshift/enhancements/blob/master/enhancements/authentication/separate-oauth-resources.md is fully implemented",
	"oauthAPIServer":         "OAuthAPIServer holds status specific only to oauth-apiserver",
}

func (AuthenticationStatus) SwaggerDoc() map[string]string {
	return map_AuthenticationStatus
}

var map_OAuthAPIServerStatus = map[string]string{
	"latestAvailableRevision": "LatestAvailableRevision is the latest revision used as suffix of revisioned secrets like encryption-config. A new revision causes a new deployment of pods.",
}

func (OAuthAPIServerStatus) SwaggerDoc() map[string]string {
	return map_OAuthAPIServerStatus
}

var map_CloudCredential = map[string]string{
	"": "CloudCredential provides a means to configure an operator to manage CredentialsRequests.",
}

func (CloudCredential) SwaggerDoc() map[string]string {
	return map_CloudCredential
}

var map_CloudCredentialSpec = map[string]string{
	"":                "CloudCredentialSpec is the specification of the desired behavior of the cloud-credential-operator.",
	"credentialsMode": "CredentialsMode allows informing CCO that it should not attempt to dynamically determine the root cloud credentials capabilities, and it should just run in the specified mode. It also allows putting the operator into \"manual\" mode if desired. Leaving the field in default mode runs CCO so that the cluster's cloud credentials will be dynamically probed for capabilities (on supported clouds/platforms).",
}

func (CloudCredentialSpec) SwaggerDoc() map[string]string {
	return map_CloudCredentialSpec
}

var map_CloudCredentialStatus = map[string]string{
	"": "CloudCredentialStatus defines the observed status of the cloud-credential-operator.",
}

func (CloudCredentialStatus) SwaggerDoc() map[string]string {
	return map_CloudCredentialStatus
}

var map_Config = map[string]string{
	"":       "Config provides information to configure the config operator.",
	"spec":   "spec is the specification of the desired behavior of the Config Operator.",
	"status": "status defines the observed status of the Config Operator.",
}

func (Config) SwaggerDoc() map[string]string {
	return map_Config
}

var map_ConfigList = map[string]string{
	"":      "ConfigList is a collection of items",
	"items": "Items contains the items",
}

func (ConfigList) SwaggerDoc() map[string]string {
	return map_ConfigList
}

var map_Console = map[string]string{
	"": "Console provides a means to configure an operator to manage the console.",
}

func (Console) SwaggerDoc() map[string]string {
	return map_Console
}

var map_ConsoleConfigRoute = map[string]string{
	"":         "ConsoleConfigRoute holds information on external route access to console.",
	"hostname": "hostname is the desired custom domain under which console will be available.",
	"secret":   "secret points to secret in the openshift-config namespace that contains custom certificate and key and needs to be created manually by the cluster admin. Referenced Secret is required to contain following key value pairs: - \"tls.crt\" - to specifies custom certificate - \"tls.key\" - to specifies private key of the custom certificate If the custom hostname uses the default routing suffix of the cluster, the Secret specification for a serving certificate will not be needed.",
}

func (ConsoleConfigRoute) SwaggerDoc() map[string]string {
	return map_ConsoleConfigRoute
}

var map_ConsoleCustomization = map[string]string{
	"":                     "ConsoleCustomization defines a list of optional configuration for the console UI.",
	"brand":                "brand is the default branding of the web console which can be overridden by providing the brand field.  There is a limited set of specific brand options. This field controls elements of the console such as the logo. Invalid value will prevent a console rollout.",
	"documentationBaseURL": "documentationBaseURL links to external documentation are shown in various sections of the web console.  Providing documentationBaseURL will override the default documentation URL. Invalid value will prevent a console rollout.",
	"customProductName":    "customProductName is the name that will be displayed in page titles, logo alt text, and the about dialog instead of the normal OpenShift product name.",
	"customLogoFile":       "customLogoFile replaces the default OpenShift logo in the masthead and about dialog. It is a reference to a ConfigMap in the openshift-config namespace. This can be created with a command like 'oc create configmap custom-logo --from-file=/path/to/file -n openshift-config'. Image size must be less than 1 MB due to constraints on the ConfigMap size. The ConfigMap key should include a file extension so that the console serves the file with the correct MIME type. Recommended logo specifications: Dimensions: Max height of 68px and max width of 200px SVG format preferred",
	"developerCatalog":     "developerCatalog allows to configure the shown developer catalog categories.",
}

func (ConsoleCustomization) SwaggerDoc() map[string]string {
	return map_ConsoleCustomization
}

var map_ConsoleProviders = map[string]string{
	"":           "ConsoleProviders defines a list of optional additional providers of functionality to the console.",
	"statuspage": "statuspage contains ID for statuspage.io page that provides status info about.",
}

func (ConsoleProviders) SwaggerDoc() map[string]string {
	return map_ConsoleProviders
}

var map_ConsoleSpec = map[string]string{
	"":              "ConsoleSpec is the specification of the desired behavior of the Console.",
	"customization": "customization is used to optionally provide a small set of customization options to the web console.",
	"providers":     "providers contains configuration for using specific service providers.",
	"route":         "route contains hostname and secret reference that contains the serving certificate. If a custom route is specified, a new route will be created with the provided hostname, under which console will be available. In case of custom hostname uses the default routing suffix of the cluster, the Secret specification for a serving certificate will not be needed. In case of custom hostname points to an arbitrary domain, manual DNS configurations steps are necessary. The default console route will be maintained to reserve the default hostname for console if the custom route is removed. If not specified, default route will be used.",
	"plugins":       "plugins defines a list of enabled console plugin names.",
}

func (ConsoleSpec) SwaggerDoc() map[string]string {
	return map_ConsoleSpec
}

var map_ConsoleStatus = map[string]string{
	"": "ConsoleStatus defines the observed status of the Console.",
}

func (ConsoleStatus) SwaggerDoc() map[string]string {
	return map_ConsoleStatus
}

var map_DeveloperConsoleCatalogCategory = map[string]string{
	"":              "DeveloperConsoleCatalogCategory for the developer console catalog.",
	"subcategories": "subcategories defines a list of child categories.",
}

func (DeveloperConsoleCatalogCategory) SwaggerDoc() map[string]string {
	return map_DeveloperConsoleCatalogCategory
}

var map_DeveloperConsoleCatalogCategoryMeta = map[string]string{
	"":      "DeveloperConsoleCatalogCategoryMeta are the key identifiers of a developer catalog category.",
	"id":    "ID is an identifier used in the URL to enable deep linking in console. ID is required and must have 1-32 URL safe (A-Z, a-z, 0-9, - and _) characters.",
	"label": "label defines a category display label. It is required and must have 1-64 characters.",
	"tags":  "tags is a list of strings that will match the category. A selected category show all items which has at least one overlapping tag between category and item.",
}

func (DeveloperConsoleCatalogCategoryMeta) SwaggerDoc() map[string]string {
	return map_DeveloperConsoleCatalogCategoryMeta
}

var map_DeveloperConsoleCatalogCustomization = map[string]string{
	"":           "DeveloperConsoleCatalogCustomization allow cluster admin to configure developer catalog.",
	"categories": "categories which are shown in the developer catalog.",
}

func (DeveloperConsoleCatalogCustomization) SwaggerDoc() map[string]string {
	return map_DeveloperConsoleCatalogCustomization
}

var map_StatuspageProvider = map[string]string{
	"":       "StatuspageProvider provides identity for statuspage account.",
	"pageID": "pageID is the unique ID assigned by Statuspage for your page. This must be a public page.",
}

func (StatuspageProvider) SwaggerDoc() map[string]string {
	return map_StatuspageProvider
}

var map_ClusterCSIDriver = map[string]string{
	"":       "ClusterCSIDriver object allows management and configuration of a CSI driver operator installed by default in OpenShift. Name of the object must be name of the CSI driver it operates. See CSIDriverName type for list of allowed values.",
	"spec":   "spec holds user settable values for configuration",
	"status": "status holds observed values from the cluster. They may not be overridden.",
}

func (ClusterCSIDriver) SwaggerDoc() map[string]string {
	return map_ClusterCSIDriver
}

var map_ClusterCSIDriverList = map[string]string{
	"": "ClusterCSIDriverList contains a list of ClusterCSIDriver",
}

func (ClusterCSIDriverList) SwaggerDoc() map[string]string {
	return map_ClusterCSIDriverList
}

var map_ClusterCSIDriverSpec = map[string]string{
	"": "ClusterCSIDriverSpec is the desired behavior of CSI driver operator",
}

func (ClusterCSIDriverSpec) SwaggerDoc() map[string]string {
	return map_ClusterCSIDriverSpec
}

var map_ClusterCSIDriverStatus = map[string]string{
	"": "ClusterCSIDriverStatus is the observed status of CSI driver operator",
}

func (ClusterCSIDriverStatus) SwaggerDoc() map[string]string {
	return map_ClusterCSIDriverStatus
}

var map_CSISnapshotController = map[string]string{
	"":       "CSISnapshotController provides a means to configure an operator to manage the CSI snapshots. `cluster` is the canonical name.",
	"spec":   "spec holds user settable values for configuration",
	"status": "status holds observed values from the cluster. They may not be overridden.",
}

func (CSISnapshotController) SwaggerDoc() map[string]string {
	return map_CSISnapshotController
}

var map_CSISnapshotControllerList = map[string]string{
	"": "CSISnapshotControllerList contains a list of CSISnapshotControllers.",
}

func (CSISnapshotControllerList) SwaggerDoc() map[string]string {
	return map_CSISnapshotControllerList
}

var map_CSISnapshotControllerSpec = map[string]string{
	"": "CSISnapshotControllerSpec is the specification of the desired behavior of the CSISnapshotController operator.",
}

func (CSISnapshotControllerSpec) SwaggerDoc() map[string]string {
	return map_CSISnapshotControllerSpec
}

var map_CSISnapshotControllerStatus = map[string]string{
	"": "CSISnapshotControllerStatus defines the observed status of the CSISnapshotController operator.",
}

func (CSISnapshotControllerStatus) SwaggerDoc() map[string]string {
	return map_CSISnapshotControllerStatus
}

var map_DNS = map[string]string{
	"":       "DNS manages the CoreDNS component to provide a name resolution service for pods and services in the cluster.\n\nThis supports the DNS-based service discovery specification: https://github.com/kubernetes/dns/blob/master/docs/specification.md\n\nMore details: https://kubernetes.io/docs/tasks/administer-cluster/coredns",
	"spec":   "spec is the specification of the desired behavior of the DNS.",
	"status": "status is the most recently observed status of the DNS.",
}

func (DNS) SwaggerDoc() map[string]string {
	return map_DNS
}

var map_DNSList = map[string]string{
	"": "DNSList contains a list of DNS",
}

func (DNSList) SwaggerDoc() map[string]string {
	return map_DNSList
}

var map_DNSSpec = map[string]string{
	"":        "DNSSpec is the specification of the desired behavior of the DNS.",
	"servers": "servers is a list of DNS resolvers that provide name query delegation for one or more subdomains outside the scope of the cluster domain. If servers consists of more than one Server, longest suffix match will be used to determine the Server.\n\nFor example, if there are two Servers, one for \"foo.com\" and another for \"a.foo.com\", and the name query is for \"www.a.foo.com\", it will be routed to the Server with Zone \"a.foo.com\".\n\nIf this field is nil, no servers are created.",
}

func (DNSSpec) SwaggerDoc() map[string]string {
	return map_DNSSpec
}

var map_DNSStatus = map[string]string{
	"":              "DNSStatus defines the observed status of the DNS.",
	"clusterIP":     "clusterIP is the service IP through which this DNS is made available.\n\nIn the case of the default DNS, this will be a well known IP that is used as the default nameserver for pods that are using the default ClusterFirst DNS policy.\n\nIn general, this IP can be specified in a pod's spec.dnsConfig.nameservers list or used explicitly when performing name resolution from within the cluster. Example: dig foo.com @<service IP>\n\nMore info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies",
	"clusterDomain": "clusterDomain is the local cluster DNS domain suffix for DNS services. This will be a subdomain as defined in RFC 1034, section 3.5: https://tools.ietf.org/html/rfc1034#section-3.5 Example: \"cluster.local\"\n\nMore info: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service",
	"conditions":    "conditions provide information about the state of the DNS on the cluster.\n\nThese are the supported DNS conditions:\n\n  * Available\n  - True if the following conditions are met:\n    * DNS controller daemonset is available.\n  - False if any of those conditions are unsatisfied.",
}

func (DNSStatus) SwaggerDoc() map[string]string {
	return map_DNSStatus
}

var map_ForwardPlugin = map[string]string{
	"":          "ForwardPlugin defines a schema for configuring the CoreDNS forward plugin.",
	"upstreams": "upstreams is a list of resolvers to forward name queries for subdomains of Zones. Upstreams are randomized when more than 1 upstream is specified. Each instance of CoreDNS performs health checking of Upstreams. When a healthy upstream returns an error during the exchange, another resolver is tried from Upstreams. Each upstream is represented by an IP address or IP:port if the upstream listens on a port other than 53.\n\nA maximum of 15 upstreams is allowed per ForwardPlugin.",
}

func (ForwardPlugin) SwaggerDoc() map[string]string {
	return map_ForwardPlugin
}

var map_Server = map[string]string{
	"":              "Server defines the schema for a server that runs per instance of CoreDNS.",
	"name":          "name is required and specifies a unique name for the server. Name must comply with the Service Name Syntax of rfc6335.",
	"zones":         "zones is required and specifies the subdomains that Server is authoritative for. Zones must conform to the rfc1123 definition of a subdomain. Specifying the cluster domain (i.e., \"cluster.local\") is invalid.",
	"forwardPlugin": "forwardPlugin defines a schema for configuring CoreDNS to proxy DNS messages to upstream resolvers.",
}

func (Server) SwaggerDoc() map[string]string {
	return map_Server
}

var map_Etcd = map[string]string{
	"": "Etcd provides information to configure an operator to manage kube-apiserver.",
}

func (Etcd) SwaggerDoc() map[string]string {
	return map_Etcd
}

var map_EtcdList = map[string]string{
	"":      "KubeAPISOperatorConfigList is a collection of items",
	"items": "Items contains the items",
}

func (EtcdList) SwaggerDoc() map[string]string {
	return map_EtcdList
}

var map_AWSClassicLoadBalancerParameters = map[string]string{
	"": "AWSClassicLoadBalancerParameters holds configuration parameters for an AWS Classic load balancer.",
}

func (AWSClassicLoadBalancerParameters) SwaggerDoc() map[string]string {
	return map_AWSClassicLoadBalancerParameters
}

var map_AWSLoadBalancerParameters = map[string]string{
	"":                    "AWSLoadBalancerParameters provides configuration settings that are specific to AWS load balancers.",
	"type":                "type is the type of AWS load balancer to instantiate for an ingresscontroller.\n\nValid values are:\n\n* \"Classic\": A Classic Load Balancer that makes routing decisions at either\n  the transport layer (TCP/SSL) or the application layer (HTTP/HTTPS). See\n  the following for additional details:\n\n    https://docs.aws.amazon.com/AmazonECS/latest/developerguide/load-balancer-types.html#clb\n\n* \"NLB\": A Network Load Balancer that makes routing decisions at the\n  transport layer (TCP/SSL). See the following for additional details:\n\n    https://docs.aws.amazon.com/AmazonECS/latest/developerguide/load-balancer-types.html#nlb",
	"classicLoadBalancer": "classicLoadBalancerParameters holds configuration parameters for an AWS classic load balancer. Present only if type is Classic.",
	"networkLoadBalancer": "networkLoadBalancerParameters holds configuration parameters for an AWS network load balancer. Present only if type is NLB.",
}

func (AWSLoadBalancerParameters) SwaggerDoc() map[string]string {
	return map_AWSLoadBalancerParameters
}

var map_AWSNetworkLoadBalancerParameters = map[string]string{
	"": "AWSNetworkLoadBalancerParameters holds configuration parameters for an AWS Network load balancer.",
}

func (AWSNetworkLoadBalancerParameters) SwaggerDoc() map[string]string {
	return map_AWSNetworkLoadBalancerParameters
}

var map_AccessLogging = map[string]string{
	"":                   "AccessLogging describes how client requests should be logged.",
	"destination":        "destination is where access logs go.",
	"httpLogFormat":      "httpLogFormat specifies the format of the log message for an HTTP request.\n\nIf this field is empty, log messages use the implementation's default HTTP log format.  For HAProxy's default HTTP log format, see the HAProxy documentation: http://cbonte.github.io/haproxy-dconv/2.0/configuration.html#8.2.3\n\nNote that this format only applies to cleartext HTTP connections and to secure HTTP connections for which the ingress controller terminates encryption (that is, edge-terminated or reencrypt connections).  It does not affect the log format for TLS passthrough connections.",
	"httpCaptureHeaders": "httpCaptureHeaders defines HTTP headers that should be captured in access logs.  If this field is empty, no headers are captured.\n\nNote that this option only applies to cleartext HTTP connections and to secure HTTP connections for which the ingress controller terminates encryption (that is, edge-terminated or reencrypt connections).  Headers cannot be captured for TLS passthrough connections.",
	"httpCaptureCookies": "httpCaptureCookies specifies HTTP cookies that should be captured in access logs.  If this field is empty, no cookies are captured.",
}

func (AccessLogging) SwaggerDoc() map[string]string {
	return map_AccessLogging
}

var map_ContainerLoggingDestinationParameters = map[string]string{
	"": "ContainerLoggingDestinationParameters describes parameters for the Container logging destination type.",
}

func (ContainerLoggingDestinationParameters) SwaggerDoc() map[string]string {
	return map_ContainerLoggingDestinationParameters
}

var map_EndpointPublishingStrategy = map[string]string{
	"":             "EndpointPublishingStrategy is a way to publish the endpoints of an IngressController, and represents the type and any additional configuration for a specific type.",
	"type":         "type is the publishing strategy to use. Valid values are:\n\n* LoadBalancerService\n\nPublishes the ingress controller using a Kubernetes LoadBalancer Service.\n\nIn this configuration, the ingress controller deployment uses container networking. A LoadBalancer Service is created to publish the deployment.\n\nSee: https://kubernetes.io/docs/concepts/services-networking/service/#loadbalancer\n\nIf domain is set, a wildcard DNS record will be managed to point at the LoadBalancer Service's external name. DNS records are managed only in DNS zones defined by dns.config.openshift.io/cluster .spec.publicZone and .spec.privateZone.\n\nWildcard DNS management is currently supported only on the AWS, Azure, and GCP platforms.\n\n* HostNetwork\n\nPublishes the ingress controller on node ports where the ingress controller is deployed.\n\nIn this configuration, the ingress controller deployment uses host networking, bound to node ports 80 and 443. The user is responsible for configuring an external load balancer to publish the ingress controller via the node ports.\n\n* Private\n\nDoes not publish the ingress controller.\n\nIn this configuration, the ingress controller deployment uses container networking, and is not explicitly published. The user must manually publish the ingress controller.\n\n* NodePortService\n\nPublishes the ingress controller using a Kubernetes NodePort Service.\n\nIn this configuration, the ingress controller deployment uses container networking. A NodePort Service is created to publish the deployment. The specific node ports are dynamically allocated by OpenShift; however, to support static port allocations, user changes to the node port field of the managed NodePort Service will preserved.",
	"loadBalancer": "loadBalancer holds parameters for the load balancer. Present only if type is LoadBalancerService.",
	"hostNetwork":  "hostNetwork holds parameters for the HostNetwork endpoint publishing strategy. Present only if type is HostNetwork.",
	"private":      "private holds parameters for the Private endpoint publishing strategy. Present only if type is Private.",
	"nodePort":     "nodePort holds parameters for the NodePortService endpoint publishing strategy. Present only if type is NodePortService.",
}

func (EndpointPublishingStrategy) SwaggerDoc() map[string]string {
	return map_EndpointPublishingStrategy
}

var map_HostNetworkStrategy = map[string]string{
	"": "HostNetworkStrategy holds parameters for the HostNetwork endpoint publishing strategy.",
}

func (HostNetworkStrategy) SwaggerDoc() map[string]string {
	return map_HostNetworkStrategy
}

var map_IngressController = map[string]string{
	"":       "IngressController describes a managed ingress controller for the cluster. The controller can service OpenShift Route and Kubernetes Ingress resources.\n\nWhen an IngressController is created, a new ingress controller deployment is created to allow external traffic to reach the services that expose Ingress or Route resources. Updating this resource may lead to disruption for public facing network connections as a new ingress controller revision may be rolled out.\n\nhttps://kubernetes.io/docs/concepts/services-networking/ingress-controllers\n\nWhenever possible, sensible defaults for the platform are used. See each field for more details.",
	"spec":   "spec is the specification of the desired behavior of the IngressController.",
	"status": "status is the most recently observed status of the IngressController.",
}

func (IngressController) SwaggerDoc() map[string]string {
	return map_IngressController
}

var map_IngressControllerCaptureHTTPCookie = map[string]string{
	"":          "IngressControllerCaptureHTTPCookie describes an HTTP cookie that should be captured.",
	"maxLength": "maxLength specifies a maximum length of the string that will be logged, which includes the cookie name, cookie value, and one-character delimiter.  If the log entry exceeds this length, the value will be truncated in the log message.  Note that the ingress controller may impose a separate bound on the total length of HTTP headers in a request.",
}

func (IngressControllerCaptureHTTPCookie) SwaggerDoc() map[string]string {
	return map_IngressControllerCaptureHTTPCookie
}

var map_IngressControllerCaptureHTTPCookieUnion = map[string]string{
	"":           "IngressControllerCaptureHTTPCookieUnion describes optional fields of an HTTP cookie that should be captured.",
	"matchType":  "matchType specifies the type of match to be performed on the cookie name.  Allowed values are \"Exact\" for an exact string match and \"Prefix\" for a string prefix match.  If \"Exact\" is specified, a name must be specified in the name field.  If \"Prefix\" is provided, a prefix must be specified in the namePrefix field.  For example, specifying matchType \"Prefix\" and namePrefix \"foo\" will capture a cookie named \"foo\" or \"foobar\" but not one named \"bar\".  The first matching cookie is captured.",
	"name":       "name specifies a cookie name.  Its value must be a valid HTTP cookie name as defined in RFC 6265 section 4.1.",
	"namePrefix": "namePrefix specifies a cookie name prefix.  Its value must be a valid HTTP cookie name as defined in RFC 6265 section 4.1.",
}

func (IngressControllerCaptureHTTPCookieUnion) SwaggerDoc() map[string]string {
	return map_IngressControllerCaptureHTTPCookieUnion
}

var map_IngressControllerCaptureHTTPHeader = map[string]string{
	"":          "IngressControllerCaptureHTTPHeader describes an HTTP header that should be captured.",
	"name":      "name specifies a header name.  Its value must be a valid HTTP header name as defined in RFC 2616 section 4.2.",
	"maxLength": "maxLength specifies a maximum length for the header value.  If a header value exceeds this length, the value will be truncated in the log message.  Note that the ingress controller may impose a separate bound on the total length of HTTP headers in a request.",
}

func (IngressControllerCaptureHTTPHeader) SwaggerDoc() map[string]string {
	return map_IngressControllerCaptureHTTPHeader
}

var map_IngressControllerCaptureHTTPHeaders = map[string]string{
	"":         "IngressControllerCaptureHTTPHeaders specifies which HTTP headers the IngressController captures.",
	"request":  "request specifies which HTTP request headers to capture.\n\nIf this field is empty, no request headers are captured.",
	"response": "response specifies which HTTP response headers to capture.\n\nIf this field is empty, no response headers are captured.",
}

func (IngressControllerCaptureHTTPHeaders) SwaggerDoc() map[string]string {
	return map_IngressControllerCaptureHTTPHeaders
}

var map_IngressControllerHTTPHeaders = map[string]string{
	"":                          "IngressControllerHTTPHeaders specifies how the IngressController handles certain HTTP headers.",
	"forwardedHeaderPolicy":     "forwardedHeaderPolicy specifies when and how the IngressController sets the Forwarded, X-Forwarded-For, X-Forwarded-Host, X-Forwarded-Port, X-Forwarded-Proto, and X-Forwarded-Proto-Version HTTP headers.  The value may be one of the following:\n\n* \"Append\", which specifies that the IngressController appends the\n  headers, preserving existing headers.\n\n* \"Replace\", which specifies that the IngressController sets the\n  headers, replacing any existing Forwarded or X-Forwarded-* headers.\n\n* \"IfNone\", which specifies that the IngressController sets the\n  headers if they are not already set.\n\n* \"Never\", which specifies that the IngressController never sets the\n  headers, preserving any existing headers.\n\nBy default, the policy is \"Append\".",
	"uniqueId":                  "uniqueId describes configuration for a custom HTTP header that the ingress controller should inject into incoming HTTP requests. Typically, this header is configured to have a value that is unique to the HTTP request.  The header can be used by applications or included in access logs to facilitate tracing individual HTTP requests.\n\nIf this field is empty, no such header is injected into requests.",
	"headerNameCaseAdjustments": "headerNameCaseAdjustments specifies case adjustments that can be applied to HTTP header names.  Each adjustment is specified as an HTTP header name with the desired capitalization.  For example, specifying \"X-Forwarded-For\" indicates that the \"x-forwarded-for\" HTTP header should be adjusted to have the specified capitalization.\n\nThese adjustments are only applied to cleartext, edge-terminated, and re-encrypt routes, and only when using HTTP/1.\n\nFor request headers, these adjustments are applied only for routes that have the haproxy.router.openshift.io/h1-adjust-case=true annotation.  For response headers, these adjustments are applied to all HTTP responses.\n\nIf this field is empty, no request headers are adjusted.",
}

func (IngressControllerHTTPHeaders) SwaggerDoc() map[string]string {
	return map_IngressControllerHTTPHeaders
}

var map_IngressControllerHTTPUniqueIdHeaderPolicy = map[string]string{
	"":       "IngressControllerHTTPUniqueIdHeaderPolicy describes configuration for a unique id header.",
	"name":   "name specifies the name of the HTTP header (for example, \"unique-id\") that the ingress controller should inject into HTTP requests.  The field's value must be a valid HTTP header name as defined in RFC 2616 section 4.2.  If the field is empty, no header is injected.",
	"format": "format specifies the format for the injected HTTP header's value. This field has no effect unless name is specified.  For the HAProxy-based ingress controller implementation, this format uses the same syntax as the HTTP log format.  If the field is empty, the default value is \"%{+X}o\\ %ci:%cp_%fi:%fp_%Ts_%rt:%pid\"; see the corresponding HAProxy documentation: http://cbonte.github.io/haproxy-dconv/2.0/configuration.html#8.2.3",
}

func (IngressControllerHTTPUniqueIdHeaderPolicy) SwaggerDoc() map[string]string {
	return map_IngressControllerHTTPUniqueIdHeaderPolicy
}

var map_IngressControllerList = map[string]string{
	"": "IngressControllerList contains a list of IngressControllers.",
}

func (IngressControllerList) SwaggerDoc() map[string]string {
	return map_IngressControllerList
}

var map_IngressControllerLogging = map[string]string{
	"":       "IngressControllerLogging describes what should be logged where.",
	"access": "access describes how the client requests should be logged.\n\nIf this field is empty, access logging is disabled.",
}

func (IngressControllerLogging) SwaggerDoc() map[string]string {
	return map_IngressControllerLogging
}

var map_IngressControllerSpec = map[string]string{
	"":                           "IngressControllerSpec is the specification of the desired behavior of the IngressController.",
	"domain":                     "domain is a DNS name serviced by the ingress controller and is used to configure multiple features:\n\n* For the LoadBalancerService endpoint publishing strategy, domain is\n  used to configure DNS records. See endpointPublishingStrategy.\n\n* When using a generated default certificate, the certificate will be valid\n  for domain and its subdomains. See defaultCertificate.\n\n* The value is published to individual Route statuses so that end-users\n  know where to target external DNS records.\n\ndomain must be unique among all IngressControllers, and cannot be updated.\n\nIf empty, defaults to ingress.config.openshift.io/cluster .spec.domain.",
	"replicas":                   "replicas is the desired number of ingress controller replicas. If unset, defaults to 2.",
	"endpointPublishingStrategy": "endpointPublishingStrategy is used to publish the ingress controller endpoints to other networks, enable load balancer integrations, etc.\n\nIf unset, the default is based on infrastructure.config.openshift.io/cluster .status.platform:\n\n  AWS:      LoadBalancerService (with External scope)\n  Azure:    LoadBalancerService (with External scope)\n  GCP:      LoadBalancerService (with External scope)\n  IBMCloud: LoadBalancerService (with External scope)\n  Libvirt:  HostNetwork\n\nAny other platform types (including None) default to HostNetwork.\n\nendpointPublishingStrategy cannot be updated.",
	"defaultCertificate":         "defaultCertificate is a reference to a secret containing the default certificate served by the ingress controller. When Routes don't specify their own certificate, defaultCertificate is used.\n\nThe secret must contain the following keys and data:\n\n  tls.crt: certificate file contents\n  tls.key: key file contents\n\nIf unset, a wildcard certificate is automatically generated and used. The certificate is valid for the ingress controller domain (and subdomains) and the generated certificate's CA will be automatically integrated with the cluster's trust store.\n\nIf a wildcard certificate is used and shared by multiple HTTP/2 enabled routes (which implies ALPN) then clients (i.e., notably browsers) are at liberty to reuse open connections. This means a client can reuse a connection to another route and that is likely to fail. This behaviour is generally known as connection coalescing.\n\nThe in-use certificate (whether generated or user-specified) will be automatically integrated with OpenShift's built-in OAuth server.",
	"namespaceSelector":          "namespaceSelector is used to filter the set of namespaces serviced by the ingress controller. This is useful for implementing shards.\n\nIf unset, the default is no filtering.",
	"routeSelector":              "routeSelector is used to filter the set of Routes serviced by the ingress controller. This is useful for implementing shards.\n\nIf unset, the default is no filtering.",
	"nodePlacement":              "nodePlacement enables explicit control over the scheduling of the ingress controller.\n\nIf unset, defaults are used. See NodePlacement for more details.",
	"tlsSecurityProfile":         "tlsSecurityProfile specifies settings for TLS connections for ingresscontrollers.\n\nIf unset, the default is based on the apiservers.config.openshift.io/cluster resource.\n\nNote that when using the Old, Intermediate, and Modern profile types, the effective profile configuration is subject to change between releases. For example, given a specification to use the Intermediate profile deployed on release X.Y.Z, an upgrade to release X.Y.Z+1 may cause a new profile configuration to be applied to the ingress controller, resulting in a rollout.\n\nNote that the minimum TLS version for ingress controllers is 1.1, and the maximum TLS version is 1.2.  An implication of this restriction is that the Modern TLS profile type cannot be used because it requires TLS 1.3.",
	"routeAdmission":             "routeAdmission defines a policy for handling new route claims (for example, to allow or deny claims across namespaces).\n\nIf empty, defaults will be applied. See specific routeAdmission fields for details about their defaults.",
	"logging":                    "logging defines parameters for what should be logged where.  If this field is empty, operational logs are enabled but access logs are disabled.",
	"httpHeaders":                "httpHeaders defines policy for HTTP headers.\n\nIf this field is empty, the default values are used.",
}

func (IngressControllerSpec) SwaggerDoc() map[string]string {
	return map_IngressControllerSpec
}

var map_IngressControllerStatus = map[string]string{
	"":                           "IngressControllerStatus defines the observed status of the IngressController.",
	"availableReplicas":          "availableReplicas is number of observed available replicas according to the ingress controller deployment.",
	"selector":                   "selector is a label selector, in string format, for ingress controller pods corresponding to the IngressController. The number of matching pods should equal the value of availableReplicas.",
	"domain":                     "domain is the actual domain in use.",
	"endpointPublishingStrategy": "endpointPublishingStrategy is the actual strategy in use.",
	"conditions":                 "conditions is a list of conditions and their status.\n\nAvailable means the ingress controller deployment is available and servicing route and ingress resources (i.e, .status.availableReplicas equals .spec.replicas)\n\nThere are additional conditions which indicate the status of other ingress controller features and capabilities.\n\n  * LoadBalancerManaged\n  - True if the following conditions are met:\n    * The endpoint publishing strategy requires a service load balancer.\n  - False if any of those conditions are unsatisfied.\n\n  * LoadBalancerReady\n  - True if the following conditions are met:\n    * A load balancer is managed.\n    * The load balancer is ready.\n  - False if any of those conditions are unsatisfied.\n\n  * DNSManaged\n  - True if the following conditions are met:\n    * The endpoint publishing strategy and platform support DNS.\n    * The ingress controller domain is set.\n    * dns.config.openshift.io/cluster configures DNS zones.\n  - False if any of those conditions are unsatisfied.\n\n  * DNSReady\n  - True if the following conditions are met:\n    * DNS is managed.\n    * DNS records have been successfully created.\n  - False if any of those conditions are unsatisfied.",
	"tlsProfile":                 "tlsProfile is the TLS connection configuration that is in effect.",
	"observedGeneration":         "observedGeneration is the most recent generation observed.",
}

func (IngressControllerStatus) SwaggerDoc() map[string]string {
	return map_IngressControllerStatus
}

var map_LoadBalancerStrategy = map[string]string{
	"":                   "LoadBalancerStrategy holds parameters for a load balancer.",
	"scope":              "scope indicates the scope at which the load balancer is exposed. Possible values are \"External\" and \"Internal\".",
	"providerParameters": "providerParameters holds desired load balancer information specific to the underlying infrastructure provider.\n\nIf empty, defaults will be applied. See specific providerParameters fields for details about their defaults.",
}

func (LoadBalancerStrategy) SwaggerDoc() map[string]string {
	return map_LoadBalancerStrategy
}

var map_LoggingDestination = map[string]string{
	"":          "LoggingDestination describes a destination for log messages.",
	"type":      "type is the type of destination for logs.  It must be one of the following:\n\n* Container\n\nThe ingress operator configures the sidecar container named \"logs\" on the ingress controller pod and configures the ingress controller to write logs to the sidecar.  The logs are then available as container logs.  The expectation is that the administrator configures a custom logging solution that reads logs from this sidecar.  Note that using container logs means that logs may be dropped if the rate of logs exceeds the container runtime's or the custom logging solution's capacity.\n\n* Syslog\n\nLogs are sent to a syslog endpoint.  The administrator must specify an endpoint that can receive syslog messages.  The expectation is that the administrator has configured a custom syslog instance.",
	"syslog":    "syslog holds parameters for a syslog endpoint.  Present only if type is Syslog.",
	"container": "container holds parameters for the Container logging destination. Present only if type is Container.",
}

func (LoggingDestination) SwaggerDoc() map[string]string {
	return map_LoggingDestination
}

var map_NodePlacement = map[string]string{
	"":             "NodePlacement describes node scheduling configuration for an ingress controller.",
	"nodeSelector": "nodeSelector is the node selector applied to ingress controller deployments.\n\nIf unset, the default is:\n\n  beta.kubernetes.io/os: linux\n  node-role.kubernetes.io/worker: ''\n\nIf set, the specified selector is used and replaces the default.",
	"tolerations":  "tolerations is a list of tolerations applied to ingress controller deployments.\n\nThe default is an empty list.\n\nSee https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/",
}

func (NodePlacement) SwaggerDoc() map[string]string {
	return map_NodePlacement
}

var map_NodePortStrategy = map[string]string{
	"": "NodePortStrategy holds parameters for the NodePortService endpoint publishing strategy.",
}

func (NodePortStrategy) SwaggerDoc() map[string]string {
	return map_NodePortStrategy
}

var map_PrivateStrategy = map[string]string{
	"": "PrivateStrategy holds parameters for the Private endpoint publishing strategy.",
}

func (PrivateStrategy) SwaggerDoc() map[string]string {
	return map_PrivateStrategy
}

var map_ProviderLoadBalancerParameters = map[string]string{
	"":     "ProviderLoadBalancerParameters holds desired load balancer information specific to the underlying infrastructure provider.",
	"type": "type is the underlying infrastructure provider for the load balancer. Allowed values are \"AWS\", \"Azure\", \"BareMetal\", \"GCP\", \"OpenStack\", and \"VSphere\".",
	"aws":  "aws provides configuration settings that are specific to AWS load balancers.\n\nIf empty, defaults will be applied. See specific aws fields for details about their defaults.",
}

func (ProviderLoadBalancerParameters) SwaggerDoc() map[string]string {
	return map_ProviderLoadBalancerParameters
}

var map_RouteAdmissionPolicy = map[string]string{
	"":                   "RouteAdmissionPolicy is an admission policy for allowing new route claims.",
	"namespaceOwnership": "namespaceOwnership describes how host name claims across namespaces should be handled.\n\nValue must be one of:\n\n- Strict: Do not allow routes in different namespaces to claim the same host.\n\n- InterNamespaceAllowed: Allow routes to claim different paths of the same\n  host name across namespaces.\n\nIf empty, the default is Strict.",
	"wildcardPolicy":     "wildcardPolicy describes how routes with wildcard policies should be handled for the ingress controller. WildcardPolicy controls use of routes [1] exposed by the ingress controller based on the route's wildcard policy.\n\n[1] https://github.com/openshift/api/blob/master/route/v1/types.go\n\nNote: Updating WildcardPolicy from WildcardsAllowed to WildcardsDisallowed will cause admitted routes with a wildcard policy of Subdomain to stop working. These routes must be updated to a wildcard policy of None to be readmitted by the ingress controller.\n\nWildcardPolicy supports WildcardsAllowed and WildcardsDisallowed values.\n\nIf empty, defaults to \"WildcardsDisallowed\".",
}

func (RouteAdmissionPolicy) SwaggerDoc() map[string]string {
	return map_RouteAdmissionPolicy
}

var map_SyslogLoggingDestinationParameters = map[string]string{
	"":         "SyslogLoggingDestinationParameters describes parameters for the Syslog logging destination type.",
	"address":  "address is the IP address of the syslog endpoint that receives log messages.",
	"port":     "port is the UDP port number of the syslog endpoint that receives log messages.",
	"facility": "facility specifies the syslog facility of log messages.\n\nIf this field is empty, the facility is \"local1\".",
}

func (SyslogLoggingDestinationParameters) SwaggerDoc() map[string]string {
	return map_SyslogLoggingDestinationParameters
}

var map_KubeAPIServer = map[string]string{
	"":       "KubeAPIServer provides information to configure an operator to manage kube-apiserver.",
	"spec":   "spec is the specification of the desired behavior of the Kubernetes API Server",
	"status": "status is the most recently observed status of the Kubernetes API Server",
}

func (KubeAPIServer) SwaggerDoc() map[string]string {
	return map_KubeAPIServer
}

var map_KubeAPIServerList = map[string]string{
	"":      "KubeAPIServerList is a collection of items",
	"items": "Items contains the items",
}

func (KubeAPIServerList) SwaggerDoc() map[string]string {
	return map_KubeAPIServerList
}

var map_KubeControllerManager = map[string]string{
	"":       "KubeControllerManager provides information to configure an operator to manage kube-controller-manager.",
	"spec":   "spec is the specification of the desired behavior of the Kubernetes Controller Manager",
	"status": "status is the most recently observed status of the Kubernetes Controller Manager",
}

func (KubeControllerManager) SwaggerDoc() map[string]string {
	return map_KubeControllerManager
}

var map_KubeControllerManagerList = map[string]string{
	"":      "KubeControllerManagerList is a collection of items",
	"items": "Items contains the items",
}

func (KubeControllerManagerList) SwaggerDoc() map[string]string {
	return map_KubeControllerManagerList
}

var map_KubeStorageVersionMigrator = map[string]string{
	"": "KubeStorageVersionMigrator provides information to configure an operator to manage kube-storage-version-migrator.",
}

func (KubeStorageVersionMigrator) SwaggerDoc() map[string]string {
	return map_KubeStorageVersionMigrator
}

var map_KubeStorageVersionMigratorList = map[string]string{
	"":      "KubeStorageVersionMigratorList is a collection of items",
	"items": "Items contains the items",
}

func (KubeStorageVersionMigratorList) SwaggerDoc() map[string]string {
	return map_KubeStorageVersionMigratorList
}

var map_AdditionalNetworkDefinition = map[string]string{
	"":                    "AdditionalNetworkDefinition configures an extra network that is available but not created by default. Instead, pods must request them by name. type must be specified, along with exactly one \"Config\" that matches the type.",
	"type":                "type is the type of network The supported values are NetworkTypeRaw, NetworkTypeSimpleMacvlan",
	"name":                "name is the name of the network. This will be populated in the resulting CRD This must be unique.",
	"namespace":           "namespace is the namespace of the network. This will be populated in the resulting CRD If not given the network will be created in the default namespace.",
	"rawCNIConfig":        "rawCNIConfig is the raw CNI configuration json to create in the NetworkAttachmentDefinition CRD",
	"simpleMacvlanConfig": "SimpleMacvlanConfig configures the macvlan interface in case of type:NetworkTypeSimpleMacvlan",
}

func (AdditionalNetworkDefinition) SwaggerDoc() map[string]string {
	return map_AdditionalNetworkDefinition
}

var map_ClusterNetworkEntry = map[string]string{
	"": "ClusterNetworkEntry is a subnet from which to allocate PodIPs. A network of size HostPrefix (in CIDR notation) will be allocated when nodes join the cluster. If the HostPrefix field is not used by the plugin, it can be left unset. Not all network providers support multiple ClusterNetworks",
}

func (ClusterNetworkEntry) SwaggerDoc() map[string]string {
	return map_ClusterNetworkEntry
}

var map_DefaultNetworkDefinition = map[string]string{
	"":                    "DefaultNetworkDefinition represents a single network plugin's configuration. type must be specified, along with exactly one \"Config\" that matches the type.",
	"type":                "type is the type of network All NetworkTypes are supported except for NetworkTypeRaw",
	"openshiftSDNConfig":  "openShiftSDNConfig configures the openshift-sdn plugin",
	"ovnKubernetesConfig": "oVNKubernetesConfig configures the ovn-kubernetes plugin. This is currently not implemented.",
	"kuryrConfig":         "KuryrConfig configures the kuryr plugin",
}

func (DefaultNetworkDefinition) SwaggerDoc() map[string]string {
	return map_DefaultNetworkDefinition
}

var map_HybridOverlayConfig = map[string]string{
	"hybridClusterNetwork":   "HybridClusterNetwork defines a network space given to nodes on an additional overlay network.",
	"hybridOverlayVXLANPort": "HybridOverlayVXLANPort defines the VXLAN port number to be used by the additional overlay network. Default is 4789",
}

func (HybridOverlayConfig) SwaggerDoc() map[string]string {
	return map_HybridOverlayConfig
}

var map_IPAMConfig = map[string]string{
	"":                 "IPAMConfig contains configurations for IPAM (IP Address Management)",
	"type":             "Type is the type of IPAM module will be used for IP Address Management(IPAM). The supported values are IPAMTypeDHCP, IPAMTypeStatic",
	"staticIPAMConfig": "StaticIPAMConfig configures the static IP address in case of type:IPAMTypeStatic",
}

func (IPAMConfig) SwaggerDoc() map[string]string {
	return map_IPAMConfig
}

var map_KuryrConfig = map[string]string{
	"":                             "KuryrConfig configures the Kuryr-Kubernetes SDN",
	"daemonProbesPort":             "The port kuryr-daemon will listen for readiness and liveness requests.",
	"controllerProbesPort":         "The port kuryr-controller will listen for readiness and liveness requests.",
	"openStackServiceNetwork":      "openStackServiceNetwork contains the CIDR of network from which to allocate IPs for OpenStack Octavia's Amphora VMs. Please note that with Amphora driver Octavia uses two IPs from that network for each loadbalancer - one given by OpenShift and second for VRRP connections. As the first one is managed by OpenShift's and second by Neutron's IPAMs, those need to come from different pools. Therefore `openStackServiceNetwork` needs to be at least twice the size of `serviceNetwork`, and whole `serviceNetwork` must be overlapping with `openStackServiceNetwork`. cluster-network-operator will then make sure VRRP IPs are taken from the ranges inside `openStackServiceNetwork` that are not overlapping with `serviceNetwork`, effectivly preventing conflicts. If not set cluster-network-operator will use `serviceNetwork` expanded by decrementing the prefix size by 1.",
	"enablePortPoolsPrepopulation": "enablePortPoolsPrepopulation when true will make Kuryr prepopulate each newly created port pool with a minimum number of ports. Kuryr uses Neutron port pooling to fight the fact that it takes a significant amount of time to create one. Instead of creating it when pod is being deployed, Kuryr keeps a number of ports ready to be attached to pods. By default port prepopulation is disabled.",
	"poolMaxPorts":                 "poolMaxPorts sets a maximum number of free ports that are being kept in a port pool. If the number of ports exceeds this setting, free ports will get deleted. Setting 0 will disable this upper bound, effectively preventing pools from shrinking and this is the default value. For more information about port pools see enablePortPoolsPrepopulation setting.",
	"poolMinPorts":                 "poolMinPorts sets a minimum number of free ports that should be kept in a port pool. If the number of ports is lower than this setting, new ports will get created and added to pool. The default is 1. For more information about port pools see enablePortPoolsPrepopulation setting.",
	"poolBatchPorts":               "poolBatchPorts sets a number of ports that should be created in a single batch request to extend the port pool. The default is 3. For more information about port pools see enablePortPoolsPrepopulation setting.",
}

func (KuryrConfig) SwaggerDoc() map[string]string {
	return map_KuryrConfig
}

var map_Network = map[string]string{
	"": "Network describes the cluster's desired network configuration. It is consumed by the cluster-network-operator.",
}

func (Network) SwaggerDoc() map[string]string {
	return map_Network
}

var map_NetworkList = map[string]string{
	"": "NetworkList contains a list of Network configurations",
}

func (NetworkList) SwaggerDoc() map[string]string {
	return map_NetworkList
}

var map_NetworkSpec = map[string]string{
	"":                          "NetworkSpec is the top-level network configuration object.",
	"clusterNetwork":            "clusterNetwork is the IP address pool to use for pod IPs. Some network providers, e.g. OpenShift SDN, support multiple ClusterNetworks. Others only support one. This is equivalent to the cluster-cidr.",
	"serviceNetwork":            "serviceNetwork is the ip address pool to use for Service IPs Currently, all existing network providers only support a single value here, but this is an array to allow for growth.",
	"defaultNetwork":            "defaultNetwork is the \"default\" network that all pods will receive",
	"additionalNetworks":        "additionalNetworks is a list of extra networks to make available to pods when multiple networks are enabled.",
	"disableMultiNetwork":       "disableMultiNetwork specifies whether or not multiple pod network support should be disabled. If unset, this property defaults to 'false' and multiple network support is enabled.",
	"deployKubeProxy":           "deployKubeProxy specifies whether or not a standalone kube-proxy should be deployed by the operator. Some network providers include kube-proxy or similar functionality. If unset, the plugin will attempt to select the correct value, which is false when OpenShift SDN and ovn-kubernetes are used and true otherwise.",
	"disableNetworkDiagnostics": "disableNetworkDiagnostics specifies whether or not PodNetworkConnectivityCheck CRs from a test pod to every node, apiserver and LB should be disabled or not. If unset, this property defaults to 'false' and network diagnostics is enabled. Setting this to 'true' would reduce the additional load of the pods performing the checks.",
	"kubeProxyConfig":           "kubeProxyConfig lets us configure desired proxy configuration. If not specified, sensible defaults will be chosen by OpenShift directly. Not consumed by all network providers - currently only openshift-sdn.",
}

func (NetworkSpec) SwaggerDoc() map[string]string {
	return map_NetworkSpec
}

var map_NetworkStatus = map[string]string{
	"": "NetworkStatus is detailed operator status, which is distilled up to the Network clusteroperator object.",
}

func (NetworkStatus) SwaggerDoc() map[string]string {
	return map_NetworkStatus
}

var map_OVNKubernetesConfig = map[string]string{
	"":                    "ovnKubernetesConfig contains the configuration parameters for networks using the ovn-kubernetes network project",
	"mtu":                 "mtu is the MTU to use for the tunnel interface. This must be 100 bytes smaller than the uplink mtu. Default is 1400",
	"genevePort":          "geneve port is the UDP port to be used by geneve encapulation. Default is 6081",
	"hybridOverlayConfig": "HybridOverlayConfig configures an additional overlay network for peers that are not using OVN.",
	"ipsecConfig":         "ipsecConfig enables and configures IPsec for pods on the pod network within the cluster.",
}

func (OVNKubernetesConfig) SwaggerDoc() map[string]string {
	return map_OVNKubernetesConfig
}

var map_OpenShiftSDNConfig = map[string]string{
	"":                       "OpenShiftSDNConfig configures the three openshift-sdn plugins",
	"mode":                   "mode is one of \"Multitenant\", \"Subnet\", or \"NetworkPolicy\"",
	"vxlanPort":              "vxlanPort is the port to use for all vxlan packets. The default is 4789.",
	"mtu":                    "mtu is the mtu to use for the tunnel interface. Defaults to 1450 if unset. This must be 50 bytes smaller than the machine's uplink.",
	"useExternalOpenvswitch": "useExternalOpenvswitch tells the operator not to install openvswitch, because it will be provided separately. If set, you must provide it yourself.",
	"enableUnidling":         "enableUnidling controls whether or not the service proxy will support idling and unidling of services. By default, unidling is enabled.",
}

func (OpenShiftSDNConfig) SwaggerDoc() map[string]string {
	return map_OpenShiftSDNConfig
}

var map_ProxyConfig = map[string]string{
	"":                   "ProxyConfig defines the configuration knobs for kubeproxy All of these are optional and have sensible defaults",
	"iptablesSyncPeriod": "An internal kube-proxy parameter. In older releases of OCP, this sometimes needed to be adjusted in large clusters for performance reasons, but this is no longer necessary, and there is no reason to change this from the default value. Default: 30s",
	"bindAddress":        "The address to \"bind\" on Defaults to 0.0.0.0",
	"proxyArguments":     "Any additional arguments to pass to the kubeproxy process",
}

func (ProxyConfig) SwaggerDoc() map[string]string {
	return map_ProxyConfig
}

var map_SimpleMacvlanConfig = map[string]string{
	"":           "SimpleMacvlanConfig contains configurations for macvlan interface.",
	"master":     "master is the host interface to create the macvlan interface from. If not specified, it will be default route interface",
	"ipamConfig": "IPAMConfig configures IPAM module will be used for IP Address Management (IPAM).",
	"mode":       "mode is the macvlan mode: bridge, private, vepa, passthru. The default is bridge",
	"mtu":        "mtu is the mtu to use for the macvlan interface. if unset, host's kernel will select the value.",
}

func (SimpleMacvlanConfig) SwaggerDoc() map[string]string {
	return map_SimpleMacvlanConfig
}

var map_StaticIPAMAddresses = map[string]string{
	"":        "StaticIPAMAddresses provides IP address and Gateway for static IPAM addresses",
	"address": "Address is the IP address in CIDR format",
	"gateway": "Gateway is IP inside of subnet to designate as the gateway",
}

func (StaticIPAMAddresses) SwaggerDoc() map[string]string {
	return map_StaticIPAMAddresses
}

var map_StaticIPAMConfig = map[string]string{
	"":          "StaticIPAMConfig contains configurations for static IPAM (IP Address Management)",
	"addresses": "Addresses configures IP address for the interface",
	"routes":    "Routes configures IP routes for the interface",
	"dns":       "DNS configures DNS for the interface",
}

func (StaticIPAMConfig) SwaggerDoc() map[string]string {
	return map_StaticIPAMConfig
}

var map_StaticIPAMDNS = map[string]string{
	"":            "StaticIPAMDNS provides DNS related information for static IPAM",
	"nameservers": "Nameservers points DNS servers for IP lookup",
	"domain":      "Domain configures the domainname the local domain used for short hostname lookups",
	"search":      "Search configures priority ordered search domains for short hostname lookups",
}

func (StaticIPAMDNS) SwaggerDoc() map[string]string {
	return map_StaticIPAMDNS
}

var map_StaticIPAMRoutes = map[string]string{
	"":            "StaticIPAMRoutes provides Destination/Gateway pairs for static IPAM routes",
	"destination": "Destination points the IP route destination",
	"gateway":     "Gateway is the route's next-hop IP address If unset, a default gateway is assumed (as determined by the CNI plugin).",
}

func (StaticIPAMRoutes) SwaggerDoc() map[string]string {
	return map_StaticIPAMRoutes
}

var map_OpenShiftAPIServer = map[string]string{
	"":       "OpenShiftAPIServer provides information to configure an operator to manage openshift-apiserver.",
	"spec":   "spec is the specification of the desired behavior of the OpenShift API Server.",
	"status": "status defines the observed status of the OpenShift API Server.",
}

func (OpenShiftAPIServer) SwaggerDoc() map[string]string {
	return map_OpenShiftAPIServer
}

var map_OpenShiftAPIServerList = map[string]string{
	"":      "OpenShiftAPIServerList is a collection of items",
	"items": "Items contains the items",
}

func (OpenShiftAPIServerList) SwaggerDoc() map[string]string {
	return map_OpenShiftAPIServerList
}

var map_OpenShiftAPIServerStatus = map[string]string{
	"latestAvailableRevision": "latestAvailableRevision is the latest revision used as suffix of revisioned secrets like encryption-config. A new revision causes a new deployment of pods.",
}

func (OpenShiftAPIServerStatus) SwaggerDoc() map[string]string {
	return map_OpenShiftAPIServerStatus
}

var map_OpenShiftControllerManager = map[string]string{
	"": "OpenShiftControllerManager provides information to configure an operator to manage openshift-controller-manager.",
}

func (OpenShiftControllerManager) SwaggerDoc() map[string]string {
	return map_OpenShiftControllerManager
}

var map_OpenShiftControllerManagerList = map[string]string{
	"":      "OpenShiftControllerManagerList is a collection of items",
	"items": "Items contains the items",
}

func (OpenShiftControllerManagerList) SwaggerDoc() map[string]string {
	return map_OpenShiftControllerManagerList
}

var map_KubeScheduler = map[string]string{
	"":       "KubeScheduler provides information to configure an operator to manage scheduler.",
	"spec":   "spec is the specification of the desired behavior of the Kubernetes Scheduler",
	"status": "status is the most recently observed status of the Kubernetes Scheduler",
}

func (KubeScheduler) SwaggerDoc() map[string]string {
	return map_KubeScheduler
}

var map_KubeSchedulerList = map[string]string{
	"":      "KubeSchedulerList is a collection of items",
	"items": "Items contains the items",
}

func (KubeSchedulerList) SwaggerDoc() map[string]string {
	return map_KubeSchedulerList
}

var map_ServiceCA = map[string]string{
	"":       "ServiceCA provides information to configure an operator to manage the service cert controllers",
	"spec":   "spec holds user settable values for configuration",
	"status": "status holds observed values from the cluster. They may not be overridden.",
}

func (ServiceCA) SwaggerDoc() map[string]string {
	return map_ServiceCA
}

var map_ServiceCAList = map[string]string{
	"":      "ServiceCAList is a collection of items",
	"items": "Items contains the items",
}

func (ServiceCAList) SwaggerDoc() map[string]string {
	return map_ServiceCAList
}

var map_ServiceCatalogAPIServer = map[string]string{
	"": "ServiceCatalogAPIServer provides information to configure an operator to manage Service Catalog API Server DEPRECATED: will be removed in 4.6",
}

func (ServiceCatalogAPIServer) SwaggerDoc() map[string]string {
	return map_ServiceCatalogAPIServer
}

var map_ServiceCatalogAPIServerList = map[string]string{
	"":      "ServiceCatalogAPIServerList is a collection of items DEPRECATED: will be removed in 4.6",
	"items": "Items contains the items",
}

func (ServiceCatalogAPIServerList) SwaggerDoc() map[string]string {
	return map_ServiceCatalogAPIServerList
}

var map_ServiceCatalogControllerManager = map[string]string{
	"": "ServiceCatalogControllerManager provides information to configure an operator to manage Service Catalog Controller Manager DEPRECATED: will be removed in 4.6",
}

func (ServiceCatalogControllerManager) SwaggerDoc() map[string]string {
	return map_ServiceCatalogControllerManager
}

var map_ServiceCatalogControllerManagerList = map[string]string{
	"":      "ServiceCatalogControllerManagerList is a collection of items DEPRECATED: will be removed in 4.6",
	"items": "Items contains the items",
}

func (ServiceCatalogControllerManagerList) SwaggerDoc() map[string]string {
	return map_ServiceCatalogControllerManagerList
}

var map_Storage = map[string]string{
	"":       "Storage provides a means to configure an operator to manage the cluster storage operator. `cluster` is the canonical name.",
	"spec":   "spec holds user settable values for configuration",
	"status": "status holds observed values from the cluster. They may not be overridden.",
}

func (Storage) SwaggerDoc() map[string]string {
	return map_Storage
}

var map_StorageList = map[string]string{
	"": "StorageList contains a list of Storages.",
}

func (StorageList) SwaggerDoc() map[string]string {
	return map_StorageList
}

var map_StorageSpec = map[string]string{
	"": "StorageSpec is the specification of the desired behavior of the cluster storage operator.",
}

func (StorageSpec) SwaggerDoc() map[string]string {
	return map_StorageSpec
}

var map_StorageStatus = map[string]string{
	"": "StorageStatus defines the observed status of the cluster storage operator.",
}

func (StorageStatus) SwaggerDoc() map[string]string {
	return map_StorageStatus
}

// AUTO-GENERATED FUNCTIONS END HERE
