// Code generated by golex. DO NOT EDIT.

/*
This file is used with golex to generate a lexer that has a signature compatible with goyacc.

Many constants referred to below are defined by goyacc when creating template.y.go

See https://godoc.org/modernc.org/golex for more about golex
*/

package datemath

import (
	"bytes"
	"fmt"
	"strconv"
)

const (
	// 0 is expected by the goyacc generated parser to indicate EOF
	eofCode = 0
)

// lexer holds the state of the lexer
type lexer struct {
	src *bytes.Reader

	buf     []byte
	current byte

	pos int

	errors []string
}

func newLexer(b []byte) *lexer {
	l := &lexer{
		src: bytes.NewReader(b),
	}
	// queue up a byte
	l.next()
	return l
}

func (l *lexer) Error(s string) {
	l.errors = append(l.errors, fmt.Sprintf("%s at character %d starting with %q", s, l.pos, string(l.buf)))
}

func (l *lexer) next() {
	if l.current != 0 {
		l.buf = append(l.buf, l.current)
	}
	l.current = 0
	if b, err := l.src.ReadByte(); err == nil {
		l.current = b
	}
	l.pos++
}
func (l *lexer) Lex(lval *yySymType) int {

	/* give some regular expressions more semantic names for use below */
	/* tell golex how to determine the current start condition */
	/* tell golex how to determine the current byte */
	/* tell golex how to advance to the next byte */

yystate0:

	// runs before each token is parsed
	l.buf = l.buf[:0]

	goto yystart1

yystate1:
	l.next()
yystart1:
	switch {
	default:
		goto yyabort
	case l.current == '+':
		goto yystate4
	case l.current == '-':
		goto yystate5
	case l.current == '.':
		goto yystate6
	case l.current == '/':
		goto yystate7
	case l.current == ':':
		goto yystate9
	case l.current == 'H' || l.current == 'M' || l.current == 'Q' || l.current == 'b' || l.current == 'd' || l.current == 'h' || l.current == 'm' || l.current == 's' || l.current == 'w' || l.current == 'y':
		goto yystate10
	case l.current == 'T':
		goto yystate11
	case l.current == 'Z':
		goto yystate12
	case l.current == '\x00':
		goto yystate2
	case l.current == 'f':
		goto yystate13
	case l.current == 'n':
		goto yystate16
	case l.current == '|':
		goto yystate20
	case l.current >= '0' && l.current <= '9':
		goto yystate8
	case l.current >= '\x01' && l.current <= '\t' || l.current >= '\v' && l.current <= '*' || l.current == ',' || l.current >= ';' && l.current <= 'G' || l.current >= 'I' && l.current <= 'L' || l.current >= 'N' && l.current <= 'P' || l.current == 'R' || l.current == 'S' || l.current >= 'U' && l.current <= 'Y' || l.current >= '[' && l.current <= 'a' || l.current == 'c' || l.current == 'e' || l.current == 'g' || l.current >= 'i' && l.current <= 'l' || l.current >= 'o' && l.current <= 'r' || l.current >= 't' && l.current <= 'v' || l.current == 'x' || l.current == 'z' || l.current == '{' || l.current >= '}' && l.current <= 'ÿ':
		goto yystate3
	}

yystate2:
	l.next()
	goto yyrule14

yystate3:
	l.next()
	goto yyrule16

yystate4:
	l.next()
	goto yyrule3

yystate5:
	l.next()
	goto yyrule4

yystate6:
	l.next()
	goto yyrule11

yystate7:
	l.next()
	goto yyrule7

yystate8:
	l.next()
	goto yyrule1

yystate9:
	l.next()
	goto yyrule5

yystate10:
	l.next()
	goto yyrule8

yystate11:
	l.next()
	goto yyrule12

yystate12:
	l.next()
	goto yyrule13

yystate13:
	l.next()
	switch {
	default:
		goto yyrule16
	case l.current == 'Q':
		goto yystate14
	case l.current == 'y':
		goto yystate15
	}

yystate14:
	l.next()
	goto yyrule10

yystate15:
	l.next()
	goto yyrule9

yystate16:
	l.next()
	switch {
	default:
		goto yyrule16
	case l.current == 'o':
		goto yystate17
	}

yystate17:
	l.next()
	switch {
	default:
		goto yyabort
	case l.current == 'w':
		goto yystate19
	case l.current >= '\x01' && l.current <= '\t' || l.current >= '\v' && l.current <= 'v' || l.current >= 'x' && l.current <= 'ÿ':
		goto yystate18
	}

yystate18:
	l.next()
	goto yyrule15

yystate19:
	l.next()
	goto yyrule2

yystate20:
	l.next()
	switch {
	default:
		goto yyrule16
	case l.current == '|':
		goto yystate21
	}

yystate21:
	l.next()
	goto yyrule6

yyrule1: // [0-9]
	{

		i, err := strconv.ParseInt(string(l.buf), 10, 0)
		if err != nil {
			panic(fmt.Sprintf("could not parse digit as number: %s", err))
		}
		lval.i = int(i)
		return tDIGIT
	}
yyrule2: // "now"
	{

		return tNOW
	}
yyrule3: // "+"
	{

		return tPLUS
	}
yyrule4: // "-"
	{

		return tMINUS
	}
yyrule5: // ":"
	{

		return tCOLON
	}
yyrule6: // "||"
	{

		return tPIPES
	}
yyrule7: // "/"
	{

		return tBACKSLASH
	}
yyrule8: // [yMwdbhHmsQ]
	{

		switch l.buf[0] {
		case 'y':
			lval.unit = timeUnitYear
		case 'Q':
			lval.unit = timeUnitQuarter
		case 'M':
			lval.unit = timeUnitMonth
		case 'w':
			lval.unit = timeUnitWeek
		case 'b':
			lval.unit = timeUnitBusinessDay
		case 'd':
			lval.unit = timeUnitDay
		case 'h', 'H':
			lval.unit = timeUnitHour
		case 'm':
			lval.unit = timeUnitMinute
		case 's':
			lval.unit = timeUnitSecond
		default:
			panic(fmt.Sprintf("unknown time unit: %q", l.buf[0]))
		}
		return tUNIT
	}
yyrule9: // "fy"
	{

		lval.unit = timeUnitFiscalYear
		return tUNIT
	}
yyrule10: // "fQ"
	{

		lval.unit = timeUnitFiscalQuarter
		return tUNIT
	}
yyrule11: // \.
	{

		return tDOT
	}
yyrule12: // "T"
	{

		return tTIME_DELIMITER
	}
yyrule13: // "Z"
	{

		return tUTC
	}
yyrule14: // {eof}
	{

		return eofCode
	}
yyrule15: // no.
	{

		return tINVALID_TOKEN
	}
yyrule16: // .
	if true { // avoid go vet determining the below panic will not be reached

		return tINVALID_TOKEN
	}
	panic("unreachable")

yyabort: // no lexem recognized
	//
	// silence unused label errors for build and satisfy go vet reachability analysis
	//
	{
		if false {
			goto yyabort
		}
		if false {
			goto yystate0
		}
		if false {
			goto yystate1
		}
	}

	// should never get here
	panic("scanner internal error")
}
