// Code generated by go-swagger; DO NOT EDIT.

package teams

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new teams API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for teams API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AddTeamMember(teamID string, body *models.AddTeamMemberCommand, opts ...ClientOption) (*AddTeamMemberOK, error)
	AddTeamMemberWithParams(params *AddTeamMemberParams, opts ...ClientOption) (*AddTeamMemberOK, error)

	CreateTeam(body *models.CreateTeamCommand, opts ...ClientOption) (*CreateTeamOK, error)
	CreateTeamWithParams(params *CreateTeamParams, opts ...ClientOption) (*CreateTeamOK, error)

	DeleteTeamByID(teamID string, opts ...ClientOption) (*DeleteTeamByIDOK, error)
	DeleteTeamByIDWithParams(params *DeleteTeamByIDParams, opts ...ClientOption) (*DeleteTeamByIDOK, error)

	GetTeamByID(teamID string, opts ...ClientOption) (*GetTeamByIDOK, error)
	GetTeamByIDWithParams(params *GetTeamByIDParams, opts ...ClientOption) (*GetTeamByIDOK, error)

	GetTeamMembers(teamID string, opts ...ClientOption) (*GetTeamMembersOK, error)
	GetTeamMembersWithParams(params *GetTeamMembersParams, opts ...ClientOption) (*GetTeamMembersOK, error)

	GetTeamPreferences(teamID string, opts ...ClientOption) (*GetTeamPreferencesOK, error)
	GetTeamPreferencesWithParams(params *GetTeamPreferencesParams, opts ...ClientOption) (*GetTeamPreferencesOK, error)

	RemoveTeamMember(userID int64, teamID string, opts ...ClientOption) (*RemoveTeamMemberOK, error)
	RemoveTeamMemberWithParams(params *RemoveTeamMemberParams, opts ...ClientOption) (*RemoveTeamMemberOK, error)

	SearchTeams(params *SearchTeamsParams, opts ...ClientOption) (*SearchTeamsOK, error)

	UpdateTeam(teamID string, body *models.UpdateTeamCommand, opts ...ClientOption) (*UpdateTeamOK, error)
	UpdateTeamWithParams(params *UpdateTeamParams, opts ...ClientOption) (*UpdateTeamOK, error)

	UpdateTeamMember(params *UpdateTeamMemberParams, opts ...ClientOption) (*UpdateTeamMemberOK, error)

	UpdateTeamPreferences(teamID string, body *models.UpdatePrefsCmd, opts ...ClientOption) (*UpdateTeamPreferencesOK, error)
	UpdateTeamPreferencesWithParams(params *UpdateTeamPreferencesParams, opts ...ClientOption) (*UpdateTeamPreferencesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AddTeamMember adds team member
*/
func (a *Client) AddTeamMember(teamID string, body *models.AddTeamMemberCommand, opts ...ClientOption) (*AddTeamMemberOK, error) {
	params := NewAddTeamMemberParams().WithBody(body).WithTeamID(teamID)
	return a.AddTeamMemberWithParams(params, opts...)
}

func (a *Client) AddTeamMemberWithParams(params *AddTeamMemberParams, opts ...ClientOption) (*AddTeamMemberOK, error) {
	if params == nil {
		params = NewAddTeamMemberParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addTeamMember",
		Method:             "POST",
		PathPattern:        "/teams/{team_id}/members",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AddTeamMemberReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AddTeamMemberOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for addTeamMember: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateTeam adds team
*/
func (a *Client) CreateTeam(body *models.CreateTeamCommand, opts ...ClientOption) (*CreateTeamOK, error) {
	params := NewCreateTeamParams().WithBody(body)
	return a.CreateTeamWithParams(params, opts...)
}

func (a *Client) CreateTeamWithParams(params *CreateTeamParams, opts ...ClientOption) (*CreateTeamOK, error) {
	if params == nil {
		params = NewCreateTeamParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createTeam",
		Method:             "POST",
		PathPattern:        "/teams",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateTeamReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateTeamOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createTeam: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteTeamByID deletes team by ID
*/
func (a *Client) DeleteTeamByID(teamID string, opts ...ClientOption) (*DeleteTeamByIDOK, error) {
	params := NewDeleteTeamByIDParams().WithTeamID(teamID)
	return a.DeleteTeamByIDWithParams(params, opts...)
}

func (a *Client) DeleteTeamByIDWithParams(params *DeleteTeamByIDParams, opts ...ClientOption) (*DeleteTeamByIDOK, error) {
	if params == nil {
		params = NewDeleteTeamByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteTeamByID",
		Method:             "DELETE",
		PathPattern:        "/teams/{team_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteTeamByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteTeamByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteTeamByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetTeamByID gets team by ID
*/
func (a *Client) GetTeamByID(teamID string, opts ...ClientOption) (*GetTeamByIDOK, error) {
	params := NewGetTeamByIDParams().WithTeamID(teamID)
	return a.GetTeamByIDWithParams(params, opts...)
}

func (a *Client) GetTeamByIDWithParams(params *GetTeamByIDParams, opts ...ClientOption) (*GetTeamByIDOK, error) {
	if params == nil {
		params = NewGetTeamByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getTeamByID",
		Method:             "GET",
		PathPattern:        "/teams/{team_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetTeamByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTeamByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getTeamByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetTeamMembers gets team members
*/
func (a *Client) GetTeamMembers(teamID string, opts ...ClientOption) (*GetTeamMembersOK, error) {
	params := NewGetTeamMembersParams().WithTeamID(teamID)
	return a.GetTeamMembersWithParams(params, opts...)
}

func (a *Client) GetTeamMembersWithParams(params *GetTeamMembersParams, opts ...ClientOption) (*GetTeamMembersOK, error) {
	if params == nil {
		params = NewGetTeamMembersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getTeamMembers",
		Method:             "GET",
		PathPattern:        "/teams/{team_id}/members",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetTeamMembersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTeamMembersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getTeamMembers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetTeamPreferences gets team preferences
*/
func (a *Client) GetTeamPreferences(teamID string, opts ...ClientOption) (*GetTeamPreferencesOK, error) {
	params := NewGetTeamPreferencesParams().WithTeamID(teamID)
	return a.GetTeamPreferencesWithParams(params, opts...)
}

func (a *Client) GetTeamPreferencesWithParams(params *GetTeamPreferencesParams, opts ...ClientOption) (*GetTeamPreferencesOK, error) {
	if params == nil {
		params = NewGetTeamPreferencesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getTeamPreferences",
		Method:             "GET",
		PathPattern:        "/teams/{team_id}/preferences",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetTeamPreferencesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTeamPreferencesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getTeamPreferences: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RemoveTeamMember removes member from team
*/
func (a *Client) RemoveTeamMember(userID int64, teamID string, opts ...ClientOption) (*RemoveTeamMemberOK, error) {
	params := NewRemoveTeamMemberParams().WithTeamID(teamID).WithUserID(userID)
	return a.RemoveTeamMemberWithParams(params, opts...)
}

func (a *Client) RemoveTeamMemberWithParams(params *RemoveTeamMemberParams, opts ...ClientOption) (*RemoveTeamMemberOK, error) {
	if params == nil {
		params = NewRemoveTeamMemberParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "removeTeamMember",
		Method:             "DELETE",
		PathPattern:        "/teams/{team_id}/members/{user_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RemoveTeamMemberReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RemoveTeamMemberOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for removeTeamMember: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SearchTeams teams search with paging
*/

func (a *Client) SearchTeams(params *SearchTeamsParams, opts ...ClientOption) (*SearchTeamsOK, error) {
	if params == nil {
		params = NewSearchTeamsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "searchTeams",
		Method:             "GET",
		PathPattern:        "/teams/search",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SearchTeamsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SearchTeamsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for searchTeams: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateTeam updates team
*/
func (a *Client) UpdateTeam(teamID string, body *models.UpdateTeamCommand, opts ...ClientOption) (*UpdateTeamOK, error) {
	params := NewUpdateTeamParams().WithBody(body).WithTeamID(teamID)
	return a.UpdateTeamWithParams(params, opts...)
}

func (a *Client) UpdateTeamWithParams(params *UpdateTeamParams, opts ...ClientOption) (*UpdateTeamOK, error) {
	if params == nil {
		params = NewUpdateTeamParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateTeam",
		Method:             "PUT",
		PathPattern:        "/teams/{team_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateTeamReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateTeamOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateTeam: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateTeamMember updates team member
*/

func (a *Client) UpdateTeamMember(params *UpdateTeamMemberParams, opts ...ClientOption) (*UpdateTeamMemberOK, error) {
	if params == nil {
		params = NewUpdateTeamMemberParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateTeamMember",
		Method:             "PUT",
		PathPattern:        "/teams/{team_id}/members/{user_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateTeamMemberReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateTeamMemberOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateTeamMember: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateTeamPreferences updates team preferences
*/
func (a *Client) UpdateTeamPreferences(teamID string, body *models.UpdatePrefsCmd, opts ...ClientOption) (*UpdateTeamPreferencesOK, error) {
	params := NewUpdateTeamPreferencesParams().WithBody(body).WithTeamID(teamID)
	return a.UpdateTeamPreferencesWithParams(params, opts...)
}

func (a *Client) UpdateTeamPreferencesWithParams(params *UpdateTeamPreferencesParams, opts ...ClientOption) (*UpdateTeamPreferencesOK, error) {
	if params == nil {
		params = NewUpdateTeamPreferencesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateTeamPreferences",
		Method:             "PUT",
		PathPattern:        "/teams/{team_id}/preferences",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateTeamPreferencesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateTeamPreferencesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateTeamPreferences: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
