// Code generated by go-swagger; DO NOT EDIT.

package datasource_permissions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// AddPermissionReader is a Reader for the AddPermission structure.
type AddPermissionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AddPermissionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAddPermissionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAddPermissionUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAddPermissionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewAddPermissionNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAddPermissionInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /datasources/{datasourceId}/permissions] addPermission", response, response.Code())
	}
}

// NewAddPermissionOK creates a AddPermissionOK with default headers values
func NewAddPermissionOK() *AddPermissionOK {
	return &AddPermissionOK{}
}

/*
AddPermissionOK describes a response with status code 200, with default header values.

(empty)
*/
type AddPermissionOK struct {
	Payload *models.AddPermissionOKBody
}

// IsSuccess returns true when this add permission Ok response has a 2xx status code
func (o *AddPermissionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this add permission Ok response has a 3xx status code
func (o *AddPermissionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permission Ok response has a 4xx status code
func (o *AddPermissionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this add permission Ok response has a 5xx status code
func (o *AddPermissionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this add permission Ok response a status code equal to that given
func (o *AddPermissionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the add permission Ok response
func (o *AddPermissionOK) Code() int {
	return 200
}

func (o *AddPermissionOK) Error() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionOk  %+v", 200, o.Payload)
}

func (o *AddPermissionOK) String() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionOk  %+v", 200, o.Payload)
}

func (o *AddPermissionOK) GetPayload() *models.AddPermissionOKBody {
	return o.Payload
}

func (o *AddPermissionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AddPermissionOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddPermissionUnauthorized creates a AddPermissionUnauthorized with default headers values
func NewAddPermissionUnauthorized() *AddPermissionUnauthorized {
	return &AddPermissionUnauthorized{}
}

/*
AddPermissionUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type AddPermissionUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add permission unauthorized response has a 2xx status code
func (o *AddPermissionUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permission unauthorized response has a 3xx status code
func (o *AddPermissionUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permission unauthorized response has a 4xx status code
func (o *AddPermissionUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this add permission unauthorized response has a 5xx status code
func (o *AddPermissionUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this add permission unauthorized response a status code equal to that given
func (o *AddPermissionUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the add permission unauthorized response
func (o *AddPermissionUnauthorized) Code() int {
	return 401
}

func (o *AddPermissionUnauthorized) Error() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionUnauthorized  %+v", 401, o.Payload)
}

func (o *AddPermissionUnauthorized) String() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionUnauthorized  %+v", 401, o.Payload)
}

func (o *AddPermissionUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddPermissionUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddPermissionForbidden creates a AddPermissionForbidden with default headers values
func NewAddPermissionForbidden() *AddPermissionForbidden {
	return &AddPermissionForbidden{}
}

/*
AddPermissionForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type AddPermissionForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add permission forbidden response has a 2xx status code
func (o *AddPermissionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permission forbidden response has a 3xx status code
func (o *AddPermissionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permission forbidden response has a 4xx status code
func (o *AddPermissionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this add permission forbidden response has a 5xx status code
func (o *AddPermissionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this add permission forbidden response a status code equal to that given
func (o *AddPermissionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the add permission forbidden response
func (o *AddPermissionForbidden) Code() int {
	return 403
}

func (o *AddPermissionForbidden) Error() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionForbidden  %+v", 403, o.Payload)
}

func (o *AddPermissionForbidden) String() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionForbidden  %+v", 403, o.Payload)
}

func (o *AddPermissionForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddPermissionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddPermissionNotFound creates a AddPermissionNotFound with default headers values
func NewAddPermissionNotFound() *AddPermissionNotFound {
	return &AddPermissionNotFound{}
}

/*
AddPermissionNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type AddPermissionNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add permission not found response has a 2xx status code
func (o *AddPermissionNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permission not found response has a 3xx status code
func (o *AddPermissionNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permission not found response has a 4xx status code
func (o *AddPermissionNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this add permission not found response has a 5xx status code
func (o *AddPermissionNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this add permission not found response a status code equal to that given
func (o *AddPermissionNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the add permission not found response
func (o *AddPermissionNotFound) Code() int {
	return 404
}

func (o *AddPermissionNotFound) Error() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionNotFound  %+v", 404, o.Payload)
}

func (o *AddPermissionNotFound) String() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionNotFound  %+v", 404, o.Payload)
}

func (o *AddPermissionNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddPermissionNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddPermissionInternalServerError creates a AddPermissionInternalServerError with default headers values
func NewAddPermissionInternalServerError() *AddPermissionInternalServerError {
	return &AddPermissionInternalServerError{}
}

/*
AddPermissionInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type AddPermissionInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add permission internal server error response has a 2xx status code
func (o *AddPermissionInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permission internal server error response has a 3xx status code
func (o *AddPermissionInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permission internal server error response has a 4xx status code
func (o *AddPermissionInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this add permission internal server error response has a 5xx status code
func (o *AddPermissionInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this add permission internal server error response a status code equal to that given
func (o *AddPermissionInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the add permission internal server error response
func (o *AddPermissionInternalServerError) Code() int {
	return 500
}

func (o *AddPermissionInternalServerError) Error() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionInternalServerError  %+v", 500, o.Payload)
}

func (o *AddPermissionInternalServerError) String() string {
	return fmt.Sprintf("[POST /datasources/{datasourceId}/permissions][%d] addPermissionInternalServerError  %+v", 500, o.Payload)
}

func (o *AddPermissionInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddPermissionInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
