package cloudWatchConsts

var NamespaceMetricsMap = map[string][]string{
	"/aws/sagemaker/Endpoints": {
		"CPUReservation",
		"CPUUtilization",
		"CPUUtilizationNormalized",
		"DiskUtilization",
		"GPUMemoryUtilization",
		"GPUMemoryUtilizationNormalized",
		"GPUReservation",
		"GPUUtilization",
		"GPUUtilizationNormalized",
		"LoadedModelCount",
		"MemoryReservation",
		"MemoryUtilization",
	},
	"/aws/sagemaker/InferenceComponents": {
		"CPUUtilizationNormalized",
		"GPUMemoryUtilizationNormalized",
		"GPUUtilizationNormalized",
		"MemoryUtilizationNormalized",
	},
	"/aws/sagemaker/InferenceRecommendationsJobs": {
		"ClientInvocationErrors",
		"ClientInvocations",
		"ClientLatency",
		"NumberOfUsers",
	},
	"/aws/sagemaker/ProcessingJobs": {
		"CPUReservation",
		"CPUUtilization",
		"CPUUtilizationNormalized",
		"DiskUtilization",
		"GPUMemoryUtilization",
		"GPUMemoryUtilizationNormalized",
		"GPUReservation",
		"GPUUtilization",
		"GPUUtilizationNormalized",
		"MemoryReservation",
		"MemoryUtilization",
	},
	"/aws/sagemaker/TrainingJobs": {
		"CPUReservation",
		"CPUUtilization",
		"CPUUtilizationNormalized",
		"DiskUtilization",
		"GPUMemoryUtilization",
		"GPUMemoryUtilizationNormalized",
		"GPUReservation",
		"GPUUtilization",
		"GPUUtilizationNormalized",
		"MemoryReservation",
		"MemoryUtilization",
	},
	"/aws/sagemaker/TransformJobs": {
		"CPUReservation",
		"CPUUtilization",
		"CPUUtilizationNormalized",
		"DiskUtilization",
		"GPUMemoryUtilization",
		"GPUMemoryUtilizationNormalized",
		"GPUReservation",
		"GPUUtilization",
		"GPUUtilizationNormalized",
		"MemoryReservation",
		"MemoryUtilization",
	},
	"AWS/ACMPrivateCA": {
		"CRLGenerated",
		"Failure",
		"MisconfiguredCRLBucket",
		"Success",
		"Time",
	},
	"AWS/AmazonMQ": {
		"AckRate",
		"BurstBalance",
		"ChannelCount",
		"ConfirmRate",
		"ConnectionCount",
		"ConsumerCount",
		"CpuCreditBalance",
		"CpuUtilization",
		"CurrentConnectionsCount",
		"DequeueCount",
		"DispatchCount",
		"EnqueueCount",
		"EnqueueTime",
		"EstablishedConnectionsCount",
		"ExchangeCount",
		"ExpiredCount",
		"HeapUsage",
		"InFlightCount",
		"InactiveDurableTopicSubscribersCount",
		"JobSchedulerStorePercentUsage",
		"JournalFilesForFastRecovery",
		"JournalFilesForFullRecovery",
		"MemoryUsage",
		"MessageCount",
		"MessageReadyCount",
		"MessageUnacknowledgedCount",
		"NetworkIn",
		"NetworkOut",
		"OpenTransactionCount",
		"ProducerCount",
		"PublishRate",
		"QueueCount",
		"QueueSize",
		"RabbitMQDiskFree",
		"RabbitMQDiskFreeLimit",
		"RabbitMQFdUsed",
		"RabbitMQMemLimit",
		"RabbitMQMemUsed",
		"ReceiveCount",
		"StorePercentUsage",
		"SystemCpuUtilization",
		"TempPercentUsage",
		"TotalConsumerCount",
		"TotalDequeueCount",
		"TotalEnqueueCount",
		"TotalMessageCount",
		"TotalProducerCount",
		"VolumeReadOps",
		"VolumeWriteOps",
	},
	"AWS/AmplifyHosting": {
		"4xxErrors",
		"5xxErrors",
		"BytesDownloaded",
		"BytesUploaded",
		"Latency",
		"Requests",
	},
	"AWS/ApiGateway": {
		"4XXError",
		"4xx",
		"5XXError",
		"5xx",
		"CacheHitCount",
		"CacheMissCount",
		"ClientError",
		"ConnectCount",
		"Count",
		"DataProcessed",
		"ExecutionError",
		"IntegrationError",
		"IntegrationLatency",
		"Latency",
		"MessageCount",
	},
	"AWS/AppFlow": {
		"FlowExecutionRecordsProcessed",
		"FlowExecutionTime",
		"FlowExecutionsFailed",
		"FlowExecutionsStarted",
		"FlowExecutionsSucceeded",
	},
	"AWS/AppRunner": {
		"2xxStatusResponses",
		"4xxStatusResponses",
		"5xxStatusResponses",
		"ActiveInstances",
		"CPUUtilization",
		"MemoryUtilization",
		"RequestLatency",
		"Requests",
	},
	"AWS/AppStream": {
		"ActualCapacity",
		"AvailableCapacity",
		"CapacityUtilization",
		"DesiredCapacity",
		"InUseCapacity",
		"InsufficientCapacityError",
		"PendingCapacity",
		"RunningCapacity",
	},
	"AWS/AppSync": {
		"4XXError",
		"5XXError",
		"ActiveConnections",
		"ActiveSubscriptions",
		"ConnectClientError",
		"ConnectServerError",
		"ConnectSuccess",
		"ConnectionDuration",
		"DisconnectClientError",
		"DisconnectServerError",
		"DisconnectSuccess",
		"Latency",
		"PublishDataMessageClientError",
		"PublishDataMessageServerError",
		"PublishDataMessageSize",
		"PublishDataMessageSuccess",
		"Requests",
		"SubscribeClientError",
		"SubscribeServerError",
		"SubscribeSuccess",
		"TokensConsumed",
		"UnsubscribeClientError",
		"UnsubscribeServerError",
		"UnsubscribeSuccess",
	},
	"AWS/ApplicationELB": {
		"ActiveConnectionCount",
		"AnomalousHostCount",
		"ClientTLSNegotiationErrorCount",
		"ConsumedLCUs",
		"DesyncMitigationMode_NonCompliant_Request_Count",
		"DroppedInvalidHeaderRequestCount",
		"ELBAuthError",
		"ELBAuthFailure",
		"ELBAuthLatency",
		"ELBAuthRefreshTokenSuccess",
		"ELBAuthSuccess",
		"ELBAuthUserClaimsSizeExceeded",
		"ForwardedInvalidHeaderRequestCount",
		"GrpcRequestCount",
		"HTTPCode_ELB_3XX_Count",
		"HTTPCode_ELB_4XX_Count",
		"HTTPCode_ELB_500_Count",
		"HTTPCode_ELB_502_Count",
		"HTTPCode_ELB_503_Count",
		"HTTPCode_ELB_504_Count",
		"HTTPCode_ELB_5XX_Count",
		"HTTPCode_Target_2XX_Count",
		"HTTPCode_Target_3XX_Count",
		"HTTPCode_Target_4XX_Count",
		"HTTPCode_Target_5XX_Count",
		"HTTP_Fixed_Response_Count",
		"HTTP_Redirect_Count",
		"HTTP_Redirect_Url_Limit_Exceeded_Count",
		"HealthyHostCount",
		"HealthyStateDNS",
		"HealthyStateRouting",
		"IPv6ProcessedBytes",
		"IPv6RequestCount",
		"LambdaInternalError",
		"LambdaTargetProcessedBytes",
		"LambdaUserError",
		"MitigatedHostCount",
		"NewConnectionCount",
		"NonStickyRequestCount",
		"ProcessedBytes",
		"RejectedConnectionCount",
		"RequestCount",
		"RequestCountPerTarget",
		"RuleEvaluations",
		"StandardProcessedBytes",
		"TargetConnectionErrorCount",
		"TargetResponseTime",
		"TargetTLSNegotiationErrorCount",
		"UnHealthyHostCount",
		"UnhealthyRoutingRequestCount",
		"UnhealthyStateDNS",
		"UnhealthyStateRouting",
	},
	"AWS/Athena": {
		"EngineExecutionTime",
		"ProcessedBytes",
		"QueryPlanningTime",
		"QueryQueueTime",
		"ServiceProcessingTime",
		"TotalExecutionTime",
	},
	"AWS/AutoScaling": {
		"GroupAndWarmPoolDesiredCapacity",
		"GroupAndWarmPoolTotalCapacity",
		"GroupDesiredCapacity",
		"GroupInServiceCapacity",
		"GroupInServiceInstances",
		"GroupMaxSize",
		"GroupMinSize",
		"GroupPendingCapacity",
		"GroupPendingInstances",
		"GroupStandbyCapacity",
		"GroupStandbyInstances",
		"GroupTerminatingCapacity",
		"GroupTerminatingInstances",
		"GroupTotalCapacity",
		"GroupTotalInstances",
		"PredictiveScalingCapacityForecast",
		"PredictiveScalingLoadForecast",
		"PredictiveScalingMetricPairCorrelation",
		"WarmPoolDesiredCapacity",
		"WarmPoolMinSize",
		"WarmPoolPendingCapacity",
		"WarmPoolTerminatingCapacity",
		"WarmPoolTotalCapacity",
		"WarmPoolWarmedCapacity",
	},
	"AWS/Backup": {
		"NumberOfBackupJobsAborted",
		"NumberOfBackupJobsCompleted",
		"NumberOfBackupJobsCreated",
		"NumberOfBackupJobsExpired",
		"NumberOfBackupJobsFailed",
		"NumberOfBackupJobsPending",
		"NumberOfBackupJobsRunning",
		"NumberOfCopyJobsCompleted",
		"NumberOfCopyJobsCreated",
		"NumberOfCopyJobsFailed",
		"NumberOfCopyJobsRunning",
		"NumberOfRecoveryPointsCold",
		"NumberOfRecoveryPointsCompleted",
		"NumberOfRecoveryPointsDeleting",
		"NumberOfRecoveryPointsExpired",
		"NumberOfRecoveryPointsPartial",
		"NumberOfRestoreJobsCompleted",
		"NumberOfRestoreJobsFailed",
		"NumberOfRestoreJobsPending",
		"NumberOfRestoreJobsRunning",
	},
	"AWS/Bedrock": {
		"InputTokenCount",
		"InvocationClientErrors",
		"InvocationLatency",
		"InvocationServerErrors",
		"InvocationThrottles",
		"Invocations",
		"OutputImageCount",
		"OutputTokenCount",
	},
	"AWS/Billing": {
		"EstimatedCharges",
	},
	"AWS/Cassandra": {
		"AccountMaxReads",
		"AccountMaxTableLevelReads",
		"AccountMaxTableLevelWrites",
		"AccountMaxWrites",
		"AccountProvisionedReadCapacityUtilization",
		"AccountProvisionedWriteCapacityUtilization",
		"ConditionalCheckFailedRequests",
		"ConsumedReadCapacityUnits",
		"ConsumedWriteCapacityUnits",
		"MaxProvisionedTableReadCapacityUtilization",
		"MaxProvisionedTableWriteCapacityUtilization",
		"ReturnedItemCount",
		"ReturnedItemCountBySelect",
		"SuccessfulRequestCount",
		"SuccessfulRequestLatency",
		"SystemErrors",
		"UserErrors",
	},
	"AWS/CertificateManager": {
		"DaysToExpiry",
	},
	"AWS/Chatbot": {
		"EventsProcessed",
		"EventsThrottled",
		"MessageDeliveryFailure",
		"MessageDeliverySuccess",
		"UnsupportedEvents",
	},
	"AWS/ClientVPN": {
		"ActiveConnectionsCount",
		"AuthenticationFailures",
		"CrlDaysToExpiry",
		"EgressBytes",
		"EgressPackets",
		"IngressBytes",
		"IngressPackets",
		"SelfServicePortalClientConfigurationDownloads",
	},
	"AWS/CloudFront": {
		"401ErrorRate",
		"403ErrorRate",
		"404ErrorRate",
		"4xxErrorRate",
		"502ErrorRate",
		"503ErrorRate",
		"504ErrorRate",
		"5xxErrorRate",
		"BytesDownloaded",
		"BytesUploaded",
		"CacheHitRate",
		"FunctionComputeUtilization",
		"FunctionExecutionErrors",
		"FunctionInvocations",
		"FunctionThrottles",
		"FunctionValidationErrors",
		"LambdaExecutionError",
		"LambdaLimitExceededErrors",
		"LambdaValidationError",
		"OriginLatency",
		"Requests",
		"TotalErrorRate",
	},
	"AWS/CloudHSM": {
		"HsmKeysSessionOccupied",
		"HsmKeysTokenOccupied",
		"HsmSessionCount",
		"HsmSslCtxsOccupied",
		"HsmTemperature",
		"HsmUnhealthy",
		"HsmUsersAvailable",
		"HsmUsersMax",
		"InterfaceEth2OctetsInput",
		"InterfaceEth2OctetsOutput",
	},
	"AWS/CloudSearch": {
		"IndexUtilization",
		"Partitions",
		"SearchableDocuments",
		"SuccessfulRequests",
	},
	"AWS/CodeBuild": {
		"BuildDuration",
		"Builds",
		"DownloadSourceDuration",
		"Duration",
		"FailedBuilds",
		"FinalizingDuration",
		"InstallDuration",
		"PostBuildDuration",
		"PreBuildDuration",
		"ProvisioningDuration",
		"QueuedDuration",
		"SubmittedDuration",
		"SucceededBuilds",
		"UploadArtifactsDuration",
	},
	"AWS/CodeGuruProfiler": {
		"Recommendations",
	},
	"AWS/Cognito": {
		"AccountTakeOverRisk",
		"CompromisedCredentialsRisk",
		"FederationSuccesses",
		"FederationThrottles",
		"NoRisk",
		"OverrideBlock",
		"Risk",
		"SignInSuccesses",
		"SignInThrottles",
		"SignUpSuccesses",
		"SignUpThrottles",
		"TokenRefreshSuccesses",
		"TokenRefreshThrottles",
	},
	"AWS/Connect": {
		"CallBackNotDialableNumber",
		"CallRecordingUploadError",
		"CallsBreachingConcurrencyQuota",
		"CallsPerInterval",
		"ConcurrentCalls",
		"ConcurrentCallsPercentage",
		"ContactFlowErrors",
		"ContactFlowFatalErrors",
		"LongestQueueWaitTime",
		"MisconfiguredPhoneNumbers",
		"MissedCalls",
		"PublicSigningKeyUsage",
		"QueueCapacityExceededError",
		"QueueSize",
		"ThrottledCalls",
		"ToInstancePacketLossRate",
	},
	"AWS/DAX": {
		"BatchGetItemRequestCount",
		"BatchWriteItemRequestCount",
		"CPUUtilization",
		"ClientConnections",
		"DeleteItemRequestCount",
		"ErrorRequestCount",
		"EstimatedDbSize",
		"EvictedSize",
		"FailedRequestCount",
		"FaultRequestCount",
		"GetItemRequestCount",
		"ItemCacheHits",
		"ItemCacheMisses",
		"NetworkPacketsIn",
		"NetworkPacketsOut",
		"PutItemRequestCount",
		"QueryCacheHits",
		"QueryCacheMisses",
		"QueryRequestCount",
		"ScanCacheHits",
		"ScanCacheMisses",
		"ScanRequestCount",
		"TotalRequestCount",
		"TransactGetItemsCount",
		"TransactWriteItemsCount",
		"UpdateItemRequestCount",
	},
	"AWS/DDoSProtection": {
		"DDoSAttackBitsPerSecond",
		"DDoSAttackPacketsPerSecond",
		"DDoSAttackRequestsPerSecond",
		"DDoSDetected",
		"VolumeBitsPerSecond",
		"VolumePacketsPerSecond",
	},
	"AWS/DMS": {
		"CDCChangesDiskSource",
		"CDCChangesDiskTarget",
		"CDCChangesMemorySource",
		"CDCChangesMemoryTarget",
		"CDCIncomingChanges",
		"CDCLatencySource",
		"CDCLatencyTarget",
		"CDCThroughputBandwidthSource",
		"CDCThroughputBandwidthTarget",
		"CDCThroughputRowsSource",
		"CDCThroughputRowsTarget",
		"CPUUtilization",
		"FreeStorageSpace",
		"FreeableMemory",
		"FullLoadThroughputBandwidthSource",
		"FullLoadThroughputBandwidthTarget",
		"FullLoadThroughputRowsSource",
		"FullLoadThroughputRowsTarget",
		"NetworkReceiveThroughput",
		"NetworkTransmitThroughput",
		"ReadIOPS",
		"ReadLatency",
		"ReadThroughput",
		"SwapUsage",
		"WriteIOPS",
		"WriteLatency",
		"WriteThroughput",
	},
	"AWS/DX": {
		"ConnectionBpsEgress",
		"ConnectionBpsIngress",
		"ConnectionCRCErrorCount",
		"ConnectionEncryptionState",
		"ConnectionErrorCount",
		"ConnectionLightLevelRx",
		"ConnectionLightLevelTx",
		"ConnectionPpsEgress",
		"ConnectionPpsIngress",
		"ConnectionState",
		"VirtualInterfaceBpsEgress",
		"VirtualInterfaceBpsIngress",
		"VirtualInterfacePpsEgress",
		"VirtualInterfacePpsIngress",
	},
	"AWS/DataSync": {
		"BytesPreparedDestination",
		"BytesPreparedSource",
		"BytesTransferred",
		"BytesVerifiedDestination",
		"BytesVerifiedSource",
		"BytesWritten",
		"FilesPreparedDestination",
		"FilesPreparedSource",
		"FilesTransferred",
		"FilesVerifiedDestination",
		"FilesVerifiedSource",
	},
	"AWS/DocDB": {
		"BackupRetentionPeriodStorageUsed",
		"BufferCacheHitRatio",
		"CPUUtilization",
		"ChangeStreamLogSize",
		"DBClusterReplicaLagMaximum",
		"DBClusterReplicaLagMinimum",
		"DBInstanceReplicaLag",
		"DatabaseConnections",
		"DatabaseConnectionsMax",
		"DatabaseCursors",
		"DatabaseCursorsMax",
		"DatabaseCursorsTimedOut",
		"DiskQueueDepth",
		"DocumentsDeleted",
		"DocumentsInserted",
		"DocumentsReturned",
		"DocumentsUpdated",
		"EngineUptime",
		"FreeLocalStorage",
		"FreeableMemory",
		"NetworkReceiveThroughput",
		"NetworkThroughput",
		"NetworkTransmitThroughput",
		"OpcountersCommand",
		"OpcountersDelete",
		"OpcountersGetmore",
		"OpcountersInsert",
		"OpcountersQuery",
		"OpcountersUpdate",
		"ReadIOPS",
		"ReadLatency",
		"ReadThroughput",
		"SnapshotStorageUsed",
		"SwapUsage",
		"TotalBackupStorageBilled",
		"VolumeBytesUsed",
		"VolumeReadIOPs",
		"VolumeWriteIOPs",
		"WriteIOPS",
		"WriteLatency",
		"WriteThroughput",
	},
	"AWS/DynamoDB": {
		"AccountMaxReads",
		"AccountMaxTableLevelReads",
		"AccountMaxTableLevelWrites",
		"AccountMaxWrites",
		"AccountProvisionedReadCapacityUtilization",
		"AccountProvisionedWriteCapacityUtilization",
		"AgeOfOldestUnreplicatedRecord",
		"ConditionalCheckFailedRequests",
		"ConsumedChangeDataCaptureUnits",
		"ConsumedReadCapacityUnits",
		"ConsumedWriteCapacityUnits",
		"FailedToReplicateRecordCount",
		"MaxProvisionedTableReadCapacityUtilization",
		"MaxProvisionedTableWriteCapacityUtilization",
		"OnDemandMaxReadRequestUnits",
		"OnDemandMaxWriteRequestUnits",
		"OnlineIndexConsumedWriteCapacity",
		"OnlineIndexPercentageProgress",
		"OnlineIndexThrottleEvents",
		"PendingReplicationCount",
		"ProvisionedReadCapacityUnits",
		"ProvisionedWriteCapacityUnits",
		"ReadThrottleEvents",
		"ReplicationLatency",
		"ReturnedBytes",
		"ReturnedItemCount",
		"ReturnedRecordsCount",
		"SuccessfulRequestLatency",
		"SystemErrors",
		"ThrottledPutRecordCount",
		"ThrottledRequests",
		"TimeToLiveDeletedItemCount",
		"TransactionConflict",
		"UserErrors",
		"WriteThrottleEvents",
	},
	"AWS/EBS": {
		"BurstBalance",
		"EnableCopiedImageDeprecationCompleted",
		"EnableCopiedImageDeprecationFailed",
		"EnableImageDeprecationCompleted",
		"EnableImageDeprecationFailed",
		"ImagesCopiedRegionCompleted",
		"ImagesCopiedRegionDeregisterCompleted",
		"ImagesCopiedRegionDeregisteredFailed",
		"ImagesCopiedRegionFailed",
		"ImagesCopiedRegionStarted",
		"ImagesCreateCompleted",
		"ImagesCreateFailed",
		"ImagesCreateStarted",
		"ImagesDeregisterCompleted",
		"ImagesDeregisterFailed",
		"ResourcesTargeted",
		"SnapshotsCopiedAccountCompleted",
		"SnapshotsCopiedAccountDeleteCompleted",
		"SnapshotsCopiedAccountDeleteFailed",
		"SnapshotsCopiedAccountFailed",
		"SnapshotsCopiedAccountStarted",
		"SnapshotsCopiedRegionCompleted",
		"SnapshotsCopiedRegionDeleteCompleted",
		"SnapshotsCopiedRegionDeleteFailed",
		"SnapshotsCopiedRegionFailed",
		"SnapshotsCopiedRegionStarted",
		"SnapshotsCreateCompleted",
		"SnapshotsCreateFailed",
		"SnapshotsCreateStarted",
		"SnapshotsDeleteCompleted",
		"SnapshotsDeleteFailed",
		"SnapshotsSharedCompleted",
		"VolumeConsumedReadWriteOps",
		"VolumeIdleTime",
		"VolumeQueueLength",
		"VolumeReadBytes",
		"VolumeReadOps",
		"VolumeThroughputPercentage",
		"VolumeTotalReadTime",
		"VolumeTotalWriteTime",
		"VolumeWriteBytes",
		"VolumeWriteOps",
	},
	"AWS/EC2": {
		"CPUCreditBalance",
		"CPUCreditUsage",
		"CPUSurplusCreditBalance",
		"CPUSurplusCreditsCharged",
		"CPUUtilization",
		"DedicatedHostCPUUtilization",
		"DiskReadBytes",
		"DiskReadOps",
		"DiskWriteBytes",
		"DiskWriteOps",
		"EBSByteBalance%",
		"EBSIOBalance%",
		"EBSReadBytes",
		"EBSReadOps",
		"EBSWriteBytes",
		"EBSWriteOps",
		"MetadataNoToken",
		"NetworkIn",
		"NetworkOut",
		"NetworkPacketsIn",
		"NetworkPacketsOut",
		"StatusCheckFailed",
		"StatusCheckFailed_AttachedEBS",
		"StatusCheckFailed_Instance",
		"StatusCheckFailed_System",
	},
	"AWS/EC2/API": {
		"ClientErrors",
		"RequestLimitExceeded",
		"ServerErrors",
		"SuccessfulCalls",
	},
	"AWS/EC2CapacityReservations": {
		"AvailableInstanceCount",
		"InstanceUtilization",
		"TotalInstanceCount",
		"UsedInstanceCount",
	},
	"AWS/EC2Spot": {
		"AvailableInstancePoolsCount",
		"BidsSubmittedForCapacity",
		"EligibleInstancePoolCount",
		"FulfilledCapacity",
		"MaxPercentCapacityAllocation",
		"PendingCapacity",
		"PercentCapacityAllocation",
		"TargetCapacity",
		"TerminatingCapacity",
	},
	"AWS/ECR": {
		"RepositoryPullCount",
	},
	"AWS/ECS": {
		"CPUReservation",
		"CPUUtilization",
		"GPUReservation",
		"MemoryReservation",
		"MemoryUtilization",
	},
	"AWS/EFS": {
		"BurstCreditBalance",
		"ClientConnections",
		"DataReadIOBytes",
		"DataWriteIOBytes",
		"MetadataIOBytes",
		"MeteredIOBytes",
		"PercentIOLimit",
		"PermittedThroughput",
		"StorageBytes",
		"TotalIOBytes",
	},
	"AWS/ELB": {
		"BackendConnectionErrors",
		"EstimatedALBActiveConnectionCount",
		"EstimatedALBConsumedLCUs",
		"EstimatedALBNewConnectionCount",
		"EstimatedProcessedBytes",
		"HTTPCode_Backend_2XX",
		"HTTPCode_Backend_3XX",
		"HTTPCode_Backend_4XX",
		"HTTPCode_Backend_5XX",
		"HTTPCode_ELB_4XX",
		"HTTPCode_ELB_5XX",
		"HealthyHostCount",
		"Latency",
		"RequestCount",
		"SpilloverCount",
		"SurgeQueueLength",
		"UnHealthyHostCount",
	},
	"AWS/EMRServerless": {
		"CPUAllocated",
		"CancelledJobs",
		"CancellingJobs",
		"FailedJobs",
		"IdleWorkerCount",
		"MaxCPUAllowed",
		"MaxMemoryAllowed",
		"MaxStorageAllowed",
		"MemoryAllocated",
		"PendingCreationWorkerCount",
		"PendingJobs",
		"RunningJobs",
		"RunningWorkerCount",
		"ScheduledJobs",
		"StorageAllocated",
		"SubmittedJobs",
		"SuccessJobs",
		"TotalWorkerCount",
	},
	"AWS/ES": {
		"2xx",
		"3xx",
		"4xx",
		"5xx",
		"ADAnomalyDetectorsIndexStatus.red",
		"ADAnomalyDetectorsIndexStatusIndexExists",
		"ADAnomalyResultsIndexStatus.red",
		"ADAnomalyResultsIndexStatusIndexExists",
		"ADExecuteFailureCount",
		"ADExecuteRequestCount",
		"ADHCExecuteFailureCount",
		"ADHCExecuteRequestCount",
		"ADModelsCheckpointIndexStatus.red",
		"ADModelsCheckpointIndexStatusIndexExists",
		"ADPluginUnhealthy",
		"AlertingDegraded",
		"AlertingIndexExists",
		"AlertingIndexStatus.green",
		"AlertingIndexStatus.red",
		"AlertingIndexStatus.yellow",
		"AlertingNodesNotOnSchedule",
		"AlertingNodesOnSchedule",
		"AlertingScheduledJobEnabled",
		"AsynchronousSearchCancelled",
		"AsynchronousSearchCompletionRate",
		"AsynchronousSearchFailureRate",
		"AsynchronousSearchInitializedRate",
		"AsynchronousSearchMaxRunningTime",
		"AsynchronousSearchPersistFailedRate",
		"AsynchronousSearchPersistRate",
		"AsynchronousSearchRejected",
		"AsynchronousSearchRunningCurrent",
		"AsynchronousSearchStoreHealth",
		"AsynchronousSearchStoreSize",
		"AsynchronousSearchStoredResponseCount",
		"AsynchronousSearchSubmissionRate",
		"AutoFollowLeaderCallFailure",
		"AutoFollowNumFailedStartReplication",
		"AutoFollowNumSuccessStartReplication",
		"AutoTuneChangesHistoryHeapSize",
		"AutoTuneChangesHistoryJVMYoungGenArgs",
		"AutoTuneFailed",
		"AutoTuneSucceeded",
		"AutoTuneValue",
		"AutomatedSnapshotFailure",
		"AvgPointInTimeAliveTime",
		"BurstBalance",
		"CPUCreditBalance",
		"CPUUtilization",
		"ClusterIndexWritesBlocked",
		"ClusterStatus.green",
		"ClusterStatus.red",
		"ClusterStatus.yellow",
		"ClusterUsedSpace",
		"ColdStorageSpaceUtilization",
		"ColdToWarmMigrationFailureCount",
		"ColdToWarmMigrationLatency",
		"ColdToWarmMigrationQueueSize",
		"ColdToWarmMigrationSuccessCount",
		"CoordinatingWriteRejected",
		"CrossClusterInboundReplicationRequests",
		"CrossClusterInboundRequests",
		"CrossClusterOutboundConnections",
		"CrossClusterOutboundReplicationRequests",
		"CrossClusterOutboundRequests",
		"CurrentPointInTime",
		"DataNodes",
		"DataNodesShards.active",
		"DataNodesShards.initializing",
		"DataNodesShards.relocating",
		"DataNodesShards.unassigned",
		"DeletedDocuments",
		"DiskQueueDepth",
		"ESReportingFailedRequestSysErrCount",
		"ESReportingFailedRequestUserErrCount",
		"ESReportingRequestCount",
		"ESReportingSuccessCount",
		"ElasticsearchRequests",
		"FollowerCheckPoint",
		"FreeStorageSpace",
		"HasActivePointInTime",
		"HasUsedPointInTime",
		"HotStorageSpaceUtilization",
		"HotToWarmMigrationFailureCount",
		"HotToWarmMigrationForceMergeLatency",
		"HotToWarmMigrationProcessingLatency",
		"HotToWarmMigrationQueueSize",
		"HotToWarmMigrationSnapshotLatency",
		"HotToWarmMigrationSuccessCount",
		"HotToWarmMigrationSuccessLatency",
		"IndexingLatency",
		"IndexingRate",
		"InvalidHostHeaderRequests",
		"IopsThrottle",
		"JVMGCOldCollectionCount",
		"JVMGCOldCollectionTime",
		"JVMGCYoungCollectionCount",
		"JVMGCYoungCollectionTime",
		"JVMMemoryPressure",
		"KMSKeyError",
		"KMSKeyInaccessible",
		"KNNCacheCapacityReached",
		"KNNCircuitBreakerTriggered",
		"KNNEvictionCount",
		"KNNGraphIndexErrors",
		"KNNGraphIndexRequests",
		"KNNGraphMemoryUsage",
		"KNNGraphQueryErrors",
		"KNNGraphQueryRequests",
		"KNNHitCount",
		"KNNLoadExceptionCount",
		"KNNLoadSuccessCount",
		"KNNMissCount",
		"KNNQueryRequests",
		"KNNScriptCompilationErrors",
		"KNNScriptCompilations",
		"KNNScriptQueryErrors",
		"KNNScriptQueryRequests",
		"KNNTotalLoadTime",
		"KibanaConcurrentConnections",
		"KibanaHealthyNodes",
		"KibanaHeapTotal",
		"KibanaHeapUsed",
		"KibanaHeapUtilization",
		"KibanaOS1MinuteLoad",
		"KibanaReportingFailedRequestSysErrCount",
		"KibanaReportingFailedRequestUserErrCount",
		"KibanaReportingRequestCount",
		"KibanaReportingSuccessCount",
		"KibanaRequestTotal",
		"KibanaResponseTimesMaxInMillis",
		"LTRFeatureMemoryUsageInBytes",
		"LTRFeaturesetMemoryUsageInBytes",
		"LTRMemoryUsage",
		"LTRModelMemoryUsageInBytes",
		"LTRRequestErrorCount",
		"LTRRequestTotalCount",
		"LTRStatus.red",
		"LeaderCheckPoint",
		"MasterCPUCreditBalance",
		"MasterCPUUtilization",
		"MasterFreeStorageSpace",
		"MasterJVMMemoryPressure",
		"MasterOldGenJVMMemoryPressure",
		"MasterReachableFromNode",
		"MasterSysMemoryUtilization",
		"MaxProvisionedThroughput",
		"Nodes",
		"OldGenJVMMemoryPressure",
		"OpenSearchDashboardsConcurrentConnections",
		"OpenSearchDashboardsHealthyNode",
		"OpenSearchDashboardsHealthyNodes",
		"OpenSearchDashboardsHeapTotal",
		"OpenSearchDashboardsHeapUsed",
		"OpenSearchDashboardsHeapUtilization",
		"OpenSearchDashboardsOS1MinuteLoad",
		"OpenSearchDashboardsRequestTotal",
		"OpenSearchDashboardsResponseTimesMaxInMillis",
		"OpenSearchRequests",
		"OpensearchDashboardsReportingFailedRequestSysErrCount",
		"OpensearchDashboardsReportingFailedRequestUserErrCount",
		"OpensearchDashboardsReportingRequestCount",
		"OpensearchDashboardsReportingSuccessCount",
		"PPLFailedRequestCountByCusErr",
		"PPLFailedRequestCountBySysErr",
		"PPLRequestCount",
		"PrimaryWriteRejected",
		"ReadIOPS",
		"ReadIOPSMicroBursting",
		"ReadLatency",
		"ReadThroughput",
		"ReadThroughputMicroBursting",
		"RemoteStorageUsedSpace",
		"RemoteStorageWriteRejected",
		"ReplicaWriteRejected",
		"ReplicationNumBootstrappingIndices",
		"ReplicationNumFailedIndices",
		"ReplicationNumPausedIndices",
		"ReplicationNumSyncingIndices",
		"ReplicationRate",
		"SQLDefaultCursorRequestCount",
		"SQLFailedRequestCountByCusErr",
		"SQLFailedRequestCountBySysErr",
		"SQLRequestCount",
		"SQLUnhealthy",
		"SearchLatency",
		"SearchRate",
		"SearchShardTaskCancelled",
		"SearchTaskCancelled",
		"SearchableDocuments",
		"SegmentCount",
		"Shards.active",
		"Shards.activePrimary",
		"Shards.delayedUnassigned",
		"Shards.initializing",
		"Shards.relocating",
		"Shards.unassigned",
		"SysMemoryUtilization",
		"ThreadpoolBulkQueue",
		"ThreadpoolBulkRejected",
		"ThreadpoolBulkThreads",
		"ThreadpoolForce_mergeQueue",
		"ThreadpoolForce_mergeRejected",
		"ThreadpoolForce_mergeThreads",
		"ThreadpoolIndexQueue",
		"ThreadpoolIndexRejected",
		"ThreadpoolIndexThreads",
		"ThreadpoolSearchQueue",
		"ThreadpoolSearchRejected",
		"ThreadpoolSearchThreads",
		"ThreadpoolWriteQueue",
		"ThreadpoolWriteRejected",
		"ThreadpoolWriteThreads",
		"Threadpoolsql-workerQueue",
		"Threadpoolsql-workerRejected",
		"Threadpoolsql-workerThreads",
		"ThroughputThrottle",
		"TotalPointInTime",
		"WarmCPUUtilization",
		"WarmFreeStorageSpace",
		"WarmJVMGCOldCollectionCount",
		"WarmJVMGCYoungCollectionCount",
		"WarmJVMGCYoungCollectionTime",
		"WarmJVMMemoryPressure",
		"WarmOldGenJVMMemoryPressure",
		"WarmSearchLatency",
		"WarmSearchRate",
		"WarmSearchableDocuments",
		"WarmStorageSpaceUtilization",
		"WarmSysMemoryUtilization",
		"WarmThreadpoolSearchQueue",
		"WarmThreadpoolSearchRejected",
		"WarmThreadpoolSearchThreads",
		"WarmToColdMigrationFailureCount",
		"WarmToColdMigrationLatency",
		"WarmToColdMigrationQueueSize",
		"WarmToColdMigrationSuccessCount",
		"WarmToHotMigrationQueueSize",
		"WriteIOPS",
		"WriteIOPSMicroBursting",
		"WriteLatency",
		"WriteThroughput",
		"WriteThroughputMicroBursting",
	},
	"AWS/ElastiCache": {
		"ActiveDefragHits",
		"AuthenticationFailures",
		"BytesReadFromDisk",
		"BytesReadIntoMemcached",
		"BytesUsedForCache",
		"BytesUsedForCacheItems",
		"BytesUsedForHash",
		"BytesUsedForMemoryDB",
		"BytesWrittenOutFromMemcached",
		"BytesWrittenToDisk",
		"CPUCreditBalance",
		"CPUCreditUsage",
		"CPUUtilization",
		"CacheHitRate",
		"CacheHits",
		"CacheMisses",
		"CasBadval",
		"CasHits",
		"CasMisses",
		"ChannelAuthorizationFailures",
		"ClusterBasedCmds",
		"ClusterBasedCmdsLatency",
		"CmdConfigGet",
		"CmdConfigSet",
		"CmdFlush",
		"CmdGet",
		"CmdSet",
		"CmdTouch",
		"CommandAuthorizationFailures",
		"CurrConfig",
		"CurrConnections",
		"CurrItems",
		"CurrVolatileItems",
		"DB0AverageTTL",
		"DatabaseCapacityUsageCountedForEvictPercentage",
		"DatabaseCapacityUsagePercentage",
		"DatabaseMemoryUsageCountedForEvictPercentage",
		"DatabaseMemoryUsagePercentage",
		"DecrHits",
		"DecrMisses",
		"DeleteHits",
		"DeleteMisses",
		"ElastiCacheProcessingUnits",
		"EngineCPUUtilization",
		"EvalBasedCmds",
		"EvalBasedCmdsECPUs",
		"EvalBasedCmdsLatency",
		"EvictedUnfetched",
		"Evictions",
		"ExpiredUnfetched",
		"FreeableMemory",
		"GeoSpatialBasedCmds",
		"GeoSpatialBasedCmdsECPUs",
		"GeoSpatialBasedCmdsLatency",
		"GetHits",
		"GetMisses",
		"GetTypeCmds",
		"GetTypeCmdsECPUs",
		"GetTypeCmdsLatency",
		"GlobalDatastoreReplicationLag",
		"HashBasedCmds",
		"HashBasedCmdsECPUs",
		"HashBasedCmdsLatency",
		"HyperLogLogBasedCmds",
		"HyperLogLogBasedCmdsECPUs",
		"HyperLogLogBasedCmdsLatency",
		"IamAuthenticationExpirations",
		"IamAuthenticationThrottling",
		"IncrHits",
		"IncrMisses",
		"IsMaster",
		"IsPrimary",
		"JsonBasedCmds",
		"JsonBasedCmdsECPUs",
		"JsonBasedCmdsLatency",
		"JsonBasedGetCmds",
		"JsonBasedGetCmdsECPUs",
		"JsonBasedSetCmds",
		"JsonBasedSetCmdsECPUs",
		"KeyAuthorizationFailures",
		"KeyBasedCmds",
		"KeyBasedCmdsECPUs",
		"KeyBasedCmdsLatency",
		"KeysTracked",
		"KeyspaceHits",
		"KeyspaceMisses",
		"ListBasedCmds",
		"ListBasedCmdsECPUs",
		"ListBasedCmdsLatency",
		"MasterLinkHealthStatus",
		"MaxReplicationThroughput",
		"MemoryFragmentationRatio",
		"NetworkBandwidthInAllowanceExceeded",
		"NetworkBandwidthOutAllowanceExceeded",
		"NetworkBytesIn",
		"NetworkBytesOut",
		"NetworkConntrackAllowanceExceeded",
		"NetworkLinkLocalAllowanceExceeded",
		"NetworkMaxBytesIn",
		"NetworkMaxBytesOut ",
		"NetworkMaxPacketsIn",
		"NetworkMaxPacketsOut",
		"NetworkPacketsIn",
		"NetworkPacketsOut",
		"NetworkPacketsPerSecondAllowanceExceeded",
		"NewConnections",
		"NewItems",
		"NonKeyTypeCmds",
		"NonKeyTypeCmdsECPUs",
		"NumItemsReadFromDisk",
		"NumItemsWrittenToDisk",
		"PrimaryLinkHealthStatus",
		"PubSubBasedCmds",
		"PubSubBasedCmdsECPUs",
		"PubSubBasedCmdsLatency",
		"Reclaimed",
		"ReplicationBytes",
		"ReplicationDelayedWriteCommands",
		"ReplicationLag",
		"SaveInProgress",
		"SearchBasedCmds",
		"SearchBasedGetCmds",
		"SearchBasedSetCmds",
		"SearchNumberOfIndexedKeys",
		"SearchNumberOfIndexes",
		"SearchTotalIndexSize",
		"SetBasedCmds",
		"SetBasedCmdsECPUs",
		"SetBasedCmdsLatency",
		"SetTypeCmds",
		"SetTypeCmdsECPUs",
		"SetTypeCmdsLatency",
		"SlabsMoved",
		"SortedSetBasedCmds",
		"SortedSetBasedCmdsECPUs",
		"SortedSetBasedCmdsLatency",
		"StreamBasedCmds",
		"StreamBasedCmdsECPUs",
		"StreamBasedCmdsLatency",
		"StringBasedCmds",
		"StringBasedCmdsECPUs",
		"StringBasedCmdsLatency",
		"SuccessfulReadRequestLatency",
		"SuccessfulWriteRequestLatency",
		"SwapUsage",
		"ThrottledCmds",
		"TotalCmdsCount",
		"TouchHits",
		"TouchMisses",
		"TrafficManagementActive",
		"UnusedMemory",
	},
	"AWS/ElasticBeanstalk": {
		"ApplicationLatencyP10",
		"ApplicationLatencyP50",
		"ApplicationLatencyP75",
		"ApplicationLatencyP85",
		"ApplicationLatencyP90",
		"ApplicationLatencyP95",
		"ApplicationLatencyP99",
		"ApplicationLatencyP99.9",
		"ApplicationRequests2xx",
		"ApplicationRequests3xx",
		"ApplicationRequests4xx",
		"ApplicationRequests5xx",
		"ApplicationRequestsTotal",
		"CPUIdle",
		"CPUIowait",
		"CPUIrq",
		"CPUNice",
		"CPUSoftirq",
		"CPUSystem",
		"CPUUser",
		"EnvironmentHealth",
		"InstanceHealth",
		"InstancesDegraded",
		"InstancesInfo",
		"InstancesNoData",
		"InstancesOk",
		"InstancesPending",
		"InstancesSevere",
		"InstancesUnknown",
		"InstancesWarning",
		"LoadAverage1min",
		"LoadAverage5min",
		"RootFilesystemUtil",
	},
	"AWS/ElasticGPUs": {
		"GPUConnectivityCheckFailed",
		"GPUHealthCheckFailed",
		"GPUMemoryUtilization",
	},
	"AWS/ElasticInference": {
		"AcceleratorHealthCheckFailed",
		"AcceleratorMemoryUsage",
		"ConnectivityCheckFailed",
	},
	"AWS/ElasticMapReduce": {
		"AppsCompleted",
		"AppsFailed",
		"AppsKilled",
		"AppsPending",
		"AppsRunning",
		"AppsSubmitted",
		"BackupFailed",
		"CapacityRemainingGB",
		"Cluster Status",
		"ContainerAllocated",
		"ContainerPending",
		"ContainerPendingRatio",
		"ContainerReserved",
		"CoreNodesPending",
		"CoreNodesRunning",
		"CorruptBlocks",
		"DfsPendingReplicationBlocks",
		"HBase",
		"HDFSBytesRead",
		"HDFSBytesWritten",
		"HDFSUtilization",
		"HbaseBackupFailed",
		"IO",
		"IsIdle",
		"JobsFailed",
		"JobsRunning",
		"LiveDataNodes",
		"LiveTaskTrackers",
		"MRActiveNodes",
		"MRDecommissionedNodes",
		"MRLostNodes",
		"MRRebootedNodes",
		"MRTotalNodes",
		"MRUnhealthyNodes",
		"Map/Reduce",
		"MapSlotsOpen",
		"MapTasksRemaining",
		"MapTasksRunning",
		"MemoryAllocatedMB",
		"MemoryAvailableMB",
		"MemoryReservedMB",
		"MemoryTotalMB",
		"MissingBlocks",
		"MostRecentBackupDuration",
		"Node Status",
		"PendingDeletionBlocks",
		"ReduceSlotsOpen",
		"ReduceTasksRemaining",
		"ReduceTasksRunning",
		"RemainingMapTasksPerSlot",
		"S3BytesRead",
		"S3BytesWritten",
		"TaskNodesPending",
		"TaskNodesRunning",
		"TimeSinceLastSuccessfulBackup",
		"TotalLoad",
		"UnderReplicatedBlocks",
		"YARNMemoryAvailablePercentage",
	},
	"AWS/ElasticTranscoder": {
		"Billed Audio Output",
		"Billed HD Output",
		"Billed SD Output",
		"Errors",
		"Jobs Completed",
		"Jobs Errored",
		"Outputs per Job",
		"Standby Time",
		"Throttles",
	},
	"AWS/EventBridge/Pipes": {
		"Concurrency",
		"Duration",
		"EnrichmentStageDuration",
		"EnrichmentStageFailed",
		"EventCount",
		"EventSize",
		"ExecutionFailed",
		"ExecutionPartiallyFailed",
		"ExecutionThrottled",
		"ExecutionTimeout",
		"Invocations",
		"TargetStageDuration",
		"TargetStageFailed",
		"TargetStagePartiallyFailed",
		"TargetStageSkipped",
	},
	"AWS/Events": {
		"DeadLetterInvocations",
		"Events",
		"FailedInvocations",
		"IngestiontoInvocationCompleteLatency",
		"IngestiontoInvocationStartLatency",
		"InvocationAttempts",
		"Invocations",
		"InvocationsCreated",
		"InvocationsFailedToBeSentToDlq",
		"InvocationsSentToDlq",
		"MatchedEvents",
		"PutEventsApproximateCallCount",
		"PutEventsApproximateFailedCount",
		"PutEventsApproximateSuccessCount",
		"PutEventsApproximateThrottledCount",
		"PutEventsEntriesCount",
		"PutEventsFailedEntriesCount",
		"PutEventsLatency",
		"PutEventsRequestSize",
		"PutPartnerEventsApproximateCallCount",
		"PutPartnerEventsApproximateFailedCount",
		"PutPartnerEventsApproximateSuccessCount",
		"PutPartnerEventsApproximateThrottledCount",
		"PutPartnerEventsEntriesCount",
		"PutPartnerEventsFailedEntriesCount",
		"PutPartnerEventsLatency",
		"RetryInvocationAttempts",
		"SuccessfulInvocationAttempts",
		"ThrottledRules",
		"TriggeredRules",
	},
	"AWS/FSx": {
		"CPUUtilization",
		"ClientConnections",
		"DataReadBytes",
		"DataReadOperations",
		"DataWriteBytes",
		"DataWriteOperations",
		"DeduplicationSavedStorage",
		"DiskIopsUtilization",
		"DiskReadBytes",
		"DiskReadOperations",
		"DiskThroughputBalance",
		"DiskThroughputUtilization",
		"DiskWriteBytes",
		"DiskWriteOperations",
		"FileServerDiskIopsBalance",
		"FileServerDiskIopsUtilization",
		"FileServerDiskThroughputBalance",
		"FileServerDiskThroughputUtilization",
		"FreeDataStorageCapacity",
		"FreeStorageCapacity",
		"MemoryUtilization",
		"MetadataOperations",
		"NetworkThroughputUtilization",
		"StorageCapacityUtilization",
	},
	"AWS/Firehose": {
		"ActivePartitionsLimit",
		"BackupToS3.Bytes",
		"BackupToS3.DataFreshness",
		"BackupToS3.Records",
		"BackupToS3.Success",
		"BytesPerSecondLimit",
		"DataReadFromKinesisStream.Bytes",
		"DataReadFromKinesisStream.Records",
		"DataReadFromSource.Backpressured",
		"DataReadFromSource.Bytes",
		"DataReadFromSource.Records",
		"DeliveryToAmazonOpenSearchServerless.AuthFailure",
		"DeliveryToAmazonOpenSearchServerless.Bytes",
		"DeliveryToAmazonOpenSearchServerless.DataFreshness",
		"DeliveryToAmazonOpenSearchServerless.DeliveryRejected",
		"DeliveryToAmazonOpenSearchServerless.Records",
		"DeliveryToAmazonOpenSearchServerless.Success",
		"DeliveryToAmazonOpenSearchService.AuthFailure",
		"DeliveryToAmazonOpenSearchService.Bytes",
		"DeliveryToAmazonOpenSearchService.DataFreshness",
		"DeliveryToAmazonOpenSearchService.DeliveryRejected",
		"DeliveryToAmazonOpenSearchService.Records",
		"DeliveryToAmazonOpenSearchService.Success",
		"DeliveryToElasticsearch.Bytes",
		"DeliveryToElasticsearch.Records",
		"DeliveryToElasticsearch.Success",
		"DeliveryToHttpEndpoint.Bytes",
		"DeliveryToHttpEndpoint.DataFreshness",
		"DeliveryToHttpEndpoint.ProcessedBytes",
		"DeliveryToHttpEndpoint.ProcessedRecords",
		"DeliveryToHttpEndpoint.Records",
		"DeliveryToHttpEndpoint.Success",
		"DeliveryToRedshift.Bytes",
		"DeliveryToRedshift.Records",
		"DeliveryToRedshift.Success",
		"DeliveryToS3.Bytes",
		"DeliveryToS3.DataFreshness",
		"DeliveryToS3.ObjectCount",
		"DeliveryToS3.Records",
		"DeliveryToS3.Success",
		"DeliveryToSnowflake.Bytes",
		"DeliveryToSnowflake.DataCommitLatency",
		"DeliveryToSnowflake.DataFreshness",
		"DeliveryToSnowflake.Records",
		"DeliveryToSnowflake.Success",
		"DeliveryToSplunk.Bytes",
		"DeliveryToSplunk.DataAckLatency",
		"DeliveryToSplunk.DataFreshness",
		"DeliveryToSplunk.Records",
		"DeliveryToSplunk.Success",
		"DescribeDeliveryStream.Latency",
		"DescribeDeliveryStream.Requests",
		"ExecuteProcessing.Duration",
		"ExecuteProcessing.Success",
		"FailedConversion.Bytes",
		"FailedConversion.Records",
		"FailedValidation.Bytes",
		"FailedValidation.Records",
		"IncomingBytes",
		"IncomingPutRequests",
		"IncomingRecords",
		"JQProcessing.Duration",
		"KMSKeyAccessDenied",
		"KMSKeyDisabled",
		"KMSKeyInvalidState",
		"KMSKeyNotFound",
		"KafkaOffsetLag",
		"KinesisMillisBehindLatest",
		"ListDeliveryStreams.Latency",
		"ListDeliveryStreams.Requests",
		"OutputDecompressedBytes.Failed",
		"OutputDecompressedBytes.Success",
		"OutputDecompressedRecords.Failed",
		"OutputDecompressedRecords.Success",
		"PartitionCount",
		"PartitionCountExceeded",
		"PerPartitionThroughput",
		"PutRecord.Bytes",
		"PutRecord.Latency",
		"PutRecord.Requests",
		"PutRecordBatch.Bytes",
		"PutRecordBatch.Latency",
		"PutRecordBatch.Records",
		"PutRecordBatch.Requests",
		"PutRequestsPerSecondLimit",
		"RecordsPerSecondLimit",
		"ResourceCount",
		"SourceThrottled.Delay",
		"SucceedConversion.Bytes",
		"SucceedConversion.Records",
		"SucceedProcessing.Bytes",
		"SucceedProcessing.Records",
		"ThrottledDescribeStream",
		"ThrottledGetRecords",
		"ThrottledGetShardIterator",
		"ThrottledRecords",
		"UpdateDeliveryStream.Latency",
		"UpdateDeliveryStream.Requests",
	},
	"AWS/FraudDetector": {
		"GetEventPrediction",
		"GetEventPrediction4xxError",
		"GetEventPrediction5xxError",
		"GetEventPredictionLatency",
		"ModelInvocation",
		"ModelInvocationError",
		"ModelInvocationLatency",
		"OutcomeReturned",
		"Prediction",
		"PredictionError",
		"PredictionLatency",
		"RuleEvaluateError",
		"RuleEvaluateFalse",
		"RuleEvaluateTrue",
		"RuleNotEvaluated",
		"VariableDefaultReturned",
		"VariableUsed",
	},
	"AWS/GameLift": {
		"ActivatingGameSessions",
		"ActiveGameSessions",
		"ActiveInstances",
		"ActiveServerProcesses",
		"AvailableGameServers",
		"AvailableGameSessions",
		"AverageWaitTime",
		"CurrentPlayerSessions",
		"CurrentTickets",
		"DesiredInstances",
		"DrainingAvailableGameServers",
		"DrainingUtilizedGameServers",
		"FirstChoiceNotViable",
		"FirstChoiceOutOfCapacity",
		"GameSessionInterruptions",
		"HealthyServerProcesses",
		"IdleInstances",
		"InstanceInterruptions",
		"LowestLatencyPlacement",
		"LowestPricePlacement",
		"MatchAcceptancesTimedOut",
		"MatchesAccepted",
		"MatchesCreated",
		"MatchesPlaced",
		"MatchesRejected",
		"MaxInstances",
		"MinInstances",
		"PercentAvailableGameSessions",
		"PercentHealthyServerProcesses",
		"PercentIdleInstances",
		"Placement",
		"PlacementsCanceled",
		"PlacementsFailed",
		"PlacementsStarted",
		"PlacementsSucceeded",
		"PlacementsTimedOut",
		"PlayerSessionActivations",
		"PlayersStarted",
		"QueueDepth",
		"RuleEvaluationsFailed",
		"RuleEvaluationsPassed",
		"ServerProcessAbnormalTerminations",
		"ServerProcessActivations",
		"ServerProcessTerminations",
		"TicketsFailed",
		"TicketsStarted",
		"TicketsTimedOut",
		"TimeToMatch",
		"TimeToTicketSuccess",
		"UtilizedGameServers",
	},
	"AWS/GatewayELB": {
		"ActiveFlowCount",
		"ConsumedLCUs",
		"HealthyHostCount",
		"NewFlowCount",
		"ProcessedBytes",
		"UnHealthyHostCount",
	},
	"AWS/GlobalAccelerator": {
		"HealthyEndpointCount",
		"NewFlowCount",
		"ProcessedBytesIn",
		"ProcessedBytesOut",
		"UnhealthyEndpointCount",
	},
	"AWS/GroundStation": {
		"BitErrorRate",
		"BlockErrorRate",
		"Es/N0",
		"ReceivedPower",
	},
	"AWS/IVS": {
		"ConcurrentStreams",
		"ConcurrentViews",
		"IngestAudioBitrate",
		"IngestFramerate",
		"IngestVideoBitrate",
		"KeyframeInterval",
		"LiveDeliveredTime",
		"LiveInputTime",
		"RecordedTime",
	},
	"AWS/IVSRealTime": {
		"DroppedFrames",
		"PacketLoss",
		"PublishBitrate",
		"PublishResolution",
		"Publishers",
	},
	"AWS/Inspector": {
		"TotalAssessmentRunFindings",
		"TotalAssessmentRuns",
		"TotalHealthyAgents",
		"TotalMatchingAgents",
	},
	"AWS/IoT": {
		"CanceledJobExecutionCount",
		"CanceledJobExecutionTotalCount",
		"ClientError",
		"Connect.AuthError",
		"Connect.ClientError",
		"Connect.ServerError",
		"Connect.Success",
		"Connect.Throttle",
		"DeleteThingShadow.Accepted",
		"FailedJobExecutionCount",
		"FailedJobExecutionTotalCount",
		"Failure",
		"GetThingShadow.Accepted",
		"InProgressJobExecutionCount",
		"InProgressJobExecutionTotalCount",
		"NonCompliantResources",
		"NumLogBatchesFailedToPublishThrottled",
		"NumLogEventsFailedToPublishThrottled",
		"ParseError",
		"Ping.Success",
		"PublishIn.AuthError",
		"PublishIn.ClientError",
		"PublishIn.ServerError",
		"PublishIn.Success",
		"PublishIn.Throttle",
		"PublishOut.AuthError",
		"PublishOut.ClientError",
		"PublishOut.Success",
		"QueuedJobExecutionCount",
		"QueuedJobExecutionTotalCount",
		"RejectedJobExecutionCount",
		"RejectedJobExecutionTotalCount",
		"RemovedJobExecutionCount",
		"RemovedJobExecutionTotalCount",
		"ResourcesEvaluated",
		"RuleMessageThrottled",
		"RuleNotFound",
		"RulesExecuted",
		"ServerError",
		"Subscribe.AuthError",
		"Subscribe.ClientError",
		"Subscribe.ServerError",
		"Subscribe.Success",
		"Subscribe.Throttle",
		"SuccededJobExecutionCount",
		"SuccededJobExecutionTotalCount",
		"Success",
		"TopicMatch",
		"Unsubscribe.ClientError",
		"Unsubscribe.ServerError",
		"Unsubscribe.Success",
		"Unsubscribe.Throttle",
		"UpdateThingShadow.Accepted",
		"Violations",
		"ViolationsCleared",
		"ViolationsInvalidated",
	},
	"AWS/IoTAnalytics": {
		"ActionExecution",
		"ActivityExecutionError",
		"IncomingMessages",
	},
	"AWS/IoTSiteWise": {
		"EIPCollector.ActiveDataStreamCount",
		"EIPCollector.Heartbeat",
		"EIPCollector.IncomingValuesCount",
		"Gateway.AvailableDiskSpace",
		"Gateway.AvailableMemory",
		"Gateway.CloudConnectivity",
		"Gateway.CpuUsage",
		"Gateway.DataProcessor.IngestionThrottled",
		"Gateway.DataProcessor.MeasurementRejected",
		"Gateway.DataProcessor.MeasurementUnmodeled",
		"Gateway.DataProcessor.MessagesRemaining",
		"Gateway.DataProcessor.ProcessingError",
		"Gateway.Heartbeat",
		"Gateway.ProcessFailureCount",
		"Gateway.PublishFailureCount",
		"Gateway.PublishRejectedCount",
		"Gateway.PublishSuccessCount",
		"Gateway.TotalDiskSpace",
		"Gateway.TotalMemory",
		"Gateway.UsedDiskSpace",
		"Gateway.UsedMemory",
		"Gateway.UsedPercentageDiskSpace",
		"Gateway.UsedPercentageMemory",
		"IoTSiteWiseProcessor.IsConnectedToMqttBroker",
		"IoTSiteWiseProcessor.MqttMessageReceivedSuccessCount",
		"IoTSiteWiseProcessor.MqttReceivedSuccessBytes",
		"IoTSiteWiseProcessor.NumberOfSubscriptionsToMqttBroker",
		"IoTSiteWiseProcessor.NumberOfUniqueMqttTopicsReceived",
		"IoTSiteWisePublisher.DroppedCount",
		"IoTSiteWisePublisher.Heartbeat",
		"IoTSiteWisePublisher.IsConnectedToMqttBroker",
		"IoTSiteWisePublisher.MessageCheckpointPersistenceErrorCount",
		"IoTSiteWisePublisher.MqttMessageReceivedSuccessCount",
		"IoTSiteWisePublisher.MqttReceivedSuccessBytes",
		"IoTSiteWisePublisher.NumberOfSubscriptionsToMqttBroker",
		"IoTSiteWisePublisher.NumberOfUniqueMqttTopicsReceived",
		"IoTSiteWisePublisher.PublishFailureCount",
		"IoTSiteWisePublisher.PublishRejectedCount",
		"IoTSiteWisePublisher.PublishSuccessCount",
		"IoTSiteWisePublisher.PublishToS3FailureCount",
		"IoTSiteWisePublisher.PublishToS3SuccessCount",
		"ModbusTCPCollector.ActiveDataStreamCount",
		"ModbusTCPCollector.Heartbeat",
		"ModbusTCPCollector.IncomingValuesCount",
		"OPCUACollector.ActiveDataStreamCount",
		"OPCUACollector.Heartbeat",
		"OpcUaCollector.ActiveDataStreamCount",
		"OpcUaCollector.ConversionErrors",
		"OpcUaCollector.Heartbeat",
		"OpcUaCollector.IncomingValuesCount",
		"OpcUaCollector.IncomingValuesErrors",
	},
	"AWS/KMS": {
		"SecondsUntilKeyMaterialExpiration",
	},
	"AWS/Kafka": {
		"ActiveControllerCount",
		"BurstBalance",
		"BwInAllowanceExceeded",
		"BwOutAllowanceExceeded",
		"BytesInPerSec",
		"BytesOutPerSec",
		"CPUCreditBalance",
		"ClientConnectionCount",
		"ConnTrackAllowanceExceeded",
		"ConnectionCloseRate",
		"ConnectionCount",
		"ConnectionCreationRate",
		"CpuCreditUsage",
		"CpuIdle",
		"CpuIoWait",
		"CpuSystem",
		"CpuUser",
		"EstimatedMaxTimeLag",
		"EstimatedTimeLag",
		"FetchConsumerLocalTimeMsMean",
		"FetchConsumerRequestQueueTimeMsMean",
		"FetchConsumerResponseQueueTimeMsMean",
		"FetchConsumerResponseSendTimeMsMean",
		"FetchConsumerTotalTimeMsMean",
		"FetchFollowerLocalTimeMsMean",
		"FetchFollowerRequestQueueTimeMsMean",
		"FetchFollowerResponseQueueTimeMsMean",
		"FetchFollowerResponseSendTimeMsMean",
		"FetchFollowerTotalTimeMsMean",
		"FetchMessageConversionsPerSec",
		"FetchThrottleByteRate",
		"FetchThrottleQueueSize",
		"FetchThrottleTime",
		"GlobalPartitionCount",
		"GlobalTopicCount",
		"HeapMemoryAfterGC",
		"KafkaAppLogsDiskUsed",
		"KafkaDataLogsDiskUsed",
		"LeaderCount",
		"MaxOffsetLag",
		"MemoryBuffered",
		"MemoryCached",
		"MemoryFree",
		"MemoryUsed",
		"MessagesInPerSec",
		"NetworkProcessorAvgIdlePercent",
		"NetworkRxDropped",
		"NetworkRxErrors",
		"NetworkRxPackets",
		"NetworkTxDropped",
		"NetworkTxErrors",
		"NetworkTxPackets",
		"OfflinePartitionsCount",
		"OffsetLag",
		"PartitionCount",
		"PpsAllowanceExceeded",
		"ProduceLocalTimeMsMean",
		"ProduceMessageConversionsPerSec",
		"ProduceMessageConversionsTimeMsMean",
		"ProduceRequestQueueTimeMsMean",
		"ProduceResponseQueueTimeMsMean",
		"ProduceResponseSendTimeMsMean",
		"ProduceThrottleByteRate",
		"ProduceThrottleQueueSize",
		"ProduceThrottleTime",
		"ProduceTotalTimeMsMean",
		"RemoteCopyBytesPerSec",
		"RemoteCopyErrorsPerSec",
		"RemoteCopyLagBytes",
		"RemoteFetchBytesPerSec",
		"RemoteFetchErrorsPerSec",
		"RemoteFetchRequestsPerSec",
		"RemoteLogManagerTasksAvgIdlePercent",
		"RemoteLogReaderAvgIdlePercent",
		"RemoteLogReaderTaskQueueSize",
		"ReplicationBytesInPerSec",
		"ReplicationBytesOutPerSec",
		"RequestBytesMean",
		"RequestExemptFromThrottleTime",
		"RequestHandlerAvgIdlePercent",
		"RequestThrottleQueueSize",
		"RequestThrottleTime",
		"RequestTime",
		"RootDiskUsed",
		"SumOffsetLag",
		"SwapFree",
		"SwapUsed",
		"TCPConnections",
		"TcpConnections",
		"TrafficBytes",
		"TrafficShaping",
		"UnderMinIsrPartitionCount",
		"UnderReplicatedPartitions",
		"VolumeQueueLength",
		"VolumeReadBytes",
		"VolumeReadOps",
		"VolumeTotalReadTime",
		"VolumeTotalWriteTime",
		"VolumeWriteBytes",
		"VolumeWriteOps",
		"ZooKeeperRequestLatencyMsMean",
		"ZooKeeperSessionState",
	},
	"AWS/KafkaConnect": {
		"BytesInPerSec",
		"BytesOutPerSec",
		"CpuUtilization",
		"ErroredTaskCount",
		"MemoryUtilization",
		"RebalanceCompletedTotal",
		"RebalanceTimeAvg",
		"RebalanceTimeMax",
		"RebalanceTimeSinceLast",
		"RunningTaskCount",
		"SinkRecordReadRate",
		"SinkRecordSendRate",
		"SourceRecordPollRate",
		"SourceRecordWriteRate",
		"TaskStartupAttemptsTotal",
		"TaskStartupSuccessPercentage",
		"WorkerCount",
	},
	"AWS/Kendra": {
		"ClickFeedbackProcessedCount",
		"ClickFeedbackSubmittedCount",
		"DataSourceDocumentCount",
		"DataSourceSyncRuntime",
		"DocumentsCrawled",
		"DocumentsIndexed",
		"DocumentsSkippedInvalidMetadata",
		"DocumentsSkippedNoChange",
		"DocumentsSubmittedForDeletion",
		"DocumentsSubmittedForDeletionFailed",
		"DocumentsSubmittedForIndexing",
		"DocumentsSubmittedForIndexingFailed",
		"IndexDocumentCount",
		"IndexDocumentStorageSize",
		"IndexQueryCount",
		"MetadataFilesCrawled",
		"NonRelevantFeedbackProcessedCount",
		"ProvisionedIndexDocumentCount",
		"ProvisionedIndexStorageSize",
		"ReleventFeedbackProcessedCount",
	},
	"AWS/Kinesis": {
		"GetRecords.Bytes",
		"GetRecords.IteratorAge",
		"GetRecords.IteratorAgeMilliseconds",
		"GetRecords.Latency",
		"GetRecords.Records",
		"GetRecords.Success",
		"IncomingBytes",
		"IncomingRecords",
		"IteratorAgeMilliseconds",
		"OutgoingBytes",
		"OutgoingRecords",
		"PutRecord.Bytes",
		"PutRecord.Latency",
		"PutRecord.Success",
		"PutRecords.Bytes",
		"PutRecords.FailedRecords",
		"PutRecords.Latency",
		"PutRecords.Records",
		"PutRecords.Success",
		"PutRecords.SuccessfulRecords",
		"PutRecords.ThrottledRecords",
		"PutRecords.TotalRecords",
		"ReadProvisionedThroughputExceeded",
		"SubscribeToShard.RateExceeded",
		"SubscribeToShard.Success",
		"SubscribeToShardEvent.Bytes",
		"SubscribeToShardEvent.MillisBehindLatest",
		"SubscribeToShardEvent.Records",
		"SubscribeToShardEvent.Success",
		"WriteProvisionedThroughputExceeded",
	},
	"AWS/KinesisAnalytics": {
		"Bytes",
		"InputProcessing.DroppedRecords",
		"InputProcessing.Duration",
		"InputProcessing.OkBytes",
		"InputProcessing.OkRecords",
		"InputProcessing.ProcessingFailedRecords",
		"InputProcessing.Success",
		"KPUs",
		"LambdaDelivery.DeliveryFailedRecords",
		"LambdaDelivery.Duration",
		"LambdaDelivery.OkRecords",
		"MillisBehindLatest",
		"Records",
		"Success",
		"backPressuredTimeMsPerSecond",
		"busyTimeMsPerSecond",
		"bytesRequestedPerFetch",
		"bytes_consumed_rate",
		"commitsFailed",
		"commitsSucceeded",
		"committedoffsets",
		"containerCPUUtilization",
		"containerDiskUtilization",
		"containerMemoryUtilization",
		"cpuUtilization",
		"currentInputWatermark",
		"currentOutputWatermark",
		"currentoffsets",
		"downtime",
		"fullRestarts",
		"heapMemoryUtilization",
		"idleTimeMsPerSecond",
		"lastCheckpointDuration",
		"lastCheckpointSize",
		"managedMemoryTotal",
		"managedMemoryUsed",
		"managedMemoryUtilization",
		"millisBehindLatest",
		"numLateRecordsDropped",
		"numRecordsIn",
		"numRecordsInPerSecond",
		"numRecordsOut",
		"numRecordsOutPerSecond",
		"numberOfFailedCheckpoints",
		"oldGenerationGCCount",
		"oldGenerationGCTime",
		"records_lag_max",
		"threadCount",
		"uptime",
		"zeppelinCpuUtilization",
		"zeppelinHeapMemoryUtilization",
		"zeppelinServerUptime",
		"zeppelinThreadCount",
		"zeppelinWaitingJobs",
	},
	"AWS/KinesisVideo": {
		"GetHLSMasterPlaylist.Latency",
		"GetHLSMasterPlaylist.Requests",
		"GetHLSMasterPlaylist.Success",
		"GetHLSMediaPlaylist.Latency",
		"GetHLSMediaPlaylist.Requests",
		"GetHLSMediaPlaylist.Success",
		"GetHLSStreamingSessionURL.Latency",
		"GetHLSStreamingSessionURL.Requests",
		"GetHLSStreamingSessionURL.Success",
		"GetMP4InitFragment.Latency",
		"GetMP4InitFragment.Requests",
		"GetMP4InitFragment.Success",
		"GetMP4MediaFragment.Latency",
		"GetMP4MediaFragment.OutgoingBytes",
		"GetMP4MediaFragment.Requests",
		"GetMP4MediaFragment.Success",
		"GetMedia.ConnectionErrors",
		"GetMedia.MillisBehindNow",
		"GetMedia.OutgoingBytes",
		"GetMedia.OutgoingFragments",
		"GetMedia.OutgoingFrames",
		"GetMedia.Requests",
		"GetMedia.Success",
		"GetMediaForFragmentList.OutgoingBytes",
		"GetMediaForFragmentList.OutgoingFragments",
		"GetMediaForFragmentList.OutgoingFrames",
		"GetMediaForFragmentList.Requests",
		"GetMediaForFragmentList.Success",
		"GetTSFragment.Latency",
		"GetTSFragment.OutgoingBytes",
		"GetTSFragment.Requests",
		"GetTSFragment.Success",
		"ListFragments.Latency",
		"PutMedia.ActiveConnections",
		"PutMedia.BufferingAckLatency",
		"PutMedia.ConnectionErrors",
		"PutMedia.ErrorAckCount",
		"PutMedia.FragmentIngestionLatency",
		"PutMedia.FragmentPersistLatency",
		"PutMedia.IncomingBytes",
		"PutMedia.IncomingFragments",
		"PutMedia.IncomingFrames",
		"PutMedia.Latency",
		"PutMedia.PersistedAckLatency",
		"PutMedia.ReceivedAckLatency",
		"PutMedia.Requests",
		"PutMedia.Success",
	},
	"AWS/Lambda": {
		"AsyncEventAge",
		"AsyncEventsDropped",
		"AsyncEventsReceived",
		"ClaimedAccountConcurrency",
		"ConcurrentExecutions",
		"DeadLetterErrors",
		"DestinationDeliveryFailures",
		"Duration",
		"Errors",
		"Invocations",
		"IteratorAge",
		"OffsetLag",
		"OversizedRecordCount",
		"PostRuntimeExtensionsDuration",
		"ProvisionedConcurrencyInvocations",
		"ProvisionedConcurrencySpilloverInvocations",
		"ProvisionedConcurrencyUtilization",
		"ProvisionedConcurrentExecutions",
		"RecursiveInvocationsDropped",
		"Throttles",
		"UnreservedConcurrentExecutions",
	},
	"AWS/Lex": {
		"BotChannelAuthErrors",
		"BotChannelConfigurationErrors",
		"BotChannelInboundThrottledEvents",
		"BotChannelOutboundThrottledEvents",
		"BotChannelRequestCount",
		"BotChannelResponseCardErrors",
		"BotChannelSystemErrors",
		"MissedUtteranceCount",
		"RuntimeInvalidLambdaResponses",
		"RuntimeLambdaErrors",
		"RuntimePollyErrors",
		"RuntimeRequestCount",
		"RuntimeSucessfulRequestLatency",
		"RuntimeSystemErrors",
		"RuntimeThrottledEvents",
		"RuntimeUserErrors",
	},
	"AWS/Logs": {
		"DeliveryErrors",
		"DeliveryThrottling",
		"ForwardedBytes",
		"ForwardedLogEvents",
		"IncomingBytes",
		"IncomingLogEvents",
	},
	"AWS/LookoutMetrics": {
		"Delivered",
		"ExecutionsFailed",
		"ExecutionsStarted",
		"ExecutionsSucceeded",
		"Undelivered",
	},
	"AWS/ML": {
		"PredictCount",
		"PredictFailureCount",
	},
	"AWS/MWAA": {
		"ActiveConnectionCount",
		"ApproximateAgeOfOldestTask",
		"CPUUtilization",
		"DatabaseConnections",
		"DiskQueueDepth",
		"FreeableMemory",
		"MemoryUtilization",
		"QueuedTasks",
		"RunningTasks",
		"VolumeWriteIOPS",
		"WriteIOPS",
		"WriteLatency",
		"WriteThroughput",
	},
	"AWS/MediaConnect": {
		"ARQRecovered",
		"ARQRequests",
		"BitRate",
		"CATError",
		"CRCError",
		"Connected",
		"ConnectedOutputs",
		"ConnectionAttempts",
		"ConsecutiveDrops",
		"ConsecutiveNotRecovered",
		"ContinuityCounter",
		"Disconnections",
		"DroppedPackets",
		"EgressBridgeBitRate",
		"EgressBridgeCATError",
		"EgressBridgeCRCError",
		"EgressBridgeContinuityCounter",
		"EgressBridgeDroppedPackets",
		"EgressBridgeFailoverSwitches",
		"EgressBridgeMergeActive",
		"EgressBridgeNotRecoveredPackets",
		"EgressBridgePATError",
		"EgressBridgePCRAccuracyError",
		"EgressBridgePCRError",
		"EgressBridgePIDError",
		"EgressBridgePMTError",
		"EgressBridgePTSError",
		"EgressBridgePacketLossPercent",
		"EgressBridgeRecoveredPackets",
		"EgressBridgeSourceBitRate",
		"EgressBridgeSourceCATError",
		"EgressBridgeSourceCRCError",
		"EgressBridgeSourceContinuityCounter",
		"EgressBridgeSourceDroppedPackets",
		"EgressBridgeSourceMergeActive",
		"EgressBridgeSourceMergeLatency",
		"EgressBridgeSourceNotRecoveredPackets",
		"EgressBridgeSourcePATError",
		"EgressBridgeSourcePCRAccuracyError",
		"EgressBridgeSourcePCRError",
		"EgressBridgeSourcePIDError",
		"EgressBridgeSourcePMTError",
		"EgressBridgeSourcePTSError",
		"EgressBridgeSourcePacketLossPercent",
		"EgressBridgeSourceRecoveredPackets",
		"EgressBridgeSourceTSByteError",
		"EgressBridgeSourceTSSyncLoss",
		"EgressBridgeSourceTotalPackets",
		"EgressBridgeSourceTransportError",
		"EgressBridgeTSByteError",
		"EgressBridgeTSSyncLoss",
		"EgressBridgeTotalPackets",
		"EgressBridgeTransportError",
		"FailoverSwitches",
		"IngressBridgeBitRate",
		"IngressBridgeCATError",
		"IngressBridgeCRCError",
		"IngressBridgeContinuityCounter",
		"IngressBridgeDroppedPackets",
		"IngressBridgeFailoverSwitches",
		"IngressBridgeMergeActive",
		"IngressBridgeNotRecoveredPackets",
		"IngressBridgePATError",
		"IngressBridgePCRAccuracyError",
		"IngressBridgePCRError",
		"IngressBridgePIDError",
		"IngressBridgePMTError",
		"IngressBridgePTSError",
		"IngressBridgePacketLossPercent",
		"IngressBridgeRecoveredPackets",
		"IngressBridgeSourceARQRecovered",
		"IngressBridgeSourceARQRequests",
		"IngressBridgeSourceBitRate",
		"IngressBridgeSourceCATError",
		"IngressBridgeSourceCRCError",
		"IngressBridgeSourceContinuityCounter",
		"IngressBridgeSourceDroppedPackets",
		"IngressBridgeSourceFECPackets",
		"IngressBridgeSourceFECRecovered",
		"IngressBridgeSourceMergeActive",
		"IngressBridgeSourceMergeLatency",
		"IngressBridgeSourceNotRecoveredPackets",
		"IngressBridgeSourceOverflowPackets",
		"IngressBridgeSourcePATError",
		"IngressBridgeSourcePCRAccuracyError",
		"IngressBridgeSourcePCRError",
		"IngressBridgeSourcePIDError",
		"IngressBridgeSourcePMTError",
		"IngressBridgeSourcePTSError",
		"IngressBridgeSourcePacketLossPercent",
		"IngressBridgeSourceRecoveredPackets",
		"IngressBridgeSourceRoundTripTime",
		"IngressBridgeSourceTSByteError",
		"IngressBridgeSourceTSSyncLoss",
		"IngressBridgeSourceTotalPackets",
		"IngressBridgeSourceTransportError",
		"IngressBridgeTSByteError",
		"IngressBridgeTSSyncLoss",
		"IngressBridgeTotalPackets",
		"IngressBridgeTransportError",
		"Jitter",
		"Latency",
		"MaintenanceCanceled",
		"MaintenanceFailed",
		"MaintenanceRescheduled",
		"MaintenanceScheduled",
		"MaintenanceStarted",
		"MaintenanceSucceeded",
		"MergeActive",
		"MergeLatency",
		"NotRecoveredPackets",
		"OutputConnected",
		"OutputDisconnections",
		"OutputDroppedPayloads",
		"OutputLatePayloads",
		"OutputTotalBytes",
		"OutputTotalPayloads",
		"OverflowPackets",
		"PATError",
		"PCRAccuracyError",
		"PCRError",
		"PIDError",
		"PMTError",
		"PTSError",
		"PacketLossPercent",
		"RecoveredPackets",
		"RoundTripTime",
		"SourceARQRecovered",
		"SourceARQRequests",
		"SourceBitRate",
		"SourceCATError",
		"SourceCRCError",
		"SourceConnected",
		"SourceContinuityCounter",
		"SourceDisconnections",
		"SourceDroppedPackets",
		"SourceDroppedPayloads",
		"SourceFECPackets",
		"SourceFECRecovered",
		"SourceLatePayloads",
		"SourceMergeActive",
		"SourceMergeLatency",
		"SourceMergeStatusWarnMismatch",
		"SourceMergeStatusWarnSolo",
		"SourceMissingPackets",
		"SourceNotRecoveredPackets",
		"SourceOverflowPackets",
		"SourcePATError",
		"SourcePCRAccuracyError",
		"SourcePCRError",
		"SourcePIDError",
		"SourcePMTError",
		"SourcePTSError",
		"SourcePacketLossPercent",
		"SourceRecoveredPackets",
		"SourceRoundTripTime",
		"SourceSelected",
		"SourceTSByteError",
		"SourceTSSyncLoss",
		"SourceTotalBytes",
		"SourceTotalPackets",
		"SourceTotalPayloads",
		"SourceTransportError",
		"TSByteError",
		"TSSyncLoss",
		"TotalPackets",
		"TransportError",
		"Uptime",
	},
	"AWS/MediaConvert": {
		"AudioOutputSeconds",
		"Errors",
		"HDOutputSeconds",
		"JobsCompletedCount",
		"JobsErroredCount",
		"SDOutputSeconds",
		"StandbyTime",
		"TranscodingTime",
		"UHDOutputSeconds",
	},
	"AWS/MediaLive": {
		"ActiveAlerts",
		"ActiveOutputs",
		"ChannelInputErrorSeconds",
		"ConfiguredBitrate",
		"ConfiguredBitrateAvailable",
		"DroppedFrames",
		"EncoderBitrate",
		"EncoderRunning",
		"ErrorSeconds",
		"FillMsec",
		"InputLocked",
		"InputLossSeconds",
		"InputTimecodesPresent",
		"InputVideoFrameRate",
		"LinkedToStreamEndpoint",
		"NetworkIn",
		"NetworkOut",
		"NotRecoveredPackets",
		"Output4xxErrors",
		"Output5xxErrors",
		"OutputAudioLevelDbfs",
		"OutputAudioLevelLkfs",
		"PipelinesLocked",
		"PrimaryInputActive",
		"RecoveredPackets",
		"Streaming",
		"SvqTime",
		"Temperature",
		"TotalPackets",
		"UsingHDMI",
		"UsingSDI",
	},
	"AWS/MediaPackage": {
		"ActiveInput",
		"EgressBytes",
		"EgressRequestCount",
		"EgressResponseTime",
		"IngressBytes",
		"IngressResponseTime",
	},
	"AWS/MediaStore": {
		"4xxErrorCount",
		"5xxErrorCount",
		"BytesDownloaded",
		"BytesUploaded",
		"RequestCount",
		"TotalTime",
		"TurnaroundTime",
	},
	"AWS/MediaTailor": {
		"AdDecisionServer.Ads",
		"AdDecisionServer.Duration",
		"AdDecisionServer.Errors",
		"AdDecisionServer.FillRate",
		"AdDecisionServer.Timeouts",
		"AdNotReady",
		"Avails.Duration",
		"Avails.FillRate",
		"Avails.FilledDuration",
		"GetManifest.Errors",
		"Origin.Errors",
		"Origin.Timeouts",
	},
	"AWS/MemoryDB": {
		"ActiveDefragHits",
		"AuthenticationFailures",
		"BytesUsedForMemoryDB",
		"CPUUtilization",
		"CommandAuthorizationFailures",
		"CurrConnections",
		"CurrItems",
		"DB0AverageTTL",
		"DatabaseMemoryUsagePercentage",
		"EngineCPUUtilization",
		"EvalBasedCmds",
		"Evictions",
		"FreeableMemory",
		"GeoSpatialBasedCmds",
		"GetTypeCmds",
		"HashBasedCmds",
		"HyperLogLogBasedCmds",
		"IsPrimary",
		"KeyAuthorizationFailures",
		"KeyBasedCmds",
		"KeysTracked",
		"KeyspaceHits",
		"KeyspaceMisses",
		"ListBasedCmds",
		"MaxReplicationThroughput",
		"MemoryFragmentationRatio",
		"NetworkBandwidthInAllowanceExceeded",
		"NetworkBandwidthOutAllowanceExceeded",
		"NetworkBytesIn",
		"NetworkBytesOut",
		"NetworkConntrackAllowanceExceeded",
		"NetworkPacketsIn",
		"NetworkPacketsOut",
		"NetworkPacketsPerSecondAllowanceExceeded",
		"NewConnections",
		"PrimaryLinkHealthStatus",
		"PubSubBasedCmds",
		"Reclaimed",
		"ReplicationBytes",
		"ReplicationDelayedWriteCommands",
		"ReplicationLag",
		"SetBasedCmds",
		"SetTypeCmds",
		"SortedSetBasedCmds",
		"StreamBasedCmds",
		"StringBasedCmds",
		"SwapUsage",
	},
	"AWS/NATGateway": {
		"ActiveConnectionCount",
		"BytesInFromDestination",
		"BytesInFromSource",
		"BytesOutToDestination",
		"BytesOutToSource",
		"ConnectionAttemptCount",
		"ConnectionEstablishedCount",
		"ErrorPortAllocation",
		"IdleTimeoutCount",
		"PacketsDropCount",
		"PacketsInFromDestination",
		"PacketsInFromSource",
		"PacketsOutToDestination",
		"PacketsOutToSource",
	},
	"AWS/Neptune": {
		"CPUUtilization",
		"ClusterReplicaLag",
		"ClusterReplicaLagMaximum",
		"ClusterReplicaLagMinimum",
		"EngineUptime",
		"FreeLocalStorage",
		"FreeableMemory",
		"GremlinErrors",
		"GremlinHttp1xx",
		"GremlinHttp2xx",
		"GremlinHttp4xx",
		"GremlinHttp5xx",
		"GremlinRequests",
		"GremlinRequestsPerSec",
		"GremlinWebSocketAvailableConnections",
		"GremlinWebSocketClientErrors",
		"GremlinWebSocketServerErrors",
		"GremlinWebSocketSuccess",
		"Http100",
		"Http101",
		"Http1xx",
		"Http200",
		"Http2xx",
		"Http400",
		"Http403",
		"Http405",
		"Http413",
		"Http429",
		"Http4xx",
		"Http500",
		"Http501",
		"Http5xx",
		"LoaderErrors",
		"LoaderRequests",
		"NetworkReceiveThroughput",
		"NetworkThroughput",
		"NetworkTransmitThroughput",
		"SparqlErrors",
		"SparqlHttp1xx",
		"SparqlHttp2xx",
		"SparqlHttp4xx",
		"SparqlHttp5xx",
		"SparqlRequests",
		"SparqlRequestsPerSec",
		"StatusErrors",
		"StatusRequests",
		"VolumeBytesUsed",
		"VolumeReadIOPs",
		"VolumeWriteIOPs",
	},
	"AWS/NetworkELB": {
		"ActiveFlowCount",
		"ActiveFlowCount_TCP",
		"ActiveFlowCount_TLS",
		"ActiveFlowCount_UDP",
		"ClientTLSNegotiationErrorCount",
		"ConsumedLCUs",
		"ConsumedLCUs_TCP",
		"ConsumedLCUs_TLS",
		"ConsumedLCUs_UDP",
		"HealthyHostCount",
		"NewFlowCount",
		"NewFlowCount_TCP",
		"NewFlowCount_TLS",
		"NewFlowCount_UDP",
		"PeakPacketsPerSecond",
		"PortAllocationErrorCount",
		"ProcessedBytes",
		"ProcessedBytes_TCP",
		"ProcessedBytes_TLS",
		"ProcessedBytes_UDP",
		"ProcessedPackets",
		"SecurityGroupBlockedFlowCount_Inbound_ICMP",
		"SecurityGroupBlockedFlowCount_Inbound_TCP",
		"SecurityGroupBlockedFlowCount_Inbound_UDP",
		"SecurityGroupBlockedFlowCount_Outbound_ICMP",
		"SecurityGroupBlockedFlowCount_Outbound_TCP",
		"SecurityGroupBlockedFlowCount_Outbound_UDP",
		"TCP_Client_Reset_Count",
		"TCP_ELB_Reset_Count",
		"TCP_Target_Reset_Count",
		"TargetTLSNegotiationErrorCount",
		"UnHealthyHostCount",
		"UnhealthyRoutingFlowCount",
	},
	"AWS/NetworkFirewall": {
		"DroppedPackets",
		"Packets",
		"PassedPackets",
		"ReceivedPacketCount",
	},
	"AWS/OpsWorks": {
		"cpu_idle",
		"cpu_nice",
		"cpu_steal",
		"cpu_system",
		"cpu_user",
		"cpu_waitio",
		"load_1",
		"load_15",
		"load_5",
		"memory_buffers",
		"memory_cached",
		"memory_free",
		"memory_swap",
		"memory_total",
		"memory_used",
		"procs",
	},
	"AWS/Polly": {
		"2XXCount",
		"4XXCount",
		"5XXCount",
		"RequestCharacters",
		"ResponseLatency",
	},
	"AWS/PrivateLinkEndpoints": {
		"ActiveConnections",
		"BytesProcessed",
		"NewConnections",
		"PacketsDropped",
		"RstPacketsReceived",
	},
	"AWS/PrivateLinkServices": {
		"ActiveConnections",
		"BytesProcessed",
		"EndpointsCount",
		"NewConnections",
		"RstPacketsReceived",
	},
	"AWS/Prometheus": {
		"AlertManagerAlertsReceived",
		"AlertManagerNotificationsFailed",
		"AlertManagerNotificationsThrottled",
		"DiscardedSamples",
		"RuleEvaluationFailures",
		"RuleEvaluations",
		"RuleGroupIterationsMissed",
	},
	"AWS/RDS": {
		"ACUUtilization",
		"AbortedClients",
		"ActiveTransactions",
		"AuroraBinlogReplicaLag",
		"AuroraDMLRejectedMasterFull",
		"AuroraDMLRejectedWriterFull",
		"AuroraEstimatedSharedMemoryBytes",
		"AuroraGlobalDBDataTransferBytes",
		"AuroraGlobalDBProgressLag",
		"AuroraGlobalDBRPOLag",
		"AuroraGlobalDBReplicatedWriteIO",
		"AuroraGlobalDBReplicationLag",
		"AuroraMemoryHealthState",
		"AuroraMemoryNumDeclinedSqlTotal",
		"AuroraMemoryNumKillConnTotal",
		"AuroraMemoryNumKillQueryTotal",
		"AuroraOptimizedReadsCacheHitRatio",
		"AuroraReplicaLag",
		"AuroraReplicaLagMaximum",
		"AuroraReplicaLagMinimum",
		"AuroraSlowConnectionHandleCount",
		"AuroraSlowHandshakeCount",
		"AuroraVolumeBytesLeftTotal",
		"AvailabilityPercentage",
		"BacktrackChangeRecordsCreationRate",
		"BacktrackChangeRecordsStored",
		"BacktrackWindowActual",
		"BacktrackWindowAlert",
		"BackupRetentionPeriodStorageUsed",
		"BinLogDiskUsage",
		"BlockedTransactions",
		"BufferCacheHitRatio",
		"BurstBalance",
		"CPUCreditBalance",
		"CPUCreditUsage",
		"CPUSurplusCreditBalance",
		"CPUSurplusCreditsCharged",
		"CPUUtilization",
		"CheckpointLag",
		"ClientConnections",
		"ClientConnectionsClosed",
		"ClientConnectionsNoTLS",
		"ClientConnectionsReceived",
		"ClientConnectionsSetupFailedAuth",
		"ClientConnectionsSetupSucceeded",
		"ClientConnectionsTLS",
		"CommitLatency",
		"CommitThroughput",
		"ConnectionAttempts",
		"DBLoad",
		"DBLoadCPU",
		"DBLoadNonCPU",
		"DDLLatency",
		"DDLThroughput",
		"DMLLatency",
		"DMLThroughput",
		"DatabaseConnectionRequests",
		"DatabaseConnectionRequestsWithTLS",
		"DatabaseConnections",
		"DatabaseConnectionsBorrowLatency",
		"DatabaseConnectionsCurrentlyBorrowed",
		"DatabaseConnectionsCurrentlyInTransaction",
		"DatabaseConnectionsCurrentlySessionPinned",
		"DatabaseConnectionsSetupFailed",
		"DatabaseConnectionsSetupSucceeded",
		"DatabaseConnectionsWithTLS",
		"Deadlocks",
		"DeleteLatency",
		"DeleteThroughput",
		"DiskQueueDepth",
		"DiskQueueDepthLogVolume",
		"EBSByteBalance%",
		"EBSIOBalance%",
		"EngineUptime",
		"FailedSQLServerAgentJobsCount",
		"FreeEphemeralStorage",
		"FreeLocalStorage",
		"FreeStorageSpace",
		"FreeStorageSpaceLogVolume",
		"FreeableMemory",
		"InsertLatency",
		"InsertThroughput",
		"LoginFailures",
		"MaxDatabaseConnectionsAllowed",
		"MaximumUsedTransactionIDs",
		"NetworkReceiveThroughput",
		"NetworkThroughput",
		"NetworkTransmitThroughput",
		"NumBinaryLogFiles",
		"OldestReplicationSlotLag",
		"PurgeBoundary",
		"PurgeFinishedPoint",
		"Queries",
		"QueryDatabaseResponseLatency",
		"QueryRequests",
		"QueryRequestsNoTLS",
		"QueryRequestsTLS",
		"QueryResponseLatency",
		"RDSToAuroraPostgreSQLReplicaLag",
		"ReadIOPS",
		"ReadIOPSEphemeralStorage",
		"ReadIOPSLogVolume",
		"ReadLatency",
		"ReadLatencyEphemeralStorage",
		"ReadLatencyLogVolume",
		"ReadThroughput",
		"ReadThroughputEphemeralStorage",
		"ReadThroughputLogVolume",
		"ReplicaLag",
		"ReplicationChannelLag",
		"ReplicationSlotDiskUsage",
		"ResultSetCacheHitRatio",
		"RollbackSegmentHistoryListLength",
		"RowLockTime",
		"SelectLatency",
		"SelectThroughput",
		"ServerlessDatabaseCapacity",
		"SnapshotStorageUsed",
		"StorageNetworkReceiveThroughput",
		"StorageNetworkThroughput",
		"StorageNetworkTransmitThroughput",
		"SumBinaryLogSize",
		"SwapUsage",
		"TempStorageIOPS",
		"TempStorageThroughput",
		"TotalBackupStorageBilled",
		"TransactionLogsDiskUsage",
		"TransactionLogsGeneration",
		"TruncateFinishedPoint",
		"UpdateLatency",
		"UpdateThroughput",
		"VolumeBytesUsed",
		"VolumeReadIOPs",
		"VolumeWriteIOPs",
		"WriteIOPS",
		"WriteIOPSEphemeralStorage",
		"WriteIOPSLogVolume",
		"WriteLatency",
		"WriteLatencyEphemeralStorage",
		"WriteLatencyLogVolume",
		"WriteThroughput",
		"WriteThroughputEphemeralStorage",
		"WriteThroughputLogVolume",
	},
	"AWS/Redshift": {
		"CPUUtilization",
		"CommitQueueLength",
		"ConcurrencyScalingActiveClusters",
		"ConcurrencyScalingSeconds",
		"DatabaseConnections",
		"HealthStatus",
		"MaintenanceMode",
		"MaxConfiguredConcurrencyScalingClusters",
		"NetworkReceiveThroughput",
		"NetworkTransmitThroughput",
		"NumExceededSchemaQuotas",
		"PercentageDiskSpaceUsed",
		"PercentageQuotaUsed",
		"QueriesCompletedPerSecond",
		"QueryDuration",
		"QueryRuntimeBreakdown",
		"ReadIOPS",
		"ReadLatency",
		"ReadThroughput",
		"SchemaQuota",
		"StorageUsed",
		"TotalTableCount",
		"WLMQueriesCompletedPerSecond",
		"WLMQueryDuration",
		"WLMQueueLength",
		"WLMQueueWaitTime",
		"WLMRunningQueries",
		"WriteIOPS",
		"WriteLatency",
		"WriteThroughput",
	},
	"AWS/Rekognition": {
		"DetectedFaceCount",
		"DetectedLabelCount",
		"ResponseTime",
		"ServerErrorCount",
		"SuccessfulRequestCount",
		"ThrottledCount",
		"UserErrorCount",
	},
	"AWS/Robomaker": {
		"Memory",
		"RealTimeFactor",
		"SimulationUnit",
		"vCPU",
	},
	"AWS/Route53": {
		"ChildHealthCheckHealthyCount",
		"ConnectionTime",
		"DNSQueries",
		"HealthCheckPercentageHealthy",
		"HealthCheckStatus",
		"SSLHandshakeTime",
		"TimeToFirstByte",
	},
	"AWS/Route53Resolver": {
		"InboundQueryVolume",
		"OutboundQueryAggregatedVolume",
		"OutboundQueryVolume",
	},
	"AWS/S3": {
		"4xxErrors",
		"5xxErrors",
		"AllRequests",
		"BucketSizeBytes",
		"BytesDownloaded",
		"BytesPendingReplication",
		"BytesUploaded",
		"DeleteRequests",
		"FirstByteLatency",
		"GetRequests",
		"HeadRequests",
		"ListRequests",
		"NumberOfObjects",
		"OperationsFailedReplication",
		"OperationsPendingReplication",
		"PostRequests",
		"PutRequests",
		"ReplicationLatency",
		"SelectRequests",
		"SelectReturnedBytes",
		"SelectScannedBytes",
		"TotalRequestLatency",
	},
	"AWS/SDKMetrics": {
		"CallCount",
		"ClientErrorCount",
		"ConnectionErrorCount",
		"EndToEndLatency",
		"ServerErrorCount",
		"ThrottleCount",
	},
	"AWS/SES": {
		"Bounce",
		"Clicks",
		"Complaint",
		"Delivery",
		"Opens",
		"PublishExpired",
		"PublishFailure",
		"PublishSuccess",
		"Received",
		"Reject",
		"Rendering Failures",
		"Reputation.BounceRate",
		"Reputation.ComplaintRate",
		"Send",
	},
	"AWS/SNS": {
		"NumberOfMessagesPublished",
		"NumberOfNotificationsDelivered",
		"NumberOfNotificationsFailed",
		"NumberOfNotificationsFilteredOut",
		"NumberOfNotificationsFilteredOut-InvalidAttributes",
		"NumberOfNotificationsFilteredOut-MessageBody",
		"NumberOfNotificationsFilteredOut-NoMessageAttributes",
		"PublishSize",
		"SMSMonthToDateSpentUSD",
		"SMSSuccessRate",
	},
	"AWS/SQS": {
		"ApproximateAgeOfOldestMessage",
		"ApproximateNumberOfMessagesDelayed",
		"ApproximateNumberOfMessagesNotVisible",
		"ApproximateNumberOfMessagesVisible",
		"NumberOfEmptyReceives",
		"NumberOfMessagesDeleted",
		"NumberOfMessagesReceived",
		"NumberOfMessagesSent",
		"SentMessageSize",
	},
	"AWS/SWF": {
		"ActivityTaskScheduleToCloseTime",
		"ActivityTaskScheduleToStartTime",
		"ActivityTaskStartToCloseTime",
		"ActivityTasksCanceled",
		"ActivityTasksCompleted",
		"ActivityTasksFailed",
		"ConsumedCapacity",
		"DecisionTaskScheduleToStartTime",
		"DecisionTaskStartToCloseTime",
		"DecisionTasksCompleted",
		"PendingTasks",
		"ProvisionedBucketSize",
		"ProvisionedRefillRate",
		"ScheduledActivityTasksTimedOutOnClose",
		"ScheduledActivityTasksTimedOutOnStart",
		"StartedActivityTasksTimedOutOnClose",
		"StartedActivityTasksTimedOutOnHeartbeat",
		"StartedDecisionTasksTimedOutOnClose",
		"ThrottledEvents",
		"WorkflowStartToCloseTime",
		"WorkflowsCanceled",
		"WorkflowsCompleted",
		"WorkflowsContinuedAsNew",
		"WorkflowsFailed",
		"WorkflowsTerminated",
		"WorkflowsTimedOut",
	},
	"AWS/SageMaker": {
		"Invocation4XXErrors",
		"Invocation5XXErrors",
		"InvocationModelErrors",
		"Invocations",
		"InvocationsPerCopy",
		"InvocationsPerInstance",
		"ModelCacheHit",
		"ModelDownloadingTime",
		"ModelLatency",
		"ModelLoadingTime",
		"ModelLoadingWaitTime",
		"ModelSetupTime",
		"ModelUnloadingTime",
		"OverheadLatency",
	},
	"AWS/SageMaker/LabelingJobs": {
		"ActiveWorkers",
		"DatasetObjectsAutoAnnotated",
		"DatasetObjectsHumanAnnotated",
		"DatasetObjectsLabelingFailed",
		"JobsFailed",
		"JobsStopped",
		"JobsSucceeded",
		"TasksAccepted",
		"TasksDeclined",
		"TasksReturned",
		"TasksSubmitted",
		"TimeSpent",
		"TotalDatasetObjectsLabeled",
	},
	"AWS/Sagemaker/ModelBuildingPipeline": {
		"ExecutionDuration",
		"ExecutionFailed",
		"ExecutionStarted",
		"ExecutionStopped",
		"ExecutionSucceeded",
		"StepDuration",
		"StepFailed",
		"StepStarted",
		"StepStopped",
		"StepSucceeded",
	},
	"AWS/Scheduler": {
		"InvocationAttemptCount",
		"InvocationDroppedCount",
		"InvocationThrottleCount",
		"InvocationsFailedToBeSentToDeadLetterCount",
		"InvocationsSentToDeadLetterCount",
		"InvocationsSentToDeadLetterCount_Truncated_MessageSizeExceeded",
		"TargetErrorCount",
		"TargetErrorThrottledCount",
	},
	"AWS/ServiceCatalog": {
		"ProvisionedProductLaunch",
	},
	"AWS/States": {
		"ActivitiesFailed",
		"ActivitiesHeartbeatTimedOut",
		"ActivitiesScheduled",
		"ActivitiesStarted",
		"ActivitiesSucceeded",
		"ActivitiesTimedOut",
		"ActivityRunTime",
		"ActivityScheduleTime",
		"ActivityTime",
		"ConsumedCapacity",
		"ExecutionThrottled",
		"ExecutionTime",
		"ExecutionsAborted",
		"ExecutionsFailed",
		"ExecutionsStarted",
		"ExecutionsSucceeded",
		"ExecutionsTimedOut",
		"ExpressExecutionBilledDuration",
		"ExpressExecutionBilledMemory",
		"ExpressExecutionMemory",
		"LambdaFunctionRunTime",
		"LambdaFunctionScheduleTime",
		"LambdaFunctionTime",
		"LambdaFunctionsFailed",
		"LambdaFunctionsScheduled",
		"LambdaFunctionsStarted",
		"LambdaFunctionsSucceeded",
		"LambdaFunctionsTimedOut",
		"ProvisionedBucketSize",
		"ProvisionedRefillRate",
		"ServiceIntegrationRunTime",
		"ServiceIntegrationScheduleTime",
		"ServiceIntegrationTime",
		"ServiceIntegrationsFailed",
		"ServiceIntegrationsScheduled",
		"ServiceIntegrationsStarted",
		"ServiceIntegrationsSucceeded",
		"ServiceIntegrationsTimedOut",
		"ThrottledEvents",
	},
	"AWS/StorageGateway": {
		"CacheFree",
		"CacheHitPercent",
		"CachePercentDirty",
		"CachePercentUsed",
		"CacheUsed",
		"CloudBytesDownloaded",
		"CloudBytesUploaded",
		"CloudDownloadLatency",
		"QueuedWrites",
		"ReadBytes",
		"ReadTime",
		"TimeSinceLastRecoveryPoint",
		"TotalCacheSize",
		"UploadBufferFree",
		"UploadBufferPercentUsed",
		"UploadBufferUsed",
		"WorkingStorageFree",
		"WorkingStoragePercentUsed",
		"WorkingStorageUsed",
		"WriteBytes",
		"WriteTime",
	},
	"AWS/Textract": {
		"ResponseTime",
		"ServerErrorCount",
		"SuccessfulRequestCount",
		"ThrottledCount",
		"UserErrorCount",
	},
	"AWS/ThingsGraph": {
		"EventStoreQueueSize",
		"FlowExecutionTime",
		"FlowExecutionsFailed",
		"FlowExecutionsStarted",
		"FlowExecutionsSucceeded",
		"FlowStepExecutionTime",
		"FlowStepExecutionsFailed",
		"FlowStepExecutionsStarted",
		"FlowStepExecutionsSucceeded",
	},
	"AWS/Timestream": {
		"DataScannedBytes",
		"SuccessfulRequestLatency",
		"SystemErrors",
		"UserErrors",
	},
	"AWS/Transfer": {
		"BytesIn",
		"BytesOut",
		"FilesIn",
		"FilesOut",
		"InboundFailedMessage",
		"InboundMessage",
		"OnPartialUploadExecutionsFailed",
		"OnPartialUploadExecutionsStarted",
		"OnPartialUploadExecutionsSuccess",
		"OnUploadExecutionsFailed",
		"OnUploadExecutionsStarted",
		"OnUploadExecutionsSuccess",
	},
	"AWS/TransitGateway": {
		"BytesIn",
		"BytesOut",
		"PacketDropCountBlackhole",
		"PacketDropCountNoRoute",
		"PacketsIn",
		"PacketsOut",
	},
	"AWS/Translate": {
		"CharacterCount",
		"ResponseTime",
		"ServerErrorCount",
		"SuccessfulRequestCount",
		"ThrottledCount",
		"UserErrorCount",
	},
	"AWS/TrustedAdvisor": {
		"GreenChecks",
		"RedChecks",
		"RedResources",
		"ServiceLimitUsage",
		"YellowChecks",
		"YellowResources",
	},
	"AWS/Usage": {
		"CallCount",
		"ResourceCount",
	},
	"AWS/VPN": {
		"TunnelDataIn",
		"TunnelDataOut",
		"TunnelState",
	},
	"AWS/WAF": {
		"AllowedRequests",
		"BlockedRequests",
		"CountedRequests",
		"PassedRequests",
	},
	"AWS/WAFV2": {
		"AllowedRequests",
		"BlockedRequests",
		"CaptchaRequests",
		"CaptchasAttempted",
		"CaptchasSolved",
		"ChallengeRequests",
		"CountedRequests",
		"PassedRequests",
		"RequestsWithValidCaptchaToken",
		"RequestsWithValidChallengeToken",
	},
	"AWS/WorkSpaces": {
		"Available",
		"ConnectionAttempt",
		"ConnectionFailure",
		"ConnectionSuccess",
		"InSessionLatency",
		"Maintenance",
		"SessionDisconnect",
		"SessionLaunchTime",
		"Stopped",
		"Unhealthy",
		"UserConnected",
	},
	"AmazonMWAA": {
		"CollectDBDags",
		"CriticalSectionBusy",
		"CriticalSectionDuration",
		"CriticalSectionQueryDuration",
		"DAGDependencyCheck",
		"DAGDurationFailed",
		"DAGDurationSuccess",
		"DAGFileProcessingLastDuration",
		"DAGFileProcessingLastRunSecondsAgo",
		"DAGFileRefreshError",
		"DAGScheduleDelay",
		"DagBagSize",
		"DagCallbackExceptions",
		"ExceptionFailures",
		"ExecutedTasks",
		"FailedCeleryTaskExecution",
		"FailedSLACallback",
		"FailedSLAEmailAttempts",
		"FilePathQueueUpdateCount",
		"FirstTaskSchedulingDelay",
		"ImportErrors",
		"InfraFailures",
		"JobEnd",
		"JobHeartbeatFailure",
		"JobStart",
		"LoadedTasks",
		"ManagerStalls",
		"OpenSlots",
		"OperatorFailures",
		"OperatorSuccesses",
		"Orphaned",
		"OrphanedTasksAdopted",
		"OrphanedTasksCleared",
		"OtherCallbackCount",
		"PokedExceptions",
		"PokedSuccess",
		"PokedTasks",
		"PoolDeferredSlots",
		"PoolFailures",
		"PoolOpenSlots",
		"PoolQueuedSlots",
		"PoolRunningSlots",
		"PoolStarvingTasks",
		"Processes",
		"ProcessorTimeouts",
		"QueuedTasks",
		"RunningTasks",
		"SLAMissed",
		"SchedulerHeartbeat",
		"SchedulerLoopDuration",
		"SlaCallbackCount",
		"StartedTaskInstances",
		"TaskInstanceCreatedUsingOperator",
		"TaskInstanceDuration",
		"TaskInstanceFailures",
		"TaskInstanceFinished",
		"TaskInstancePreviouslySucceeded",
		"TaskInstanceQueuedDuration",
		"TaskInstanceScheduledDuration",
		"TaskInstanceSuccesses",
		"TaskRemovedFromDAG",
		"TaskRestoredToDAG",
		"TaskTimeoutError",
		"TasksExecutable",
		"TasksKilledExternally",
		"TasksPending",
		"TasksRunning",
		"TasksStarving",
		"TasksWithoutDagRun",
		"TotalParseTime",
		"TriggerHeartbeat",
		"TriggeredDagRuns",
		"TriggersBlockedMainThread",
		"TriggersFailed",
		"TriggersRunning",
		"TriggersSucceeded",
		"Updates",
		"ZombiesKilled",
	},
	"CloudWatchSynthetics": {
		"2xx",
		"4xx",
		"5xx",
		"Duration",
		"Failed",
		"Failed requests",
		"SuccessPercent",
		"VisualMonitoringSuccessPercent",
		"VisualMonitoringTotalComparisons",
	},
	"ContainerInsights": {
		"cluster_failed_node_count",
		"cluster_node_count",
		"namespace_number_of_running_pods",
		"node_cpu_limit",
		"node_cpu_reserved_capacity",
		"node_cpu_usage_total",
		"node_cpu_utilization",
		"node_filesystem_utilization",
		"node_memory_limit",
		"node_memory_reserved_capacity",
		"node_memory_utilization",
		"node_memory_working_set",
		"node_network_total_bytes",
		"node_number_of_running_containers",
		"node_number_of_running_pods",
		"pod_cpu_reserved_capacity",
		"pod_cpu_utilization",
		"pod_cpu_utilization_over_pod_limit",
		"pod_memory_reserved_capacity",
		"pod_memory_utilization",
		"pod_memory_utilization_over_pod_limit",
		"pod_network_rx_bytes",
		"pod_network_tx_bytes",
		"pod_number_of_container_restarts",
		"service_number_of_running_pods",
	},
	"ECS/ContainerInsights": {
		"ContainerInstanceCount",
		"CpuReserved",
		"CpuUtilized",
		"DeploymentCount",
		"DesiredTaskCount",
		"EBSFilesystemSize",
		"EBSFilesystemUtilized",
		"EphemeralStorageReserved",
		"EphemeralStorageUtilized",
		"MemoryReserved",
		"MemoryUtilized",
		"NetworkRxBytes",
		"NetworkTxBytes",
		"PendingTaskCount",
		"RunningTaskCount",
		"ServiceCount",
		"StorageReadBytes",
		"StorageWriteBytes",
		"TaskCount",
		"TaskSetCount",
		"instance_cpu_limit",
		"instance_cpu_reserved_capacity",
		"instance_cpu_usage_total",
		"instance_cpu_utilization",
		"instance_filesystem_utilization",
		"instance_memory_limit",
		"instance_memory_reserved_capacity",
		"instance_memory_utilization",
		"instance_memory_working_set",
		"instance_network_total_bytes",
		"instance_number_of_running_tasks",
	},
	"Glue": {
		"glue.ALL.disk.available_GB",
		"glue.ALL.disk.used.percentage",
		"glue.ALL.disk.used_GB",
		"glue.ALL.jvm.heap.usage",
		"glue.ALL.jvm.heap.used",
		"glue.ALL.memory.heap.available",
		"glue.ALL.memory.heap.used",
		"glue.ALL.memory.heap.used.percentage",
		"glue.ALL.memory.non-heap.available",
		"glue.ALL.memory.non-heap.percentage",
		"glue.ALL.memory.non-heap.used",
		"glue.ALL.memory.total.available",
		"glue.ALL.memory.total.used",
		"glue.ALL.memory.total.used.percentage",
		"glue.ALL.s3.filesystem.read_bytes",
		"glue.ALL.s3.filesystem.write_bytes",
		"glue.ALL.system.cpuSystemLoad",
		"glue.driver.BlockManager.disk.diskSpaceUsed_MB",
		"glue.driver.ExecutorAllocationManager.executors.numberAllExecutors",
		"glue.driver.ExecutorAllocationManager.executors.numberMaxNeededExecutors",
		"glue.driver.aggregate.bytesRead",
		"glue.driver.aggregate.elapsedTime",
		"glue.driver.aggregate.numCompletedStages",
		"glue.driver.aggregate.numCompletedTasks",
		"glue.driver.aggregate.numFailedTasks",
		"glue.driver.aggregate.numKilledTasks",
		"glue.driver.aggregate.recordsRead",
		"glue.driver.aggregate.shuffleBytesWritten",
		"glue.driver.aggregate.shuffleLocalBytesRead",
		"glue.driver.bytesRead",
		"glue.driver.bytesWritten",
		"glue.driver.disk.available_GB",
		"glue.driver.disk.used.percentage",
		"glue.driver.disk.used_GB",
		"glue.driver.filesRead",
		"glue.driver.filesWritten",
		"glue.driver.jvm.heap.usage",
		"glue.driver.jvm.heap.used",
		"glue.driver.memory.heap.available",
		"glue.driver.memory.heap.used",
		"glue.driver.memory.heap.used.percentage",
		"glue.driver.memory.non-heap.available",
		"glue.driver.memory.non-heap.percentage",
		"glue.driver.memory.non-heap.used",
		"glue.driver.memory.total.available",
		"glue.driver.memory.total.used",
		"glue.driver.memory.total.used.percentage",
		"glue.driver.partitionsRead",
		"glue.driver.recordsRead",
		"glue.driver.recordsWritten",
		"glue.driver.s3.filesystem.read_bytes",
		"glue.driver.s3.filesystem.write_bytes",
		"glue.driver.skewness.job",
		"glue.driver.skewness.stage",
		"glue.driver.streaming.batchProcessingTimeInMs",
		"glue.driver.streaming.numRecords",
		"glue.driver.system.cpuSystemLoad",
		"glue.driver.workerUtilization",
		"glue.error.ALL",
		"glue.succeed.ALL",
	},
}

var NamespaceDimensionKeysMap = map[string][]string{
	"AWS/ACMPrivateCA":                   {},
	"AWS/AmazonMQ":                       {"Broker", "NetworkConnector", "Queue", "Topic", "Node", "Virtual host"},
	"AWS/ApiGateway":                     {"ApiId", "ApiName", "Method", "Resource", "Route", "Stage"},
	"AWS/AppFlow":                        {"FlowName"},
	"AWS/AppRunner":                      {"Instance", "ServiceID", "ServiceName"},
	"AWS/AppStream":                      {"Fleet"},
	"AWS/AppSync":                        {"GraphQLAPIId"},
	"AWS/ApplicationELB":                 {"AvailabilityZone", "LoadBalancer", "TargetGroup"},
	"AWS/Athena":                         {"QueryState", "QueryType", "WorkGroup"},
	"AWS/AutoScaling":                    {"AutoScalingGroupName", "PairIndex", "PolicyName"},
	"AWS/Backup":                         {"BackupVaultName", "ResourceType"},
	"AWS/Bedrock":                        {"BucketedStepSize", "ImageSize", "ModelId"},
	"AWS/Billing":                        {"Currency", "LinkedAccount", "ServiceName"},
	"AWS/CertificateManager":             {"CertificateArn"},
	"AWS/Chatbot":                        {"ConfigurationName"},
	"AWS/ClientVPN":                      {"Endpoint"},
	"AWS/CloudFront":                     {"DistributionId", "Region"},
	"AWS/CloudHSM":                       {"ClusterId", "HsmId", "Region"},
	"AWS/CloudSearch":                    {"ClientId", "DomainName"},
	"AWS/CodeBuild":                      {"ProjectName"},
	"AWS/CodeGuruProfiler":               {},
	"AWS/Cognito":                        {"Operation", "RiskLevel", "UserPoolId", "UserPool", "UserPoolClient", "IdentityProvider"},
	"AWS/Connect":                        {"InstanceId", "MetricGroup", "ContactFlowName", "SigningKeyId", "TypeOfConnection", "Participant", "QueueName", "StreamType"},
	"AWS/DataSync":                       {"AgentId", "TaskId"},
	"AWS/DDoSProtection":                 {"ResourceArn", "AttackVector", "MitigationAction", "Protocol", "SourcePort", "DestinationPort", "SourceIp", "SourceAsn", "TcpFlags"},
	"AWS/DMS":                            {"ReplicationInstanceIdentifier", "ReplicationTaskIdentifier"},
	"AWS/DocDB":                          {"DBClusterIdentifier", "DBInstanceIdentifier", "Role"},
	"AWS/DX":                             {"ConnectionId", "OpticalLaneNumber", "VirtualInterfaceId"},
	"AWS/DAX":                            {"Account", "ClusterId", "NodeId"},
	"AWS/DynamoDB":                       {"DelegatedOperation", "GlobalSecondaryIndexName", "Operation", "OperationType", "ReceivingRegion", "StreamLabel", "TableName", "Verb"},
	"AWS/EBS":                            {"DLMPolicyId", "VolumeId"},
	"AWS/EC2":                            {"AutoScalingGroupName", "ImageId", "InstanceId", "InstanceType"},
	"AWS/ElasticGPUs":                    {"EGPUId", "InstanceId"},
	"AWS/EC2/API":                        {},
	"AWS/EC2CapacityReservations":        {"CapacityReservationId"},
	"AWS/EC2Spot":                        {"AvailabilityZone", "FleetRequestId", "InstanceType"},
	"AWS/ECS":                            {"ClusterName", "ServiceName"},
	"AWS/EFS":                            {"FileSystemId", "StorageClass"},
	"AWS/ELB":                            {"AvailabilityZone", "LoadBalancerName"},
	"AWS/ES":                             {"ClientId", "DomainName", "NodeId"},
	"AWS/ElastiCache":                    {"CacheClusterId", "CacheNodeId"},
	"AWS/ElasticBeanstalk":               {"EnvironmentName", "InstanceId"},
	"AWS/ElasticInference":               {"ElasticInferenceAcceleratorId", "InstanceId"},
	"AWS/ElasticMapReduce":               {"ClusterId", "JobFlowId", "JobId"},
	"AWS/EMRServerless":                  {"ApplicationId", "WorkerType", "CapacityAllocationType"},
	"AWS/ElasticTranscoder":              {"Operation", "PipelineId"},
	"AWS/Events":                         {"EventBusName", "EventSourceName", "RuleName"},
	"AWS/FSx":                            {"FileSystemId"},
	"AWS/Firehose":                       {"DeliveryStreamName"},
	"AWS/FraudDetector":                  {"DetectorID", "DetectorVersionID", "ModelEndpoint", "ModelID", "ModelType", "OutcomeName", "RuleID", "VariableName"},
	"AWS/GameLift":                       {"GameServerGroup", "FleetId", "InstanceType", "Location", "MatchmakingConfigurationName", "MatchmakingConfigurationName-RuleName", "MetricGroup", "OperatingSystem", "QueueName"},
	"AWS/GlobalAccelerator":              {"Accelerator", "Listener", "EndpointGroup", "SourceRegion", "DestinationEdge", "TransportProtocol", "AcceleratorIPAddress"},
	"Glue":                               {"JobName", "JobRunId", "Type"},
	"AWS/GroundStation":                  {"Channel", "Polarization", "SatelliteId"},
	"AWS/Inspector":                      {},
	"AWS/IVS":                            {"Channel", "ViewerCountryCode"},
	"AWS/IoT":                            {"ActionType", "BehaviorName", "CheckName", "JobId", "Protocol", "RuleName", "ScheduledAuditName", "SecurityProfileName"},
	"AWS/IoTAnalytics":                   {"ActionType", "ChannelName", "DatasetName", "DatastoreName", "PipelineActivityName", "PipelineActivityType", "PipelineName"},
	"AWS/IoTSiteWise":                    {"AccountId", "GatewayId", "PropertyGroup", "Reason", "SourceName", "StreamName", "ThrottledAt"},
	"AWS/KMS":                            {"KeyId"},
	"AWS/Kafka":                          {"Broker ID", "Cluster Name", "Consumer Group", "Topic"},
	"AWS/Kendra":                         {"DataSourceId", "IndexId"},
	"AWS/Kinesis":                        {"ShardId", "StreamName"},
	"AWS/KinesisAnalytics":               {"Application", "Flow", "Id", "Operator", "Parallelism", "Task"},
	"AWS/KinesisVideo":                   {"StreamName"},
	"AWS/Lambda":                         {"ExecutedVersion", "FunctionName", "Resource"},
	"AWS/Lex":                            {"BotAlias", "BotChannelName", "BotName", "BotVersion", "InputMode", "Operation", "Source"},
	"AWS/Logs":                           {"DestinationType", "FilterName", "LogGroupName"},
	"AWS/LookoutMetrics":                 {"AlertArn", "AnomalyDetectorArn"},
	"AWS/ML":                             {"MLModelId", "RequestMode"},
	"AWS/MediaConnect":                   {"AvailabilityZone", "FlowARN", "SourceARN", "OutputARN"},
	"AWS/MediaConvert":                   {"Job", "Operation", "Queue"},
	"AWS/MediaPackage":                   {"Channel", "No Dimension", "OriginEndpoint", "StatusCodeRange"},
	"AWS/MediaLive":                      {"ActiveInputFailoverLabel", "AudioDescriptionName", "ChannelId", "DeviceType", "InputDeviceId", "OutputGroupName", "Pipeline"},
	"AWS/MediaStore":                     {"ContainerName", "ObjectGroupName", "RequestType"},
	"AWS/MediaTailor":                    {"ConfigurationName"},
	"AWS/MemoryDB":                       {"ClusterName", "NodeName"},
	"AWS/NATGateway":                     {"NatGatewayId"},
	"AWS/Neptune":                        {"DBClusterIdentifier", "DatabaseClass", "EngineName", "Role"},
	"AWS/NetworkELB":                     {"AvailabilityZone", "LoadBalancer", "TargetGroup"},
	"AWS/GatewayELB":                     {"AvailabilityZone", "LoadBalancer", "TargetGroup"},
	"AWS/NetworkFirewall":                {"AvailabilityZone", "CustomAction", "Engine", "FirewallName"},
	"AWS/OpsWorks":                       {"InstanceId", "LayerId", "StackId"},
	"AWS/Polly":                          {"Operation"},
	"AWS/PrivateLinkEndpoints":           {"Endpoint Type", "Service Name", "Subnet Id", "VPC Endpoint Id", "VPC Id"},
	"AWS/PrivateLinkServices":            {"Az", "Load Balancer Arn", "Service Id", "VPC Endpoint Id"},
	"AWS/Prometheus":                     {"Reason", "RuleGroup", "Workspace"},
	"AWS/IVSRealTime":                    {"Stage", "Participant", "SimulcastLayer", "MediaType"},
	"AWS/RDS":                            {"DBClusterIdentifier", "DBInstanceIdentifier", "DatabaseClass", "DbClusterIdentifier", "EndpointName", "EngineName", "ProxyName", "Role", "SourceRegion", "Target", "TargetGroup", "TargetRole"},
	"AWS/Redshift":                       {"ClusterIdentifier", "NodeID", "service class", "stage", "latency", "wlmid"},
	"AWS/Robomaker":                      {"SimulationJobId"},
	"AWS/Route53":                        {"HealthCheckId", "Region", "HostedZoneId"},
	"AWS/Route53Resolver":                {"EndpointId"},
	"AWS/S3":                             {"BucketName", "DestinationBucket", "FilterId", "RuleId", "SourceBucket", "StorageType"},
	"AWS/SDKMetrics":                     {"DestinationRegion", "Service"},
	"AWS/ServiceCatalog":                 {"State", "ProductId", "ProvisioningArtifactId"},
	"AWS/SES":                            {"RuleName", "RuleSetName"},
	"AWS/SNS":                            {"Application", "Country", "Platform", "SMSType", "TopicName"},
	"AWS/SQS":                            {"QueueName"},
	"AWS/SWF":                            {"APIName", "ActivityTypeName", "ActivityTypeVersion", "DecisionName", "Domain", "TaskListName", "WorkflowTypeName", "WorkflowTypeVersion"},
	"AWS/SageMaker":                      {"EndpointName", "InferenceComponentName", "VariantName"},
	"/aws/sagemaker/Endpoints":           {"EndpointName", "Host", "VariantName"},
	"/aws/sagemaker/InferenceComponents": {"InferenceComponentName"},
	"/aws/sagemaker/InferenceRecommendationsJobs": {"EndpointName", "JobName"},
	"AWS/SageMaker/LabelingJobs":                  {"LabelingJobName"},
	"AWS/Sagemaker/ModelBuildingPipeline":         {"PipelineName", "StepName"},
	"/aws/sagemaker/ProcessingJobs":               {"Host"},
	"/aws/sagemaker/TrainingJobs":                 {"Host"},
	"/aws/sagemaker/TransformJobs":                {"Host"},
	"AWS/States":                                  {"APIName", "ActivityArn", "LambdaFunctionArn", "ServiceIntegrationResourceArn", "ServiceName", "StateMachineArn"},
	"AWS/StorageGateway":                          {"GatewayId", "GatewayName", "VolumeId"},
	"AWS/Textract":                                {},
	"AWS/Timestream":                              {"Operation", "DatabaseName", "TableName"},
	"AWS/ThingsGraph":                             {"FlowTemplateId", "StepName", "SystemTemplateId"},
	"AWS/TransitGateway":                          {"TransitGateway", "TransitGatewayAttachment"},
	"AWS/Transfer":                                {"ServerId"},
	"AWS/Translate":                               {"LanguagePair", "Operation"},
	"AWS/TrustedAdvisor":                          {},
	"AWS/Usage":                                   {"Class", "Resource", "Service", "Type"},
	"AWS/VPN":                                     {"TunnelIpAddress", "VpnId"},
	"AWS/WAF":                                     {"Region", "Rule", "RuleGroup", "WebACL"},
	"AWS/WAFV2":                                   {"Region", "Rule", "RuleGroup", "WebACL"},
	"AWS/WorkSpaces":                              {"DirectoryId", "WorkspaceId"},
	"ECS/ContainerInsights":                       {"ClusterName", "ServiceName", "TaskDefinitionFamily", "EC2InstanceId", "ContainerInstanceId"},
	"ContainerInsights":                           {"ClusterName", "NodeName", "Namespace", "InstanceId", "PodName", "Service"},
	"AWS/Rekognition":                             {},
	"AWS/Cassandra":                               {"Keyspace", "Operation", "TableName"},
	"AWS/AmplifyHosting":                          {"App"},
	"CloudWatchSynthetics":                        {"CanaryName", "StepName"},
	"AWS/Scheduler":                               {"ScheduleGroup"},
	"AWS/MWAA":                                    {"Cluster", "Queue", "Database"},
	"AWS/ECR":                                     {"RepositoryName"},
	"AmazonMWAA":                                  {"DAG", "DAGFilename", "Function", "Job", "Operator", "Pool", "Task", "HostName"},
}
