// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteRoleParams creates a new DeleteRoleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteRoleParams() *DeleteRoleParams {
	return &DeleteRoleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteRoleParamsWithTimeout creates a new DeleteRoleParams object
// with the ability to set a timeout on a request.
func NewDeleteRoleParamsWithTimeout(timeout time.Duration) *DeleteRoleParams {
	return &DeleteRoleParams{
		timeout: timeout,
	}
}

// NewDeleteRoleParamsWithContext creates a new DeleteRoleParams object
// with the ability to set a context for a request.
func NewDeleteRoleParamsWithContext(ctx context.Context) *DeleteRoleParams {
	return &DeleteRoleParams{
		Context: ctx,
	}
}

// NewDeleteRoleParamsWithHTTPClient creates a new DeleteRoleParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteRoleParamsWithHTTPClient(client *http.Client) *DeleteRoleParams {
	return &DeleteRoleParams{
		HTTPClient: client,
	}
}

/*
DeleteRoleParams contains all the parameters to send to the API endpoint

	for the delete role operation.

	Typically these are written to a http.Request.
*/
type DeleteRoleParams struct {

	// Force.
	Force *bool

	// Global.
	Global *bool

	// RoleUID.
	RoleUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteRoleParams) WithDefaults() *DeleteRoleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteRoleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete role params
func (o *DeleteRoleParams) WithTimeout(timeout time.Duration) *DeleteRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete role params
func (o *DeleteRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete role params
func (o *DeleteRoleParams) WithContext(ctx context.Context) *DeleteRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete role params
func (o *DeleteRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete role params
func (o *DeleteRoleParams) WithHTTPClient(client *http.Client) *DeleteRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete role params
func (o *DeleteRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithForce adds the force to the delete role params
func (o *DeleteRoleParams) WithForce(force *bool) *DeleteRoleParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the delete role params
func (o *DeleteRoleParams) SetForce(force *bool) {
	o.Force = force
}

// WithGlobal adds the global to the delete role params
func (o *DeleteRoleParams) WithGlobal(global *bool) *DeleteRoleParams {
	o.SetGlobal(global)
	return o
}

// SetGlobal adds the global to the delete role params
func (o *DeleteRoleParams) SetGlobal(global *bool) {
	o.Global = global
}

// WithRoleUID adds the roleUID to the delete role params
func (o *DeleteRoleParams) WithRoleUID(roleUID string) *DeleteRoleParams {
	o.SetRoleUID(roleUID)
	return o
}

// SetRoleUID adds the roleUid to the delete role params
func (o *DeleteRoleParams) SetRoleUID(roleUID string) {
	o.RoleUID = roleUID
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	if o.Global != nil {

		// query param global
		var qrGlobal bool

		if o.Global != nil {
			qrGlobal = *o.Global
		}
		qGlobal := swag.FormatBool(qrGlobal)
		if qGlobal != "" {

			if err := r.SetQueryParam("global", qGlobal); err != nil {
				return err
			}
		}
	}

	// path param roleUID
	if err := r.SetPathParam("roleUID", o.RoleUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
