// Code generated by bpf2go; DO NOT EDIT.
//go:build arm64

package ebpf

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type NetSkConnInitiatorKey struct {
	_     structs.HostLayout
	LowIp struct {
		_    structs.HostLayout
		In6U struct {
			_       structs.HostLayout
			U6Addr8 [16]uint8
		}
	}
	HighIp struct {
		_    structs.HostLayout
		In6U struct {
			_       structs.HostLayout
			U6Addr8 [16]uint8
		}
	}
	LowIpPort  uint16
	HighIpPort uint16
}

type NetSkFlowId NetSkFlowIdT

type NetSkFlowIdT struct {
	_     structs.HostLayout
	SrcIp struct {
		_    structs.HostLayout
		In6U struct {
			_       structs.HostLayout
			U6Addr8 [16]uint8
		}
	}
	DstIp struct {
		_    structs.HostLayout
		In6U struct {
			_       structs.HostLayout
			U6Addr8 [16]uint8
		}
	}
	IfIndex           uint32
	EthProtocol       uint16
	SrcPort           uint16
	DstPort           uint16
	TransportProtocol uint8
	Pad               [1]uint8
}

type NetSkFlowMetrics NetSkFlowMetricsT

type NetSkFlowMetricsT struct {
	_               structs.HostLayout
	Bytes           uint64
	StartMonoTimeNs uint64
	EndMonoTimeNs   uint64
	Packets         uint32
	Flags           uint16
	IfaceDirection  uint8
	Initiator       uint8
	Errno           uint8
	Pad             [7]uint8
}

type NetSkFlowRecordT struct {
	_       structs.HostLayout
	Metrics NetSkFlowMetrics
	Id      NetSkFlowId
	Pad     [4]uint8
}

// LoadNetSk returns the embedded CollectionSpec for NetSk.
func LoadNetSk() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_NetSkBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load NetSk: %w", err)
	}

	return spec, err
}

// LoadNetSkObjects loads NetSk and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*NetSkObjects
//	*NetSkPrograms
//	*NetSkMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadNetSkObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadNetSk()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// NetSkSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type NetSkSpecs struct {
	NetSkProgramSpecs
	NetSkMapSpecs
	NetSkVariableSpecs
}

// NetSkProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type NetSkProgramSpecs struct {
	ObiSocketFilter *ebpf.ProgramSpec `ebpf:"obi_socket__filter"`
}

// NetSkMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type NetSkMapSpecs struct {
	AggregatedFlows *ebpf.MapSpec `ebpf:"aggregated_flows"`
	ConnInitiators  *ebpf.MapSpec `ebpf:"conn_initiators"`
	DirectFlows     *ebpf.MapSpec `ebpf:"direct_flows"`
	FlowDirections  *ebpf.MapSpec `ebpf:"flow_directions"`
}

// NetSkVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type NetSkVariableSpecs struct {
	Ip4in6            *ebpf.VariableSpec `ebpf:"ip4in6"`
	Sampling          *ebpf.VariableSpec `ebpf:"sampling"`
	TraceMessages     *ebpf.VariableSpec `ebpf:"trace_messages"`
	UnusedFlowId      *ebpf.VariableSpec `ebpf:"unused_flow_id"`
	UnusedFlowMetrics *ebpf.VariableSpec `ebpf:"unused_flow_metrics"`
	UnusedFlowRecord  *ebpf.VariableSpec `ebpf:"unused_flow_record"`
}

// NetSkObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadNetSkObjects or ebpf.CollectionSpec.LoadAndAssign.
type NetSkObjects struct {
	NetSkPrograms
	NetSkMaps
	NetSkVariables
}

func (o *NetSkObjects) Close() error {
	return _NetSkClose(
		&o.NetSkPrograms,
		&o.NetSkMaps,
	)
}

// NetSkMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadNetSkObjects or ebpf.CollectionSpec.LoadAndAssign.
type NetSkMaps struct {
	AggregatedFlows *ebpf.Map `ebpf:"aggregated_flows"`
	ConnInitiators  *ebpf.Map `ebpf:"conn_initiators"`
	DirectFlows     *ebpf.Map `ebpf:"direct_flows"`
	FlowDirections  *ebpf.Map `ebpf:"flow_directions"`
}

func (m *NetSkMaps) Close() error {
	return _NetSkClose(
		m.AggregatedFlows,
		m.ConnInitiators,
		m.DirectFlows,
		m.FlowDirections,
	)
}

// NetSkVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadNetSkObjects or ebpf.CollectionSpec.LoadAndAssign.
type NetSkVariables struct {
	Ip4in6            *ebpf.Variable `ebpf:"ip4in6"`
	Sampling          *ebpf.Variable `ebpf:"sampling"`
	TraceMessages     *ebpf.Variable `ebpf:"trace_messages"`
	UnusedFlowId      *ebpf.Variable `ebpf:"unused_flow_id"`
	UnusedFlowMetrics *ebpf.Variable `ebpf:"unused_flow_metrics"`
	UnusedFlowRecord  *ebpf.Variable `ebpf:"unused_flow_record"`
}

// NetSkPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadNetSkObjects or ebpf.CollectionSpec.LoadAndAssign.
type NetSkPrograms struct {
	ObiSocketFilter *ebpf.Program `ebpf:"obi_socket__filter"`
}

func (p *NetSkPrograms) Close() error {
	return _NetSkClose(
		p.ObiSocketFilter,
	)
}

func _NetSkClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed netsk_arm64_bpfel.o
var _NetSkBytes []byte
