// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	monitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	applyconfigurationmonitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1alpha1"
	scheme "github.com/prometheus-operator/prometheus-operator/pkg/client/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// AlertmanagerConfigsGetter has a method to return a AlertmanagerConfigInterface.
// A group's client should implement this interface.
type AlertmanagerConfigsGetter interface {
	AlertmanagerConfigs(namespace string) AlertmanagerConfigInterface
}

// AlertmanagerConfigInterface has methods to work with AlertmanagerConfig resources.
type AlertmanagerConfigInterface interface {
	Create(ctx context.Context, alertmanagerConfig *monitoringv1alpha1.AlertmanagerConfig, opts v1.CreateOptions) (*monitoringv1alpha1.AlertmanagerConfig, error)
	Update(ctx context.Context, alertmanagerConfig *monitoringv1alpha1.AlertmanagerConfig, opts v1.UpdateOptions) (*monitoringv1alpha1.AlertmanagerConfig, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*monitoringv1alpha1.AlertmanagerConfig, error)
	List(ctx context.Context, opts v1.ListOptions) (*monitoringv1alpha1.AlertmanagerConfigList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *monitoringv1alpha1.AlertmanagerConfig, err error)
	Apply(ctx context.Context, alertmanagerConfig *applyconfigurationmonitoringv1alpha1.AlertmanagerConfigApplyConfiguration, opts v1.ApplyOptions) (result *monitoringv1alpha1.AlertmanagerConfig, err error)
	AlertmanagerConfigExpansion
}

// alertmanagerConfigs implements AlertmanagerConfigInterface
type alertmanagerConfigs struct {
	*gentype.ClientWithListAndApply[*monitoringv1alpha1.AlertmanagerConfig, *monitoringv1alpha1.AlertmanagerConfigList, *applyconfigurationmonitoringv1alpha1.AlertmanagerConfigApplyConfiguration]
}

// newAlertmanagerConfigs returns a AlertmanagerConfigs
func newAlertmanagerConfigs(c *MonitoringV1alpha1Client, namespace string) *alertmanagerConfigs {
	return &alertmanagerConfigs{
		gentype.NewClientWithListAndApply[*monitoringv1alpha1.AlertmanagerConfig, *monitoringv1alpha1.AlertmanagerConfigList, *applyconfigurationmonitoringv1alpha1.AlertmanagerConfigApplyConfiguration](
			"alertmanagerconfigs",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *monitoringv1alpha1.AlertmanagerConfig { return &monitoringv1alpha1.AlertmanagerConfig{} },
			func() *monitoringv1alpha1.AlertmanagerConfigList { return &monitoringv1alpha1.AlertmanagerConfigList{} },
		),
	}
}
