// Code generated by goyacc -l -p syntax -o pkg/logql/syntax/syntax.y.go pkg/logql/syntax/syntax.y. DO NOT EDIT.
package syntax

import __yyfmt__ "fmt"

import (
	"github.com/grafana/loki/v3/pkg/logql/log"
	"github.com/prometheus/prometheus/model/labels"
	"time"
)

type syntaxSymType struct {
	yys   int
	val   interface{}
	bytes uint64
	dur   time.Duration
	op    string
	binOp string
	str   string
	strs  []string

	expr         Expr
	logExpr      LogSelectorExpr
	metricExpr   SampleExpr
	variantsExpr VariantsExpr

	matcher                       *labels.Matcher
	matchers                      []*labels.Matcher
	metricExprs                   []SampleExpr
	stage                         StageExpr
	stages                        MultiStageExpr
	filterer                      log.LabelFilterer
	filter                        log.LineMatchType
	lineFilterExpr                *LineFilterExpr
	binOpts                       *BinOpOptions
	namedMatcher                  log.NamedLabelMatcher
	namedMatchers                 []log.NamedLabelMatcher
	labelFormat                   log.LabelFmt
	labelsFormat                  []log.LabelFmt
	grouping                      *Grouping
	logRangeExpr                  *LogRangeExpr
	literalExpr                   *LiteralExpr
	labelFormatExpr               *LabelFmtExpr
	labelExtractionExpression     log.LabelExtractionExpr
	labelExtractionExpressionList []log.LabelExtractionExpr
	unwrapExpr                    *UnwrapExpr
	offsetExpr                    *OffsetExpr
}

const BYTES = 57346
const IDENTIFIER = 57347
const STRING = 57348
const NUMBER = 57349
const FUNCTION_FLAG = 57350
const DURATION = 57351
const RANGE = 57352
const MATCHERS = 57353
const LABELS = 57354
const EQ = 57355
const RE = 57356
const NRE = 57357
const NPA = 57358
const OPEN_BRACE = 57359
const CLOSE_BRACE = 57360
const OPEN_BRACKET = 57361
const CLOSE_BRACKET = 57362
const COMMA = 57363
const DOT = 57364
const PIPE_MATCH = 57365
const PIPE_EXACT = 57366
const PIPE_PATTERN = 57367
const OPEN_PARENTHESIS = 57368
const CLOSE_PARENTHESIS = 57369
const BY = 57370
const WITHOUT = 57371
const COUNT_OVER_TIME = 57372
const RATE = 57373
const RATE_COUNTER = 57374
const SUM = 57375
const SORT = 57376
const SORT_DESC = 57377
const AVG = 57378
const MAX = 57379
const MIN = 57380
const COUNT = 57381
const STDDEV = 57382
const STDVAR = 57383
const BOTTOMK = 57384
const TOPK = 57385
const APPROX_TOPK = 57386
const BYTES_OVER_TIME = 57387
const BYTES_RATE = 57388
const BOOL = 57389
const JSON = 57390
const REGEXP = 57391
const LOGFMT = 57392
const PIPE = 57393
const LINE_FMT = 57394
const LABEL_FMT = 57395
const UNWRAP = 57396
const AVG_OVER_TIME = 57397
const SUM_OVER_TIME = 57398
const MIN_OVER_TIME = 57399
const MAX_OVER_TIME = 57400
const STDVAR_OVER_TIME = 57401
const STDDEV_OVER_TIME = 57402
const QUANTILE_OVER_TIME = 57403
const BYTES_CONV = 57404
const DURATION_CONV = 57405
const DURATION_SECONDS_CONV = 57406
const FIRST_OVER_TIME = 57407
const LAST_OVER_TIME = 57408
const ABSENT_OVER_TIME = 57409
const VECTOR = 57410
const LABEL_REPLACE = 57411
const UNPACK = 57412
const OFFSET = 57413
const PATTERN = 57414
const IP = 57415
const ON = 57416
const IGNORING = 57417
const GROUP_LEFT = 57418
const GROUP_RIGHT = 57419
const DECOLORIZE = 57420
const DROP = 57421
const KEEP = 57422
const VARIANTS = 57423
const OF = 57424
const OR = 57425
const AND = 57426
const UNLESS = 57427
const CMP_EQ = 57428
const NEQ = 57429
const LT = 57430
const LTE = 57431
const GT = 57432
const GTE = 57433
const ADD = 57434
const SUB = 57435
const MUL = 57436
const DIV = 57437
const MOD = 57438
const POW = 57439

var syntaxToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"BYTES",
	"IDENTIFIER",
	"STRING",
	"NUMBER",
	"FUNCTION_FLAG",
	"DURATION",
	"RANGE",
	"MATCHERS",
	"LABELS",
	"EQ",
	"RE",
	"NRE",
	"NPA",
	"OPEN_BRACE",
	"CLOSE_BRACE",
	"OPEN_BRACKET",
	"CLOSE_BRACKET",
	"COMMA",
	"DOT",
	"PIPE_MATCH",
	"PIPE_EXACT",
	"PIPE_PATTERN",
	"OPEN_PARENTHESIS",
	"CLOSE_PARENTHESIS",
	"BY",
	"WITHOUT",
	"COUNT_OVER_TIME",
	"RATE",
	"RATE_COUNTER",
	"SUM",
	"SORT",
	"SORT_DESC",
	"AVG",
	"MAX",
	"MIN",
	"COUNT",
	"STDDEV",
	"STDVAR",
	"BOTTOMK",
	"TOPK",
	"APPROX_TOPK",
	"BYTES_OVER_TIME",
	"BYTES_RATE",
	"BOOL",
	"JSON",
	"REGEXP",
	"LOGFMT",
	"PIPE",
	"LINE_FMT",
	"LABEL_FMT",
	"UNWRAP",
	"AVG_OVER_TIME",
	"SUM_OVER_TIME",
	"MIN_OVER_TIME",
	"MAX_OVER_TIME",
	"STDVAR_OVER_TIME",
	"STDDEV_OVER_TIME",
	"QUANTILE_OVER_TIME",
	"BYTES_CONV",
	"DURATION_CONV",
	"DURATION_SECONDS_CONV",
	"FIRST_OVER_TIME",
	"LAST_OVER_TIME",
	"ABSENT_OVER_TIME",
	"VECTOR",
	"LABEL_REPLACE",
	"UNPACK",
	"OFFSET",
	"PATTERN",
	"IP",
	"ON",
	"IGNORING",
	"GROUP_LEFT",
	"GROUP_RIGHT",
	"DECOLORIZE",
	"DROP",
	"KEEP",
	"VARIANTS",
	"OF",
	"OR",
	"AND",
	"UNLESS",
	"CMP_EQ",
	"NEQ",
	"LT",
	"LTE",
	"GT",
	"GTE",
	"ADD",
	"SUB",
	"MUL",
	"DIV",
	"MOD",
	"POW",
}
var syntaxStatenames = [...]string{}

const syntaxEofCode = 1
const syntaxErrCode = 2
const syntaxInitialStackSize = 16

var syntaxExca = [...]int{
	-1, 1,
	1, -1,
	-2, 0,
	-1, 150,
	21, 227,
	27, 227,
	-2, 3,
	-1, 290,
	21, 228,
	27, 228,
	-2, 3,
}

const syntaxPrivate = 57344

const syntaxLast = 642

var syntaxAct = [...]int{

	293, 232, 88, 4, 217, 67, 130, 6, 188, 206,
	158, 79, 203, 195, 66, 241, 205, 193, 80, 2,
	59, 286, 84, 51, 52, 53, 60, 61, 64, 65,
	62, 63, 54, 55, 56, 57, 58, 59, 143, 218,
	11, 52, 53, 60, 61, 64, 65, 62, 63, 54,
	55, 56, 57, 58, 59, 60, 61, 64, 65, 62,
	63, 54, 55, 56, 57, 58, 59, 56, 57, 58,
	59, 289, 113, 144, 210, 156, 157, 296, 119, 54,
	55, 56, 57, 58, 59, 150, 301, 154, 156, 157,
	269, 162, 225, 18, 160, 268, 265, 167, 224, 18,
	284, 264, 219, 18, 281, 283, 146, 18, 278, 280,
	98, 18, 70, 277, 169, 172, 173, 298, 174, 175,
	176, 177, 178, 179, 180, 181, 182, 183, 184, 185,
	186, 187, 275, 170, 171, 18, 272, 274, 371, 18,
	146, 271, 371, 200, 197, 208, 208, 216, 211, 214,
	215, 212, 213, 343, 297, 140, 209, 392, 296, 267,
	223, 155, 228, 343, 387, 263, 297, 310, 239, 235,
	140, 190, 236, 360, 145, 233, 134, 228, 19, 20,
	374, 114, 244, 350, 19, 20, 190, 380, 19, 20,
	379, 134, 19, 20, 298, 298, 19, 20, 252, 253,
	254, 344, 335, 299, 298, 75, 77, 298, 75, 77,
	256, 89, 90, 72, 73, 74, 72, 73, 74, 378,
	19, 20, 228, 243, 19, 20, 290, 87, 368, 89,
	90, 376, 291, 294, 189, 300, 228, 303, 160, 113,
	306, 292, 307, 119, 234, 320, 295, 305, 191, 189,
	304, 266, 270, 273, 276, 279, 282, 285, 346, 347,
	348, 229, 310, 363, 314, 316, 319, 321, 359, 208,
	299, 322, 328, 324, 353, 75, 77, 76, 140, 333,
	76, 243, 308, 72, 73, 74, 310, 351, 140, 247,
	310, 331, 358, 243, 190, 336, 357, 338, 340, 134,
	342, 113, 243, 318, 140, 243, 352, 341, 337, 134,
	113, 234, 310, 354, 237, 317, 310, 222, 312, 243,
	190, 148, 311, 221, 315, 134, 259, 245, 147, 334,
	159, 126, 127, 125, 330, 135, 137, 301, 365, 366,
	15, 242, 160, 113, 367, 364, 140, 76, 15, 161,
	369, 370, 329, 128, 287, 129, 375, 161, 251, 250,
	249, 136, 138, 139, 231, 18, 248, 134, 220, 75,
	77, 382, 166, 383, 384, 15, 165, 72, 73, 74,
	261, 302, 191, 189, 7, 164, 388, 94, 23, 24,
	25, 38, 47, 48, 39, 41, 42, 40, 43, 44,
	45, 46, 49, 26, 27, 234, 93, 86, 81, 390,
	386, 356, 152, 28, 29, 30, 31, 32, 33, 34,
	257, 309, 262, 35, 36, 37, 50, 21, 151, 231,
	240, 153, 260, 246, 75, 77, 238, 75, 77, 14,
	15, 76, 72, 73, 74, 72, 73, 74, 230, 7,
	19, 20, 258, 23, 24, 25, 38, 47, 48, 39,
	41, 42, 40, 43, 44, 45, 46, 49, 26, 27,
	234, 385, 85, 234, 373, 372, 349, 339, 28, 29,
	30, 31, 32, 33, 34, 83, 326, 327, 35, 36,
	37, 50, 21, 296, 196, 163, 196, 255, 391, 194,
	3, 168, 75, 77, 14, 15, 76, 92, 78, 76,
	72, 73, 74, 91, 7, 19, 20, 389, 23, 24,
	25, 38, 47, 48, 39, 41, 42, 40, 43, 44,
	45, 46, 49, 26, 27, 377, 362, 361, 234, 332,
	323, 149, 313, 28, 29, 30, 31, 32, 33, 34,
	75, 77, 140, 35, 36, 37, 50, 21, 72, 73,
	74, 325, 288, 227, 204, 202, 226, 225, 224, 14,
	201, 199, 198, 134, 76, 95, 381, 355, 207, 196,
	19, 20, 85, 204, 97, 96, 69, 192, 22, 82,
	71, 131, 132, 141, 133, 126, 127, 125, 142, 135,
	137, 17, 345, 16, 68, 124, 123, 122, 121, 120,
	118, 117, 116, 115, 5, 13, 12, 128, 10, 129,
	9, 8, 76, 1, 0, 136, 138, 139, 99, 100,
	101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
	111, 112,
}
var syntaxPact = [...]int{

	358, -1000, -60, -1000, -1000, -1000, 535, 358, -1000, -1000,
	-1000, -1000, -1000, -1000, 382, 467, 381, 201, -1000, 506,
	500, 380, 361, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 63, 63, 63, 63, 63, 63, 63, 63, 63,
	63, 63, 63, 63, 63, 63, 535, -1000, 190, 547,
	-45, 67, -1000, -1000, -1000, -1000, -1000, -1000, 301, 294,
	-60, 358, 410, -1000, -1000, 74, 323, 488, 359, 350,
	346, -1000, -1000, 358, 494, 358, 59, 39, -1000, 358,
	358, 358, 358, 358, 358, 358, 358, 358, 358, 358,
	358, 358, 358, -1000, -45, -1000, -1000, -1000, -1000, 165,
	-1000, -1000, -1000, -1000, -1000, 491, 574, 566, -1000, 565,
	-1000, -1000, -1000, -1000, 341, 564, -1000, 578, 573, 573,
	61, -1000, -1000, 33, -1000, 342, -1000, -1000, -1000, 296,
	-1000, -1000, -1000, 577, 562, 561, 560, 557, 234, 427,
	419, 331, 287, 415, 423, 314, 300, 412, 262, -43,
	340, 334, 333, 332, -31, -31, -27, -27, -77, -77,
	-77, -77, -13, -13, -13, -13, -13, -13, 165, 341,
	341, 341, 489, 399, -1000, -1000, 439, 399, -1000, -1000,
	299, -1000, 411, -1000, 367, 401, -1000, 74, -1000, 401,
	92, 86, 132, 128, 104, 100, 96, -1000, -62, 328,
	556, -11, 358, -1000, -1000, -1000, -1000, -1000, -1000, 183,
	331, 422, 144, 193, 283, 354, 220, 183, 358, 255,
	400, 295, -1000, -1000, 291, -1000, 536, -1000, 297, 288,
	276, 218, 273, 165, 150, -1000, 399, 574, 534, -1000,
	559, 481, 573, 326, -1000, -1000, -1000, 308, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, 33, 533, 252, 303,
	-1000, -1000, 175, 487, 66, 487, 468, 6, 341, 6,
	143, 196, 466, 156, 260, -1000, -1000, 247, -1000, 358,
	572, -1000, -1000, 390, 269, -1000, 265, -1000, -1000, 241,
	-1000, 146, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 531,
	530, -1000, 236, -1000, 331, 183, 66, 487, 66, -1000,
	-1000, 165, -1000, 6, -1000, 202, -1000, -1000, -1000, 87,
	465, 464, 153, 183, 204, -1000, 529, -1000, -1000, -1000,
	-1000, 192, 163, -1000, 160, -1000, 66, -1000, 571, 91,
	66, 32, 6, 6, 461, -1000, -1000, 389, -1000, -1000,
	-1000, 137, 66, -1000, -1000, 6, 511, -1000, -1000, 388,
	492, 130, -1000,
}
var syntaxPgo = [...]int{

	0, 623, 18, 500, 3, 621, 620, 618, 616, 615,
	614, 5, 613, 612, 611, 610, 609, 608, 607, 606,
	605, 14, 112, 604, 4, 603, 602, 601, 102, 598,
	594, 593, 8, 592, 591, 590, 6, 589, 7, 588,
	15, 587, 575, 585, 584, 9, 16, 12, 565, 2,
	10, 40, 13, 17, 1, 0, 541,
}
var syntaxR1 = [...]int{

	0, 1, 2, 2, 2, 3, 3, 3, 4, 4,
	4, 4, 4, 4, 4, 10, 50, 50, 50, 50,
	50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
	50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
	50, 50, 54, 54, 54, 26, 26, 26, 5, 5,
	5, 5, 6, 6, 6, 6, 6, 6, 8, 38,
	38, 38, 37, 37, 36, 36, 36, 36, 21, 21,
	11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
	11, 35, 35, 35, 35, 35, 35, 28, 24, 24,
	24, 22, 22, 22, 23, 23, 41, 41, 12, 12,
	13, 13, 13, 13, 14, 15, 15, 16, 17, 47,
	47, 48, 48, 48, 18, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 52, 52, 53, 53, 34, 34,
	33, 33, 31, 31, 31, 31, 31, 31, 31, 29,
	29, 29, 29, 29, 29, 29, 30, 30, 30, 30,
	30, 30, 30, 45, 45, 46, 46, 19, 20, 7,
	7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 43, 43, 44, 44, 44, 44,
	42, 42, 42, 42, 42, 42, 42, 42, 51, 51,
	51, 9, 39, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
	55, 40, 40, 49, 49, 49, 49, 56, 56,
}
var syntaxR2 = [...]int{

	0, 1, 1, 1, 1, 1, 2, 3, 1, 1,
	1, 1, 1, 1, 3, 8, 2, 3, 4, 5,
	3, 4, 5, 6, 3, 4, 5, 6, 3, 4,
	5, 6, 4, 5, 6, 7, 3, 4, 4, 5,
	3, 2, 3, 6, 3, 1, 1, 1, 4, 6,
	5, 7, 4, 5, 5, 6, 7, 7, 12, 3,
	3, 2, 1, 3, 3, 3, 3, 3, 1, 2,
	1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 1, 1, 1, 1, 1, 1, 1, 1, 3,
	4, 2, 5, 3, 1, 2, 1, 2, 1, 2,
	1, 2, 1, 2, 2, 3, 2, 2, 1, 3,
	3, 1, 3, 3, 2, 1, 1, 1, 1, 3,
	2, 3, 3, 3, 3, 1, 1, 3, 6, 6,
	1, 1, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 1, 1, 1, 3, 2, 2, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 0, 1, 5, 4, 5, 4,
	1, 1, 2, 4, 5, 2, 4, 5, 1, 2,
	2, 4, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	2, 1, 3, 4, 4, 3, 3, 1, 3,
}
var syntaxChk = [...]int{

	-1000, -1, -2, -3, -4, -10, -38, 26, -5, -6,
	-7, -51, -8, -9, 81, 17, -25, -27, 7, 92,
	93, 69, -39, 30, 31, 32, 45, 46, 55, 56,
	57, 58, 59, 60, 61, 65, 66, 67, 33, 36,
	39, 37, 38, 40, 41, 42, 43, 34, 35, 44,
	68, 83, 84, 85, 92, 93, 94, 95, 96, 97,
	86, 87, 90, 91, 88, 89, -21, -11, -23, 51,
	-22, -35, 23, 24, 25, 15, 87, 16, -3, -4,
	-2, 26, -37, 18, -36, 5, 26, 26, -49, 28,
	29, 7, 7, 26, 26, -42, -43, -44, 47, -42,
	-42, -42, -42, -42, -42, -42, -42, -42, -42, -42,
	-42, -42, -42, -11, -22, -12, -13, -14, -15, -32,
	-16, -17, -18, -19, -20, 50, 48, 49, 70, 72,
	-36, -34, -33, -30, 26, 52, 78, 53, 79, 80,
	5, -31, -29, 83, 6, -28, 73, 27, 27, -56,
	-4, 18, 2, 21, 13, 87, 14, 15, -50, 7,
	-38, 26, -4, 7, 26, 26, 26, -4, 7, -2,
	74, 75, 76, 77, -2, -2, -2, -2, -2, -2,
	-2, -2, -2, -2, -2, -2, -2, -2, -32, 84,
	21, 83, -41, -53, 8, -52, 5, -53, 6, 6,
	-32, 6, -48, -47, 5, -46, -45, 5, -36, -46,
	13, 87, 90, 91, 88, 89, 86, -24, 6, -28,
	26, 27, 21, -36, 6, 6, 6, 6, 2, 27,
	21, 10, -54, -21, 51, -38, -50, 27, 21, -4,
	7, -40, 27, 5, -40, 27, 21, 27, 26, 26,
	26, 26, -32, -32, -32, 8, -53, 21, 13, 27,
	21, 13, 21, 73, 9, 4, -51, 73, 9, 4,
	-51, 9, 4, -51, 9, 4, -51, 9, 4, -51,
	9, 4, -51, 9, 4, -51, 83, 26, 6, 82,
	-4, -49, -50, -55, -54, -21, 71, 10, 51, 10,
	-54, 54, 27, -54, -21, 27, -49, -4, 27, 21,
	21, 27, 27, 6, -40, 27, -40, 27, 27, -40,
	27, -40, -52, 6, -47, 2, 5, 6, -45, 26,
	26, -24, 6, 27, 26, 27, -54, -21, -54, 9,
	-55, -32, -55, 10, 5, -26, 62, 63, 64, 10,
	27, 27, -54, 27, -4, 5, 21, 27, 27, 27,
	27, 6, 6, 27, -50, -49, -54, -55, 26, -55,
	-54, 51, 10, 10, 27, -49, 27, 6, 27, 27,
	27, 5, -54, -55, -55, 10, 21, 27, -55, 6,
	21, 6, 27,
}
var syntaxDef = [...]int{

	0, -2, 1, 2, 3, 4, 5, 0, 8, 9,
	10, 11, 12, 13, 0, 0, 0, 0, 188, 0,
	0, 0, 0, 205, 206, 207, 208, 209, 210, 211,
	212, 213, 214, 215, 216, 217, 218, 219, 193, 194,
	195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
	192, 174, 174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 6, 68, 70, 0,
	94, 0, 81, 82, 83, 84, 85, 86, 2, 3,
	0, 0, 0, 61, 62, 0, 0, 0, 0, 0,
	0, 189, 190, 0, 0, 0, 180, 181, 175, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 69, 95, 71, 72, 73, 74, 75,
	76, 77, 78, 79, 80, 98, 100, 0, 102, 0,
	115, 116, 117, 118, 0, 0, 108, 0, 0, 0,
	0, 130, 131, 0, 91, 0, 87, 7, 14, 0,
	-2, 59, 60, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 3, 188, 0, 0, 0, 3, 0, 159,
	0, 0, 182, 185, 160, 161, 162, 163, 164, 165,
	166, 167, 168, 169, 170, 171, 172, 173, 120, 0,
	0, 0, 99, 106, 96, 126, 125, 104, 101, 103,
	0, 107, 114, 111, 0, 157, 155, 153, 154, 158,
	0, 0, 0, 0, 0, 0, 0, 93, 88, 0,
	0, 0, 0, 63, 64, 65, 66, 67, 41, 48,
	0, 16, 0, 0, 0, 0, 0, 52, 0, 3,
	188, 0, 225, 221, 0, 226, 0, 191, 0, 0,
	0, 0, 121, 122, 123, 97, 105, 0, 0, 119,
	0, 0, 0, 0, 137, 144, 151, 0, 136, 143,
	150, 132, 139, 146, 133, 140, 147, 134, 141, 148,
	135, 142, 149, 138, 145, 152, 0, 0, 0, 0,
	-2, 50, 0, 17, 20, 36, 0, 24, 0, 28,
	0, 0, 0, 0, 0, 40, 54, 3, 53, 0,
	0, 223, 224, 0, 0, 177, 0, 179, 183, 0,
	186, 0, 127, 124, 112, 113, 109, 110, 156, 0,
	0, 89, 0, 92, 0, 49, 21, 37, 38, 220,
	25, 44, 29, 32, 42, 0, 45, 46, 47, 18,
	0, 0, 0, 55, 3, 222, 0, 176, 178, 184,
	187, 0, 0, 90, 0, 51, 39, 33, 0, 19,
	22, 0, 26, 30, 0, 56, 57, 0, 128, 129,
	15, 0, 23, 27, 31, 34, 0, 43, 35, 0,
	0, 0, 58,
}
var syntaxTok1 = [...]int{

	1,
}
var syntaxTok2 = [...]int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
	92, 93, 94, 95, 96, 97,
}
var syntaxTok3 = [...]int{
	0,
}

var syntaxErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

/*	parser for yacc output	*/

var (
	syntaxDebug        = 0
	syntaxErrorVerbose = false
)

type syntaxLexer interface {
	Lex(lval *syntaxSymType) int
	Error(s string)
}

type syntaxParser interface {
	Parse(syntaxLexer) int
	Lookahead() int
}

type syntaxParserImpl struct {
	lval  syntaxSymType
	stack [syntaxInitialStackSize]syntaxSymType
	char  int
}

func (p *syntaxParserImpl) Lookahead() int {
	return p.char
}

func syntaxNewParser() syntaxParser {
	return &syntaxParserImpl{}
}

const syntaxFlag = -1000

func syntaxTokname(c int) string {
	if c >= 1 && c-1 < len(syntaxToknames) {
		if syntaxToknames[c-1] != "" {
			return syntaxToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func syntaxStatname(s int) string {
	if s >= 0 && s < len(syntaxStatenames) {
		if syntaxStatenames[s] != "" {
			return syntaxStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func syntaxErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !syntaxErrorVerbose {
		return "syntax error"
	}

	for _, e := range syntaxErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + syntaxTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := syntaxPact[state]
	for tok := TOKSTART; tok-1 < len(syntaxToknames); tok++ {
		if n := base + tok; n >= 0 && n < syntaxLast && syntaxChk[syntaxAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if syntaxDef[state] == -2 {
		i := 0
		for syntaxExca[i] != -1 || syntaxExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; syntaxExca[i] >= 0; i += 2 {
			tok := syntaxExca[i]
			if tok < TOKSTART || syntaxExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if syntaxExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += syntaxTokname(tok)
	}
	return res
}

func syntaxlex1(lex syntaxLexer, lval *syntaxSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = syntaxTok1[0]
		goto out
	}
	if char < len(syntaxTok1) {
		token = syntaxTok1[char]
		goto out
	}
	if char >= syntaxPrivate {
		if char < syntaxPrivate+len(syntaxTok2) {
			token = syntaxTok2[char-syntaxPrivate]
			goto out
		}
	}
	for i := 0; i < len(syntaxTok3); i += 2 {
		token = syntaxTok3[i+0]
		if token == char {
			token = syntaxTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = syntaxTok2[1] /* unknown char */
	}
	if syntaxDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", syntaxTokname(token), uint(char))
	}
	return char, token
}

func syntaxParse(syntaxlex syntaxLexer) int {
	return syntaxNewParser().Parse(syntaxlex)
}

func (syntaxrcvr *syntaxParserImpl) Parse(syntaxlex syntaxLexer) int {
	var syntaxn int
	var syntaxVAL syntaxSymType
	var syntaxDollar []syntaxSymType
	_ = syntaxDollar // silence set and not used
	syntaxS := syntaxrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	syntaxstate := 0
	syntaxrcvr.char = -1
	syntaxtoken := -1 // syntaxrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		syntaxstate = -1
		syntaxrcvr.char = -1
		syntaxtoken = -1
	}()
	syntaxp := -1
	goto syntaxstack

ret0:
	return 0

ret1:
	return 1

syntaxstack:
	/* put a state and value onto the stack */
	if syntaxDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", syntaxTokname(syntaxtoken), syntaxStatname(syntaxstate))
	}

	syntaxp++
	if syntaxp >= len(syntaxS) {
		nyys := make([]syntaxSymType, len(syntaxS)*2)
		copy(nyys, syntaxS)
		syntaxS = nyys
	}
	syntaxS[syntaxp] = syntaxVAL
	syntaxS[syntaxp].yys = syntaxstate

syntaxnewstate:
	syntaxn = syntaxPact[syntaxstate]
	if syntaxn <= syntaxFlag {
		goto syntaxdefault /* simple state */
	}
	if syntaxrcvr.char < 0 {
		syntaxrcvr.char, syntaxtoken = syntaxlex1(syntaxlex, &syntaxrcvr.lval)
	}
	syntaxn += syntaxtoken
	if syntaxn < 0 || syntaxn >= syntaxLast {
		goto syntaxdefault
	}
	syntaxn = syntaxAct[syntaxn]
	if syntaxChk[syntaxn] == syntaxtoken { /* valid shift */
		syntaxrcvr.char = -1
		syntaxtoken = -1
		syntaxVAL = syntaxrcvr.lval
		syntaxstate = syntaxn
		if Errflag > 0 {
			Errflag--
		}
		goto syntaxstack
	}

syntaxdefault:
	/* default state action */
	syntaxn = syntaxDef[syntaxstate]
	if syntaxn == -2 {
		if syntaxrcvr.char < 0 {
			syntaxrcvr.char, syntaxtoken = syntaxlex1(syntaxlex, &syntaxrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if syntaxExca[xi+0] == -1 && syntaxExca[xi+1] == syntaxstate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			syntaxn = syntaxExca[xi+0]
			if syntaxn < 0 || syntaxn == syntaxtoken {
				break
			}
		}
		syntaxn = syntaxExca[xi+1]
		if syntaxn < 0 {
			goto ret0
		}
	}
	if syntaxn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			syntaxlex.Error(syntaxErrorMessage(syntaxstate, syntaxtoken))
			Nerrs++
			if syntaxDebug >= 1 {
				__yyfmt__.Printf("%s", syntaxStatname(syntaxstate))
				__yyfmt__.Printf(" saw %s\n", syntaxTokname(syntaxtoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for syntaxp >= 0 {
				syntaxn = syntaxPact[syntaxS[syntaxp].yys] + syntaxErrCode
				if syntaxn >= 0 && syntaxn < syntaxLast {
					syntaxstate = syntaxAct[syntaxn] /* simulate a shift of "error" */
					if syntaxChk[syntaxstate] == syntaxErrCode {
						goto syntaxstack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if syntaxDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", syntaxS[syntaxp].yys)
				}
				syntaxp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if syntaxDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", syntaxTokname(syntaxtoken))
			}
			if syntaxtoken == syntaxEofCode {
				goto ret1
			}
			syntaxrcvr.char = -1
			syntaxtoken = -1
			goto syntaxnewstate /* try again in the same state */
		}
	}

	/* reduction by production syntaxn */
	if syntaxDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", syntaxn, syntaxStatname(syntaxstate))
	}

	syntaxnt := syntaxn
	syntaxpt := syntaxp
	_ = syntaxpt // guard against "declared and not used"

	syntaxp -= syntaxR2[syntaxn]
	// syntaxp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if syntaxp+1 >= len(syntaxS) {
		nyys := make([]syntaxSymType, len(syntaxS)*2)
		copy(nyys, syntaxS)
		syntaxS = nyys
	}
	syntaxVAL = syntaxS[syntaxp+1]

	/* consult goto table to find next state */
	syntaxn = syntaxR1[syntaxn]
	syntaxg := syntaxPgo[syntaxn]
	syntaxj := syntaxg + syntaxS[syntaxp].yys + 1

	if syntaxj >= syntaxLast {
		syntaxstate = syntaxAct[syntaxg]
	} else {
		syntaxstate = syntaxAct[syntaxj]
		if syntaxChk[syntaxstate] != -syntaxn {
			syntaxstate = syntaxAct[syntaxg]
		}
	}
	// dummy call; replaced with literal code
	switch syntaxnt {

	case 1:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxlex.(*parser).expr = syntaxDollar[1].expr
		}
	case 2:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.expr = syntaxDollar[1].logExpr
		}
	case 3:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.expr = syntaxDollar[1].metricExpr
		}
	case 4:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.expr = syntaxDollar[1].variantsExpr
		}
	case 5:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.logExpr = newMatcherExpr(syntaxDollar[1].matchers)
		}
	case 6:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.logExpr = newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].stages)
		}
	case 7:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.logExpr = syntaxDollar[2].logExpr
		}
	case 8:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = syntaxDollar[1].metricExpr
		}
	case 9:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = syntaxDollar[1].metricExpr
		}
	case 10:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = syntaxDollar[1].metricExpr
		}
	case 11:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = syntaxDollar[1].literalExpr
		}
	case 12:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = syntaxDollar[1].metricExpr
		}
	case 13:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = syntaxDollar[1].metricExpr
		}
	case 14:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = syntaxDollar[2].metricExpr
		}
	case 15:
		syntaxDollar = syntaxS[syntaxpt-8 : syntaxpt+1]
		{
			syntaxVAL.variantsExpr = newVariantsExpr(syntaxDollar[3].metricExprs, syntaxDollar[7].logRangeExpr)
		}
	case 16:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].dur, nil, nil)
		}
	case 17:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].dur, nil, syntaxDollar[3].offsetExpr)
		}
	case 18:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[4].dur, nil, nil)
		}
	case 19:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[4].dur, nil, syntaxDollar[5].offsetExpr)
		}
	case 20:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].dur, syntaxDollar[3].unwrapExpr, nil)
		}
	case 21:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].dur, syntaxDollar[4].unwrapExpr, syntaxDollar[3].offsetExpr)
		}
	case 22:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[4].dur, syntaxDollar[5].unwrapExpr, nil)
		}
	case 23:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[4].dur, syntaxDollar[6].unwrapExpr, syntaxDollar[5].offsetExpr)
		}
	case 24:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[3].dur, syntaxDollar[2].unwrapExpr, nil)
		}
	case 25:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[3].dur, syntaxDollar[2].unwrapExpr, syntaxDollar[4].offsetExpr)
		}
	case 26:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[5].dur, syntaxDollar[3].unwrapExpr, nil)
		}
	case 27:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[5].dur, syntaxDollar[3].unwrapExpr, syntaxDollar[6].offsetExpr)
		}
	case 28:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].stages), syntaxDollar[3].dur, nil, nil)
		}
	case 29:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].stages), syntaxDollar[3].dur, nil, syntaxDollar[4].offsetExpr)
		}
	case 30:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[3].stages), syntaxDollar[5].dur, nil, nil)
		}
	case 31:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[3].stages), syntaxDollar[5].dur, nil, syntaxDollar[6].offsetExpr)
		}
	case 32:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].stages), syntaxDollar[4].dur, syntaxDollar[3].unwrapExpr, nil)
		}
	case 33:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[2].stages), syntaxDollar[4].dur, syntaxDollar[3].unwrapExpr, syntaxDollar[5].offsetExpr)
		}
	case 34:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[3].stages), syntaxDollar[6].dur, syntaxDollar[4].unwrapExpr, nil)
		}
	case 35:
		syntaxDollar = syntaxS[syntaxpt-7 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[2].matchers), syntaxDollar[3].stages), syntaxDollar[6].dur, syntaxDollar[4].unwrapExpr, syntaxDollar[7].offsetExpr)
		}
	case 36:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[3].stages), syntaxDollar[2].dur, nil, nil)
		}
	case 37:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[4].stages), syntaxDollar[2].dur, nil, syntaxDollar[3].offsetExpr)
		}
	case 38:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[3].stages), syntaxDollar[2].dur, syntaxDollar[4].unwrapExpr, nil)
		}
	case 39:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(syntaxDollar[1].matchers), syntaxDollar[4].stages), syntaxDollar[2].dur, syntaxDollar[5].unwrapExpr, syntaxDollar[3].offsetExpr)
		}
	case 40:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.logRangeExpr = syntaxDollar[2].logRangeExpr
		}
	case 42:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.unwrapExpr = newUnwrapExpr(syntaxDollar[3].str, "")
		}
	case 43:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.unwrapExpr = newUnwrapExpr(syntaxDollar[5].str, syntaxDollar[3].op)
		}
	case 44:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.unwrapExpr = syntaxDollar[1].unwrapExpr.addPostFilter(syntaxDollar[3].filterer)
		}
	case 45:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpConvBytes
		}
	case 46:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpConvDuration
		}
	case 47:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpConvDurationSeconds
		}
	case 48:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = newRangeAggregationExpr(syntaxDollar[3].logRangeExpr, syntaxDollar[1].op, nil, nil)
		}
	case 49:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = newRangeAggregationExpr(syntaxDollar[5].logRangeExpr, syntaxDollar[1].op, nil, &syntaxDollar[3].str)
		}
	case 50:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = newRangeAggregationExpr(syntaxDollar[3].logRangeExpr, syntaxDollar[1].op, syntaxDollar[5].grouping, nil)
		}
	case 51:
		syntaxDollar = syntaxS[syntaxpt-7 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = newRangeAggregationExpr(syntaxDollar[5].logRangeExpr, syntaxDollar[1].op, syntaxDollar[7].grouping, &syntaxDollar[3].str)
		}
	case 52:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewVectorAggregationExpr(syntaxDollar[3].metricExpr, syntaxDollar[1].op, nil, nil)
		}
	case 53:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewVectorAggregationExpr(syntaxDollar[4].metricExpr, syntaxDollar[1].op, syntaxDollar[2].grouping, nil)
		}
	case 54:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewVectorAggregationExpr(syntaxDollar[3].metricExpr, syntaxDollar[1].op, syntaxDollar[5].grouping, nil)
		}
	case 55:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewVectorAggregationExpr(syntaxDollar[5].metricExpr, syntaxDollar[1].op, nil, &syntaxDollar[3].str)
		}
	case 56:
		syntaxDollar = syntaxS[syntaxpt-7 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewVectorAggregationExpr(syntaxDollar[5].metricExpr, syntaxDollar[1].op, syntaxDollar[7].grouping, &syntaxDollar[3].str)
		}
	case 57:
		syntaxDollar = syntaxS[syntaxpt-7 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewVectorAggregationExpr(syntaxDollar[6].metricExpr, syntaxDollar[1].op, syntaxDollar[2].grouping, &syntaxDollar[4].str)
		}
	case 58:
		syntaxDollar = syntaxS[syntaxpt-12 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewLabelReplaceExpr(syntaxDollar[3].metricExpr, syntaxDollar[5].str, syntaxDollar[7].str, syntaxDollar[9].str, syntaxDollar[11].str)
		}
	case 59:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.matchers = syntaxDollar[2].matchers
		}
	case 60:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.matchers = syntaxDollar[2].matchers
		}
	case 61:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
		}
	case 62:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.matchers = []*labels.Matcher{syntaxDollar[1].matcher}
		}
	case 63:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.matchers = append(syntaxDollar[1].matchers, syntaxDollar[3].matcher)
		}
	case 64:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.matcher = mustNewMatcher(labels.MatchEqual, syntaxDollar[1].str, syntaxDollar[3].str)
		}
	case 65:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.matcher = mustNewMatcher(labels.MatchNotEqual, syntaxDollar[1].str, syntaxDollar[3].str)
		}
	case 66:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.matcher = mustNewMatcher(labels.MatchRegexp, syntaxDollar[1].str, syntaxDollar[3].str)
		}
	case 67:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.matcher = mustNewMatcher(labels.MatchNotRegexp, syntaxDollar[1].str, syntaxDollar[3].str)
		}
	case 68:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.stages = MultiStageExpr{syntaxDollar[1].stage}
		}
	case 69:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stages = append(syntaxDollar[1].stages, syntaxDollar[2].stage)
		}
	case 70:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[1].lineFilterExpr
		}
	case 71:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 72:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 73:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 74:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 75:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = &LabelFilterExpr{LabelFilterer: syntaxDollar[2].filterer}
		}
	case 76:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 77:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 78:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 79:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 80:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = syntaxDollar[2].stage
		}
	case 81:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filter = log.LineMatchRegexp
		}
	case 82:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filter = log.LineMatchEqual
		}
	case 83:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filter = log.LineMatchPattern
		}
	case 84:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filter = log.LineMatchNotRegexp
		}
	case 85:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filter = log.LineMatchNotEqual
		}
	case 86:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filter = log.LineMatchNotPattern
		}
	case 87:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpFilterIP
		}
	case 88:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.lineFilterExpr = newLineFilterExpr(log.LineMatchEqual, "", syntaxDollar[1].str)
		}
	case 89:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.lineFilterExpr = newOrLineFilterExpr(newLineFilterExpr(log.LineMatchEqual, "", syntaxDollar[1].str), syntaxDollar[3].lineFilterExpr)
		}
	case 90:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.lineFilterExpr = newLineFilterExpr(log.LineMatchEqual, syntaxDollar[1].op, syntaxDollar[3].str)
		}
	case 91:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.lineFilterExpr = newLineFilterExpr(syntaxDollar[1].filter, "", syntaxDollar[2].str)
		}
	case 92:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.lineFilterExpr = newLineFilterExpr(syntaxDollar[1].filter, syntaxDollar[2].op, syntaxDollar[4].str)
		}
	case 93:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.lineFilterExpr = newOrLineFilterExpr(syntaxDollar[1].lineFilterExpr, syntaxDollar[3].lineFilterExpr)
		}
	case 94:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.lineFilterExpr = syntaxDollar[1].lineFilterExpr
		}
	case 95:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.lineFilterExpr = newNestedLineFilterExpr(syntaxDollar[1].lineFilterExpr, syntaxDollar[2].lineFilterExpr)
		}
	case 96:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.strs = []string{syntaxDollar[1].str}
		}
	case 97:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.strs = append(syntaxDollar[1].strs, syntaxDollar[2].str)
		}
	case 98:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.stage = newLogfmtParserExpr(nil)
		}
	case 99:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newLogfmtParserExpr(syntaxDollar[2].strs)
		}
	case 100:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.stage = newLabelParserExpr(OpParserTypeJSON, "")
		}
	case 101:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newLabelParserExpr(OpParserTypeRegexp, syntaxDollar[2].str)
		}
	case 102:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.stage = newLabelParserExpr(OpParserTypeUnpack, "")
		}
	case 103:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newLabelParserExpr(OpParserTypePattern, syntaxDollar[2].str)
		}
	case 104:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newJSONExpressionParser(syntaxDollar[2].labelExtractionExpressionList)
		}
	case 105:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.stage = newLogfmtExpressionParser(syntaxDollar[3].labelExtractionExpressionList, syntaxDollar[2].strs)
		}
	case 106:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newLogfmtExpressionParser(syntaxDollar[2].labelExtractionExpressionList, nil)
		}
	case 107:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newLineFmtExpr(syntaxDollar[2].str)
		}
	case 108:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.stage = newDecolorizeExpr()
		}
	case 109:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.labelFormat = log.NewRenameLabelFmt(syntaxDollar[1].str, syntaxDollar[3].str)
		}
	case 110:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.labelFormat = log.NewTemplateLabelFmt(syntaxDollar[1].str, syntaxDollar[3].str)
		}
	case 111:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.labelsFormat = []log.LabelFmt{syntaxDollar[1].labelFormat}
		}
	case 112:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.labelsFormat = append(syntaxDollar[1].labelsFormat, syntaxDollar[3].labelFormat)
		}
	case 114:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newLabelFmtExpr(syntaxDollar[2].labelsFormat)
		}
	case 115:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewStringLabelFilter(syntaxDollar[1].matcher)
		}
	case 116:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filterer = syntaxDollar[1].filterer
		}
	case 117:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filterer = syntaxDollar[1].filterer
		}
	case 118:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filterer = syntaxDollar[1].filterer
		}
	case 119:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = syntaxDollar[2].filterer
		}
	case 120:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewAndLabelFilter(syntaxDollar[1].filterer, syntaxDollar[2].filterer)
		}
	case 121:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewAndLabelFilter(syntaxDollar[1].filterer, syntaxDollar[3].filterer)
		}
	case 122:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewAndLabelFilter(syntaxDollar[1].filterer, syntaxDollar[3].filterer)
		}
	case 123:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewOrLabelFilter(syntaxDollar[1].filterer, syntaxDollar[3].filterer)
		}
	case 124:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.labelExtractionExpression = log.NewLabelExtractionExpr(syntaxDollar[1].str, syntaxDollar[3].str)
		}
	case 125:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.labelExtractionExpression = log.NewLabelExtractionExpr(syntaxDollar[1].str, syntaxDollar[1].str)
		}
	case 126:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.labelExtractionExpressionList = []log.LabelExtractionExpr{syntaxDollar[1].labelExtractionExpression}
		}
	case 127:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.labelExtractionExpressionList = append(syntaxDollar[1].labelExtractionExpressionList, syntaxDollar[3].labelExtractionExpression)
		}
	case 128:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewIPLabelFilter(syntaxDollar[5].str, syntaxDollar[1].str, log.LabelFilterEqual)
		}
	case 129:
		syntaxDollar = syntaxS[syntaxpt-6 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewIPLabelFilter(syntaxDollar[5].str, syntaxDollar[1].str, log.LabelFilterNotEqual)
		}
	case 130:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filterer = syntaxDollar[1].filterer
		}
	case 131:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.filterer = syntaxDollar[1].filterer
		}
	case 132:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewDurationLabelFilter(log.LabelFilterGreaterThan, syntaxDollar[1].str, syntaxDollar[3].dur)
		}
	case 133:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewDurationLabelFilter(log.LabelFilterGreaterThanOrEqual, syntaxDollar[1].str, syntaxDollar[3].dur)
		}
	case 134:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewDurationLabelFilter(log.LabelFilterLesserThan, syntaxDollar[1].str, syntaxDollar[3].dur)
		}
	case 135:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewDurationLabelFilter(log.LabelFilterLesserThanOrEqual, syntaxDollar[1].str, syntaxDollar[3].dur)
		}
	case 136:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewDurationLabelFilter(log.LabelFilterNotEqual, syntaxDollar[1].str, syntaxDollar[3].dur)
		}
	case 137:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewDurationLabelFilter(log.LabelFilterEqual, syntaxDollar[1].str, syntaxDollar[3].dur)
		}
	case 138:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewDurationLabelFilter(log.LabelFilterEqual, syntaxDollar[1].str, syntaxDollar[3].dur)
		}
	case 139:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewBytesLabelFilter(log.LabelFilterGreaterThan, syntaxDollar[1].str, syntaxDollar[3].bytes)
		}
	case 140:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewBytesLabelFilter(log.LabelFilterGreaterThanOrEqual, syntaxDollar[1].str, syntaxDollar[3].bytes)
		}
	case 141:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewBytesLabelFilter(log.LabelFilterLesserThan, syntaxDollar[1].str, syntaxDollar[3].bytes)
		}
	case 142:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewBytesLabelFilter(log.LabelFilterLesserThanOrEqual, syntaxDollar[1].str, syntaxDollar[3].bytes)
		}
	case 143:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewBytesLabelFilter(log.LabelFilterNotEqual, syntaxDollar[1].str, syntaxDollar[3].bytes)
		}
	case 144:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewBytesLabelFilter(log.LabelFilterEqual, syntaxDollar[1].str, syntaxDollar[3].bytes)
		}
	case 145:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewBytesLabelFilter(log.LabelFilterEqual, syntaxDollar[1].str, syntaxDollar[3].bytes)
		}
	case 146:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewNumericLabelFilter(log.LabelFilterGreaterThan, syntaxDollar[1].str, syntaxDollar[3].literalExpr.Val)
		}
	case 147:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewNumericLabelFilter(log.LabelFilterGreaterThanOrEqual, syntaxDollar[1].str, syntaxDollar[3].literalExpr.Val)
		}
	case 148:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewNumericLabelFilter(log.LabelFilterLesserThan, syntaxDollar[1].str, syntaxDollar[3].literalExpr.Val)
		}
	case 149:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewNumericLabelFilter(log.LabelFilterLesserThanOrEqual, syntaxDollar[1].str, syntaxDollar[3].literalExpr.Val)
		}
	case 150:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewNumericLabelFilter(log.LabelFilterNotEqual, syntaxDollar[1].str, syntaxDollar[3].literalExpr.Val)
		}
	case 151:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewNumericLabelFilter(log.LabelFilterEqual, syntaxDollar[1].str, syntaxDollar[3].literalExpr.Val)
		}
	case 152:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.filterer = log.NewNumericLabelFilter(log.LabelFilterEqual, syntaxDollar[1].str, syntaxDollar[3].literalExpr.Val)
		}
	case 153:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.namedMatcher = log.NewNamedLabelMatcher(nil, syntaxDollar[1].str)
		}
	case 154:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.namedMatcher = log.NewNamedLabelMatcher(syntaxDollar[1].matcher, "")
		}
	case 155:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.namedMatchers = []log.NamedLabelMatcher{syntaxDollar[1].namedMatcher}
		}
	case 156:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.namedMatchers = append(syntaxDollar[1].namedMatchers, syntaxDollar[3].namedMatcher)
		}
	case 157:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newDropLabelsExpr(syntaxDollar[2].namedMatchers)
		}
	case 158:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.stage = newKeepLabelsExpr(syntaxDollar[2].namedMatchers)
		}
	case 159:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("or", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 160:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("and", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 161:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("unless", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 162:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("+", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 163:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("-", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 164:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("*", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 165:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("/", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 166:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("%", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 167:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("^", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 168:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("==", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 169:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("!=", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 170:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr(">", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 171:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr(">=", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 172:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("<", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 173:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = mustNewBinOpExpr("<=", syntaxDollar[3].binOpts, syntaxDollar[1].expr, syntaxDollar[4].expr)
		}
	case 174:
		syntaxDollar = syntaxS[syntaxpt-0 : syntaxpt+1]
		{
			syntaxVAL.binOpts = &BinOpOptions{VectorMatching: &VectorMatching{Card: CardOneToOne}}
		}
	case 175:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.binOpts = &BinOpOptions{VectorMatching: &VectorMatching{Card: CardOneToOne}, ReturnBool: true}
		}
	case 176:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.On = true
			syntaxVAL.binOpts.VectorMatching.MatchingLabels = syntaxDollar[4].strs
		}
	case 177:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.On = true
		}
	case 178:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.MatchingLabels = syntaxDollar[4].strs
		}
	case 179:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
		}
	case 180:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
		}
	case 181:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
		}
	case 182:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.Card = CardManyToOne
		}
	case 183:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.Card = CardManyToOne
		}
	case 184:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.Card = CardManyToOne
			syntaxVAL.binOpts.VectorMatching.Include = syntaxDollar[4].strs
		}
	case 185:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.Card = CardOneToMany
		}
	case 186:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.Card = CardOneToMany
		}
	case 187:
		syntaxDollar = syntaxS[syntaxpt-5 : syntaxpt+1]
		{
			syntaxVAL.binOpts = syntaxDollar[1].binOpts
			syntaxVAL.binOpts.VectorMatching.Card = CardOneToMany
			syntaxVAL.binOpts.VectorMatching.Include = syntaxDollar[4].strs
		}
	case 188:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.literalExpr = mustNewLiteralExpr(syntaxDollar[1].str, false)
		}
	case 189:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.literalExpr = mustNewLiteralExpr(syntaxDollar[2].str, false)
		}
	case 190:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.literalExpr = mustNewLiteralExpr(syntaxDollar[2].str, true)
		}
	case 191:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.metricExpr = NewVectorExpr(syntaxDollar[3].str)
		}
	case 192:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.str = OpTypeVector
		}
	case 193:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeSum
		}
	case 194:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeAvg
		}
	case 195:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeCount
		}
	case 196:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeMax
		}
	case 197:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeMin
		}
	case 198:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeStddev
		}
	case 199:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeStdvar
		}
	case 200:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeBottomK
		}
	case 201:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeTopK
		}
	case 202:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeSort
		}
	case 203:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeSortDesc
		}
	case 204:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpTypeApproxTopK
		}
	case 205:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeCount
		}
	case 206:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeRate
		}
	case 207:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeRateCounter
		}
	case 208:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeBytes
		}
	case 209:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeBytesRate
		}
	case 210:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeAvg
		}
	case 211:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeSum
		}
	case 212:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeMin
		}
	case 213:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeMax
		}
	case 214:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeStdvar
		}
	case 215:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeStddev
		}
	case 216:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeQuantile
		}
	case 217:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeFirst
		}
	case 218:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeLast
		}
	case 219:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.op = OpRangeTypeAbsent
		}
	case 220:
		syntaxDollar = syntaxS[syntaxpt-2 : syntaxpt+1]
		{
			syntaxVAL.offsetExpr = newOffsetExpr(syntaxDollar[2].dur)
		}
	case 221:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.strs = []string{syntaxDollar[1].str}
		}
	case 222:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.strs = append(syntaxDollar[1].strs, syntaxDollar[3].str)
		}
	case 223:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.grouping = &Grouping{Without: false, Groups: syntaxDollar[3].strs}
		}
	case 224:
		syntaxDollar = syntaxS[syntaxpt-4 : syntaxpt+1]
		{
			syntaxVAL.grouping = &Grouping{Without: true, Groups: syntaxDollar[3].strs}
		}
	case 225:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.grouping = &Grouping{Without: false, Groups: nil}
		}
	case 226:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.grouping = &Grouping{Without: true, Groups: nil}
		}
	case 227:
		syntaxDollar = syntaxS[syntaxpt-1 : syntaxpt+1]
		{
			syntaxVAL.metricExprs = []SampleExpr{syntaxDollar[1].metricExpr}
		}
	case 228:
		syntaxDollar = syntaxS[syntaxpt-3 : syntaxpt+1]
		{
			syntaxVAL.metricExprs = append(syntaxDollar[1].metricExprs, syntaxDollar[3].metricExpr)
		}
	}
	goto syntaxstack /* stack new state and value */
}
