// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// LogsGroupByMissing - The value to use for logs that don't have the facet used to group by
type LogsGroupByMissing struct {
	LogsGroupByMissingString *string
	LogsGroupByMissingNumber *float64

	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject interface{}
}

// LogsGroupByMissingStringAsLogsGroupByMissing is a convenience function that returns string wrapped in LogsGroupByMissing.
func LogsGroupByMissingStringAsLogsGroupByMissing(v *string) LogsGroupByMissing {
	return LogsGroupByMissing{LogsGroupByMissingString: v}
}

// LogsGroupByMissingNumberAsLogsGroupByMissing is a convenience function that returns float64 wrapped in LogsGroupByMissing.
func LogsGroupByMissingNumberAsLogsGroupByMissing(v *float64) LogsGroupByMissing {
	return LogsGroupByMissing{LogsGroupByMissingNumber: v}
}

// UnmarshalJSON turns data into one of the pointers in the struct.
func (obj *LogsGroupByMissing) UnmarshalJSON(data []byte) error {
	var err error
	match := 0
	// try to unmarshal data into LogsGroupByMissingString
	err = datadog.Unmarshal(data, &obj.LogsGroupByMissingString)
	if err == nil {
		if obj.LogsGroupByMissingString != nil {
			jsonLogsGroupByMissingString, _ := datadog.Marshal(obj.LogsGroupByMissingString)
			if string(jsonLogsGroupByMissingString) == "{}" { // empty struct
				obj.LogsGroupByMissingString = nil
			} else {
				match++
			}
		} else {
			obj.LogsGroupByMissingString = nil
		}
	} else {
		obj.LogsGroupByMissingString = nil
	}

	// try to unmarshal data into LogsGroupByMissingNumber
	err = datadog.Unmarshal(data, &obj.LogsGroupByMissingNumber)
	if err == nil {
		if obj.LogsGroupByMissingNumber != nil {
			jsonLogsGroupByMissingNumber, _ := datadog.Marshal(obj.LogsGroupByMissingNumber)
			if string(jsonLogsGroupByMissingNumber) == "{}" { // empty struct
				obj.LogsGroupByMissingNumber = nil
			} else {
				match++
			}
		} else {
			obj.LogsGroupByMissingNumber = nil
		}
	} else {
		obj.LogsGroupByMissingNumber = nil
	}

	if match != 1 { // more than 1 match
		// reset to nil
		obj.LogsGroupByMissingString = nil
		obj.LogsGroupByMissingNumber = nil
		return datadog.Unmarshal(data, &obj.UnparsedObject)
	}
	return nil // exactly one match
}

// MarshalJSON turns data from the first non-nil pointers in the struct to JSON.
func (obj LogsGroupByMissing) MarshalJSON() ([]byte, error) {
	if obj.LogsGroupByMissingString != nil {
		return datadog.Marshal(&obj.LogsGroupByMissingString)
	}

	if obj.LogsGroupByMissingNumber != nil {
		return datadog.Marshal(&obj.LogsGroupByMissingNumber)
	}

	if obj.UnparsedObject != nil {
		return datadog.Marshal(obj.UnparsedObject)
	}
	return nil, nil // no data in oneOf schemas
}

// GetActualInstance returns the actual instance.
func (obj *LogsGroupByMissing) GetActualInstance() interface{} {
	if obj.LogsGroupByMissingString != nil {
		return obj.LogsGroupByMissingString
	}

	if obj.LogsGroupByMissingNumber != nil {
		return obj.LogsGroupByMissingNumber
	}

	// all schemas are nil
	return nil
}
