//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	moduleVersion = "v0.11.0"
)

// AccessMode - Access mode types.
type AccessMode string

const (
	AccessModeOpen        AccessMode = "Open"
	AccessModePrivateOnly AccessMode = "PrivateOnly"
)

// PossibleAccessModeValues returns the possible values for the AccessMode const type.
func PossibleAccessModeValues() []AccessMode {
	return []AccessMode{
		AccessModeOpen,
		AccessModePrivateOnly,
	}
}

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AggregationType - the aggregation type of the metric.
type AggregationType string

const (
	AggregationTypeAverage AggregationType = "Average"
	AggregationTypeCount   AggregationType = "Count"
	AggregationTypeMaximum AggregationType = "Maximum"
	AggregationTypeMinimum AggregationType = "Minimum"
	AggregationTypeNone    AggregationType = "None"
	AggregationTypeTotal   AggregationType = "Total"
)

// PossibleAggregationTypeValues returns the possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{
		AggregationTypeAverage,
		AggregationTypeCount,
		AggregationTypeMaximum,
		AggregationTypeMinimum,
		AggregationTypeNone,
		AggregationTypeTotal,
	}
}

// AggregationTypeEnum - the criteria time aggregation types.
type AggregationTypeEnum string

const (
	AggregationTypeEnumAverage AggregationTypeEnum = "Average"
	AggregationTypeEnumCount   AggregationTypeEnum = "Count"
	AggregationTypeEnumMaximum AggregationTypeEnum = "Maximum"
	AggregationTypeEnumMinimum AggregationTypeEnum = "Minimum"
	AggregationTypeEnumTotal   AggregationTypeEnum = "Total"
)

// PossibleAggregationTypeEnumValues returns the possible values for the AggregationTypeEnum const type.
func PossibleAggregationTypeEnumValues() []AggregationTypeEnum {
	return []AggregationTypeEnum{
		AggregationTypeEnumAverage,
		AggregationTypeEnumCount,
		AggregationTypeEnumMaximum,
		AggregationTypeEnumMinimum,
		AggregationTypeEnumTotal,
	}
}

// AlertSeverity - Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required
// only for rules of the kind LogAlert.
type AlertSeverity int64

const (
	AlertSeverityFour  AlertSeverity = 4
	AlertSeverityOne   AlertSeverity = 1
	AlertSeverityThree AlertSeverity = 3
	AlertSeverityTwo   AlertSeverity = 2
	AlertSeverityZero  AlertSeverity = 0
)

// PossibleAlertSeverityValues returns the possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{
		AlertSeverityFour,
		AlertSeverityOne,
		AlertSeverityThree,
		AlertSeverityTwo,
		AlertSeverityZero,
	}
}

// BaselineSensitivity - the sensitivity of the baseline.
type BaselineSensitivity string

const (
	BaselineSensitivityHigh   BaselineSensitivity = "High"
	BaselineSensitivityLow    BaselineSensitivity = "Low"
	BaselineSensitivityMedium BaselineSensitivity = "Medium"
)

// PossibleBaselineSensitivityValues returns the possible values for the BaselineSensitivity const type.
func PossibleBaselineSensitivityValues() []BaselineSensitivity {
	return []BaselineSensitivity{
		BaselineSensitivityHigh,
		BaselineSensitivityLow,
		BaselineSensitivityMedium,
	}
}

// CategoryType - The type of the diagnostic settings category.
type CategoryType string

const (
	CategoryTypeLogs    CategoryType = "Logs"
	CategoryTypeMetrics CategoryType = "Metrics"
)

// PossibleCategoryTypeValues returns the possible values for the CategoryType const type.
func PossibleCategoryTypeValues() []CategoryType {
	return []CategoryType{
		CategoryTypeLogs,
		CategoryTypeMetrics,
	}
}

// ComparisonOperationType - the operator that is used to compare the metric data and the threshold.
type ComparisonOperationType string

const (
	ComparisonOperationTypeEquals             ComparisonOperationType = "Equals"
	ComparisonOperationTypeGreaterThan        ComparisonOperationType = "GreaterThan"
	ComparisonOperationTypeGreaterThanOrEqual ComparisonOperationType = "GreaterThanOrEqual"
	ComparisonOperationTypeLessThan           ComparisonOperationType = "LessThan"
	ComparisonOperationTypeLessThanOrEqual    ComparisonOperationType = "LessThanOrEqual"
	ComparisonOperationTypeNotEquals          ComparisonOperationType = "NotEquals"
)

// PossibleComparisonOperationTypeValues returns the possible values for the ComparisonOperationType const type.
func PossibleComparisonOperationTypeValues() []ComparisonOperationType {
	return []ComparisonOperationType{
		ComparisonOperationTypeEquals,
		ComparisonOperationTypeGreaterThan,
		ComparisonOperationTypeGreaterThanOrEqual,
		ComparisonOperationTypeLessThan,
		ComparisonOperationTypeLessThanOrEqual,
		ComparisonOperationTypeNotEquals,
	}
}

// ConditionOperator - Operators allowed in the rule condition.
type ConditionOperator string

const (
	ConditionOperatorEquals             ConditionOperator = "Equals"
	ConditionOperatorGreaterThan        ConditionOperator = "GreaterThan"
	ConditionOperatorGreaterThanOrEqual ConditionOperator = "GreaterThanOrEqual"
	ConditionOperatorLessThan           ConditionOperator = "LessThan"
	ConditionOperatorLessThanOrEqual    ConditionOperator = "LessThanOrEqual"
)

// PossibleConditionOperatorValues returns the possible values for the ConditionOperator const type.
func PossibleConditionOperatorValues() []ConditionOperator {
	return []ConditionOperator{
		ConditionOperatorEquals,
		ConditionOperatorGreaterThan,
		ConditionOperatorGreaterThanOrEqual,
		ConditionOperatorLessThan,
		ConditionOperatorLessThanOrEqual,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// CriterionType - Specifies the type of threshold criteria
type CriterionType string

const (
	CriterionTypeDynamicThresholdCriterion CriterionType = "DynamicThresholdCriterion"
	CriterionTypeStaticThresholdCriterion  CriterionType = "StaticThresholdCriterion"
)

// PossibleCriterionTypeValues returns the possible values for the CriterionType const type.
func PossibleCriterionTypeValues() []CriterionType {
	return []CriterionType{
		CriterionTypeDynamicThresholdCriterion,
		CriterionTypeStaticThresholdCriterion,
	}
}

// DataStatus - The status of VM Insights data from the resource. When reported as present the data array will contain information
// about the data containers to which data for the specified resource is being routed.
type DataStatus string

const (
	DataStatusNotPresent DataStatus = "notPresent"
	DataStatusPresent    DataStatus = "present"
)

// PossibleDataStatusValues returns the possible values for the DataStatus const type.
func PossibleDataStatusValues() []DataStatus {
	return []DataStatus{
		DataStatusNotPresent,
		DataStatusPresent,
	}
}

// DimensionOperator - Operator for dimension values
type DimensionOperator string

const (
	DimensionOperatorExclude DimensionOperator = "Exclude"
	DimensionOperatorInclude DimensionOperator = "Include"
)

// PossibleDimensionOperatorValues returns the possible values for the DimensionOperator const type.
func PossibleDimensionOperatorValues() []DimensionOperator {
	return []DimensionOperator{
		DimensionOperatorExclude,
		DimensionOperatorInclude,
	}
}

// DynamicThresholdOperator - The operator used to compare the metric value against the threshold.
type DynamicThresholdOperator string

const (
	DynamicThresholdOperatorGreaterOrLessThan DynamicThresholdOperator = "GreaterOrLessThan"
	DynamicThresholdOperatorGreaterThan       DynamicThresholdOperator = "GreaterThan"
	DynamicThresholdOperatorLessThan          DynamicThresholdOperator = "LessThan"
)

// PossibleDynamicThresholdOperatorValues returns the possible values for the DynamicThresholdOperator const type.
func PossibleDynamicThresholdOperatorValues() []DynamicThresholdOperator {
	return []DynamicThresholdOperator{
		DynamicThresholdOperatorGreaterOrLessThan,
		DynamicThresholdOperatorGreaterThan,
		DynamicThresholdOperatorLessThan,
	}
}

// DynamicThresholdSensitivity - The extent of deviation required to trigger an alert. This will affect how tight the threshold
// is to the metric series pattern.
type DynamicThresholdSensitivity string

const (
	DynamicThresholdSensitivityHigh   DynamicThresholdSensitivity = "High"
	DynamicThresholdSensitivityLow    DynamicThresholdSensitivity = "Low"
	DynamicThresholdSensitivityMedium DynamicThresholdSensitivity = "Medium"
)

// PossibleDynamicThresholdSensitivityValues returns the possible values for the DynamicThresholdSensitivity const type.
func PossibleDynamicThresholdSensitivityValues() []DynamicThresholdSensitivity {
	return []DynamicThresholdSensitivity{
		DynamicThresholdSensitivityHigh,
		DynamicThresholdSensitivityLow,
		DynamicThresholdSensitivityMedium,
	}
}

// EventLevel - the event level
type EventLevel string

const (
	EventLevelCritical      EventLevel = "Critical"
	EventLevelError         EventLevel = "Error"
	EventLevelInformational EventLevel = "Informational"
	EventLevelVerbose       EventLevel = "Verbose"
	EventLevelWarning       EventLevel = "Warning"
)

// PossibleEventLevelValues returns the possible values for the EventLevel const type.
func PossibleEventLevelValues() []EventLevel {
	return []EventLevel{
		EventLevelCritical,
		EventLevelError,
		EventLevelInformational,
		EventLevelVerbose,
		EventLevelWarning,
	}
}

// IdentityType - Type of managed service identity.
type IdentityType string

const (
	IdentityTypeNone           IdentityType = "None"
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
	IdentityTypeUserAssigned   IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns the possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{
		IdentityTypeNone,
		IdentityTypeSystemAssigned,
		IdentityTypeUserAssigned,
	}
}

// Kind - Indicates the type of scheduled query rule. The default is LogAlert.
type Kind string

const (
	KindLogAlert    Kind = "LogAlert"
	KindLogToMetric Kind = "LogToMetric"
)

// PossibleKindValues returns the possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{
		KindLogAlert,
		KindLogToMetric,
	}
}

// KnownColumnDefinitionType - The type of the column data.
type KnownColumnDefinitionType string

const (
	KnownColumnDefinitionTypeBoolean  KnownColumnDefinitionType = "boolean"
	KnownColumnDefinitionTypeDatetime KnownColumnDefinitionType = "datetime"
	KnownColumnDefinitionTypeDynamic  KnownColumnDefinitionType = "dynamic"
	KnownColumnDefinitionTypeInt      KnownColumnDefinitionType = "int"
	KnownColumnDefinitionTypeLong     KnownColumnDefinitionType = "long"
	KnownColumnDefinitionTypeReal     KnownColumnDefinitionType = "real"
	KnownColumnDefinitionTypeString   KnownColumnDefinitionType = "string"
)

// PossibleKnownColumnDefinitionTypeValues returns the possible values for the KnownColumnDefinitionType const type.
func PossibleKnownColumnDefinitionTypeValues() []KnownColumnDefinitionType {
	return []KnownColumnDefinitionType{
		KnownColumnDefinitionTypeBoolean,
		KnownColumnDefinitionTypeDatetime,
		KnownColumnDefinitionTypeDynamic,
		KnownColumnDefinitionTypeInt,
		KnownColumnDefinitionTypeLong,
		KnownColumnDefinitionTypeReal,
		KnownColumnDefinitionTypeString,
	}
}

// KnownDataCollectionEndpointProvisioningState - The resource provisioning state. This property is READ-ONLY.
type KnownDataCollectionEndpointProvisioningState string

const (
	KnownDataCollectionEndpointProvisioningStateCanceled  KnownDataCollectionEndpointProvisioningState = "Canceled"
	KnownDataCollectionEndpointProvisioningStateCreating  KnownDataCollectionEndpointProvisioningState = "Creating"
	KnownDataCollectionEndpointProvisioningStateDeleting  KnownDataCollectionEndpointProvisioningState = "Deleting"
	KnownDataCollectionEndpointProvisioningStateFailed    KnownDataCollectionEndpointProvisioningState = "Failed"
	KnownDataCollectionEndpointProvisioningStateSucceeded KnownDataCollectionEndpointProvisioningState = "Succeeded"
	KnownDataCollectionEndpointProvisioningStateUpdating  KnownDataCollectionEndpointProvisioningState = "Updating"
)

// PossibleKnownDataCollectionEndpointProvisioningStateValues returns the possible values for the KnownDataCollectionEndpointProvisioningState const type.
func PossibleKnownDataCollectionEndpointProvisioningStateValues() []KnownDataCollectionEndpointProvisioningState {
	return []KnownDataCollectionEndpointProvisioningState{
		KnownDataCollectionEndpointProvisioningStateCanceled,
		KnownDataCollectionEndpointProvisioningStateCreating,
		KnownDataCollectionEndpointProvisioningStateDeleting,
		KnownDataCollectionEndpointProvisioningStateFailed,
		KnownDataCollectionEndpointProvisioningStateSucceeded,
		KnownDataCollectionEndpointProvisioningStateUpdating,
	}
}

// KnownDataCollectionEndpointResourceKind - The kind of the resource.
type KnownDataCollectionEndpointResourceKind string

const (
	KnownDataCollectionEndpointResourceKindLinux   KnownDataCollectionEndpointResourceKind = "Linux"
	KnownDataCollectionEndpointResourceKindWindows KnownDataCollectionEndpointResourceKind = "Windows"
)

// PossibleKnownDataCollectionEndpointResourceKindValues returns the possible values for the KnownDataCollectionEndpointResourceKind const type.
func PossibleKnownDataCollectionEndpointResourceKindValues() []KnownDataCollectionEndpointResourceKind {
	return []KnownDataCollectionEndpointResourceKind{
		KnownDataCollectionEndpointResourceKindLinux,
		KnownDataCollectionEndpointResourceKindWindows,
	}
}

// KnownDataCollectionRuleAssociationProvisioningState - The resource provisioning state.
type KnownDataCollectionRuleAssociationProvisioningState string

const (
	KnownDataCollectionRuleAssociationProvisioningStateCanceled  KnownDataCollectionRuleAssociationProvisioningState = "Canceled"
	KnownDataCollectionRuleAssociationProvisioningStateCreating  KnownDataCollectionRuleAssociationProvisioningState = "Creating"
	KnownDataCollectionRuleAssociationProvisioningStateDeleting  KnownDataCollectionRuleAssociationProvisioningState = "Deleting"
	KnownDataCollectionRuleAssociationProvisioningStateFailed    KnownDataCollectionRuleAssociationProvisioningState = "Failed"
	KnownDataCollectionRuleAssociationProvisioningStateSucceeded KnownDataCollectionRuleAssociationProvisioningState = "Succeeded"
	KnownDataCollectionRuleAssociationProvisioningStateUpdating  KnownDataCollectionRuleAssociationProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleAssociationProvisioningStateValues returns the possible values for the KnownDataCollectionRuleAssociationProvisioningState const type.
func PossibleKnownDataCollectionRuleAssociationProvisioningStateValues() []KnownDataCollectionRuleAssociationProvisioningState {
	return []KnownDataCollectionRuleAssociationProvisioningState{
		KnownDataCollectionRuleAssociationProvisioningStateCanceled,
		KnownDataCollectionRuleAssociationProvisioningStateCreating,
		KnownDataCollectionRuleAssociationProvisioningStateDeleting,
		KnownDataCollectionRuleAssociationProvisioningStateFailed,
		KnownDataCollectionRuleAssociationProvisioningStateSucceeded,
		KnownDataCollectionRuleAssociationProvisioningStateUpdating,
	}
}

// KnownDataCollectionRuleProvisioningState - The resource provisioning state.
type KnownDataCollectionRuleProvisioningState string

const (
	KnownDataCollectionRuleProvisioningStateCanceled  KnownDataCollectionRuleProvisioningState = "Canceled"
	KnownDataCollectionRuleProvisioningStateCreating  KnownDataCollectionRuleProvisioningState = "Creating"
	KnownDataCollectionRuleProvisioningStateDeleting  KnownDataCollectionRuleProvisioningState = "Deleting"
	KnownDataCollectionRuleProvisioningStateFailed    KnownDataCollectionRuleProvisioningState = "Failed"
	KnownDataCollectionRuleProvisioningStateSucceeded KnownDataCollectionRuleProvisioningState = "Succeeded"
	KnownDataCollectionRuleProvisioningStateUpdating  KnownDataCollectionRuleProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleProvisioningStateValues returns the possible values for the KnownDataCollectionRuleProvisioningState const type.
func PossibleKnownDataCollectionRuleProvisioningStateValues() []KnownDataCollectionRuleProvisioningState {
	return []KnownDataCollectionRuleProvisioningState{
		KnownDataCollectionRuleProvisioningStateCanceled,
		KnownDataCollectionRuleProvisioningStateCreating,
		KnownDataCollectionRuleProvisioningStateDeleting,
		KnownDataCollectionRuleProvisioningStateFailed,
		KnownDataCollectionRuleProvisioningStateSucceeded,
		KnownDataCollectionRuleProvisioningStateUpdating,
	}
}

// KnownDataCollectionRuleResourceKind - The kind of the resource.
type KnownDataCollectionRuleResourceKind string

const (
	KnownDataCollectionRuleResourceKindLinux   KnownDataCollectionRuleResourceKind = "Linux"
	KnownDataCollectionRuleResourceKindWindows KnownDataCollectionRuleResourceKind = "Windows"
)

// PossibleKnownDataCollectionRuleResourceKindValues returns the possible values for the KnownDataCollectionRuleResourceKind const type.
func PossibleKnownDataCollectionRuleResourceKindValues() []KnownDataCollectionRuleResourceKind {
	return []KnownDataCollectionRuleResourceKind{
		KnownDataCollectionRuleResourceKindLinux,
		KnownDataCollectionRuleResourceKindWindows,
	}
}

type KnownDataFlowStreams string

const (
	KnownDataFlowStreamsMicrosoftEvent           KnownDataFlowStreams = "Microsoft-Event"
	KnownDataFlowStreamsMicrosoftInsightsMetrics KnownDataFlowStreams = "Microsoft-InsightsMetrics"
	KnownDataFlowStreamsMicrosoftPerf            KnownDataFlowStreams = "Microsoft-Perf"
	KnownDataFlowStreamsMicrosoftSyslog          KnownDataFlowStreams = "Microsoft-Syslog"
	KnownDataFlowStreamsMicrosoftWindowsEvent    KnownDataFlowStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownDataFlowStreamsValues returns the possible values for the KnownDataFlowStreams const type.
func PossibleKnownDataFlowStreamsValues() []KnownDataFlowStreams {
	return []KnownDataFlowStreams{
		KnownDataFlowStreamsMicrosoftEvent,
		KnownDataFlowStreamsMicrosoftInsightsMetrics,
		KnownDataFlowStreamsMicrosoftPerf,
		KnownDataFlowStreamsMicrosoftSyslog,
		KnownDataFlowStreamsMicrosoftWindowsEvent,
	}
}

type KnownExtensionDataSourceStreams string

const (
	KnownExtensionDataSourceStreamsMicrosoftEvent           KnownExtensionDataSourceStreams = "Microsoft-Event"
	KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics KnownExtensionDataSourceStreams = "Microsoft-InsightsMetrics"
	KnownExtensionDataSourceStreamsMicrosoftPerf            KnownExtensionDataSourceStreams = "Microsoft-Perf"
	KnownExtensionDataSourceStreamsMicrosoftSyslog          KnownExtensionDataSourceStreams = "Microsoft-Syslog"
	KnownExtensionDataSourceStreamsMicrosoftWindowsEvent    KnownExtensionDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownExtensionDataSourceStreamsValues returns the possible values for the KnownExtensionDataSourceStreams const type.
func PossibleKnownExtensionDataSourceStreamsValues() []KnownExtensionDataSourceStreams {
	return []KnownExtensionDataSourceStreams{
		KnownExtensionDataSourceStreamsMicrosoftEvent,
		KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics,
		KnownExtensionDataSourceStreamsMicrosoftPerf,
		KnownExtensionDataSourceStreamsMicrosoftSyslog,
		KnownExtensionDataSourceStreamsMicrosoftWindowsEvent,
	}
}

// KnownLocationSpecProvisioningStatus - The resource provisioning state in this location.
type KnownLocationSpecProvisioningStatus string

const (
	KnownLocationSpecProvisioningStatusCanceled  KnownLocationSpecProvisioningStatus = "Canceled"
	KnownLocationSpecProvisioningStatusCreating  KnownLocationSpecProvisioningStatus = "Creating"
	KnownLocationSpecProvisioningStatusDeleting  KnownLocationSpecProvisioningStatus = "Deleting"
	KnownLocationSpecProvisioningStatusFailed    KnownLocationSpecProvisioningStatus = "Failed"
	KnownLocationSpecProvisioningStatusSucceeded KnownLocationSpecProvisioningStatus = "Succeeded"
	KnownLocationSpecProvisioningStatusUpdating  KnownLocationSpecProvisioningStatus = "Updating"
)

// PossibleKnownLocationSpecProvisioningStatusValues returns the possible values for the KnownLocationSpecProvisioningStatus const type.
func PossibleKnownLocationSpecProvisioningStatusValues() []KnownLocationSpecProvisioningStatus {
	return []KnownLocationSpecProvisioningStatus{
		KnownLocationSpecProvisioningStatusCanceled,
		KnownLocationSpecProvisioningStatusCreating,
		KnownLocationSpecProvisioningStatusDeleting,
		KnownLocationSpecProvisioningStatusFailed,
		KnownLocationSpecProvisioningStatusSucceeded,
		KnownLocationSpecProvisioningStatusUpdating,
	}
}

// KnownLogFileTextSettingsRecordStartTimestampFormat - One of the supported timestamp formats
type KnownLogFileTextSettingsRecordStartTimestampFormat string

const (
	KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMYyyyHHMmSsZzz KnownLogFileTextSettingsRecordStartTimestampFormat = "dd/MMM/yyyy:HH:mm:ss zzz"
	KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHMmSs       KnownLogFileTextSettingsRecordStartTimestampFormat = "ddMMyy HH:mm:ss"
	KnownLogFileTextSettingsRecordStartTimestampFormatISO8601            KnownLogFileTextSettingsRecordStartTimestampFormat = "ISO 8601"
	KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM   KnownLogFileTextSettingsRecordStartTimestampFormat = "M/D/YYYY HH:MM:SS AM/PM"
	KnownLogFileTextSettingsRecordStartTimestampFormatMMMDHhMmSs         KnownLogFileTextSettingsRecordStartTimestampFormat = "MMM d hh:mm:ss"
	KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS    KnownLogFileTextSettingsRecordStartTimestampFormat = "Mon DD, YYYY HH:MM:SS"
	KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS     KnownLogFileTextSettingsRecordStartTimestampFormat = "YYYY-MM-DD HH:MM:SS"
	KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHMmSs       KnownLogFileTextSettingsRecordStartTimestampFormat = "yyMMdd HH:mm:ss"
	KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHMmSsK   KnownLogFileTextSettingsRecordStartTimestampFormat = "yyyy-MM-ddTHH:mm:ssK"
)

// PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues returns the possible values for the KnownLogFileTextSettingsRecordStartTimestampFormat const type.
func PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues() []KnownLogFileTextSettingsRecordStartTimestampFormat {
	return []KnownLogFileTextSettingsRecordStartTimestampFormat{
		KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMYyyyHHMmSsZzz,
		KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHMmSs,
		KnownLogFileTextSettingsRecordStartTimestampFormatISO8601,
		KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM,
		KnownLogFileTextSettingsRecordStartTimestampFormatMMMDHhMmSs,
		KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS,
		KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS,
		KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHMmSs,
		KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHMmSsK,
	}
}

// KnownLogFilesDataSourceFormat - The data format of the log files
type KnownLogFilesDataSourceFormat string

const (
	KnownLogFilesDataSourceFormatText KnownLogFilesDataSourceFormat = "text"
)

// PossibleKnownLogFilesDataSourceFormatValues returns the possible values for the KnownLogFilesDataSourceFormat const type.
func PossibleKnownLogFilesDataSourceFormatValues() []KnownLogFilesDataSourceFormat {
	return []KnownLogFilesDataSourceFormat{
		KnownLogFilesDataSourceFormatText,
	}
}

type KnownPerfCounterDataSourceStreams string

const (
	KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics KnownPerfCounterDataSourceStreams = "Microsoft-InsightsMetrics"
	KnownPerfCounterDataSourceStreamsMicrosoftPerf            KnownPerfCounterDataSourceStreams = "Microsoft-Perf"
)

// PossibleKnownPerfCounterDataSourceStreamsValues returns the possible values for the KnownPerfCounterDataSourceStreams const type.
func PossibleKnownPerfCounterDataSourceStreamsValues() []KnownPerfCounterDataSourceStreams {
	return []KnownPerfCounterDataSourceStreams{
		KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics,
		KnownPerfCounterDataSourceStreamsMicrosoftPerf,
	}
}

type KnownPrometheusForwarderDataSourceStreams string

const (
	KnownPrometheusForwarderDataSourceStreamsMicrosoftPrometheusMetrics KnownPrometheusForwarderDataSourceStreams = "Microsoft-PrometheusMetrics"
)

// PossibleKnownPrometheusForwarderDataSourceStreamsValues returns the possible values for the KnownPrometheusForwarderDataSourceStreams const type.
func PossibleKnownPrometheusForwarderDataSourceStreamsValues() []KnownPrometheusForwarderDataSourceStreams {
	return []KnownPrometheusForwarderDataSourceStreams{
		KnownPrometheusForwarderDataSourceStreamsMicrosoftPrometheusMetrics,
	}
}

// KnownPublicNetworkAccessOptions - The configuration to set whether network access from public internet to the endpoints
// are allowed.
type KnownPublicNetworkAccessOptions string

const (
	KnownPublicNetworkAccessOptionsDisabled           KnownPublicNetworkAccessOptions = "Disabled"
	KnownPublicNetworkAccessOptionsEnabled            KnownPublicNetworkAccessOptions = "Enabled"
	KnownPublicNetworkAccessOptionsSecuredByPerimeter KnownPublicNetworkAccessOptions = "SecuredByPerimeter"
)

// PossibleKnownPublicNetworkAccessOptionsValues returns the possible values for the KnownPublicNetworkAccessOptions const type.
func PossibleKnownPublicNetworkAccessOptionsValues() []KnownPublicNetworkAccessOptions {
	return []KnownPublicNetworkAccessOptions{
		KnownPublicNetworkAccessOptionsDisabled,
		KnownPublicNetworkAccessOptionsEnabled,
		KnownPublicNetworkAccessOptionsSecuredByPerimeter,
	}
}

type KnownSyslogDataSourceFacilityNames string

const (
	KnownSyslogDataSourceFacilityNamesAsterisk KnownSyslogDataSourceFacilityNames = "*"
	KnownSyslogDataSourceFacilityNamesAuth     KnownSyslogDataSourceFacilityNames = "auth"
	KnownSyslogDataSourceFacilityNamesAuthpriv KnownSyslogDataSourceFacilityNames = "authpriv"
	KnownSyslogDataSourceFacilityNamesCron     KnownSyslogDataSourceFacilityNames = "cron"
	KnownSyslogDataSourceFacilityNamesDaemon   KnownSyslogDataSourceFacilityNames = "daemon"
	KnownSyslogDataSourceFacilityNamesKern     KnownSyslogDataSourceFacilityNames = "kern"
	KnownSyslogDataSourceFacilityNamesLocal0   KnownSyslogDataSourceFacilityNames = "local0"
	KnownSyslogDataSourceFacilityNamesLocal1   KnownSyslogDataSourceFacilityNames = "local1"
	KnownSyslogDataSourceFacilityNamesLocal2   KnownSyslogDataSourceFacilityNames = "local2"
	KnownSyslogDataSourceFacilityNamesLocal3   KnownSyslogDataSourceFacilityNames = "local3"
	KnownSyslogDataSourceFacilityNamesLocal4   KnownSyslogDataSourceFacilityNames = "local4"
	KnownSyslogDataSourceFacilityNamesLocal5   KnownSyslogDataSourceFacilityNames = "local5"
	KnownSyslogDataSourceFacilityNamesLocal6   KnownSyslogDataSourceFacilityNames = "local6"
	KnownSyslogDataSourceFacilityNamesLocal7   KnownSyslogDataSourceFacilityNames = "local7"
	KnownSyslogDataSourceFacilityNamesLpr      KnownSyslogDataSourceFacilityNames = "lpr"
	KnownSyslogDataSourceFacilityNamesMail     KnownSyslogDataSourceFacilityNames = "mail"
	KnownSyslogDataSourceFacilityNamesMark     KnownSyslogDataSourceFacilityNames = "mark"
	KnownSyslogDataSourceFacilityNamesNews     KnownSyslogDataSourceFacilityNames = "news"
	KnownSyslogDataSourceFacilityNamesSyslog   KnownSyslogDataSourceFacilityNames = "syslog"
	KnownSyslogDataSourceFacilityNamesUser     KnownSyslogDataSourceFacilityNames = "user"
	KnownSyslogDataSourceFacilityNamesUucp     KnownSyslogDataSourceFacilityNames = "uucp"
)

// PossibleKnownSyslogDataSourceFacilityNamesValues returns the possible values for the KnownSyslogDataSourceFacilityNames const type.
func PossibleKnownSyslogDataSourceFacilityNamesValues() []KnownSyslogDataSourceFacilityNames {
	return []KnownSyslogDataSourceFacilityNames{
		KnownSyslogDataSourceFacilityNamesAsterisk,
		KnownSyslogDataSourceFacilityNamesAuth,
		KnownSyslogDataSourceFacilityNamesAuthpriv,
		KnownSyslogDataSourceFacilityNamesCron,
		KnownSyslogDataSourceFacilityNamesDaemon,
		KnownSyslogDataSourceFacilityNamesKern,
		KnownSyslogDataSourceFacilityNamesLocal0,
		KnownSyslogDataSourceFacilityNamesLocal1,
		KnownSyslogDataSourceFacilityNamesLocal2,
		KnownSyslogDataSourceFacilityNamesLocal3,
		KnownSyslogDataSourceFacilityNamesLocal4,
		KnownSyslogDataSourceFacilityNamesLocal5,
		KnownSyslogDataSourceFacilityNamesLocal6,
		KnownSyslogDataSourceFacilityNamesLocal7,
		KnownSyslogDataSourceFacilityNamesLpr,
		KnownSyslogDataSourceFacilityNamesMail,
		KnownSyslogDataSourceFacilityNamesMark,
		KnownSyslogDataSourceFacilityNamesNews,
		KnownSyslogDataSourceFacilityNamesSyslog,
		KnownSyslogDataSourceFacilityNamesUser,
		KnownSyslogDataSourceFacilityNamesUucp,
	}
}

type KnownSyslogDataSourceLogLevels string

const (
	KnownSyslogDataSourceLogLevelsAlert     KnownSyslogDataSourceLogLevels = "Alert"
	KnownSyslogDataSourceLogLevelsAsterisk  KnownSyslogDataSourceLogLevels = "*"
	KnownSyslogDataSourceLogLevelsCritical  KnownSyslogDataSourceLogLevels = "Critical"
	KnownSyslogDataSourceLogLevelsDebug     KnownSyslogDataSourceLogLevels = "Debug"
	KnownSyslogDataSourceLogLevelsEmergency KnownSyslogDataSourceLogLevels = "Emergency"
	KnownSyslogDataSourceLogLevelsError     KnownSyslogDataSourceLogLevels = "Error"
	KnownSyslogDataSourceLogLevelsInfo      KnownSyslogDataSourceLogLevels = "Info"
	KnownSyslogDataSourceLogLevelsNotice    KnownSyslogDataSourceLogLevels = "Notice"
	KnownSyslogDataSourceLogLevelsWarning   KnownSyslogDataSourceLogLevels = "Warning"
)

// PossibleKnownSyslogDataSourceLogLevelsValues returns the possible values for the KnownSyslogDataSourceLogLevels const type.
func PossibleKnownSyslogDataSourceLogLevelsValues() []KnownSyslogDataSourceLogLevels {
	return []KnownSyslogDataSourceLogLevels{
		KnownSyslogDataSourceLogLevelsAlert,
		KnownSyslogDataSourceLogLevelsAsterisk,
		KnownSyslogDataSourceLogLevelsCritical,
		KnownSyslogDataSourceLogLevelsDebug,
		KnownSyslogDataSourceLogLevelsEmergency,
		KnownSyslogDataSourceLogLevelsError,
		KnownSyslogDataSourceLogLevelsInfo,
		KnownSyslogDataSourceLogLevelsNotice,
		KnownSyslogDataSourceLogLevelsWarning,
	}
}

type KnownSyslogDataSourceStreams string

const (
	KnownSyslogDataSourceStreamsMicrosoftSyslog KnownSyslogDataSourceStreams = "Microsoft-Syslog"
)

// PossibleKnownSyslogDataSourceStreamsValues returns the possible values for the KnownSyslogDataSourceStreams const type.
func PossibleKnownSyslogDataSourceStreamsValues() []KnownSyslogDataSourceStreams {
	return []KnownSyslogDataSourceStreams{
		KnownSyslogDataSourceStreamsMicrosoftSyslog,
	}
}

type KnownWindowsEventLogDataSourceStreams string

const (
	KnownWindowsEventLogDataSourceStreamsMicrosoftEvent        KnownWindowsEventLogDataSourceStreams = "Microsoft-Event"
	KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent KnownWindowsEventLogDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownWindowsEventLogDataSourceStreamsValues returns the possible values for the KnownWindowsEventLogDataSourceStreams const type.
func PossibleKnownWindowsEventLogDataSourceStreamsValues() []KnownWindowsEventLogDataSourceStreams {
	return []KnownWindowsEventLogDataSourceStreams{
		KnownWindowsEventLogDataSourceStreamsMicrosoftEvent,
		KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent,
	}
}

// ManagedServiceIdentityType - Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
type ManagedServiceIdentityType string

const (
	ManagedServiceIdentityTypeNone                       ManagedServiceIdentityType = "None"
	ManagedServiceIdentityTypeSystemAssigned             ManagedServiceIdentityType = "SystemAssigned"
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = "SystemAssigned,UserAssigned"
	ManagedServiceIdentityTypeUserAssigned               ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns the possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{
		ManagedServiceIdentityTypeNone,
		ManagedServiceIdentityTypeSystemAssigned,
		ManagedServiceIdentityTypeSystemAssignedUserAssigned,
		ManagedServiceIdentityTypeUserAssigned,
	}
}

// MetricAggregationType - the aggregation type of the metric.
type MetricAggregationType string

const (
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	MetricAggregationTypeCount   MetricAggregationType = "Count"
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	MetricAggregationTypeNone    MetricAggregationType = "None"
	MetricAggregationTypeTotal   MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns the possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{
		MetricAggregationTypeAverage,
		MetricAggregationTypeCount,
		MetricAggregationTypeMaximum,
		MetricAggregationTypeMinimum,
		MetricAggregationTypeNone,
		MetricAggregationTypeTotal,
	}
}

// MetricClass - The class of the metric.
type MetricClass string

const (
	MetricClassAvailability MetricClass = "Availability"
	MetricClassErrors       MetricClass = "Errors"
	MetricClassLatency      MetricClass = "Latency"
	MetricClassSaturation   MetricClass = "Saturation"
	MetricClassTransactions MetricClass = "Transactions"
)

// PossibleMetricClassValues returns the possible values for the MetricClass const type.
func PossibleMetricClassValues() []MetricClass {
	return []MetricClass{
		MetricClassAvailability,
		MetricClassErrors,
		MetricClassLatency,
		MetricClassSaturation,
		MetricClassTransactions,
	}
}

// MetricResultType - Reduces the set of data collected. The syntax allowed depends on the operation. See the operation's
// description for details.
type MetricResultType string

const (
	MetricResultTypeData     MetricResultType = "Data"
	MetricResultTypeMetadata MetricResultType = "Metadata"
)

// PossibleMetricResultTypeValues returns the possible values for the MetricResultType const type.
func PossibleMetricResultTypeValues() []MetricResultType {
	return []MetricResultType{
		MetricResultTypeData,
		MetricResultTypeMetadata,
	}
}

// MetricStatisticType - the metric statistic type. How the metrics from multiple instances are combined.
type MetricStatisticType string

const (
	MetricStatisticTypeAverage MetricStatisticType = "Average"
	MetricStatisticTypeCount   MetricStatisticType = "Count"
	MetricStatisticTypeMax     MetricStatisticType = "Max"
	MetricStatisticTypeMin     MetricStatisticType = "Min"
	MetricStatisticTypeSum     MetricStatisticType = "Sum"
)

// PossibleMetricStatisticTypeValues returns the possible values for the MetricStatisticType const type.
func PossibleMetricStatisticTypeValues() []MetricStatisticType {
	return []MetricStatisticType{
		MetricStatisticTypeAverage,
		MetricStatisticTypeCount,
		MetricStatisticTypeMax,
		MetricStatisticTypeMin,
		MetricStatisticTypeSum,
	}
}

// MetricUnit - The unit of the metric.
type MetricUnit string

const (
	MetricUnitBitsPerSecond  MetricUnit = "BitsPerSecond"
	MetricUnitByteSeconds    MetricUnit = "ByteSeconds"
	MetricUnitBytes          MetricUnit = "Bytes"
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	MetricUnitCores          MetricUnit = "Cores"
	MetricUnitCount          MetricUnit = "Count"
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	MetricUnitMilliCores     MetricUnit = "MilliCores"
	MetricUnitMilliSeconds   MetricUnit = "MilliSeconds"
	MetricUnitNanoCores      MetricUnit = "NanoCores"
	MetricUnitPercent        MetricUnit = "Percent"
	MetricUnitSeconds        MetricUnit = "Seconds"
	MetricUnitUnspecified    MetricUnit = "Unspecified"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBitsPerSecond,
		MetricUnitByteSeconds,
		MetricUnitBytes,
		MetricUnitBytesPerSecond,
		MetricUnitCores,
		MetricUnitCount,
		MetricUnitCountPerSecond,
		MetricUnitMilliCores,
		MetricUnitMilliSeconds,
		MetricUnitNanoCores,
		MetricUnitPercent,
		MetricUnitSeconds,
		MetricUnitUnspecified,
	}
}

// NamespaceClassification - Kind of namespace
type NamespaceClassification string

const (
	NamespaceClassificationCustom   NamespaceClassification = "Custom"
	NamespaceClassificationPlatform NamespaceClassification = "Platform"
	NamespaceClassificationQos      NamespaceClassification = "Qos"
)

// PossibleNamespaceClassificationValues returns the possible values for the NamespaceClassification const type.
func PossibleNamespaceClassificationValues() []NamespaceClassification {
	return []NamespaceClassification{
		NamespaceClassificationCustom,
		NamespaceClassificationPlatform,
		NamespaceClassificationQos,
	}
}

// Odatatype - specifies the type of the alert criteria.
type Odatatype string

const (
	OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria Odatatype = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria"
	OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria   Odatatype = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria"
	OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria    Odatatype = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"
)

// PossibleOdatatypeValues returns the possible values for the Odatatype const type.
func PossibleOdatatypeValues() []Odatatype {
	return []Odatatype{
		OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria,
		OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria,
		OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria,
	}
}

// OnboardingStatus - The onboarding status for the resource. Note that, a higher level scope, e.g., resource group or subscription,
// is considered onboarded if at least one resource under it is onboarded.
type OnboardingStatus string

const (
	OnboardingStatusNotOnboarded OnboardingStatus = "notOnboarded"
	OnboardingStatusOnboarded    OnboardingStatus = "onboarded"
	OnboardingStatusUnknown      OnboardingStatus = "unknown"
)

// PossibleOnboardingStatusValues returns the possible values for the OnboardingStatus const type.
func PossibleOnboardingStatusValues() []OnboardingStatus {
	return []OnboardingStatus{
		OnboardingStatusNotOnboarded,
		OnboardingStatusOnboarded,
		OnboardingStatusUnknown,
	}
}

// Operator - the criteria operator.
type Operator string

const (
	OperatorEquals             Operator = "Equals"
	OperatorGreaterThan        Operator = "GreaterThan"
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	OperatorLessThan           Operator = "LessThan"
	OperatorLessThanOrEqual    Operator = "LessThanOrEqual"
)

// PossibleOperatorValues returns the possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{
		OperatorEquals,
		OperatorGreaterThan,
		OperatorGreaterThanOrEqual,
		OperatorLessThan,
		OperatorLessThanOrEqual,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// PredictiveAutoscalePolicyScaleMode - the predictive autoscale mode
type PredictiveAutoscalePolicyScaleMode string

const (
	PredictiveAutoscalePolicyScaleModeDisabled     PredictiveAutoscalePolicyScaleMode = "Disabled"
	PredictiveAutoscalePolicyScaleModeEnabled      PredictiveAutoscalePolicyScaleMode = "Enabled"
	PredictiveAutoscalePolicyScaleModeForecastOnly PredictiveAutoscalePolicyScaleMode = "ForecastOnly"
)

// PossiblePredictiveAutoscalePolicyScaleModeValues returns the possible values for the PredictiveAutoscalePolicyScaleMode const type.
func PossiblePredictiveAutoscalePolicyScaleModeValues() []PredictiveAutoscalePolicyScaleMode {
	return []PredictiveAutoscalePolicyScaleMode{
		PredictiveAutoscalePolicyScaleModeDisabled,
		PredictiveAutoscalePolicyScaleModeEnabled,
		PredictiveAutoscalePolicyScaleModeForecastOnly,
	}
}

// PrivateEndpointConnectionProvisioningState - The current provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = "Creating"
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = "Deleting"
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = "Failed"
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns the possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{
		PrivateEndpointConnectionProvisioningStateCreating,
		PrivateEndpointConnectionProvisioningStateDeleting,
		PrivateEndpointConnectionProvisioningStateFailed,
		PrivateEndpointConnectionProvisioningStateSucceeded,
	}
}

// PrivateEndpointServiceConnectionStatus - The private endpoint connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	PrivateEndpointServiceConnectionStatusPending  PrivateEndpointServiceConnectionStatus = "Pending"
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns the possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{
		PrivateEndpointServiceConnectionStatusApproved,
		PrivateEndpointServiceConnectionStatusPending,
		PrivateEndpointServiceConnectionStatusRejected,
	}
}

// ProvisioningState - The provisioning state of the Azure Monitor workspace. Set to Succeeded if everything is healthy.
type ProvisioningState string

const (
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateCreating  ProvisioningState = "Creating"
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCanceled,
		ProvisioningStateCreating,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
	}
}

// PublicNetworkAccess - This determines if traffic is allowed over public network. By default it is enabled.
type PublicNetworkAccess string

const (
	PublicNetworkAccessDisabled           PublicNetworkAccess = "Disabled"
	PublicNetworkAccessEnabled            PublicNetworkAccess = "Enabled"
	PublicNetworkAccessSecuredByPerimeter PublicNetworkAccess = "SecuredByPerimeter"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
		PublicNetworkAccessSecuredByPerimeter,
	}
}

// ReceiverStatus - Indicates the status of the receiver. Receivers that are not Enabled will not receive any communications.
type ReceiverStatus string

const (
	ReceiverStatusDisabled     ReceiverStatus = "Disabled"
	ReceiverStatusEnabled      ReceiverStatus = "Enabled"
	ReceiverStatusNotSpecified ReceiverStatus = "NotSpecified"
)

// PossibleReceiverStatusValues returns the possible values for the ReceiverStatus const type.
func PossibleReceiverStatusValues() []ReceiverStatus {
	return []ReceiverStatus{
		ReceiverStatusDisabled,
		ReceiverStatusEnabled,
		ReceiverStatusNotSpecified,
	}
}

// RecurrenceFrequency - the recurrence frequency. How often the schedule profile should take effect. This value must be Week,
// meaning each week will have the same set of profiles. For example, to set a daily schedule, set
// schedule to every day of the week. The frequency property specifies that the schedule is repeated weekly.
type RecurrenceFrequency string

const (
	RecurrenceFrequencyDay    RecurrenceFrequency = "Day"
	RecurrenceFrequencyHour   RecurrenceFrequency = "Hour"
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	RecurrenceFrequencyMonth  RecurrenceFrequency = "Month"
	RecurrenceFrequencyNone   RecurrenceFrequency = "None"
	RecurrenceFrequencySecond RecurrenceFrequency = "Second"
	RecurrenceFrequencyWeek   RecurrenceFrequency = "Week"
	RecurrenceFrequencyYear   RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns the possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{
		RecurrenceFrequencyDay,
		RecurrenceFrequencyHour,
		RecurrenceFrequencyMinute,
		RecurrenceFrequencyMonth,
		RecurrenceFrequencyNone,
		RecurrenceFrequencySecond,
		RecurrenceFrequencyWeek,
		RecurrenceFrequencyYear,
	}
}

type ResultType string

const (
	ResultTypeData     ResultType = "Data"
	ResultTypeMetadata ResultType = "Metadata"
)

// PossibleResultTypeValues returns the possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{
		ResultTypeData,
		ResultTypeMetadata,
	}
}

// ScaleDirection - the scale direction. Whether the scaling action increases or decreases the number of instances.
type ScaleDirection string

const (
	ScaleDirectionDecrease ScaleDirection = "Decrease"
	ScaleDirectionIncrease ScaleDirection = "Increase"
	ScaleDirectionNone     ScaleDirection = "None"
)

// PossibleScaleDirectionValues returns the possible values for the ScaleDirection const type.
func PossibleScaleDirectionValues() []ScaleDirection {
	return []ScaleDirection{
		ScaleDirectionDecrease,
		ScaleDirectionIncrease,
		ScaleDirectionNone,
	}
}

// ScaleRuleMetricDimensionOperationType - the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being
// equal to any of the values. 'NotEquals' being not equal to all of the values
type ScaleRuleMetricDimensionOperationType string

const (
	ScaleRuleMetricDimensionOperationTypeEquals    ScaleRuleMetricDimensionOperationType = "Equals"
	ScaleRuleMetricDimensionOperationTypeNotEquals ScaleRuleMetricDimensionOperationType = "NotEquals"
)

// PossibleScaleRuleMetricDimensionOperationTypeValues returns the possible values for the ScaleRuleMetricDimensionOperationType const type.
func PossibleScaleRuleMetricDimensionOperationTypeValues() []ScaleRuleMetricDimensionOperationType {
	return []ScaleRuleMetricDimensionOperationType{
		ScaleRuleMetricDimensionOperationTypeEquals,
		ScaleRuleMetricDimensionOperationTypeNotEquals,
	}
}

// ScaleType - the type of action that should occur when the scale rule fires.
type ScaleType string

const (
	ScaleTypeChangeCount             ScaleType = "ChangeCount"
	ScaleTypeExactCount              ScaleType = "ExactCount"
	ScaleTypePercentChangeCount      ScaleType = "PercentChangeCount"
	ScaleTypeServiceAllowedNextValue ScaleType = "ServiceAllowedNextValue"
)

// PossibleScaleTypeValues returns the possible values for the ScaleType const type.
func PossibleScaleTypeValues() []ScaleType {
	return []ScaleType{
		ScaleTypeChangeCount,
		ScaleTypeExactCount,
		ScaleTypePercentChangeCount,
		ScaleTypeServiceAllowedNextValue,
	}
}

// TimeAggregation - Aggregation type. Relevant and required only for rules of the kind LogAlert.
type TimeAggregation string

const (
	TimeAggregationAverage TimeAggregation = "Average"
	TimeAggregationCount   TimeAggregation = "Count"
	TimeAggregationMaximum TimeAggregation = "Maximum"
	TimeAggregationMinimum TimeAggregation = "Minimum"
	TimeAggregationTotal   TimeAggregation = "Total"
)

// PossibleTimeAggregationValues returns the possible values for the TimeAggregation const type.
func PossibleTimeAggregationValues() []TimeAggregation {
	return []TimeAggregation{
		TimeAggregationAverage,
		TimeAggregationCount,
		TimeAggregationMaximum,
		TimeAggregationMinimum,
		TimeAggregationTotal,
	}
}

// TimeAggregationOperator - Aggregation operators allowed in a rule.
type TimeAggregationOperator string

const (
	TimeAggregationOperatorAverage TimeAggregationOperator = "Average"
	TimeAggregationOperatorLast    TimeAggregationOperator = "Last"
	TimeAggregationOperatorMaximum TimeAggregationOperator = "Maximum"
	TimeAggregationOperatorMinimum TimeAggregationOperator = "Minimum"
	TimeAggregationOperatorTotal   TimeAggregationOperator = "Total"
)

// PossibleTimeAggregationOperatorValues returns the possible values for the TimeAggregationOperator const type.
func PossibleTimeAggregationOperatorValues() []TimeAggregationOperator {
	return []TimeAggregationOperator{
		TimeAggregationOperatorAverage,
		TimeAggregationOperatorLast,
		TimeAggregationOperatorMaximum,
		TimeAggregationOperatorMinimum,
		TimeAggregationOperatorTotal,
	}
}

// TimeAggregationType - time aggregation type. How the data that is collected should be combined over time. The default value
// is Average.
type TimeAggregationType string

const (
	TimeAggregationTypeAverage TimeAggregationType = "Average"
	TimeAggregationTypeCount   TimeAggregationType = "Count"
	TimeAggregationTypeLast    TimeAggregationType = "Last"
	TimeAggregationTypeMaximum TimeAggregationType = "Maximum"
	TimeAggregationTypeMinimum TimeAggregationType = "Minimum"
	TimeAggregationTypeTotal   TimeAggregationType = "Total"
)

// PossibleTimeAggregationTypeValues returns the possible values for the TimeAggregationType const type.
func PossibleTimeAggregationTypeValues() []TimeAggregationType {
	return []TimeAggregationType{
		TimeAggregationTypeAverage,
		TimeAggregationTypeCount,
		TimeAggregationTypeLast,
		TimeAggregationTypeMaximum,
		TimeAggregationTypeMinimum,
		TimeAggregationTypeTotal,
	}
}

// Unit - The unit of the metric.
type Unit string

const (
	UnitBitsPerSecond  Unit = "BitsPerSecond"
	UnitByteSeconds    Unit = "ByteSeconds"
	UnitBytes          Unit = "Bytes"
	UnitBytesPerSecond Unit = "BytesPerSecond"
	UnitCores          Unit = "Cores"
	UnitCount          Unit = "Count"
	UnitCountPerSecond Unit = "CountPerSecond"
	UnitMilliCores     Unit = "MilliCores"
	UnitMilliSeconds   Unit = "MilliSeconds"
	UnitNanoCores      Unit = "NanoCores"
	UnitPercent        Unit = "Percent"
	UnitSeconds        Unit = "Seconds"
	UnitUnspecified    Unit = "Unspecified"
)

// PossibleUnitValues returns the possible values for the Unit const type.
func PossibleUnitValues() []Unit {
	return []Unit{
		UnitBitsPerSecond,
		UnitByteSeconds,
		UnitBytes,
		UnitBytesPerSecond,
		UnitCores,
		UnitCount,
		UnitCountPerSecond,
		UnitMilliCores,
		UnitMilliSeconds,
		UnitNanoCores,
		UnitPercent,
		UnitSeconds,
		UnitUnspecified,
	}
}
