import { formatDistance } from "./ar-TN/_lib/formatDistance.js";
import { formatLong } from "./ar-TN/_lib/formatLong.js";
import { formatRelative } from "./ar-TN/_lib/formatRelative.js";
import { localize } from "./ar-TN/_lib/localize.js";
import { match } from "./ar-TN/_lib/match.js";

/**
 * @category Locales
 * @summary Arabic locale (Tunisian Arabic).
 * @language Arabic
 * @iso-639-2 ara
 * @author Koussay Haj Kacem [@essana3](https://github.com/essana3)
 */
export const arTN = {
  code: "ar-TN",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 1,
  },
};

// Fallback for modularized imports:
export default arTN;
