import { getParents } from "../../dag/utils";
import { flatMap, reverse } from "../../iters";
import { dfs as depthFirstSearch } from "../../utils";
/** @internal */
function buildOperator(options) {
    function dfsCall(layers) {
        // get iteration over nodes in dfs order
        let iter;
        if (options.topDown) {
            iter = depthFirstSearch((n) => n.ichildren(), ...flatMap(reverse(layers), (l) => l));
        }
        else {
            const parents = getParents(flatMap(layers, (l) => l));
            iter = depthFirstSearch((n) => { var _a; return (_a = parents.get(n)) !== null && _a !== void 0 ? _a : []; }, ...flatMap(layers, (l) => l));
        }
        // since we know we'll hit every node in iteration, we can clear the layers
        for (const layer of layers) {
            layer.splice(0);
        }
        // re-add in the order seen
        for (const node of iter) {
            layers[node.data.layer].push(node);
        }
    }
    function topDown(val) {
        if (val === undefined) {
            return options.topDown;
        }
        else {
            return buildOperator({ topDown: val });
        }
    }
    dfsCall.topDown = topDown;
    return dfsCall;
}
/**
 * Create a default {@link DfsOperator}, bundled as
 * {@link decrossDfs}.
 */
export function dfs(...args) {
    if (args.length) {
        throw new Error(`got arguments to dfs(${args}), but constructor takes no arguments.`);
    }
    return buildOperator({ topDown: true });
}
