import { jsx } from 'react/jsx-runtime';
import { Component } from 'react';
import { PanelContextRoot } from '../../components/PanelChrome/PanelContext.js';
import { hasVisibleLegendSeries, PlotLegend } from '../../components/uPlot/PlotLegend.js';
import { withTheme2 } from '../../themes/ThemeContext.js';
import { GraphNG } from '../GraphNG/GraphNG.js';
import { preparePlotConfigBuilder } from './utils.js';

const propsToDiff = ["legend", "options", "theme"];
class UnthemedTimeSeries extends Component {
  constructor() {
    super(...arguments);
    this.prepConfig = (alignedFrame, allFrames, getTimeRange) => {
      const { sync } = this.context;
      const { theme, timeZone, renderers, tweakAxis, tweakScale } = this.props;
      return preparePlotConfigBuilder({
        frame: alignedFrame,
        theme,
        timeZones: Array.isArray(timeZone) ? timeZone : [timeZone],
        getTimeRange,
        sync,
        allFrames,
        renderers,
        tweakScale,
        tweakAxis
      });
    };
    this.renderLegend = (config) => {
      const { legend, frames } = this.props;
      if (!config || legend && !legend.showLegend || !hasVisibleLegendSeries(config, frames)) {
        return null;
      }
      return /* @__PURE__ */ jsx(PlotLegend, { data: frames, config, ...legend });
    };
  }
  render() {
    return /* @__PURE__ */ jsx(
      GraphNG,
      {
        ...this.props,
        prepConfig: this.prepConfig,
        propsToDiff,
        renderLegend: this.renderLegend
      }
    );
  }
}
UnthemedTimeSeries.contextType = PanelContextRoot;
const TimeSeries = withTheme2(UnthemedTimeSeries);
TimeSeries.displayName = "TimeSeries";

export { TimeSeries, UnthemedTimeSeries };
//# sourceMappingURL=TimeSeries.js.map
