import { UAParser } from 'ua-parser-js';
import { unknownString } from '@grafana/faro-core';
export const browserMeta = () => {
    const parser = new UAParser();
    const { name, version } = parser.getBrowser();
    const { name: osName, version: osVersion } = parser.getOS();
    const userAgent = parser.getUA();
    const language = navigator.language;
    const mobile = navigator.userAgent.includes('Mobi');
    const brands = getBrands();
    return {
        browser: {
            name: name !== null && name !== void 0 ? name : unknownString,
            version: version !== null && version !== void 0 ? version : unknownString,
            os: `${osName !== null && osName !== void 0 ? osName : unknownString} ${osVersion !== null && osVersion !== void 0 ? osVersion : unknownString}`,
            userAgent: userAgent !== null && userAgent !== void 0 ? userAgent : unknownString,
            language: language !== null && language !== void 0 ? language : unknownString,
            mobile,
            brands: brands !== null && brands !== void 0 ? brands : unknownString,
            viewportWidth: `${window.innerWidth}`,
            viewportHeight: `${window.innerHeight}`,
        },
    };
    function getBrands() {
        if (!name || !version) {
            return undefined;
        }
        if ('userAgentData' in navigator && navigator.userAgentData) {
            // userAgentData in experimental (only Chrome supports it) thus TS does not ship the respective type declarations
            return navigator.userAgentData.brands;
        }
        return undefined;
    }
};
//# sourceMappingURL=meta.js.map