"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeMetas = void 0;
var utils_1 = require("../utils");
function initializeMetas(_unpatchedConsole, internalLogger, _config) {
    var items = [];
    var listeners = [];
    var getValue = function () { return items.reduce(function (acc, item) { return Object.assign(acc, (0, utils_1.isFunction)(item) ? item() : item); }, {}); };
    var notifyListeners = function () {
        if (listeners.length) {
            var value_1 = getValue();
            listeners.forEach(function (listener) { return listener(value_1); });
        }
    };
    var add = function () {
        var newItems = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            newItems[_i] = arguments[_i];
        }
        internalLogger.debug('Adding metas\n', newItems);
        items.push.apply(items, newItems);
        notifyListeners();
    };
    var remove = function () {
        var itemsToRemove = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            itemsToRemove[_i] = arguments[_i];
        }
        internalLogger.debug('Removing metas\n', itemsToRemove);
        items = items.filter(function (currentItem) { return !itemsToRemove.includes(currentItem); });
        notifyListeners();
    };
    var addListener = function (listener) {
        internalLogger.debug('Adding metas listener\n', listener);
        listeners.push(listener);
    };
    var removeListener = function (listener) {
        internalLogger.debug('Removing metas listener\n', listener);
        listeners = listeners.filter(function (currentListener) { return currentListener !== listener; });
    };
    return {
        add: add,
        remove: remove,
        addListener: addListener,
        removeListener: removeListener,
        get value() {
            return getValue();
        },
    };
}
exports.initializeMetas = initializeMetas;
//# sourceMappingURL=initialize.js.map