// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/search.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SearchFilter int32

const (
	SearchFilter_SEARCH_FILTER_UNSPECIFIED    SearchFilter = 0
	SearchFilter_SEARCH_FILTER_USER           SearchFilter = 1
	SearchFilter_SEARCH_FILTER_ORGANIZATION   SearchFilter = 2
	SearchFilter_SEARCH_FILTER_REPOSITORY     SearchFilter = 3
	SearchFilter_SEARCH_FILTER_TEAM           SearchFilter = 6
	SearchFilter_SEARCH_FILTER_CURATED_PLUGIN SearchFilter = 7
	SearchFilter_SEARCH_FILTER_MODULE_ELEMENT SearchFilter = 8
	SearchFilter_SEARCH_FILTER_MODULE_FILE    SearchFilter = 9
)

// Enum value maps for SearchFilter.
var (
	SearchFilter_name = map[int32]string{
		0: "SEARCH_FILTER_UNSPECIFIED",
		1: "SEARCH_FILTER_USER",
		2: "SEARCH_FILTER_ORGANIZATION",
		3: "SEARCH_FILTER_REPOSITORY",
		6: "SEARCH_FILTER_TEAM",
		7: "SEARCH_FILTER_CURATED_PLUGIN",
		8: "SEARCH_FILTER_MODULE_ELEMENT",
		9: "SEARCH_FILTER_MODULE_FILE",
	}
	SearchFilter_value = map[string]int32{
		"SEARCH_FILTER_UNSPECIFIED":    0,
		"SEARCH_FILTER_USER":           1,
		"SEARCH_FILTER_ORGANIZATION":   2,
		"SEARCH_FILTER_REPOSITORY":     3,
		"SEARCH_FILTER_TEAM":           6,
		"SEARCH_FILTER_CURATED_PLUGIN": 7,
		"SEARCH_FILTER_MODULE_ELEMENT": 8,
		"SEARCH_FILTER_MODULE_FILE":    9,
	}
)

func (x SearchFilter) Enum() *SearchFilter {
	p := new(SearchFilter)
	*p = x
	return p
}

func (x SearchFilter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchFilter) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[0].Descriptor()
}

func (SearchFilter) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[0]
}

func (x SearchFilter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type OrderBy int32

const (
	OrderBy_ORDER_BY_UNSPECIFIED OrderBy = 0
	OrderBy_ORDER_BY_CREATE_TIME OrderBy = 1
	OrderBy_ORDER_BY_UPDATE_TIME OrderBy = 2
	OrderBy_ORDER_BY_NAME        OrderBy = 3
)

// Enum value maps for OrderBy.
var (
	OrderBy_name = map[int32]string{
		0: "ORDER_BY_UNSPECIFIED",
		1: "ORDER_BY_CREATE_TIME",
		2: "ORDER_BY_UPDATE_TIME",
		3: "ORDER_BY_NAME",
	}
	OrderBy_value = map[string]int32{
		"ORDER_BY_UNSPECIFIED": 0,
		"ORDER_BY_CREATE_TIME": 1,
		"ORDER_BY_UPDATE_TIME": 2,
		"ORDER_BY_NAME":        3,
	}
)

func (x OrderBy) Enum() *OrderBy {
	p := new(OrderBy)
	*p = x
	return p
}

func (x OrderBy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrderBy) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[1].Descriptor()
}

func (OrderBy) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[1]
}

func (x OrderBy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// SearchModuleElementType is the protobuf element type of a fully qualified name in a module element search result.
// This is a subset of types in https://protobuf.com/docs/language-spec#named-elements that are exposing in the search.
type SearchModuleElementType int32

const (
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED SearchModuleElementType = 0
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_SERVICE     SearchModuleElementType = 1
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_METHOD      SearchModuleElementType = 2
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_MESSAGE     SearchModuleElementType = 3
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_ENUM        SearchModuleElementType = 4
)

// Enum value maps for SearchModuleElementType.
var (
	SearchModuleElementType_name = map[int32]string{
		0: "SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED",
		1: "SEARCH_MODULE_ELEMENT_TYPE_SERVICE",
		2: "SEARCH_MODULE_ELEMENT_TYPE_METHOD",
		3: "SEARCH_MODULE_ELEMENT_TYPE_MESSAGE",
		4: "SEARCH_MODULE_ELEMENT_TYPE_ENUM",
	}
	SearchModuleElementType_value = map[string]int32{
		"SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED": 0,
		"SEARCH_MODULE_ELEMENT_TYPE_SERVICE":     1,
		"SEARCH_MODULE_ELEMENT_TYPE_METHOD":      2,
		"SEARCH_MODULE_ELEMENT_TYPE_MESSAGE":     3,
		"SEARCH_MODULE_ELEMENT_TYPE_ENUM":        4,
	}
)

func (x SearchModuleElementType) Enum() *SearchModuleElementType {
	p := new(SearchModuleElementType)
	*p = x
	return p
}

func (x SearchModuleElementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchModuleElementType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[2].Descriptor()
}

func (SearchModuleElementType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[2]
}

func (x SearchModuleElementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type SearchModuleContentFilter int32

const (
	SearchModuleContentFilter_SEARCH_MODULE_CONTENT_FILTER_UNSPECIFIED SearchModuleContentFilter = 0
	// SEARCH_MODULE_CONTENT_FILTER_ELEMENT is the filter for elements, e.g. messages, services, and methods.
	SearchModuleContentFilter_SEARCH_MODULE_CONTENT_FILTER_ELEMENT SearchModuleContentFilter = 1
	// SEARCH_MODULE_CONTENT_FILTER_FILE is the filter for files.
	SearchModuleContentFilter_SEARCH_MODULE_CONTENT_FILTER_FILE SearchModuleContentFilter = 2
)

// Enum value maps for SearchModuleContentFilter.
var (
	SearchModuleContentFilter_name = map[int32]string{
		0: "SEARCH_MODULE_CONTENT_FILTER_UNSPECIFIED",
		1: "SEARCH_MODULE_CONTENT_FILTER_ELEMENT",
		2: "SEARCH_MODULE_CONTENT_FILTER_FILE",
	}
	SearchModuleContentFilter_value = map[string]int32{
		"SEARCH_MODULE_CONTENT_FILTER_UNSPECIFIED": 0,
		"SEARCH_MODULE_CONTENT_FILTER_ELEMENT":     1,
		"SEARCH_MODULE_CONTENT_FILTER_FILE":        2,
	}
)

func (x SearchModuleContentFilter) Enum() *SearchModuleContentFilter {
	p := new(SearchModuleContentFilter)
	*p = x
	return p
}

func (x SearchModuleContentFilter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchModuleContentFilter) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[3].Descriptor()
}

func (SearchModuleContentFilter) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[3]
}

func (x SearchModuleContentFilter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type RepositorySearchResult struct {
	state                              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                      string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Name                    string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Owner                   string                 `protobuf:"bytes,3,opt,name=owner,proto3"`
	xxx_hidden_Visibility              Visibility             `protobuf:"varint,4,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility"`
	xxx_hidden_Deprecated              bool                   `protobuf:"varint,5,opt,name=deprecated,proto3"`
	xxx_hidden_LatestSpdxLicenseId     string                 `protobuf:"bytes,6,opt,name=latest_spdx_license_id,json=latestSpdxLicenseId,proto3"`
	xxx_hidden_OwnerVerificationStatus VerificationStatus     `protobuf:"varint,7,opt,name=owner_verification_status,json=ownerVerificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus"`
	xxx_hidden_Url                     string                 `protobuf:"bytes,8,opt,name=url,proto3"`
	xxx_hidden_LatestCommitTime        *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=latest_commit_time,json=latestCommitTime,proto3"`
	unknownFields                      protoimpl.UnknownFields
	sizeCache                          protoimpl.SizeCache
}

func (x *RepositorySearchResult) Reset() {
	*x = RepositorySearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositorySearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositorySearchResult) ProtoMessage() {}

func (x *RepositorySearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositorySearchResult) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *RepositorySearchResult) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *RepositorySearchResult) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *RepositorySearchResult) GetVisibility() Visibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *RepositorySearchResult) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *RepositorySearchResult) GetLatestSpdxLicenseId() string {
	if x != nil {
		return x.xxx_hidden_LatestSpdxLicenseId
	}
	return ""
}

func (x *RepositorySearchResult) GetOwnerVerificationStatus() VerificationStatus {
	if x != nil {
		return x.xxx_hidden_OwnerVerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *RepositorySearchResult) GetUrl() string {
	if x != nil {
		return x.xxx_hidden_Url
	}
	return ""
}

func (x *RepositorySearchResult) GetLatestCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_LatestCommitTime
	}
	return nil
}

func (x *RepositorySearchResult) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *RepositorySearchResult) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *RepositorySearchResult) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *RepositorySearchResult) SetVisibility(v Visibility) {
	x.xxx_hidden_Visibility = v
}

func (x *RepositorySearchResult) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *RepositorySearchResult) SetLatestSpdxLicenseId(v string) {
	x.xxx_hidden_LatestSpdxLicenseId = v
}

func (x *RepositorySearchResult) SetOwnerVerificationStatus(v VerificationStatus) {
	x.xxx_hidden_OwnerVerificationStatus = v
}

func (x *RepositorySearchResult) SetUrl(v string) {
	x.xxx_hidden_Url = v
}

func (x *RepositorySearchResult) SetLatestCommitTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_LatestCommitTime = v
}

func (x *RepositorySearchResult) HasLatestCommitTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_LatestCommitTime != nil
}

func (x *RepositorySearchResult) ClearLatestCommitTime() {
	x.xxx_hidden_LatestCommitTime = nil
}

type RepositorySearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id   string
	Name string
	// The name of the user or organization
	// who is the owner of this repository.
	Owner string
	// The visibility of the repository.
	Visibility Visibility
	Deprecated bool
	// The SPDX license ID of the latest main commit in the repository.
	LatestSpdxLicenseId string
	// The verification status of the owner of the repository.
	OwnerVerificationStatus VerificationStatus
	// The user configurable URL in the description of the repository.
	Url string
	// The commit time of the latest main commit in the repository.
	LatestCommitTime *timestamppb.Timestamp
}

func (b0 RepositorySearchResult_builder) Build() *RepositorySearchResult {
	m0 := &RepositorySearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_Deprecated = b.Deprecated
	x.xxx_hidden_LatestSpdxLicenseId = b.LatestSpdxLicenseId
	x.xxx_hidden_OwnerVerificationStatus = b.OwnerVerificationStatus
	x.xxx_hidden_Url = b.Url
	x.xxx_hidden_LatestCommitTime = b.LatestCommitTime
	return m0
}

type OrganizationSearchResult struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id         string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Name       string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *OrganizationSearchResult) Reset() {
	*x = OrganizationSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OrganizationSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrganizationSearchResult) ProtoMessage() {}

func (x *OrganizationSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *OrganizationSearchResult) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *OrganizationSearchResult) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *OrganizationSearchResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *OrganizationSearchResult) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *OrganizationSearchResult) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *OrganizationSearchResult) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *OrganizationSearchResult) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *OrganizationSearchResult) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

type OrganizationSearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id         string
	Name       string
	CreateTime *timestamppb.Timestamp
}

func (b0 OrganizationSearchResult_builder) Build() *OrganizationSearchResult {
	m0 := &OrganizationSearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_CreateTime = b.CreateTime
	return m0
}

type UserSearchResult struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id          string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Username    string                 `protobuf:"bytes,2,opt,name=username,proto3"`
	xxx_hidden_Deactivated bool                   `protobuf:"varint,3,opt,name=deactivated,proto3"`
	xxx_hidden_CreateTime  *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *UserSearchResult) Reset() {
	*x = UserSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSearchResult) ProtoMessage() {}

func (x *UserSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserSearchResult) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *UserSearchResult) GetUsername() string {
	if x != nil {
		return x.xxx_hidden_Username
	}
	return ""
}

func (x *UserSearchResult) GetDeactivated() bool {
	if x != nil {
		return x.xxx_hidden_Deactivated
	}
	return false
}

func (x *UserSearchResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *UserSearchResult) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *UserSearchResult) SetUsername(v string) {
	x.xxx_hidden_Username = v
}

func (x *UserSearchResult) SetDeactivated(v bool) {
	x.xxx_hidden_Deactivated = v
}

func (x *UserSearchResult) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *UserSearchResult) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *UserSearchResult) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

type UserSearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id          string
	Username    string
	Deactivated bool
	CreateTime  *timestamppb.Timestamp
}

func (b0 UserSearchResult_builder) Build() *UserSearchResult {
	m0 := &UserSearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Username = b.Username
	x.xxx_hidden_Deactivated = b.Deactivated
	x.xxx_hidden_CreateTime = b.CreateTime
	return m0
}

type TeamSearchResult struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id               string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Name             string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_OrganizationName string                 `protobuf:"bytes,3,opt,name=organization_name,json=organizationName,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *TeamSearchResult) Reset() {
	*x = TeamSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TeamSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TeamSearchResult) ProtoMessage() {}

func (x *TeamSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TeamSearchResult) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *TeamSearchResult) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *TeamSearchResult) GetOrganizationName() string {
	if x != nil {
		return x.xxx_hidden_OrganizationName
	}
	return ""
}

func (x *TeamSearchResult) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *TeamSearchResult) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *TeamSearchResult) SetOrganizationName(v string) {
	x.xxx_hidden_OrganizationName = v
}

type TeamSearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id               string
	Name             string
	OrganizationName string
}

func (b0 TeamSearchResult_builder) Build() *TeamSearchResult {
	m0 := &TeamSearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_OrganizationName = b.OrganizationName
	return m0
}

type CuratedPluginSearchResult struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id              string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_Name            string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Owner           string                 `protobuf:"bytes,3,opt,name=owner,proto3"`
	xxx_hidden_Deprecated      bool                   `protobuf:"varint,4,opt,name=deprecated,proto3"`
	xxx_hidden_Description     string                 `protobuf:"bytes,5,opt,name=description,proto3"`
	xxx_hidden_RegistryType    PluginRegistryType     `protobuf:"varint,6,opt,name=registry_type,json=registryType,proto3,enum=buf.alpha.registry.v1alpha1.PluginRegistryType"`
	xxx_hidden_OutputLanguages []PluginLanguage       `protobuf:"varint,7,rep,packed,name=output_languages,json=outputLanguages,proto3,enum=buf.alpha.registry.v1alpha1.PluginLanguage"`
	xxx_hidden_CreateTime      *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *CuratedPluginSearchResult) Reset() {
	*x = CuratedPluginSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CuratedPluginSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPluginSearchResult) ProtoMessage() {}

func (x *CuratedPluginSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CuratedPluginSearchResult) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *CuratedPluginSearchResult) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CuratedPluginSearchResult) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *CuratedPluginSearchResult) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *CuratedPluginSearchResult) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *CuratedPluginSearchResult) GetRegistryType() PluginRegistryType {
	if x != nil {
		return x.xxx_hidden_RegistryType
	}
	return PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED
}

func (x *CuratedPluginSearchResult) GetOutputLanguages() []PluginLanguage {
	if x != nil {
		return x.xxx_hidden_OutputLanguages
	}
	return nil
}

func (x *CuratedPluginSearchResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *CuratedPluginSearchResult) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *CuratedPluginSearchResult) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *CuratedPluginSearchResult) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *CuratedPluginSearchResult) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *CuratedPluginSearchResult) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *CuratedPluginSearchResult) SetRegistryType(v PluginRegistryType) {
	x.xxx_hidden_RegistryType = v
}

func (x *CuratedPluginSearchResult) SetOutputLanguages(v []PluginLanguage) {
	x.xxx_hidden_OutputLanguages = v
}

func (x *CuratedPluginSearchResult) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *CuratedPluginSearchResult) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *CuratedPluginSearchResult) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

type CuratedPluginSearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id   string
	Name string
	// The name of the user or organization
	// who is the owner of this plugin.
	Owner      string
	Deprecated bool
	// The description of the plugin and it's functionality.
	Description string
	// The registry type of the plugin.
	RegistryType PluginRegistryType
	// The output languages supported by the plugin.
	OutputLanguages []PluginLanguage
	// The plugins creation timestamp.
	CreateTime *timestamppb.Timestamp
}

func (b0 CuratedPluginSearchResult_builder) Build() *CuratedPluginSearchResult {
	m0 := &CuratedPluginSearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Deprecated = b.Deprecated
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_RegistryType = b.RegistryType
	x.xxx_hidden_OutputLanguages = b.OutputLanguages
	x.xxx_hidden_CreateTime = b.CreateTime
	return m0
}

type ModuleElementSearchResult struct {
	state                              protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId            string                  `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryOwner         string                  `protobuf:"bytes,2,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName          string                  `protobuf:"bytes,3,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_ProtoFilePath           string                  `protobuf:"bytes,4,opt,name=proto_file_path,json=protoFilePath,proto3"`
	xxx_hidden_FullyQualifiedName      string                  `protobuf:"bytes,5,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3"`
	xxx_hidden_PackageName             string                  `protobuf:"bytes,6,opt,name=package_name,json=packageName,proto3"`
	xxx_hidden_SearchModuleElementType SearchModuleElementType `protobuf:"varint,7,opt,name=search_module_element_type,json=searchModuleElementType,proto3,enum=buf.alpha.registry.v1alpha1.SearchModuleElementType"`
	unknownFields                      protoimpl.UnknownFields
	sizeCache                          protoimpl.SizeCache
}

func (x *ModuleElementSearchResult) Reset() {
	*x = ModuleElementSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModuleElementSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleElementSearchResult) ProtoMessage() {}

func (x *ModuleElementSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ModuleElementSearchResult) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ModuleElementSearchResult) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *ModuleElementSearchResult) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *ModuleElementSearchResult) GetProtoFilePath() string {
	if x != nil {
		return x.xxx_hidden_ProtoFilePath
	}
	return ""
}

func (x *ModuleElementSearchResult) GetFullyQualifiedName() string {
	if x != nil {
		return x.xxx_hidden_FullyQualifiedName
	}
	return ""
}

func (x *ModuleElementSearchResult) GetPackageName() string {
	if x != nil {
		return x.xxx_hidden_PackageName
	}
	return ""
}

func (x *ModuleElementSearchResult) GetSearchModuleElementType() SearchModuleElementType {
	if x != nil {
		return x.xxx_hidden_SearchModuleElementType
	}
	return SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED
}

func (x *ModuleElementSearchResult) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ModuleElementSearchResult) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *ModuleElementSearchResult) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *ModuleElementSearchResult) SetProtoFilePath(v string) {
	x.xxx_hidden_ProtoFilePath = v
}

func (x *ModuleElementSearchResult) SetFullyQualifiedName(v string) {
	x.xxx_hidden_FullyQualifiedName = v
}

func (x *ModuleElementSearchResult) SetPackageName(v string) {
	x.xxx_hidden_PackageName = v
}

func (x *ModuleElementSearchResult) SetSearchModuleElementType(v SearchModuleElementType) {
	x.xxx_hidden_SearchModuleElementType = v
}

type ModuleElementSearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryId            string
	RepositoryOwner         string
	RepositoryName          string
	ProtoFilePath           string
	FullyQualifiedName      string
	PackageName             string
	SearchModuleElementType SearchModuleElementType
}

func (b0 ModuleElementSearchResult_builder) Build() *ModuleElementSearchResult {
	m0 := &ModuleElementSearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_ProtoFilePath = b.ProtoFilePath
	x.xxx_hidden_FullyQualifiedName = b.FullyQualifiedName
	x.xxx_hidden_PackageName = b.PackageName
	x.xxx_hidden_SearchModuleElementType = b.SearchModuleElementType
	return m0
}

type ModuleFileSearchResult struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId    string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,2,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,3,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_ProtoFilePath   string                 `protobuf:"bytes,4,opt,name=proto_file_path,json=protoFilePath,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ModuleFileSearchResult) Reset() {
	*x = ModuleFileSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModuleFileSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleFileSearchResult) ProtoMessage() {}

func (x *ModuleFileSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ModuleFileSearchResult) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ModuleFileSearchResult) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *ModuleFileSearchResult) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *ModuleFileSearchResult) GetProtoFilePath() string {
	if x != nil {
		return x.xxx_hidden_ProtoFilePath
	}
	return ""
}

func (x *ModuleFileSearchResult) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ModuleFileSearchResult) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *ModuleFileSearchResult) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *ModuleFileSearchResult) SetProtoFilePath(v string) {
	x.xxx_hidden_ProtoFilePath = v
}

type ModuleFileSearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryId    string
	RepositoryOwner string
	RepositoryName  string
	ProtoFilePath   string
}

func (b0 ModuleFileSearchResult_builder) Build() *ModuleFileSearchResult {
	m0 := &ModuleFileSearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_ProtoFilePath = b.ProtoFilePath
	return m0
}

type SearchResult struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Item isSearchResult_Item    `protobuf_oneof:"item"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SearchResult) Reset() {
	*x = SearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResult) ProtoMessage() {}

func (x *SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchResult) GetRepository() *RepositorySearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchResult_Repository); ok {
			return x.Repository
		}
	}
	return nil
}

func (x *SearchResult) GetOrganization() *OrganizationSearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchResult_Organization); ok {
			return x.Organization
		}
	}
	return nil
}

func (x *SearchResult) GetUser() *UserSearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchResult_User); ok {
			return x.User
		}
	}
	return nil
}

func (x *SearchResult) GetTeam() *TeamSearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchResult_Team); ok {
			return x.Team
		}
	}
	return nil
}

func (x *SearchResult) GetCuratedPlugin() *CuratedPluginSearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchResult_CuratedPlugin); ok {
			return x.CuratedPlugin
		}
	}
	return nil
}

func (x *SearchResult) GetModuleElement() *ModuleElementSearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchResult_ModuleElement); ok {
			return x.ModuleElement
		}
	}
	return nil
}

func (x *SearchResult) GetModuleFile() *ModuleFileSearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchResult_ModuleFile); ok {
			return x.ModuleFile
		}
	}
	return nil
}

func (x *SearchResult) SetRepository(v *RepositorySearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchResult_Repository{v}
}

func (x *SearchResult) SetOrganization(v *OrganizationSearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchResult_Organization{v}
}

func (x *SearchResult) SetUser(v *UserSearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchResult_User{v}
}

func (x *SearchResult) SetTeam(v *TeamSearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchResult_Team{v}
}

func (x *SearchResult) SetCuratedPlugin(v *CuratedPluginSearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchResult_CuratedPlugin{v}
}

func (x *SearchResult) SetModuleElement(v *ModuleElementSearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchResult_ModuleElement{v}
}

func (x *SearchResult) SetModuleFile(v *ModuleFileSearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchResult_ModuleFile{v}
}

func (x *SearchResult) HasItem() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Item != nil
}

func (x *SearchResult) HasRepository() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchResult_Repository)
	return ok
}

func (x *SearchResult) HasOrganization() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchResult_Organization)
	return ok
}

func (x *SearchResult) HasUser() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchResult_User)
	return ok
}

func (x *SearchResult) HasTeam() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchResult_Team)
	return ok
}

func (x *SearchResult) HasCuratedPlugin() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchResult_CuratedPlugin)
	return ok
}

func (x *SearchResult) HasModuleElement() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchResult_ModuleElement)
	return ok
}

func (x *SearchResult) HasModuleFile() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchResult_ModuleFile)
	return ok
}

func (x *SearchResult) ClearItem() {
	x.xxx_hidden_Item = nil
}

func (x *SearchResult) ClearRepository() {
	if _, ok := x.xxx_hidden_Item.(*searchResult_Repository); ok {
		x.xxx_hidden_Item = nil
	}
}

func (x *SearchResult) ClearOrganization() {
	if _, ok := x.xxx_hidden_Item.(*searchResult_Organization); ok {
		x.xxx_hidden_Item = nil
	}
}

func (x *SearchResult) ClearUser() {
	if _, ok := x.xxx_hidden_Item.(*searchResult_User); ok {
		x.xxx_hidden_Item = nil
	}
}

func (x *SearchResult) ClearTeam() {
	if _, ok := x.xxx_hidden_Item.(*searchResult_Team); ok {
		x.xxx_hidden_Item = nil
	}
}

func (x *SearchResult) ClearCuratedPlugin() {
	if _, ok := x.xxx_hidden_Item.(*searchResult_CuratedPlugin); ok {
		x.xxx_hidden_Item = nil
	}
}

func (x *SearchResult) ClearModuleElement() {
	if _, ok := x.xxx_hidden_Item.(*searchResult_ModuleElement); ok {
		x.xxx_hidden_Item = nil
	}
}

func (x *SearchResult) ClearModuleFile() {
	if _, ok := x.xxx_hidden_Item.(*searchResult_ModuleFile); ok {
		x.xxx_hidden_Item = nil
	}
}

const SearchResult_Item_not_set_case case_SearchResult_Item = 0
const SearchResult_Repository_case case_SearchResult_Item = 1
const SearchResult_Organization_case case_SearchResult_Item = 2
const SearchResult_User_case case_SearchResult_Item = 3
const SearchResult_Team_case case_SearchResult_Item = 4
const SearchResult_CuratedPlugin_case case_SearchResult_Item = 7
const SearchResult_ModuleElement_case case_SearchResult_Item = 8
const SearchResult_ModuleFile_case case_SearchResult_Item = 9

func (x *SearchResult) WhichItem() case_SearchResult_Item {
	if x == nil {
		return SearchResult_Item_not_set_case
	}
	switch x.xxx_hidden_Item.(type) {
	case *searchResult_Repository:
		return SearchResult_Repository_case
	case *searchResult_Organization:
		return SearchResult_Organization_case
	case *searchResult_User:
		return SearchResult_User_case
	case *searchResult_Team:
		return SearchResult_Team_case
	case *searchResult_CuratedPlugin:
		return SearchResult_CuratedPlugin_case
	case *searchResult_ModuleElement:
		return SearchResult_ModuleElement_case
	case *searchResult_ModuleFile:
		return SearchResult_ModuleFile_case
	default:
		return SearchResult_Item_not_set_case
	}
}

type SearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Item:
	Repository    *RepositorySearchResult
	Organization  *OrganizationSearchResult
	User          *UserSearchResult
	Team          *TeamSearchResult
	CuratedPlugin *CuratedPluginSearchResult
	ModuleElement *ModuleElementSearchResult
	ModuleFile    *ModuleFileSearchResult
	// -- end of xxx_hidden_Item
}

func (b0 SearchResult_builder) Build() *SearchResult {
	m0 := &SearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Repository != nil {
		x.xxx_hidden_Item = &searchResult_Repository{b.Repository}
	}
	if b.Organization != nil {
		x.xxx_hidden_Item = &searchResult_Organization{b.Organization}
	}
	if b.User != nil {
		x.xxx_hidden_Item = &searchResult_User{b.User}
	}
	if b.Team != nil {
		x.xxx_hidden_Item = &searchResult_Team{b.Team}
	}
	if b.CuratedPlugin != nil {
		x.xxx_hidden_Item = &searchResult_CuratedPlugin{b.CuratedPlugin}
	}
	if b.ModuleElement != nil {
		x.xxx_hidden_Item = &searchResult_ModuleElement{b.ModuleElement}
	}
	if b.ModuleFile != nil {
		x.xxx_hidden_Item = &searchResult_ModuleFile{b.ModuleFile}
	}
	return m0
}

type case_SearchResult_Item protoreflect.FieldNumber

func (x case_SearchResult_Item) String() string {
	md := file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[7].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isSearchResult_Item interface {
	isSearchResult_Item()
}

type searchResult_Repository struct {
	Repository *RepositorySearchResult `protobuf:"bytes,1,opt,name=repository,proto3,oneof"`
}

type searchResult_Organization struct {
	Organization *OrganizationSearchResult `protobuf:"bytes,2,opt,name=organization,proto3,oneof"`
}

type searchResult_User struct {
	User *UserSearchResult `protobuf:"bytes,3,opt,name=user,proto3,oneof"`
}

type searchResult_Team struct {
	Team *TeamSearchResult `protobuf:"bytes,4,opt,name=team,proto3,oneof"`
}

type searchResult_CuratedPlugin struct {
	CuratedPlugin *CuratedPluginSearchResult `protobuf:"bytes,7,opt,name=curated_plugin,json=curatedPlugin,proto3,oneof"`
}

type searchResult_ModuleElement struct {
	ModuleElement *ModuleElementSearchResult `protobuf:"bytes,8,opt,name=module_element,json=moduleElement,proto3,oneof"`
}

type searchResult_ModuleFile struct {
	ModuleFile *ModuleFileSearchResult `protobuf:"bytes,9,opt,name=module_file,json=moduleFile,proto3,oneof"`
}

func (*searchResult_Repository) isSearchResult_Item() {}

func (*searchResult_Organization) isSearchResult_Item() {}

func (*searchResult_User) isSearchResult_Item() {}

func (*searchResult_Team) isSearchResult_Item() {}

func (*searchResult_CuratedPlugin) isSearchResult_Item() {}

func (*searchResult_ModuleElement) isSearchResult_Item() {}

func (*searchResult_ModuleFile) isSearchResult_Item() {}

type ElementSearchResult struct {
	state                         protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId       string                         `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryOwner    string                         `protobuf:"bytes,2,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName     string                         `protobuf:"bytes,3,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_ProtoFilePath      string                         `protobuf:"bytes,4,opt,name=proto_file_path,json=protoFilePath,proto3"`
	xxx_hidden_FullyQualifiedName string                         `protobuf:"bytes,5,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3"`
	xxx_hidden_Document           isElementSearchResult_Document `protobuf_oneof:"document"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *ElementSearchResult) Reset() {
	*x = ElementSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ElementSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ElementSearchResult) ProtoMessage() {}

func (x *ElementSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ElementSearchResult) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ElementSearchResult) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *ElementSearchResult) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *ElementSearchResult) GetProtoFilePath() string {
	if x != nil {
		return x.xxx_hidden_ProtoFilePath
	}
	return ""
}

func (x *ElementSearchResult) GetFullyQualifiedName() string {
	if x != nil {
		return x.xxx_hidden_FullyQualifiedName
	}
	return ""
}

func (x *ElementSearchResult) GetService() *Service {
	if x != nil {
		if x, ok := x.xxx_hidden_Document.(*elementSearchResult_Service); ok {
			return x.Service
		}
	}
	return nil
}

func (x *ElementSearchResult) GetMethod() *Method {
	if x != nil {
		if x, ok := x.xxx_hidden_Document.(*elementSearchResult_Method); ok {
			return x.Method
		}
	}
	return nil
}

func (x *ElementSearchResult) GetEnum() *Enum {
	if x != nil {
		if x, ok := x.xxx_hidden_Document.(*elementSearchResult_Enum); ok {
			return x.Enum
		}
	}
	return nil
}

func (x *ElementSearchResult) GetMessage() *Message {
	if x != nil {
		if x, ok := x.xxx_hidden_Document.(*elementSearchResult_Message); ok {
			return x.Message
		}
	}
	return nil
}

func (x *ElementSearchResult) GetFileExtension() *FileExtension {
	if x != nil {
		if x, ok := x.xxx_hidden_Document.(*elementSearchResult_FileExtension); ok {
			return x.FileExtension
		}
	}
	return nil
}

func (x *ElementSearchResult) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ElementSearchResult) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *ElementSearchResult) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *ElementSearchResult) SetProtoFilePath(v string) {
	x.xxx_hidden_ProtoFilePath = v
}

func (x *ElementSearchResult) SetFullyQualifiedName(v string) {
	x.xxx_hidden_FullyQualifiedName = v
}

func (x *ElementSearchResult) SetService(v *Service) {
	if v == nil {
		x.xxx_hidden_Document = nil
		return
	}
	x.xxx_hidden_Document = &elementSearchResult_Service{v}
}

func (x *ElementSearchResult) SetMethod(v *Method) {
	if v == nil {
		x.xxx_hidden_Document = nil
		return
	}
	x.xxx_hidden_Document = &elementSearchResult_Method{v}
}

func (x *ElementSearchResult) SetEnum(v *Enum) {
	if v == nil {
		x.xxx_hidden_Document = nil
		return
	}
	x.xxx_hidden_Document = &elementSearchResult_Enum{v}
}

func (x *ElementSearchResult) SetMessage(v *Message) {
	if v == nil {
		x.xxx_hidden_Document = nil
		return
	}
	x.xxx_hidden_Document = &elementSearchResult_Message{v}
}

func (x *ElementSearchResult) SetFileExtension(v *FileExtension) {
	if v == nil {
		x.xxx_hidden_Document = nil
		return
	}
	x.xxx_hidden_Document = &elementSearchResult_FileExtension{v}
}

func (x *ElementSearchResult) HasDocument() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Document != nil
}

func (x *ElementSearchResult) HasService() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Document.(*elementSearchResult_Service)
	return ok
}

func (x *ElementSearchResult) HasMethod() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Document.(*elementSearchResult_Method)
	return ok
}

func (x *ElementSearchResult) HasEnum() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Document.(*elementSearchResult_Enum)
	return ok
}

func (x *ElementSearchResult) HasMessage() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Document.(*elementSearchResult_Message)
	return ok
}

func (x *ElementSearchResult) HasFileExtension() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Document.(*elementSearchResult_FileExtension)
	return ok
}

func (x *ElementSearchResult) ClearDocument() {
	x.xxx_hidden_Document = nil
}

func (x *ElementSearchResult) ClearService() {
	if _, ok := x.xxx_hidden_Document.(*elementSearchResult_Service); ok {
		x.xxx_hidden_Document = nil
	}
}

func (x *ElementSearchResult) ClearMethod() {
	if _, ok := x.xxx_hidden_Document.(*elementSearchResult_Method); ok {
		x.xxx_hidden_Document = nil
	}
}

func (x *ElementSearchResult) ClearEnum() {
	if _, ok := x.xxx_hidden_Document.(*elementSearchResult_Enum); ok {
		x.xxx_hidden_Document = nil
	}
}

func (x *ElementSearchResult) ClearMessage() {
	if _, ok := x.xxx_hidden_Document.(*elementSearchResult_Message); ok {
		x.xxx_hidden_Document = nil
	}
}

func (x *ElementSearchResult) ClearFileExtension() {
	if _, ok := x.xxx_hidden_Document.(*elementSearchResult_FileExtension); ok {
		x.xxx_hidden_Document = nil
	}
}

const ElementSearchResult_Document_not_set_case case_ElementSearchResult_Document = 0
const ElementSearchResult_Service_case case_ElementSearchResult_Document = 6
const ElementSearchResult_Method_case case_ElementSearchResult_Document = 7
const ElementSearchResult_Enum_case case_ElementSearchResult_Document = 8
const ElementSearchResult_Message_case case_ElementSearchResult_Document = 9
const ElementSearchResult_FileExtension_case case_ElementSearchResult_Document = 10

func (x *ElementSearchResult) WhichDocument() case_ElementSearchResult_Document {
	if x == nil {
		return ElementSearchResult_Document_not_set_case
	}
	switch x.xxx_hidden_Document.(type) {
	case *elementSearchResult_Service:
		return ElementSearchResult_Service_case
	case *elementSearchResult_Method:
		return ElementSearchResult_Method_case
	case *elementSearchResult_Enum:
		return ElementSearchResult_Enum_case
	case *elementSearchResult_Message:
		return ElementSearchResult_Message_case
	case *elementSearchResult_FileExtension:
		return ElementSearchResult_FileExtension_case
	default:
		return ElementSearchResult_Document_not_set_case
	}
}

type ElementSearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryId       string
	RepositoryOwner    string
	RepositoryName     string
	ProtoFilePath      string
	FullyQualifiedName string
	// Fields of oneof xxx_hidden_Document:
	Service       *Service
	Method        *Method
	Enum          *Enum
	Message       *Message
	FileExtension *FileExtension
	// -- end of xxx_hidden_Document
}

func (b0 ElementSearchResult_builder) Build() *ElementSearchResult {
	m0 := &ElementSearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_ProtoFilePath = b.ProtoFilePath
	x.xxx_hidden_FullyQualifiedName = b.FullyQualifiedName
	if b.Service != nil {
		x.xxx_hidden_Document = &elementSearchResult_Service{b.Service}
	}
	if b.Method != nil {
		x.xxx_hidden_Document = &elementSearchResult_Method{b.Method}
	}
	if b.Enum != nil {
		x.xxx_hidden_Document = &elementSearchResult_Enum{b.Enum}
	}
	if b.Message != nil {
		x.xxx_hidden_Document = &elementSearchResult_Message{b.Message}
	}
	if b.FileExtension != nil {
		x.xxx_hidden_Document = &elementSearchResult_FileExtension{b.FileExtension}
	}
	return m0
}

type case_ElementSearchResult_Document protoreflect.FieldNumber

func (x case_ElementSearchResult_Document) String() string {
	md := file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[8].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isElementSearchResult_Document interface {
	isElementSearchResult_Document()
}

type elementSearchResult_Service struct {
	Service *Service `protobuf:"bytes,6,opt,name=service,proto3,oneof"`
}

type elementSearchResult_Method struct {
	Method *Method `protobuf:"bytes,7,opt,name=method,proto3,oneof"`
}

type elementSearchResult_Enum struct {
	Enum *Enum `protobuf:"bytes,8,opt,name=enum,proto3,oneof"`
}

type elementSearchResult_Message struct {
	Message *Message `protobuf:"bytes,9,opt,name=message,proto3,oneof"`
}

type elementSearchResult_FileExtension struct {
	FileExtension *FileExtension `protobuf:"bytes,10,opt,name=file_extension,json=fileExtension,proto3,oneof"`
}

func (*elementSearchResult_Service) isElementSearchResult_Document() {}

func (*elementSearchResult_Method) isElementSearchResult_Document() {}

func (*elementSearchResult_Enum) isElementSearchResult_Document() {}

func (*elementSearchResult_Message) isElementSearchResult_Document() {}

func (*elementSearchResult_FileExtension) isElementSearchResult_Document() {}

type FileSearchResult struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId    string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,2,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,3,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_ProtoFilePath   string                 `protobuf:"bytes,4,opt,name=proto_file_path,json=protoFilePath,proto3"`
	xxx_hidden_Content         []byte                 `protobuf:"bytes,5,opt,name=content,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *FileSearchResult) Reset() {
	*x = FileSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileSearchResult) ProtoMessage() {}

func (x *FileSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FileSearchResult) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *FileSearchResult) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *FileSearchResult) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *FileSearchResult) GetProtoFilePath() string {
	if x != nil {
		return x.xxx_hidden_ProtoFilePath
	}
	return ""
}

func (x *FileSearchResult) GetContent() []byte {
	if x != nil {
		return x.xxx_hidden_Content
	}
	return nil
}

func (x *FileSearchResult) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *FileSearchResult) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *FileSearchResult) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *FileSearchResult) SetProtoFilePath(v string) {
	x.xxx_hidden_ProtoFilePath = v
}

func (x *FileSearchResult) SetContent(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_Content = v
}

type FileSearchResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryId    string
	RepositoryOwner string
	RepositoryName  string
	ProtoFilePath   string
	Content         []byte
}

func (b0 FileSearchResult_builder) Build() *FileSearchResult {
	m0 := &FileSearchResult{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_ProtoFilePath = b.ProtoFilePath
	x.xxx_hidden_Content = b.Content
	return m0
}

type SearchModuleContentResult struct {
	state           protoimpl.MessageState           `protogen:"opaque.v1"`
	xxx_hidden_Item isSearchModuleContentResult_Item `protobuf_oneof:"item"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SearchModuleContentResult) Reset() {
	*x = SearchModuleContentResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchModuleContentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchModuleContentResult) ProtoMessage() {}

func (x *SearchModuleContentResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchModuleContentResult) GetElement() *ElementSearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchModuleContentResult_Element); ok {
			return x.Element
		}
	}
	return nil
}

func (x *SearchModuleContentResult) GetFile() *FileSearchResult {
	if x != nil {
		if x, ok := x.xxx_hidden_Item.(*searchModuleContentResult_File); ok {
			return x.File
		}
	}
	return nil
}

func (x *SearchModuleContentResult) SetElement(v *ElementSearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchModuleContentResult_Element{v}
}

func (x *SearchModuleContentResult) SetFile(v *FileSearchResult) {
	if v == nil {
		x.xxx_hidden_Item = nil
		return
	}
	x.xxx_hidden_Item = &searchModuleContentResult_File{v}
}

func (x *SearchModuleContentResult) HasItem() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Item != nil
}

func (x *SearchModuleContentResult) HasElement() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchModuleContentResult_Element)
	return ok
}

func (x *SearchModuleContentResult) HasFile() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Item.(*searchModuleContentResult_File)
	return ok
}

func (x *SearchModuleContentResult) ClearItem() {
	x.xxx_hidden_Item = nil
}

func (x *SearchModuleContentResult) ClearElement() {
	if _, ok := x.xxx_hidden_Item.(*searchModuleContentResult_Element); ok {
		x.xxx_hidden_Item = nil
	}
}

func (x *SearchModuleContentResult) ClearFile() {
	if _, ok := x.xxx_hidden_Item.(*searchModuleContentResult_File); ok {
		x.xxx_hidden_Item = nil
	}
}

const SearchModuleContentResult_Item_not_set_case case_SearchModuleContentResult_Item = 0
const SearchModuleContentResult_Element_case case_SearchModuleContentResult_Item = 1
const SearchModuleContentResult_File_case case_SearchModuleContentResult_Item = 2

func (x *SearchModuleContentResult) WhichItem() case_SearchModuleContentResult_Item {
	if x == nil {
		return SearchModuleContentResult_Item_not_set_case
	}
	switch x.xxx_hidden_Item.(type) {
	case *searchModuleContentResult_Element:
		return SearchModuleContentResult_Element_case
	case *searchModuleContentResult_File:
		return SearchModuleContentResult_File_case
	default:
		return SearchModuleContentResult_Item_not_set_case
	}
}

type SearchModuleContentResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Item:
	Element *ElementSearchResult
	File    *FileSearchResult
	// -- end of xxx_hidden_Item
}

func (b0 SearchModuleContentResult_builder) Build() *SearchModuleContentResult {
	m0 := &SearchModuleContentResult{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Element != nil {
		x.xxx_hidden_Item = &searchModuleContentResult_Element{b.Element}
	}
	if b.File != nil {
		x.xxx_hidden_Item = &searchModuleContentResult_File{b.File}
	}
	return m0
}

type case_SearchModuleContentResult_Item protoreflect.FieldNumber

func (x case_SearchModuleContentResult_Item) String() string {
	md := file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[10].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isSearchModuleContentResult_Item interface {
	isSearchModuleContentResult_Item()
}

type searchModuleContentResult_Element struct {
	Element *ElementSearchResult `protobuf:"bytes,1,opt,name=element,proto3,oneof"`
}

type searchModuleContentResult_File struct {
	File *FileSearchResult `protobuf:"bytes,2,opt,name=file,proto3,oneof"`
}

func (*searchModuleContentResult_Element) isSearchModuleContentResult_Item() {}

func (*searchModuleContentResult_File) isSearchModuleContentResult_Item() {}

type SearchRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Query     string                 `protobuf:"bytes,1,opt,name=query,proto3"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken uint32                 `protobuf:"varint,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Filters   []SearchFilter         `protobuf:"varint,4,rep,packed,name=filters,proto3,enum=buf.alpha.registry.v1alpha1.SearchFilter"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *SearchRequest) Reset() {
	*x = SearchRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest) ProtoMessage() {}

func (x *SearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchRequest) GetQuery() string {
	if x != nil {
		return x.xxx_hidden_Query
	}
	return ""
}

func (x *SearchRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *SearchRequest) GetPageToken() uint32 {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return 0
}

func (x *SearchRequest) GetFilters() []SearchFilter {
	if x != nil {
		return x.xxx_hidden_Filters
	}
	return nil
}

func (x *SearchRequest) SetQuery(v string) {
	x.xxx_hidden_Query = v
}

func (x *SearchRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *SearchRequest) SetPageToken(v uint32) {
	x.xxx_hidden_PageToken = v
}

func (x *SearchRequest) SetFilters(v []SearchFilter) {
	x.xxx_hidden_Filters = v
}

type SearchRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The search string.
	Query    string
	PageSize uint32
	// The first page is returned if this is 0.
	PageToken uint32
	// Empty list means show all. Supplying one or more enums will
	// limit the search to only the requested resources.
	// Supplying all possible enums is equivalent to empty list of filters.
	Filters []SearchFilter
}

func (b0 SearchRequest_builder) Build() *SearchRequest {
	m0 := &SearchRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Query = b.Query
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Filters = b.Filters
	return m0
}

type SearchResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_SearchResults *[]*SearchResult       `protobuf:"bytes,1,rep,name=search_results,json=searchResults,proto3"`
	xxx_hidden_NextPageToken uint32                 `protobuf:"varint,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *SearchResponse) Reset() {
	*x = SearchResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse) ProtoMessage() {}

func (x *SearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchResponse) GetSearchResults() []*SearchResult {
	if x != nil {
		if x.xxx_hidden_SearchResults != nil {
			return *x.xxx_hidden_SearchResults
		}
	}
	return nil
}

func (x *SearchResponse) GetNextPageToken() uint32 {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return 0
}

func (x *SearchResponse) SetSearchResults(v []*SearchResult) {
	x.xxx_hidden_SearchResults = &v
}

func (x *SearchResponse) SetNextPageToken(v uint32) {
	x.xxx_hidden_NextPageToken = v
}

type SearchResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	SearchResults []*SearchResult
	// There are no more pages if this is 0.
	NextPageToken uint32
}

func (b0 SearchResponse_builder) Build() *SearchResponse {
	m0 := &SearchResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_SearchResults = &b.SearchResults
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type SearchTagRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Query           string                 `protobuf:"bytes,3,opt,name=query,proto3"`
	xxx_hidden_PageSize        uint32                 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken       string                 `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_OrderBy         OrderBy                `protobuf:"varint,6,opt,name=order_by,json=orderBy,proto3,enum=buf.alpha.registry.v1alpha1.OrderBy"`
	xxx_hidden_Reverse         bool                   `protobuf:"varint,7,opt,name=reverse,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *SearchTagRequest) Reset() {
	*x = SearchTagRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTagRequest) ProtoMessage() {}

func (x *SearchTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchTagRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *SearchTagRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *SearchTagRequest) GetQuery() string {
	if x != nil {
		return x.xxx_hidden_Query
	}
	return ""
}

func (x *SearchTagRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *SearchTagRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *SearchTagRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.xxx_hidden_OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *SearchTagRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *SearchTagRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *SearchTagRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *SearchTagRequest) SetQuery(v string) {
	x.xxx_hidden_Query = v
}

func (x *SearchTagRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *SearchTagRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *SearchTagRequest) SetOrderBy(v OrderBy) {
	x.xxx_hidden_OrderBy = v
}

func (x *SearchTagRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type SearchTagRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the repository.
	RepositoryOwner string
	// The name of the repository.
	RepositoryName string
	// The search string.
	Query    string
	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	// The field to order results by.
	OrderBy OrderBy
	// Reverse orders results in descending order.
	Reverse bool
}

func (b0 SearchTagRequest_builder) Build() *SearchTagRequest {
	m0 := &SearchTagRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Query = b.Query
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_OrderBy = b.OrderBy
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type SearchTagResponse struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryTags *[]*RepositoryTag      `protobuf:"bytes,1,rep,name=repository_tags,json=repositoryTags,proto3"`
	xxx_hidden_NextPageToken  string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *SearchTagResponse) Reset() {
	*x = SearchTagResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTagResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTagResponse) ProtoMessage() {}

func (x *SearchTagResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchTagResponse) GetRepositoryTags() []*RepositoryTag {
	if x != nil {
		if x.xxx_hidden_RepositoryTags != nil {
			return *x.xxx_hidden_RepositoryTags
		}
	}
	return nil
}

func (x *SearchTagResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *SearchTagResponse) SetRepositoryTags(v []*RepositoryTag) {
	x.xxx_hidden_RepositoryTags = &v
}

func (x *SearchTagResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type SearchTagResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryTags []*RepositoryTag
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 SearchTagResponse_builder) Build() *SearchTagResponse {
	m0 := &SearchTagResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryTags = &b.RepositoryTags
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type SearchDraftRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Query           string                 `protobuf:"bytes,3,opt,name=query,proto3"`
	xxx_hidden_PageSize        uint32                 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken       string                 `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_OrderBy         OrderBy                `protobuf:"varint,6,opt,name=order_by,json=orderBy,proto3,enum=buf.alpha.registry.v1alpha1.OrderBy"`
	xxx_hidden_Reverse         bool                   `protobuf:"varint,7,opt,name=reverse,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *SearchDraftRequest) Reset() {
	*x = SearchDraftRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDraftRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDraftRequest) ProtoMessage() {}

func (x *SearchDraftRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchDraftRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *SearchDraftRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *SearchDraftRequest) GetQuery() string {
	if x != nil {
		return x.xxx_hidden_Query
	}
	return ""
}

func (x *SearchDraftRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *SearchDraftRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *SearchDraftRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.xxx_hidden_OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *SearchDraftRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *SearchDraftRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *SearchDraftRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *SearchDraftRequest) SetQuery(v string) {
	x.xxx_hidden_Query = v
}

func (x *SearchDraftRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *SearchDraftRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *SearchDraftRequest) SetOrderBy(v OrderBy) {
	x.xxx_hidden_OrderBy = v
}

func (x *SearchDraftRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type SearchDraftRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the repository.
	RepositoryOwner string
	// The name of the repository.
	RepositoryName string
	// The search string.
	Query    string
	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	// The field to order results by.
	OrderBy OrderBy
	// Reverse orders results in descending order.
	Reverse bool
}

func (b0 SearchDraftRequest_builder) Build() *SearchDraftRequest {
	m0 := &SearchDraftRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Query = b.Query
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_OrderBy = b.OrderBy
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type SearchDraftResponse struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryCommits *[]*RepositoryCommit   `protobuf:"bytes,1,rep,name=repository_commits,json=repositoryCommits,proto3"`
	xxx_hidden_NextPageToken     string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *SearchDraftResponse) Reset() {
	*x = SearchDraftResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDraftResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDraftResponse) ProtoMessage() {}

func (x *SearchDraftResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchDraftResponse) GetRepositoryCommits() []*RepositoryCommit {
	if x != nil {
		if x.xxx_hidden_RepositoryCommits != nil {
			return *x.xxx_hidden_RepositoryCommits
		}
	}
	return nil
}

func (x *SearchDraftResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *SearchDraftResponse) SetRepositoryCommits(v []*RepositoryCommit) {
	x.xxx_hidden_RepositoryCommits = &v
}

func (x *SearchDraftResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type SearchDraftResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryCommits []*RepositoryCommit
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 SearchDraftResponse_builder) Build() *SearchDraftResponse {
	m0 := &SearchDraftResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryCommits = &b.RepositoryCommits
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type SearchModuleContentRequest struct {
	state                         protoimpl.MessageState      `protogen:"opaque.v1"`
	xxx_hidden_Query              string                      `protobuf:"bytes,1,opt,name=query,proto3"`
	xxx_hidden_PageSize           uint32                      `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken          uint32                      `protobuf:"varint,3,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Filters            []SearchModuleContentFilter `protobuf:"varint,4,rep,packed,name=filters,proto3,enum=buf.alpha.registry.v1alpha1.SearchModuleContentFilter"`
	xxx_hidden_RepositoryFullName string                      `protobuf:"bytes,5,opt,name=repository_full_name,json=repositoryFullName,proto3"`
	xxx_hidden_RepositoryOwner    string                      `protobuf:"bytes,6,opt,name=repository_owner,json=repositoryOwner,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *SearchModuleContentRequest) Reset() {
	*x = SearchModuleContentRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchModuleContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchModuleContentRequest) ProtoMessage() {}

func (x *SearchModuleContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchModuleContentRequest) GetQuery() string {
	if x != nil {
		return x.xxx_hidden_Query
	}
	return ""
}

func (x *SearchModuleContentRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *SearchModuleContentRequest) GetPageToken() uint32 {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return 0
}

func (x *SearchModuleContentRequest) GetFilters() []SearchModuleContentFilter {
	if x != nil {
		return x.xxx_hidden_Filters
	}
	return nil
}

func (x *SearchModuleContentRequest) GetRepositoryFullName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryFullName
	}
	return ""
}

func (x *SearchModuleContentRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *SearchModuleContentRequest) SetQuery(v string) {
	x.xxx_hidden_Query = v
}

func (x *SearchModuleContentRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *SearchModuleContentRequest) SetPageToken(v uint32) {
	x.xxx_hidden_PageToken = v
}

func (x *SearchModuleContentRequest) SetFilters(v []SearchModuleContentFilter) {
	x.xxx_hidden_Filters = v
}

func (x *SearchModuleContentRequest) SetRepositoryFullName(v string) {
	x.xxx_hidden_RepositoryFullName = v
}

func (x *SearchModuleContentRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

type SearchModuleContentRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The search string.
	Query    string
	PageSize uint32
	// The first page is returned if this is 0.
	PageToken uint32
	// Empty list means show all. Supplying one or more enums will
	// limit the search to only the requested resources.
	// Supplying all possible enums is equivalent to empty list of filters.
	Filters []SearchModuleContentFilter
	// Optional, if provided the search results will be limited to the provided repository.
	RepositoryFullName string
	// Optional, if provided the search results will be limited to the provided owner,
	// ignored if repository_full_name is provided.
	RepositoryOwner string
}

func (b0 SearchModuleContentRequest_builder) Build() *SearchModuleContentRequest {
	m0 := &SearchModuleContentRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Query = b.Query
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Filters = b.Filters
	x.xxx_hidden_RepositoryFullName = b.RepositoryFullName
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	return m0
}

type SearchModuleContentResponse struct {
	state                    protoimpl.MessageState        `protogen:"opaque.v1"`
	xxx_hidden_SearchResults *[]*SearchModuleContentResult `protobuf:"bytes,1,rep,name=search_results,json=searchResults,proto3"`
	xxx_hidden_NextPageToken uint32                        `protobuf:"varint,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *SearchModuleContentResponse) Reset() {
	*x = SearchModuleContentResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchModuleContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchModuleContentResponse) ProtoMessage() {}

func (x *SearchModuleContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SearchModuleContentResponse) GetSearchResults() []*SearchModuleContentResult {
	if x != nil {
		if x.xxx_hidden_SearchResults != nil {
			return *x.xxx_hidden_SearchResults
		}
	}
	return nil
}

func (x *SearchModuleContentResponse) GetNextPageToken() uint32 {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return 0
}

func (x *SearchModuleContentResponse) SetSearchResults(v []*SearchModuleContentResult) {
	x.xxx_hidden_SearchResults = &v
}

func (x *SearchModuleContentResponse) SetNextPageToken(v uint32) {
	x.xxx_hidden_NextPageToken = v
}

type SearchModuleContentResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	SearchResults []*SearchModuleContentResult
	// There are no more pages if this is 0.
	NextPageToken uint32
}

func (b0 SearchModuleContentResponse_builder) Build() *SearchModuleContentResponse {
	m0 := &SearchModuleContentResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_SearchResults = &b.SearchResults
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

var File_buf_alpha_registry_v1alpha1_search_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_search_proto_rawDesc = "" +
	"\n" +
	"(buf/alpha/registry/v1alpha1/search.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a%buf/alpha/registry/v1alpha1/doc.proto\x1a1buf/alpha/registry/v1alpha1/plugin_curation.proto\x1a,buf/alpha/registry/v1alpha1/repository.proto\x1a3buf/alpha/registry/v1alpha1/repository_commit.proto\x1a0buf/alpha/registry/v1alpha1/repository_tag.proto\x1a5buf/alpha/registry/v1alpha1/verification_status.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xb9\x03\n" +
	"\x16RepositorySearchResult\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x14\n" +
	"\x05owner\x18\x03 \x01(\tR\x05owner\x12G\n" +
	"\n" +
	"visibility\x18\x04 \x01(\x0e2'.buf.alpha.registry.v1alpha1.VisibilityR\n" +
	"visibility\x12\x1e\n" +
	"\n" +
	"deprecated\x18\x05 \x01(\bR\n" +
	"deprecated\x123\n" +
	"\x16latest_spdx_license_id\x18\x06 \x01(\tR\x13latestSpdxLicenseId\x12k\n" +
	"\x19owner_verification_status\x18\a \x01(\x0e2/.buf.alpha.registry.v1alpha1.VerificationStatusR\x17ownerVerificationStatus\x12\x10\n" +
	"\x03url\x18\b \x01(\tR\x03url\x12H\n" +
	"\x12latest_commit_time\x18\t \x01(\v2\x1a.google.protobuf.TimestampR\x10latestCommitTime\"{\n" +
	"\x18OrganizationSearchResult\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12;\n" +
	"\vcreate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\"\x9d\x01\n" +
	"\x10UserSearchResult\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1a\n" +
	"\busername\x18\x02 \x01(\tR\busername\x12 \n" +
	"\vdeactivated\x18\x03 \x01(\bR\vdeactivated\x12;\n" +
	"\vcreate_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\"c\n" +
	"\x10TeamSearchResult\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12+\n" +
	"\x11organization_name\x18\x03 \x01(\tR\x10organizationName\"\x82\x03\n" +
	"\x19CuratedPluginSearchResult\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x14\n" +
	"\x05owner\x18\x03 \x01(\tR\x05owner\x12\x1e\n" +
	"\n" +
	"deprecated\x18\x04 \x01(\bR\n" +
	"deprecated\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12T\n" +
	"\rregistry_type\x18\x06 \x01(\x0e2/.buf.alpha.registry.v1alpha1.PluginRegistryTypeR\fregistryType\x12V\n" +
	"\x10output_languages\x18\a \x03(\x0e2+.buf.alpha.registry.v1alpha1.PluginLanguageR\x0foutputLanguages\x12;\n" +
	"\vcreate_time\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\"\x84\x03\n" +
	"\x19ModuleElementSearchResult\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12)\n" +
	"\x10repository_owner\x18\x02 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x03 \x01(\tR\x0erepositoryName\x12&\n" +
	"\x0fproto_file_path\x18\x04 \x01(\tR\rprotoFilePath\x120\n" +
	"\x14fully_qualified_name\x18\x05 \x01(\tR\x12fullyQualifiedName\x12!\n" +
	"\fpackage_name\x18\x06 \x01(\tR\vpackageName\x12q\n" +
	"\x1asearch_module_element_type\x18\a \x01(\x0e24.buf.alpha.registry.v1alpha1.SearchModuleElementTypeR\x17searchModuleElementType\"\xb9\x01\n" +
	"\x16ModuleFileSearchResult\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12)\n" +
	"\x10repository_owner\x18\x02 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x03 \x01(\tR\x0erepositoryName\x12&\n" +
	"\x0fproto_file_path\x18\x04 \x01(\tR\rprotoFilePath\"\x8c\x05\n" +
	"\fSearchResult\x12U\n" +
	"\n" +
	"repository\x18\x01 \x01(\v23.buf.alpha.registry.v1alpha1.RepositorySearchResultH\x00R\n" +
	"repository\x12[\n" +
	"\forganization\x18\x02 \x01(\v25.buf.alpha.registry.v1alpha1.OrganizationSearchResultH\x00R\forganization\x12C\n" +
	"\x04user\x18\x03 \x01(\v2-.buf.alpha.registry.v1alpha1.UserSearchResultH\x00R\x04user\x12C\n" +
	"\x04team\x18\x04 \x01(\v2-.buf.alpha.registry.v1alpha1.TeamSearchResultH\x00R\x04team\x12_\n" +
	"\x0ecurated_plugin\x18\a \x01(\v26.buf.alpha.registry.v1alpha1.CuratedPluginSearchResultH\x00R\rcuratedPlugin\x12_\n" +
	"\x0emodule_element\x18\b \x01(\v26.buf.alpha.registry.v1alpha1.ModuleElementSearchResultH\x00R\rmoduleElement\x12V\n" +
	"\vmodule_file\x18\t \x01(\v23.buf.alpha.registry.v1alpha1.ModuleFileSearchResultH\x00R\n" +
	"moduleFileB\x06\n" +
	"\x04itemJ\x04\b\x05\x10\x06J\x04\b\x06\x10\aR\x06pluginR\btemplate\"\xc5\x04\n" +
	"\x13ElementSearchResult\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12)\n" +
	"\x10repository_owner\x18\x02 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x03 \x01(\tR\x0erepositoryName\x12&\n" +
	"\x0fproto_file_path\x18\x04 \x01(\tR\rprotoFilePath\x120\n" +
	"\x14fully_qualified_name\x18\x05 \x01(\tR\x12fullyQualifiedName\x12@\n" +
	"\aservice\x18\x06 \x01(\v2$.buf.alpha.registry.v1alpha1.ServiceH\x00R\aservice\x12=\n" +
	"\x06method\x18\a \x01(\v2#.buf.alpha.registry.v1alpha1.MethodH\x00R\x06method\x127\n" +
	"\x04enum\x18\b \x01(\v2!.buf.alpha.registry.v1alpha1.EnumH\x00R\x04enum\x12@\n" +
	"\amessage\x18\t \x01(\v2$.buf.alpha.registry.v1alpha1.MessageH\x00R\amessage\x12S\n" +
	"\x0efile_extension\x18\n" +
	" \x01(\v2*.buf.alpha.registry.v1alpha1.FileExtensionH\x00R\rfileExtensionB\n" +
	"\n" +
	"\bdocument\"\xcd\x01\n" +
	"\x10FileSearchResult\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12)\n" +
	"\x10repository_owner\x18\x02 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x03 \x01(\tR\x0erepositoryName\x12&\n" +
	"\x0fproto_file_path\x18\x04 \x01(\tR\rprotoFilePath\x12\x18\n" +
	"\acontent\x18\x05 \x01(\fR\acontent\"\xb6\x01\n" +
	"\x19SearchModuleContentResult\x12L\n" +
	"\aelement\x18\x01 \x01(\v20.buf.alpha.registry.v1alpha1.ElementSearchResultH\x00R\aelement\x12C\n" +
	"\x04file\x18\x02 \x01(\v2-.buf.alpha.registry.v1alpha1.FileSearchResultH\x00R\x04fileB\x06\n" +
	"\x04item\"\xa6\x01\n" +
	"\rSearchRequest\x12\x14\n" +
	"\x05query\x18\x01 \x01(\tR\x05query\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\rR\tpageToken\x12C\n" +
	"\afilters\x18\x04 \x03(\x0e2).buf.alpha.registry.v1alpha1.SearchFilterR\afilters\"\x8a\x01\n" +
	"\x0eSearchResponse\x12P\n" +
	"\x0esearch_results\x18\x01 \x03(\v2).buf.alpha.registry.v1alpha1.SearchResultR\rsearchResults\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\rR\rnextPageToken\"\x93\x02\n" +
	"\x10SearchTagRequest\x12)\n" +
	"\x10repository_owner\x18\x01 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12\x14\n" +
	"\x05query\x18\x03 \x01(\tR\x05query\x12\x1b\n" +
	"\tpage_size\x18\x04 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x05 \x01(\tR\tpageToken\x12?\n" +
	"\border_by\x18\x06 \x01(\x0e2$.buf.alpha.registry.v1alpha1.OrderByR\aorderBy\x12\x18\n" +
	"\areverse\x18\a \x01(\bR\areverse\"\x90\x01\n" +
	"\x11SearchTagResponse\x12S\n" +
	"\x0frepository_tags\x18\x01 \x03(\v2*.buf.alpha.registry.v1alpha1.RepositoryTagR\x0erepositoryTags\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x95\x02\n" +
	"\x12SearchDraftRequest\x12)\n" +
	"\x10repository_owner\x18\x01 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12\x14\n" +
	"\x05query\x18\x03 \x01(\tR\x05query\x12\x1b\n" +
	"\tpage_size\x18\x04 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x05 \x01(\tR\tpageToken\x12?\n" +
	"\border_by\x18\x06 \x01(\x0e2$.buf.alpha.registry.v1alpha1.OrderByR\aorderBy\x12\x18\n" +
	"\areverse\x18\a \x01(\bR\areverse\"\x9b\x01\n" +
	"\x13SearchDraftResponse\x12\\\n" +
	"\x12repository_commits\x18\x01 \x03(\v2-.buf.alpha.registry.v1alpha1.RepositoryCommitR\x11repositoryCommits\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x9d\x02\n" +
	"\x1aSearchModuleContentRequest\x12\x14\n" +
	"\x05query\x18\x01 \x01(\tR\x05query\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\rR\tpageToken\x12P\n" +
	"\afilters\x18\x04 \x03(\x0e26.buf.alpha.registry.v1alpha1.SearchModuleContentFilterR\afilters\x120\n" +
	"\x14repository_full_name\x18\x05 \x01(\tR\x12repositoryFullName\x12)\n" +
	"\x10repository_owner\x18\x06 \x01(\tR\x0frepositoryOwner\"\xa4\x01\n" +
	"\x1bSearchModuleContentResponse\x12]\n" +
	"\x0esearch_results\x18\x01 \x03(\v26.buf.alpha.registry.v1alpha1.SearchModuleContentResultR\rsearchResults\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\rR\rnextPageToken*\xb8\x02\n" +
	"\fSearchFilter\x12\x1d\n" +
	"\x19SEARCH_FILTER_UNSPECIFIED\x10\x00\x12\x16\n" +
	"\x12SEARCH_FILTER_USER\x10\x01\x12\x1e\n" +
	"\x1aSEARCH_FILTER_ORGANIZATION\x10\x02\x12\x1c\n" +
	"\x18SEARCH_FILTER_REPOSITORY\x10\x03\x12\x16\n" +
	"\x12SEARCH_FILTER_TEAM\x10\x06\x12 \n" +
	"\x1cSEARCH_FILTER_CURATED_PLUGIN\x10\a\x12 \n" +
	"\x1cSEARCH_FILTER_MODULE_ELEMENT\x10\b\x12\x1d\n" +
	"\x19SEARCH_FILTER_MODULE_FILE\x10\t\"\x04\b\x04\x10\x04\"\x04\b\x05\x10\x05*\x14SEARCH_FILTER_PLUGIN*\x16SEARCH_FILTER_TEMPLATE*j\n" +
	"\aOrderBy\x12\x18\n" +
	"\x14ORDER_BY_UNSPECIFIED\x10\x00\x12\x18\n" +
	"\x14ORDER_BY_CREATE_TIME\x10\x01\x12\x18\n" +
	"\x14ORDER_BY_UPDATE_TIME\x10\x02\x12\x11\n" +
	"\rORDER_BY_NAME\x10\x03*\xe1\x01\n" +
	"\x17SearchModuleElementType\x12*\n" +
	"&SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED\x10\x00\x12&\n" +
	"\"SEARCH_MODULE_ELEMENT_TYPE_SERVICE\x10\x01\x12%\n" +
	"!SEARCH_MODULE_ELEMENT_TYPE_METHOD\x10\x02\x12&\n" +
	"\"SEARCH_MODULE_ELEMENT_TYPE_MESSAGE\x10\x03\x12#\n" +
	"\x1fSEARCH_MODULE_ELEMENT_TYPE_ENUM\x10\x04*\x9a\x01\n" +
	"\x19SearchModuleContentFilter\x12,\n" +
	"(SEARCH_MODULE_CONTENT_FILTER_UNSPECIFIED\x10\x00\x12(\n" +
	"$SEARCH_MODULE_CONTENT_FILTER_ELEMENT\x10\x01\x12%\n" +
	"!SEARCH_MODULE_CONTENT_FILTER_FILE\x10\x022\xef\x03\n" +
	"\rSearchService\x12f\n" +
	"\x06Search\x12*.buf.alpha.registry.v1alpha1.SearchRequest\x1a+.buf.alpha.registry.v1alpha1.SearchResponse\"\x03\x90\x02\x01\x12o\n" +
	"\tSearchTag\x12-.buf.alpha.registry.v1alpha1.SearchTagRequest\x1a..buf.alpha.registry.v1alpha1.SearchTagResponse\"\x03\x90\x02\x01\x12u\n" +
	"\vSearchDraft\x12/.buf.alpha.registry.v1alpha1.SearchDraftRequest\x1a0.buf.alpha.registry.v1alpha1.SearchDraftResponse\"\x03\x90\x02\x01\x12\x8d\x01\n" +
	"\x13SearchModuleContent\x127.buf.alpha.registry.v1alpha1.SearchModuleContentRequest\x1a8.buf.alpha.registry.v1alpha1.SearchModuleContentResponse\"\x03\x90\x02\x01B\x98\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\vSearchProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_search_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_buf_alpha_registry_v1alpha1_search_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_buf_alpha_registry_v1alpha1_search_proto_goTypes = []any{
	(SearchFilter)(0),                   // 0: buf.alpha.registry.v1alpha1.SearchFilter
	(OrderBy)(0),                        // 1: buf.alpha.registry.v1alpha1.OrderBy
	(SearchModuleElementType)(0),        // 2: buf.alpha.registry.v1alpha1.SearchModuleElementType
	(SearchModuleContentFilter)(0),      // 3: buf.alpha.registry.v1alpha1.SearchModuleContentFilter
	(*RepositorySearchResult)(nil),      // 4: buf.alpha.registry.v1alpha1.RepositorySearchResult
	(*OrganizationSearchResult)(nil),    // 5: buf.alpha.registry.v1alpha1.OrganizationSearchResult
	(*UserSearchResult)(nil),            // 6: buf.alpha.registry.v1alpha1.UserSearchResult
	(*TeamSearchResult)(nil),            // 7: buf.alpha.registry.v1alpha1.TeamSearchResult
	(*CuratedPluginSearchResult)(nil),   // 8: buf.alpha.registry.v1alpha1.CuratedPluginSearchResult
	(*ModuleElementSearchResult)(nil),   // 9: buf.alpha.registry.v1alpha1.ModuleElementSearchResult
	(*ModuleFileSearchResult)(nil),      // 10: buf.alpha.registry.v1alpha1.ModuleFileSearchResult
	(*SearchResult)(nil),                // 11: buf.alpha.registry.v1alpha1.SearchResult
	(*ElementSearchResult)(nil),         // 12: buf.alpha.registry.v1alpha1.ElementSearchResult
	(*FileSearchResult)(nil),            // 13: buf.alpha.registry.v1alpha1.FileSearchResult
	(*SearchModuleContentResult)(nil),   // 14: buf.alpha.registry.v1alpha1.SearchModuleContentResult
	(*SearchRequest)(nil),               // 15: buf.alpha.registry.v1alpha1.SearchRequest
	(*SearchResponse)(nil),              // 16: buf.alpha.registry.v1alpha1.SearchResponse
	(*SearchTagRequest)(nil),            // 17: buf.alpha.registry.v1alpha1.SearchTagRequest
	(*SearchTagResponse)(nil),           // 18: buf.alpha.registry.v1alpha1.SearchTagResponse
	(*SearchDraftRequest)(nil),          // 19: buf.alpha.registry.v1alpha1.SearchDraftRequest
	(*SearchDraftResponse)(nil),         // 20: buf.alpha.registry.v1alpha1.SearchDraftResponse
	(*SearchModuleContentRequest)(nil),  // 21: buf.alpha.registry.v1alpha1.SearchModuleContentRequest
	(*SearchModuleContentResponse)(nil), // 22: buf.alpha.registry.v1alpha1.SearchModuleContentResponse
	(Visibility)(0),                     // 23: buf.alpha.registry.v1alpha1.Visibility
	(VerificationStatus)(0),             // 24: buf.alpha.registry.v1alpha1.VerificationStatus
	(*timestamppb.Timestamp)(nil),       // 25: google.protobuf.Timestamp
	(PluginRegistryType)(0),             // 26: buf.alpha.registry.v1alpha1.PluginRegistryType
	(PluginLanguage)(0),                 // 27: buf.alpha.registry.v1alpha1.PluginLanguage
	(*Service)(nil),                     // 28: buf.alpha.registry.v1alpha1.Service
	(*Method)(nil),                      // 29: buf.alpha.registry.v1alpha1.Method
	(*Enum)(nil),                        // 30: buf.alpha.registry.v1alpha1.Enum
	(*Message)(nil),                     // 31: buf.alpha.registry.v1alpha1.Message
	(*FileExtension)(nil),               // 32: buf.alpha.registry.v1alpha1.FileExtension
	(*RepositoryTag)(nil),               // 33: buf.alpha.registry.v1alpha1.RepositoryTag
	(*RepositoryCommit)(nil),            // 34: buf.alpha.registry.v1alpha1.RepositoryCommit
}
var file_buf_alpha_registry_v1alpha1_search_proto_depIdxs = []int32{
	23, // 0: buf.alpha.registry.v1alpha1.RepositorySearchResult.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	24, // 1: buf.alpha.registry.v1alpha1.RepositorySearchResult.owner_verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	25, // 2: buf.alpha.registry.v1alpha1.RepositorySearchResult.latest_commit_time:type_name -> google.protobuf.Timestamp
	25, // 3: buf.alpha.registry.v1alpha1.OrganizationSearchResult.create_time:type_name -> google.protobuf.Timestamp
	25, // 4: buf.alpha.registry.v1alpha1.UserSearchResult.create_time:type_name -> google.protobuf.Timestamp
	26, // 5: buf.alpha.registry.v1alpha1.CuratedPluginSearchResult.registry_type:type_name -> buf.alpha.registry.v1alpha1.PluginRegistryType
	27, // 6: buf.alpha.registry.v1alpha1.CuratedPluginSearchResult.output_languages:type_name -> buf.alpha.registry.v1alpha1.PluginLanguage
	25, // 7: buf.alpha.registry.v1alpha1.CuratedPluginSearchResult.create_time:type_name -> google.protobuf.Timestamp
	2,  // 8: buf.alpha.registry.v1alpha1.ModuleElementSearchResult.search_module_element_type:type_name -> buf.alpha.registry.v1alpha1.SearchModuleElementType
	4,  // 9: buf.alpha.registry.v1alpha1.SearchResult.repository:type_name -> buf.alpha.registry.v1alpha1.RepositorySearchResult
	5,  // 10: buf.alpha.registry.v1alpha1.SearchResult.organization:type_name -> buf.alpha.registry.v1alpha1.OrganizationSearchResult
	6,  // 11: buf.alpha.registry.v1alpha1.SearchResult.user:type_name -> buf.alpha.registry.v1alpha1.UserSearchResult
	7,  // 12: buf.alpha.registry.v1alpha1.SearchResult.team:type_name -> buf.alpha.registry.v1alpha1.TeamSearchResult
	8,  // 13: buf.alpha.registry.v1alpha1.SearchResult.curated_plugin:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginSearchResult
	9,  // 14: buf.alpha.registry.v1alpha1.SearchResult.module_element:type_name -> buf.alpha.registry.v1alpha1.ModuleElementSearchResult
	10, // 15: buf.alpha.registry.v1alpha1.SearchResult.module_file:type_name -> buf.alpha.registry.v1alpha1.ModuleFileSearchResult
	28, // 16: buf.alpha.registry.v1alpha1.ElementSearchResult.service:type_name -> buf.alpha.registry.v1alpha1.Service
	29, // 17: buf.alpha.registry.v1alpha1.ElementSearchResult.method:type_name -> buf.alpha.registry.v1alpha1.Method
	30, // 18: buf.alpha.registry.v1alpha1.ElementSearchResult.enum:type_name -> buf.alpha.registry.v1alpha1.Enum
	31, // 19: buf.alpha.registry.v1alpha1.ElementSearchResult.message:type_name -> buf.alpha.registry.v1alpha1.Message
	32, // 20: buf.alpha.registry.v1alpha1.ElementSearchResult.file_extension:type_name -> buf.alpha.registry.v1alpha1.FileExtension
	12, // 21: buf.alpha.registry.v1alpha1.SearchModuleContentResult.element:type_name -> buf.alpha.registry.v1alpha1.ElementSearchResult
	13, // 22: buf.alpha.registry.v1alpha1.SearchModuleContentResult.file:type_name -> buf.alpha.registry.v1alpha1.FileSearchResult
	0,  // 23: buf.alpha.registry.v1alpha1.SearchRequest.filters:type_name -> buf.alpha.registry.v1alpha1.SearchFilter
	11, // 24: buf.alpha.registry.v1alpha1.SearchResponse.search_results:type_name -> buf.alpha.registry.v1alpha1.SearchResult
	1,  // 25: buf.alpha.registry.v1alpha1.SearchTagRequest.order_by:type_name -> buf.alpha.registry.v1alpha1.OrderBy
	33, // 26: buf.alpha.registry.v1alpha1.SearchTagResponse.repository_tags:type_name -> buf.alpha.registry.v1alpha1.RepositoryTag
	1,  // 27: buf.alpha.registry.v1alpha1.SearchDraftRequest.order_by:type_name -> buf.alpha.registry.v1alpha1.OrderBy
	34, // 28: buf.alpha.registry.v1alpha1.SearchDraftResponse.repository_commits:type_name -> buf.alpha.registry.v1alpha1.RepositoryCommit
	3,  // 29: buf.alpha.registry.v1alpha1.SearchModuleContentRequest.filters:type_name -> buf.alpha.registry.v1alpha1.SearchModuleContentFilter
	14, // 30: buf.alpha.registry.v1alpha1.SearchModuleContentResponse.search_results:type_name -> buf.alpha.registry.v1alpha1.SearchModuleContentResult
	15, // 31: buf.alpha.registry.v1alpha1.SearchService.Search:input_type -> buf.alpha.registry.v1alpha1.SearchRequest
	17, // 32: buf.alpha.registry.v1alpha1.SearchService.SearchTag:input_type -> buf.alpha.registry.v1alpha1.SearchTagRequest
	19, // 33: buf.alpha.registry.v1alpha1.SearchService.SearchDraft:input_type -> buf.alpha.registry.v1alpha1.SearchDraftRequest
	21, // 34: buf.alpha.registry.v1alpha1.SearchService.SearchModuleContent:input_type -> buf.alpha.registry.v1alpha1.SearchModuleContentRequest
	16, // 35: buf.alpha.registry.v1alpha1.SearchService.Search:output_type -> buf.alpha.registry.v1alpha1.SearchResponse
	18, // 36: buf.alpha.registry.v1alpha1.SearchService.SearchTag:output_type -> buf.alpha.registry.v1alpha1.SearchTagResponse
	20, // 37: buf.alpha.registry.v1alpha1.SearchService.SearchDraft:output_type -> buf.alpha.registry.v1alpha1.SearchDraftResponse
	22, // 38: buf.alpha.registry.v1alpha1.SearchService.SearchModuleContent:output_type -> buf.alpha.registry.v1alpha1.SearchModuleContentResponse
	35, // [35:39] is the sub-list for method output_type
	31, // [31:35] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_search_proto_init() }
func file_buf_alpha_registry_v1alpha1_search_proto_init() {
	if File_buf_alpha_registry_v1alpha1_search_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_doc_proto_init()
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_commit_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_tag_proto_init()
	file_buf_alpha_registry_v1alpha1_verification_status_proto_init()
	file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[7].OneofWrappers = []any{
		(*searchResult_Repository)(nil),
		(*searchResult_Organization)(nil),
		(*searchResult_User)(nil),
		(*searchResult_Team)(nil),
		(*searchResult_CuratedPlugin)(nil),
		(*searchResult_ModuleElement)(nil),
		(*searchResult_ModuleFile)(nil),
	}
	file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[8].OneofWrappers = []any{
		(*elementSearchResult_Service)(nil),
		(*elementSearchResult_Method)(nil),
		(*elementSearchResult_Enum)(nil),
		(*elementSearchResult_Message)(nil),
		(*elementSearchResult_FileExtension)(nil),
	}
	file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[10].OneofWrappers = []any{
		(*searchModuleContentResult_Element)(nil),
		(*searchModuleContentResult_File)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_search_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_search_proto_rawDesc)),
			NumEnums:      4,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_search_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_search_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_search_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_search_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_search_proto = out.File
	file_buf_alpha_registry_v1alpha1_search_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_search_proto_depIdxs = nil
}
