package builtin.kubernetes.KSV038

import rego.v1

test_networkpolicy_with_spec_pod_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "access-nginx"},
		"spec": {
			"podSelector": {"matchLabels": {"app": "nginx"}},
			"ingress": [{"from": [{"podSelector": {"matchLabels": {"access": "true"}}}]}],
		},
	}

	count(r) == 0
}

test_networkpolicy_without_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "access-nginx"},
		"spec": {"ingress": [{"from": [{}]}]},
	}

	r[_].msg == "Network policy should uses podSelector and/or the namespaceSelector to restrict ingress and egress traffic within the Pod network"
}

test_networkpolicy_with_spec_namespace_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "access-nginx"},
		"spec": {
			"namespaceSelector": {"matchLabels": {"app": "nginx"}},
			"ingress": [{"from": [{"podSelector": {"matchLabels": {"access": "true"}}}]}],
		},
	}

	count(r) == 0
}

test_networkpolicy_with_ingress_pod_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "access-nginx"},
		"spec": {"ingress": [{"from": [{"podSelector": {"matchLabels": {"access": "true"}}}]}]},
	}

	count(r) == 0
}

test_networkpolicy_with_ingress_namespace_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "access-nginx"},
		"spec": {"ingress": [{"from": [{"namespaceSelector": {"matchLabels": {"access": "true"}}}]}]},
	}

	count(r) == 0
}

test_networkpolicy_with_egress_namespace_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "access-nginx"},
		"spec": {"egress": [{"to": [{"namespaceSelector": {"matchLabels": {"access": "true"}}}]}]},
	}

	count(r) == 0
}

test_networkpolicy_with_egress_pod_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "access-nginx"},
		"spec": {"egress": [{"to": [{"podSelector": {"matchLabels": {"access": "true"}}}]}]},
	}

	count(r) == 0
}

test_networkpolicy_with_deny_all_egress_pod_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "deny-all-egress"},
		"spec": {
			"podSelector": {},
			"policyType": ["Egress"],
		},
	}

	count(r) == 0
}

test_networkpolicy_with_deny_all_ingress_pod_selector if {
	r := deny with input as {
		"apiVersion": "networking.k8s.io/v1",
		"kind": "NetworkPolicy",
		"metadata": {"name": "deny-all-ingress"},
		"spec": {
			"podSelector": {},
			"policyType": ["Ingress"],
		},
	}

	count(r) == 0
}

test_service if {
	r := deny with input as {
		"apiVersion": "v1",
		"kind": "Service",
		"spec": {
			"clusterIP": "None",
			"internalTrafficPolicy": "Cluster",
			"ipFamilyPolicy": "SingleStack",
			"selector": {"app": "x"},
			"sessionAffinity": "None",
			"type": "ClusterIP",
		},
	}

	count(r) == 0
}
