package builtin.dockerfile.DS029

import rego.v1

test_denied if {
	r := deny with input as {"Stages": [{"Name": "node:12", "Commands": [
		{
			"Cmd": "from",
			"Value": ["node:12"],
		},
		{
			"Cmd": "run",
			"Value": ["apt-get install -y python=2.7"],
		},
	]}]}

	count(r) == 1
	r[_].msg == "'--no-install-recommends' flag is missed: 'apt-get install -y python=2.7'"
}

test_json_array_denied if {
	r := deny with input as {"Stages": [{"Name": "node:12", "Commands": [
		{
			"Cmd": "from",
			"Value": ["node:12"],
		},
		{
			"Cmd": "run",
			"Value": [
				"apt-get",
				"install",
				"-y",
				"apt-utils",
			],
		},
	]}]}

	count(r) == 1
	r[_].msg == "'--no-install-recommends' flag is missed: 'apt-get install -y apt-utils'"
}

test_allowed if {
	r := deny with input as {"Stages": [{"Name": "node:12", "Commands": [
		{
			"Cmd": "from",
			"Value": ["node:12"],
		},
		{
			"Cmd": "run",
			"Value": ["apt-get -fmy install --no-install-recommends apt-utils"],
		},
	]}]}

	count(r) == 0
}

test_with_flag_behind_allowed if {
	r := deny with input as {"Stages": [{"Name": "node:12", "Commands": [
		{
			"Cmd": "from",
			"Value": ["node:12"],
		},
		{
			"Cmd": "run",
			"Value": ["apt-get --no-install-recommends install -fmy apt-utils"],
		},
	]}]}

	count(r) == 0
}

test_json_array_long_flag_allowed if {
	r := deny with input as {"Stages": [{"Name": "node:12", "Commands": [
		{
			"Cmd": "from",
			"Value": ["node:12"],
		},
		{
			"Cmd": "run",
			"Value": [
				"apt-get",
				"--yes",
				"-q",
				"--no-install-recommends",
				"install",
				"apt-utils",
			],
		},
	]}]}

	count(r) == 0
}

test_chained_allowed if {
	r := deny with input as {"Stages": [{"Name": "node:12", "Commands": [
		{
			"Cmd": "from",
			"Value": ["node:12"],
		},
		{
			"Cmd": "run",
			"Value": ["apt-get update && apt-get --no-install-recommends -y install apt-utils"],
		},
	]}]}

	count(r) == 0
}

test_flags_after_pkgs_allowed if {
	r := deny with input as {"Stages": [{"Name": "debian:11-slim", "Commands": [
		{
			"Cmd": "from",
			"Value": ["debian:11-slim"],
		},
		{
			"Cmd": "run",
			"Value": ["apt-get update && DEBIAN_FRONTEND=noninteractive apt-get install -y tzdata postgresql-10 --no-install-recommends && rm -rf /var/lib/apt/lists/*"],
		},
	]}]}
	count(r) == 0
}
