# METADATA
# title: GitHub repository has vulnerability alerts disabled.
# description: |
#   GitHub repository should be set to use vulnerability alerts.
#
#   You can do this by setting the <code>vulnerability_alerts</code> attribute to 'true'.
# scope: package
# schemas:
#   - input: schema["cloud"]
# related_resources:
#   - https://docs.github.com/en/code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/about-alerts-for-vulnerable-dependencies
# custom:
#   id: AVD-GIT-0003
#   avd_id: AVD-GIT-0003
#   provider: github
#   service: repositories
#   severity: HIGH
#   short_code: enable_vulnerability_alerts
#   recommended_action: Enable vulnerability alerts
#   input:
#     selector:
#       - type: cloud
#         subtypes:
#           - service: repositories
#             provider: github
#   examples: checks/cloud/github/repositories/enable_vulnerability_alerts.yaml
package builtin.github.repositories.github0003

import rego.v1

deny contains res if {
	some repo in input.github.repositories
	not repo.archived.value
	repo.vulnerabilityalerts.value == false
	res := result.new("Repository does not have vulnerability alerts enabled", repo.vulnerabilityalerts)
}
