// Copyright 2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: pluginrpc/v1/pluginrpc.proto

// Interfaces for the pluginrpc system.
//
// These interfaces define how requests and responses and sent over stdin and stdout, as well
// as define how procedures are specified.
//
// These interfaces will work if a given plugin responds to `--protocol` with `1`.

//go:build protoopaque

package pluginrpcv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A code for an error.
//
// Matches with google.rpc.Code.
type Code int32

const (
	// The zero value.
	Code_CODE_UNSPECIFIED Code = 0
	// Indicates that the operation was canceled, typically by the
	Code_CODE_CANCELED Code = 1
	// Indicates that the operation failed for an unknown reason.
	Code_CODE_UNKNOWN Code = 2
	// Indicates that client supplied an invalid argument.
	Code_CODE_INVALID_ARGUMENT Code = 3
	// Indicates that deadline expired before the operation could complete.
	Code_CODE_DEADLINE_EXCEEDED Code = 4
	// Indicates that some requested entity (for example, a file or directory)
	// was not found.
	Code_CODE_NOT_FOUND Code = 5
	// Indicates that client attempted to create an entity (for example, a file
	// or directory) that already exists.
	Code_CODE_ALREADY_EXISTS Code = 6
	// Indicates that the caller doesn't have permission to execute the
	// specified operation.
	Code_CODE_PERMISSION_DENIED Code = 7
	// Indicates that some resource has been exhausted. For example, a per-user
	// quota may be exhausted or the entire file system may be full.
	Code_CODE_RESOURCE_EXHAUSTED Code = 8
	// Indicates that the system is not in a state required for the operation's execution.
	Code_CODE_FAILED_PRECONDITION Code = 9
	// Indicates that operation was aborted by the system, usually because of a
	// concurrency issue such as a sequencer check failure or transaction abort.
	Code_CODE_ABORTED Code = 10
	// Indicates that the operation was attempted past the valid range (for example,
	// seeking past end-of-file).
	Code_CODE_OUT_OF_RANGE Code = 11
	// Indicates that the operation isn't implemented, supported, or enabled in this service.
	Code_CODE_UNIMPLEMENTED Code = 12
	// Indicates that some invariants expected by the underlying system have been broken.
	// This code is reserved for serious errors.
	Code_CODE_INTERNAL Code = 13
	// Indicates that the service is currently unavailable. This is usually temporary, so
	// clients can back off and retry idempotent operations.
	Code_CODE_UNAVAILABLE Code = 14
	// Indicates that the operation has resulted in unrecoverable data loss or corruption.
	Code_CODE_DATA_LOSS Code = 15
	// Indicates that the request does not have valid authentication credentials for the operation.
	Code_CODE_UNAUTHENTICATED Code = 16
)

// Enum value maps for Code.
var (
	Code_name = map[int32]string{
		0:  "CODE_UNSPECIFIED",
		1:  "CODE_CANCELED",
		2:  "CODE_UNKNOWN",
		3:  "CODE_INVALID_ARGUMENT",
		4:  "CODE_DEADLINE_EXCEEDED",
		5:  "CODE_NOT_FOUND",
		6:  "CODE_ALREADY_EXISTS",
		7:  "CODE_PERMISSION_DENIED",
		8:  "CODE_RESOURCE_EXHAUSTED",
		9:  "CODE_FAILED_PRECONDITION",
		10: "CODE_ABORTED",
		11: "CODE_OUT_OF_RANGE",
		12: "CODE_UNIMPLEMENTED",
		13: "CODE_INTERNAL",
		14: "CODE_UNAVAILABLE",
		15: "CODE_DATA_LOSS",
		16: "CODE_UNAUTHENTICATED",
	}
	Code_value = map[string]int32{
		"CODE_UNSPECIFIED":         0,
		"CODE_CANCELED":            1,
		"CODE_UNKNOWN":             2,
		"CODE_INVALID_ARGUMENT":    3,
		"CODE_DEADLINE_EXCEEDED":   4,
		"CODE_NOT_FOUND":           5,
		"CODE_ALREADY_EXISTS":      6,
		"CODE_PERMISSION_DENIED":   7,
		"CODE_RESOURCE_EXHAUSTED":  8,
		"CODE_FAILED_PRECONDITION": 9,
		"CODE_ABORTED":             10,
		"CODE_OUT_OF_RANGE":        11,
		"CODE_UNIMPLEMENTED":       12,
		"CODE_INTERNAL":            13,
		"CODE_UNAVAILABLE":         14,
		"CODE_DATA_LOSS":           15,
		"CODE_UNAUTHENTICATED":     16,
	}
)

func (x Code) Enum() *Code {
	p := new(Code)
	*p = x
	return p
}

func (x Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Code) Descriptor() protoreflect.EnumDescriptor {
	return file_pluginrpc_v1_pluginrpc_proto_enumTypes[0].Descriptor()
}

func (Code) Type() protoreflect.EnumType {
	return &file_pluginrpc_v1_pluginrpc_proto_enumTypes[0]
}

func (x Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// A specification of a single procedure that can be invoked within a plugin.
//
// A prodecure has a path, and the args used to invoke it via the plugin.
type Procedure struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Path string                 `protobuf:"bytes,1,opt,name=path,proto3"`
	xxx_hidden_Args []string               `protobuf:"bytes,2,rep,name=args,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Procedure) Reset() {
	*x = Procedure{}
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Procedure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Procedure) ProtoMessage() {}

func (x *Procedure) ProtoReflect() protoreflect.Message {
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Procedure) GetPath() string {
	if x != nil {
		return x.xxx_hidden_Path
	}
	return ""
}

func (x *Procedure) GetArgs() []string {
	if x != nil {
		return x.xxx_hidden_Args
	}
	return nil
}

func (x *Procedure) SetPath(v string) {
	x.xxx_hidden_Path = v
}

func (x *Procedure) SetArgs(v []string) {
	x.xxx_hidden_Args = v
}

type Procedure_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The path of the procedure.
	//
	// When mapped to a Protobuf method, this will be `/fully.qualified.package.Service/Method`.
	//
	// Example:
	//
	//	package buf.plugin.check.v1;
	//
	//	service LintService {
	//	  rpc Lint(LintRequest) returns (LintResponse);
	//	}
	//
	// The path would be `/buf.plugin.check.v1.LintService/Lint`.
	//
	// The path must be a valid URI.
	Path string
	// The args to invoke on the plugin to invoke this method per the protocol specification.
	//
	// Example: If the args are `["plugin, "lint"]`, this method would be invoked by calling
	// the binary with the args `plugin lint`.
	//
	// This is optional. If not set, the default is that the procedure can be called
	// by calling the path as the only argument.
	//
	// Args must be at least of length 2, may only consist of characters in [a-zA-Z0-9_-], and may not
	// start or end with a dash or underscore.
	Args []string
}

func (b0 Procedure_builder) Build() *Procedure {
	m0 := &Procedure{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Path = b.Path
	x.xxx_hidden_Args = b.Args
	return m0
}

// The response given when the `--spec` flag is passed to the plugin.
type Spec struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Procedures *[]*Procedure          `protobuf:"bytes,1,rep,name=procedures,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Spec) Reset() {
	*x = Spec{}
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Spec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Spec) ProtoMessage() {}

func (x *Spec) ProtoReflect() protoreflect.Message {
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Spec) GetProcedures() []*Procedure {
	if x != nil {
		if x.xxx_hidden_Procedures != nil {
			return *x.xxx_hidden_Procedures
		}
	}
	return nil
}

func (x *Spec) SetProcedures(v []*Procedure) {
	x.xxx_hidden_Procedures = &v
}

type Spec_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The specifications of the Procedures implemented.
	//
	// All Procedures must have a unique path and args. The latter is unenforceable
	// via protovalidate, but users should assume that pluginrpc implementations
	// will enforce that args are unique.
	Procedures []*Procedure
}

func (b0 Spec_builder) Build() *Spec {
	m0 := &Spec{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Procedures = &b.Procedures
	return m0
}

// A request sent over a transport.
type Request struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value *anypb.Any             `protobuf:"bytes,1,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Request) Reset() {
	*x = Request{}
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Request) ProtoMessage() {}

func (x *Request) ProtoReflect() protoreflect.Message {
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Request) GetValue() *anypb.Any {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return nil
}

func (x *Request) SetValue(v *anypb.Any) {
	x.xxx_hidden_Value = v
}

func (x *Request) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *Request) ClearValue() {
	x.xxx_hidden_Value = nil
}

type Request_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The request value.
	//
	// May not be present.
	Value *anypb.Any
}

func (b0 Request_builder) Build() *Request {
	m0 := &Request{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	return m0
}

// A response received over a transport.
type Response struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value *anypb.Any             `protobuf:"bytes,1,opt,name=value,proto3"`
	xxx_hidden_Error *Error                 `protobuf:"bytes,2,opt,name=error,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Response) Reset() {
	*x = Response{}
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Response) ProtoMessage() {}

func (x *Response) ProtoReflect() protoreflect.Message {
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Response) GetValue() *anypb.Any {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return nil
}

func (x *Response) GetError() *Error {
	if x != nil {
		return x.xxx_hidden_Error
	}
	return nil
}

func (x *Response) SetValue(v *anypb.Any) {
	x.xxx_hidden_Value = v
}

func (x *Response) SetError(v *Error) {
	x.xxx_hidden_Error = v
}

func (x *Response) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *Response) HasError() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Error != nil
}

func (x *Response) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *Response) ClearError() {
	x.xxx_hidden_Error = nil
}

type Response_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The response value.
	//
	// May or may not be present, regardless of if there is an Error.
	Value *anypb.Any
	// An error.
	//
	// May or may not be present, regardless of if there is a response value.
	Error *Error
}

func (b0 Response_builder) Build() *Response {
	m0 := &Response{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Error = b.Error
	return m0
}

// An error received over a transport as part of a Response.
type Error struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Code    Code                   `protobuf:"varint,1,opt,name=code,proto3,enum=pluginrpc.v1.Code"`
	xxx_hidden_Message string                 `protobuf:"bytes,2,opt,name=message,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Error) Reset() {
	*x = Error{}
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_pluginrpc_v1_pluginrpc_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Error) GetCode() Code {
	if x != nil {
		return x.xxx_hidden_Code
	}
	return Code_CODE_UNSPECIFIED
}

func (x *Error) GetMessage() string {
	if x != nil {
		return x.xxx_hidden_Message
	}
	return ""
}

func (x *Error) SetCode(v Code) {
	x.xxx_hidden_Code = v
}

func (x *Error) SetMessage(v string) {
	x.xxx_hidden_Message = v
}

type Error_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The error code.
	Code Code
	// The message of the error.
	Message string
}

func (b0 Error_builder) Build() *Error {
	m0 := &Error{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Code = b.Code
	x.xxx_hidden_Message = b.Message
	return m0
}

var File_pluginrpc_v1_pluginrpc_proto protoreflect.FileDescriptor

const file_pluginrpc_v1_pluginrpc_proto_rawDesc = "" +
	"\n" +
	"\x1cpluginrpc/v1/pluginrpc.proto\x12\fpluginrpc.v1\x1a\x1bbuf/validate/validate.proto\x1a\x19google/protobuf/any.proto\"t\n" +
	"\tProcedure\x12\x1f\n" +
	"\x04path\x18\x01 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x01\x01R\x04path\x12F\n" +
	"\x04args\x18\x02 \x03(\tB2\xbaH/\x92\x01,\"*r(2&^[a-zA-Z0-9][a-zA-Z0-9_-]*[a-zA-Z0-9]$R\x04args\"\xa8\x01\n" +
	"\x04Spec\x12\x9f\x01\n" +
	"\n" +
	"procedures\x18\x01 \x03(\v2\x17.pluginrpc.v1.ProcedureBf\xbaHc\xba\x01[\n" +
	"\vpath_unique\x12\x1eprocedure paths must be unique\x1a,this.map(procedure, procedure.path).unique()\x92\x01\x02\b\x01R\n" +
	"procedures\"5\n" +
	"\aRequest\x12*\n" +
	"\x05value\x18\x01 \x01(\v2\x14.google.protobuf.AnyR\x05value\"a\n" +
	"\bResponse\x12*\n" +
	"\x05value\x18\x01 \x01(\v2\x14.google.protobuf.AnyR\x05value\x12)\n" +
	"\x05error\x18\x02 \x01(\v2\x13.pluginrpc.v1.ErrorR\x05error\"\\\n" +
	"\x05Error\x121\n" +
	"\x04code\x18\x01 \x01(\x0e2\x12.pluginrpc.v1.CodeB\t\xbaH\x06\x82\x01\x03\"\x01\x00R\x04code\x12 \n" +
	"\amessage\x18\x02 \x01(\tB\x06\xbaH\x03\xc8\x01\x01R\amessage*\x94\x03\n" +
	"\x04Code\x12\x14\n" +
	"\x10CODE_UNSPECIFIED\x10\x00\x12\x11\n" +
	"\rCODE_CANCELED\x10\x01\x12\x10\n" +
	"\fCODE_UNKNOWN\x10\x02\x12\x19\n" +
	"\x15CODE_INVALID_ARGUMENT\x10\x03\x12\x1a\n" +
	"\x16CODE_DEADLINE_EXCEEDED\x10\x04\x12\x12\n" +
	"\x0eCODE_NOT_FOUND\x10\x05\x12\x17\n" +
	"\x13CODE_ALREADY_EXISTS\x10\x06\x12\x1a\n" +
	"\x16CODE_PERMISSION_DENIED\x10\a\x12\x1b\n" +
	"\x17CODE_RESOURCE_EXHAUSTED\x10\b\x12\x1c\n" +
	"\x18CODE_FAILED_PRECONDITION\x10\t\x12\x10\n" +
	"\fCODE_ABORTED\x10\n" +
	"\x12\x15\n" +
	"\x11CODE_OUT_OF_RANGE\x10\v\x12\x16\n" +
	"\x12CODE_UNIMPLEMENTED\x10\f\x12\x11\n" +
	"\rCODE_INTERNAL\x10\r\x12\x14\n" +
	"\x10CODE_UNAVAILABLE\x10\x0e\x12\x12\n" +
	"\x0eCODE_DATA_LOSS\x10\x0f\x12\x18\n" +
	"\x14CODE_UNAUTHENTICATED\x10\x10BRZPbuf.build/gen/go/pluginrpc/pluginrpc/protocolbuffers/go/pluginrpc/v1;pluginrpcv1b\x06proto3"

var file_pluginrpc_v1_pluginrpc_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_pluginrpc_v1_pluginrpc_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_pluginrpc_v1_pluginrpc_proto_goTypes = []any{
	(Code)(0),         // 0: pluginrpc.v1.Code
	(*Procedure)(nil), // 1: pluginrpc.v1.Procedure
	(*Spec)(nil),      // 2: pluginrpc.v1.Spec
	(*Request)(nil),   // 3: pluginrpc.v1.Request
	(*Response)(nil),  // 4: pluginrpc.v1.Response
	(*Error)(nil),     // 5: pluginrpc.v1.Error
	(*anypb.Any)(nil), // 6: google.protobuf.Any
}
var file_pluginrpc_v1_pluginrpc_proto_depIdxs = []int32{
	1, // 0: pluginrpc.v1.Spec.procedures:type_name -> pluginrpc.v1.Procedure
	6, // 1: pluginrpc.v1.Request.value:type_name -> google.protobuf.Any
	6, // 2: pluginrpc.v1.Response.value:type_name -> google.protobuf.Any
	5, // 3: pluginrpc.v1.Response.error:type_name -> pluginrpc.v1.Error
	0, // 4: pluginrpc.v1.Error.code:type_name -> pluginrpc.v1.Code
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_pluginrpc_v1_pluginrpc_proto_init() }
func file_pluginrpc_v1_pluginrpc_proto_init() {
	if File_pluginrpc_v1_pluginrpc_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_pluginrpc_v1_pluginrpc_proto_rawDesc), len(file_pluginrpc_v1_pluginrpc_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pluginrpc_v1_pluginrpc_proto_goTypes,
		DependencyIndexes: file_pluginrpc_v1_pluginrpc_proto_depIdxs,
		EnumInfos:         file_pluginrpc_v1_pluginrpc_proto_enumTypes,
		MessageInfos:      file_pluginrpc_v1_pluginrpc_proto_msgTypes,
	}.Build()
	File_pluginrpc_v1_pluginrpc_proto = out.File
	file_pluginrpc_v1_pluginrpc_proto_goTypes = nil
	file_pluginrpc_v1_pluginrpc_proto_depIdxs = nil
}
