// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/registry/owner/v1/user_service.proto

//go:build !protoopaque

package ownerv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListUsersRequest_Order int32

const (
	ListUsersRequest_ORDER_UNSPECIFIED ListUsersRequest_Order = 0
	// Order by create_time newest to oldest.
	ListUsersRequest_ORDER_CREATE_TIME_DESC ListUsersRequest_Order = 1
	// Order by create_time oldest to newest.
	ListUsersRequest_ORDER_CREATE_TIME_ASC ListUsersRequest_Order = 2
)

// Enum value maps for ListUsersRequest_Order.
var (
	ListUsersRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListUsersRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListUsersRequest_Order) Enum() *ListUsersRequest_Order {
	p := new(ListUsersRequest_Order)
	*p = x
	return p
}

func (x ListUsersRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListUsersRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_owner_v1_user_service_proto_enumTypes[0].Descriptor()
}

func (ListUsersRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_owner_v1_user_service_proto_enumTypes[0]
}

func (x ListUsersRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetUsersRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Users to request.
	UserRefs      []*UserRef `protobuf:"bytes,1,rep,name=user_refs,json=userRefs,proto3" json:"user_refs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUsersRequest) Reset() {
	*x = GetUsersRequest{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUsersRequest) ProtoMessage() {}

func (x *GetUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUsersRequest) GetUserRefs() []*UserRef {
	if x != nil {
		return x.UserRefs
	}
	return nil
}

func (x *GetUsersRequest) SetUserRefs(v []*UserRef) {
	x.UserRefs = v
}

type GetUsersRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Users to request.
	UserRefs []*UserRef
}

func (b0 GetUsersRequest_builder) Build() *GetUsersRequest {
	m0 := &GetUsersRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.UserRefs = b.UserRefs
	return m0
}

type GetUsersResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The retrieved Users in the same order as requested.
	Users         []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetUsersResponse) Reset() {
	*x = GetUsersResponse{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUsersResponse) ProtoMessage() {}

func (x *GetUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetUsersResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

func (x *GetUsersResponse) SetUsers(v []*User) {
	x.Users = v
}

type GetUsersResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The retrieved Users in the same order as requested.
	Users []*User
}

func (b0 GetUsersResponse_builder) Build() *GetUsersResponse {
	m0 := &GetUsersResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Users = b.Users
	return m0
}

type ListUsersRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The specific Organizations to list Users for.
	//
	// If this is empty, all Users for all Organizations are listed, but this functionality
	// is limited to Users with the necessary permissions.
	OrganizationRefs []*OrganizationRef `protobuf:"bytes,3,rep,name=organization_refs,json=organizationRefs,proto3" json:"organization_refs,omitempty"`
	// The order to return the Users.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListUsersRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.owner.v1.ListUsersRequest_Order" json:"order,omitempty"`
	// Only return Users of these types.
	HasTypes []UserType `protobuf:"varint,5,rep,packed,name=has_types,json=hasTypes,proto3,enum=buf.registry.owner.v1.UserType" json:"has_types,omitempty"`
	// Only return Users of these states.
	HasStates     []UserState `protobuf:"varint,6,rep,packed,name=has_states,json=hasStates,proto3,enum=buf.registry.owner.v1.UserState" json:"has_states,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListUsersRequest) Reset() {
	*x = ListUsersRequest{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsersRequest) ProtoMessage() {}

func (x *ListUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUsersRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUsersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListUsersRequest) GetOrganizationRefs() []*OrganizationRef {
	if x != nil {
		return x.OrganizationRefs
	}
	return nil
}

func (x *ListUsersRequest) GetOrder() ListUsersRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListUsersRequest_ORDER_UNSPECIFIED
}

func (x *ListUsersRequest) GetHasTypes() []UserType {
	if x != nil {
		return x.HasTypes
	}
	return nil
}

func (x *ListUsersRequest) GetHasStates() []UserState {
	if x != nil {
		return x.HasStates
	}
	return nil
}

func (x *ListUsersRequest) SetPageSize(v uint32) {
	x.PageSize = v
}

func (x *ListUsersRequest) SetPageToken(v string) {
	x.PageToken = v
}

func (x *ListUsersRequest) SetOrganizationRefs(v []*OrganizationRef) {
	x.OrganizationRefs = v
}

func (x *ListUsersRequest) SetOrder(v ListUsersRequest_Order) {
	x.Order = v
}

func (x *ListUsersRequest) SetHasTypes(v []UserType) {
	x.HasTypes = v
}

func (x *ListUsersRequest) SetHasStates(v []UserState) {
	x.HasStates = v
}

type ListUsersRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The specific Organizations to list Users for.
	//
	// If this is empty, all Users for all Organizations are listed, but this functionality
	// is limited to Users with the necessary permissions.
	OrganizationRefs []*OrganizationRef
	// The order to return the Users.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListUsersRequest_Order
	// Only return Users of these types.
	HasTypes []UserType
	// Only return Users of these states.
	HasStates []UserState
}

func (b0 ListUsersRequest_builder) Build() *ListUsersRequest {
	m0 := &ListUsersRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.PageSize = b.PageSize
	x.PageToken = b.PageToken
	x.OrganizationRefs = b.OrganizationRefs
	x.Order = b.Order
	x.HasTypes = b.HasTypes
	x.HasStates = b.HasStates
	return m0
}

type ListUsersResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of Users.
	Users         []*User `protobuf:"bytes,2,rep,name=users,proto3" json:"users,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListUsersResponse) Reset() {
	*x = ListUsersResponse{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsersResponse) ProtoMessage() {}

func (x *ListUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListUsersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListUsersResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

func (x *ListUsersResponse) SetNextPageToken(v string) {
	x.NextPageToken = v
}

func (x *ListUsersResponse) SetUsers(v []*User) {
	x.Users = v
}

type ListUsersResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The list of Users.
	Users []*User
}

func (b0 ListUsersResponse_builder) Build() *ListUsersResponse {
	m0 := &ListUsersResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.NextPageToken = b.NextPageToken
	x.Users = b.Users
	return m0
}

type CreateUsersRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Users to create.
	Values        []*CreateUsersRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateUsersRequest) Reset() {
	*x = CreateUsersRequest{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUsersRequest) ProtoMessage() {}

func (x *CreateUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateUsersRequest) GetValues() []*CreateUsersRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *CreateUsersRequest) SetValues(v []*CreateUsersRequest_Value) {
	x.Values = v
}

type CreateUsersRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Users to create.
	Values []*CreateUsersRequest_Value
}

func (b0 CreateUsersRequest_builder) Build() *CreateUsersRequest {
	m0 := &CreateUsersRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

type CreateUsersResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The created Users in the same order as given on the request.
	Users         []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateUsersResponse) Reset() {
	*x = CreateUsersResponse{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUsersResponse) ProtoMessage() {}

func (x *CreateUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateUsersResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

func (x *CreateUsersResponse) SetUsers(v []*User) {
	x.Users = v
}

type CreateUsersResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The created Users in the same order as given on the request.
	Users []*User
}

func (b0 CreateUsersResponse_builder) Build() *CreateUsersResponse {
	m0 := &CreateUsersResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Users = b.Users
	return m0
}

type UpdateUsersRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Users to update.
	Values        []*UpdateUsersRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateUsersRequest) Reset() {
	*x = UpdateUsersRequest{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUsersRequest) ProtoMessage() {}

func (x *UpdateUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateUsersRequest) GetValues() []*UpdateUsersRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *UpdateUsersRequest) SetValues(v []*UpdateUsersRequest_Value) {
	x.Values = v
}

type UpdateUsersRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Users to update.
	Values []*UpdateUsersRequest_Value
}

func (b0 UpdateUsersRequest_builder) Build() *UpdateUsersRequest {
	m0 := &UpdateUsersRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

type UpdateUsersResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The updated Users in the same order as given on the request.
	Users         []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateUsersResponse) Reset() {
	*x = UpdateUsersResponse{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUsersResponse) ProtoMessage() {}

func (x *UpdateUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateUsersResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

func (x *UpdateUsersResponse) SetUsers(v []*User) {
	x.Users = v
}

type UpdateUsersResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The updated Users in the same order as given on the request.
	Users []*User
}

func (b0 UpdateUsersResponse_builder) Build() *UpdateUsersResponse {
	m0 := &UpdateUsersResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Users = b.Users
	return m0
}

type DeleteUsersRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Users to delete.
	UserRefs      []*UserRef `protobuf:"bytes,1,rep,name=user_refs,json=userRefs,proto3" json:"user_refs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteUsersRequest) Reset() {
	*x = DeleteUsersRequest{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUsersRequest) ProtoMessage() {}

func (x *DeleteUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteUsersRequest) GetUserRefs() []*UserRef {
	if x != nil {
		return x.UserRefs
	}
	return nil
}

func (x *DeleteUsersRequest) SetUserRefs(v []*UserRef) {
	x.UserRefs = v
}

type DeleteUsersRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Users to delete.
	UserRefs []*UserRef
}

func (b0 DeleteUsersRequest_builder) Build() *DeleteUsersRequest {
	m0 := &DeleteUsersRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.UserRefs = b.UserRefs
	return m0
}

type DeleteUsersResponse struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteUsersResponse) Reset() {
	*x = DeleteUsersResponse{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUsersResponse) ProtoMessage() {}

func (x *DeleteUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteUsersResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteUsersResponse_builder) Build() *DeleteUsersResponse {
	m0 := &DeleteUsersResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// An individual request to create a User.
type CreateUsersRequest_Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The name of the User.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the User.
	//
	// If not set, the default USER_TYPE_STANDARD is used.
	Type UserType `protobuf:"varint,2,opt,name=type,proto3,enum=buf.registry.owner.v1.UserType" json:"type,omitempty"`
	// The configurable description of the User.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The configurable URL that represents the homepage for a User.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// The verification status of the User.
	//
	// If not set, the User will default to VERIFICATION_STATUS_UNVERIFIED.
	VerificationStatus UserVerificationStatus `protobuf:"varint,5,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.UserVerificationStatus" json:"verification_status,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *CreateUsersRequest_Value) Reset() {
	*x = CreateUsersRequest_Value{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateUsersRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUsersRequest_Value) ProtoMessage() {}

func (x *CreateUsersRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateUsersRequest_Value) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateUsersRequest_Value) GetType() UserType {
	if x != nil {
		return x.Type
	}
	return UserType_USER_TYPE_UNSPECIFIED
}

func (x *CreateUsersRequest_Value) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateUsersRequest_Value) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *CreateUsersRequest_Value) GetVerificationStatus() UserVerificationStatus {
	if x != nil {
		return x.VerificationStatus
	}
	return UserVerificationStatus_USER_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *CreateUsersRequest_Value) SetName(v string) {
	x.Name = v
}

func (x *CreateUsersRequest_Value) SetType(v UserType) {
	x.Type = v
}

func (x *CreateUsersRequest_Value) SetDescription(v string) {
	x.Description = v
}

func (x *CreateUsersRequest_Value) SetUrl(v string) {
	x.Url = v
}

func (x *CreateUsersRequest_Value) SetVerificationStatus(v UserVerificationStatus) {
	x.VerificationStatus = v
}

type CreateUsersRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the User.
	Name string
	// The type of the User.
	//
	// If not set, the default USER_TYPE_STANDARD is used.
	Type UserType
	// The configurable description of the User.
	Description string
	// The configurable URL that represents the homepage for a User.
	Url string
	// The verification status of the User.
	//
	// If not set, the User will default to VERIFICATION_STATUS_UNVERIFIED.
	VerificationStatus UserVerificationStatus
}

func (b0 CreateUsersRequest_Value_builder) Build() *CreateUsersRequest_Value {
	m0 := &CreateUsersRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.Name = b.Name
	x.Type = b.Type
	x.Description = b.Description
	x.Url = b.Url
	x.VerificationStatus = b.VerificationStatus
	return m0
}

// An individual request to update a User.
type UpdateUsersRequest_Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The User to update.
	UserRef *UserRef `protobuf:"bytes,1,opt,name=user_ref,json=userRef,proto3" json:"user_ref,omitempty"`
	// The state of the User.
	State *UserState `protobuf:"varint,2,opt,name=state,proto3,enum=buf.registry.owner.v1.UserState,oneof" json:"state,omitempty"`
	// The configurable description of the User.
	Description *string `protobuf:"bytes,3,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The configurable URL that represents the homepage for a User.
	Url *string `protobuf:"bytes,4,opt,name=url,proto3,oneof" json:"url,omitempty"`
	// The verification status of the User.
	VerificationStatus *UserVerificationStatus `protobuf:"varint,5,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.UserVerificationStatus,oneof" json:"verification_status,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *UpdateUsersRequest_Value) Reset() {
	*x = UpdateUsersRequest_Value{}
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUsersRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUsersRequest_Value) ProtoMessage() {}

func (x *UpdateUsersRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateUsersRequest_Value) GetUserRef() *UserRef {
	if x != nil {
		return x.UserRef
	}
	return nil
}

func (x *UpdateUsersRequest_Value) GetState() UserState {
	if x != nil && x.State != nil {
		return *x.State
	}
	return UserState_USER_STATE_UNSPECIFIED
}

func (x *UpdateUsersRequest_Value) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *UpdateUsersRequest_Value) GetUrl() string {
	if x != nil && x.Url != nil {
		return *x.Url
	}
	return ""
}

func (x *UpdateUsersRequest_Value) GetVerificationStatus() UserVerificationStatus {
	if x != nil && x.VerificationStatus != nil {
		return *x.VerificationStatus
	}
	return UserVerificationStatus_USER_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *UpdateUsersRequest_Value) SetUserRef(v *UserRef) {
	x.UserRef = v
}

func (x *UpdateUsersRequest_Value) SetState(v UserState) {
	x.State = &v
}

func (x *UpdateUsersRequest_Value) SetDescription(v string) {
	x.Description = &v
}

func (x *UpdateUsersRequest_Value) SetUrl(v string) {
	x.Url = &v
}

func (x *UpdateUsersRequest_Value) SetVerificationStatus(v UserVerificationStatus) {
	x.VerificationStatus = &v
}

func (x *UpdateUsersRequest_Value) HasUserRef() bool {
	if x == nil {
		return false
	}
	return x.UserRef != nil
}

func (x *UpdateUsersRequest_Value) HasState() bool {
	if x == nil {
		return false
	}
	return x.State != nil
}

func (x *UpdateUsersRequest_Value) HasDescription() bool {
	if x == nil {
		return false
	}
	return x.Description != nil
}

func (x *UpdateUsersRequest_Value) HasUrl() bool {
	if x == nil {
		return false
	}
	return x.Url != nil
}

func (x *UpdateUsersRequest_Value) HasVerificationStatus() bool {
	if x == nil {
		return false
	}
	return x.VerificationStatus != nil
}

func (x *UpdateUsersRequest_Value) ClearUserRef() {
	x.UserRef = nil
}

func (x *UpdateUsersRequest_Value) ClearState() {
	x.State = nil
}

func (x *UpdateUsersRequest_Value) ClearDescription() {
	x.Description = nil
}

func (x *UpdateUsersRequest_Value) ClearUrl() {
	x.Url = nil
}

func (x *UpdateUsersRequest_Value) ClearVerificationStatus() {
	x.VerificationStatus = nil
}

type UpdateUsersRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The User to update.
	UserRef *UserRef
	// The state of the User.
	State *UserState
	// The configurable description of the User.
	Description *string
	// The configurable URL that represents the homepage for a User.
	Url *string
	// The verification status of the User.
	VerificationStatus *UserVerificationStatus
}

func (b0 UpdateUsersRequest_Value_builder) Build() *UpdateUsersRequest_Value {
	m0 := &UpdateUsersRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.UserRef = b.UserRef
	x.State = b.State
	x.Description = b.Description
	x.Url = b.Url
	x.VerificationStatus = b.VerificationStatus
	return m0
}

var File_buf_registry_owner_v1_user_service_proto protoreflect.FileDescriptor

const file_buf_registry_owner_v1_user_service_proto_rawDesc = "" +
	"\n" +
	"(buf/registry/owner/v1/user_service.proto\x12\x15buf.registry.owner.v1\x1a(buf/registry/owner/v1/organization.proto\x1a buf/registry/owner/v1/user.proto\x1a\x1bbuf/validate/validate.proto\"[\n" +
	"\x0fGetUsersRequest\x12H\n" +
	"\tuser_refs\x18\x01 \x03(\v2\x1e.buf.registry.owner.v1.UserRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\buserRefs\"O\n" +
	"\x10GetUsersResponse\x12;\n" +
	"\x05users\x18\x01 \x03(\v2\x1b.buf.registry.owner.v1.UserB\b\xbaH\x05\x92\x01\x02\b\x01R\x05users\"\x82\x04\n" +
	"\x10ListUsersRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12S\n" +
	"\x11organization_refs\x18\x03 \x03(\v2&.buf.registry.owner.v1.OrganizationRefR\x10organizationRefs\x12M\n" +
	"\x05order\x18\x04 \x01(\x0e2-.buf.registry.owner.v1.ListUsersRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\x12O\n" +
	"\thas_types\x18\x05 \x03(\x0e2\x1f.buf.registry.owner.v1.UserTypeB\x11\xbaH\x0e\x92\x01\v\x18\x01\"\a\x82\x01\x04\x10\x01 \x00R\bhasTypes\x12R\n" +
	"\n" +
	"has_states\x18\x06 \x03(\x0e2 .buf.registry.owner.v1.UserStateB\x11\xbaH\x0e\x92\x01\v\x18\x01\"\a\x82\x01\x04\x10\x01 \x00R\thasStates\"U\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x1a\n" +
	"\x16ORDER_CREATE_TIME_DESC\x10\x01\x12\x19\n" +
	"\x15ORDER_CREATE_TIME_ASC\x10\x02\"x\n" +
	"\x11ListUsersResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x121\n" +
	"\x05users\x18\x02 \x03(\v2\x1b.buf.registry.owner.v1.UserR\x05users\"\xa8\x03\n" +
	"\x12CreateUsersRequest\x12T\n" +
	"\x06values\x18\x01 \x03(\v2/.buf.registry.owner.v1.CreateUsersRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\xbb\x02\n" +
	"\x05Value\x12;\n" +
	"\x04name\x18\x01 \x01(\tB'\xbaH$\xc8\x01\x01r\x1f\x10\x02\x18 2\x19^[a-z][a-z0-9-]*[a-z0-9]$R\x04name\x12=\n" +
	"\x04type\x18\x02 \x01(\x0e2\x1f.buf.registry.owner.v1.UserTypeB\b\xbaH\x05\x82\x01\x02\x10\x01R\x04type\x12*\n" +
	"\vdescription\x18\x03 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription\x12 \n" +
	"\x03url\x18\x04 \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\x03url\x12h\n" +
	"\x13verification_status\x18\x05 \x01(\x0e2-.buf.registry.owner.v1.UserVerificationStatusB\b\xbaH\x05\x82\x01\x02\x10\x01R\x12verificationStatus\"R\n" +
	"\x13CreateUsersResponse\x12;\n" +
	"\x05users\x18\x01 \x03(\v2\x1b.buf.registry.owner.v1.UserB\b\xbaH\x05\x92\x01\x02\b\x01R\x05users\"\xc9\x04\n" +
	"\x12UpdateUsersRequest\x12T\n" +
	"\x06values\x18\x01 \x03(\v2/.buf.registry.owner.v1.UpdateUsersRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\xdc\x03\n" +
	"\x05Value\x12A\n" +
	"\buser_ref\x18\x01 \x01(\v2\x1e.buf.registry.owner.v1.UserRefB\x06\xbaH\x03\xc8\x01\x01R\auserRef\x12G\n" +
	"\x05state\x18\x02 \x01(\x0e2 .buf.registry.owner.v1.UserStateB\n" +
	"\xbaH\a\x82\x01\x04\x10\x01 \x00H\x00R\x05state\x88\x01\x01\x12/\n" +
	"\vdescription\x18\x03 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02H\x01R\vdescription\x88\x01\x01\x12m\n" +
	"\x03url\x18\x04 \x01(\tBV\xbaHS\xba\x01K\n" +
	"\n" +
	"string.uri\x1a=this == '' || this.isUri() ? '' : 'value must be a valid URI'r\x03\x18\xff\x01H\x02R\x03url\x88\x01\x01\x12m\n" +
	"\x13verification_status\x18\x05 \x01(\x0e2-.buf.registry.owner.v1.UserVerificationStatusB\b\xbaH\x05\x82\x01\x02\x10\x01H\x03R\x12verificationStatus\x88\x01\x01B\b\n" +
	"\x06_stateB\x0e\n" +
	"\f_descriptionB\x06\n" +
	"\x04_urlB\x16\n" +
	"\x14_verification_status\"R\n" +
	"\x13UpdateUsersResponse\x12;\n" +
	"\x05users\x18\x01 \x03(\v2\x1b.buf.registry.owner.v1.UserB\b\xbaH\x05\x92\x01\x02\b\x01R\x05users\"^\n" +
	"\x12DeleteUsersRequest\x12H\n" +
	"\tuser_refs\x18\x01 \x03(\v2\x1e.buf.registry.owner.v1.UserRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\buserRefs\"\x15\n" +
	"\x13DeleteUsersResponse2\x95\x04\n" +
	"\vUserService\x12`\n" +
	"\bGetUsers\x12&.buf.registry.owner.v1.GetUsersRequest\x1a'.buf.registry.owner.v1.GetUsersResponse\"\x03\x90\x02\x01\x12c\n" +
	"\tListUsers\x12'.buf.registry.owner.v1.ListUsersRequest\x1a(.buf.registry.owner.v1.ListUsersResponse\"\x03\x90\x02\x01\x12i\n" +
	"\vCreateUsers\x12).buf.registry.owner.v1.CreateUsersRequest\x1a*.buf.registry.owner.v1.CreateUsersResponse\"\x03\x90\x02\x02\x12i\n" +
	"\vUpdateUsers\x12).buf.registry.owner.v1.UpdateUsersRequest\x1a*.buf.registry.owner.v1.UpdateUsersResponse\"\x03\x90\x02\x02\x12i\n" +
	"\vDeleteUsers\x12).buf.registry.owner.v1.DeleteUsersRequest\x1a*.buf.registry.owner.v1.DeleteUsersResponse\"\x03\x90\x02\x02BUZSbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1;ownerv1b\x06proto3"

var file_buf_registry_owner_v1_user_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_owner_v1_user_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_registry_owner_v1_user_service_proto_goTypes = []any{
	(ListUsersRequest_Order)(0),      // 0: buf.registry.owner.v1.ListUsersRequest.Order
	(*GetUsersRequest)(nil),          // 1: buf.registry.owner.v1.GetUsersRequest
	(*GetUsersResponse)(nil),         // 2: buf.registry.owner.v1.GetUsersResponse
	(*ListUsersRequest)(nil),         // 3: buf.registry.owner.v1.ListUsersRequest
	(*ListUsersResponse)(nil),        // 4: buf.registry.owner.v1.ListUsersResponse
	(*CreateUsersRequest)(nil),       // 5: buf.registry.owner.v1.CreateUsersRequest
	(*CreateUsersResponse)(nil),      // 6: buf.registry.owner.v1.CreateUsersResponse
	(*UpdateUsersRequest)(nil),       // 7: buf.registry.owner.v1.UpdateUsersRequest
	(*UpdateUsersResponse)(nil),      // 8: buf.registry.owner.v1.UpdateUsersResponse
	(*DeleteUsersRequest)(nil),       // 9: buf.registry.owner.v1.DeleteUsersRequest
	(*DeleteUsersResponse)(nil),      // 10: buf.registry.owner.v1.DeleteUsersResponse
	(*CreateUsersRequest_Value)(nil), // 11: buf.registry.owner.v1.CreateUsersRequest.Value
	(*UpdateUsersRequest_Value)(nil), // 12: buf.registry.owner.v1.UpdateUsersRequest.Value
	(*UserRef)(nil),                  // 13: buf.registry.owner.v1.UserRef
	(*User)(nil),                     // 14: buf.registry.owner.v1.User
	(*OrganizationRef)(nil),          // 15: buf.registry.owner.v1.OrganizationRef
	(UserType)(0),                    // 16: buf.registry.owner.v1.UserType
	(UserState)(0),                   // 17: buf.registry.owner.v1.UserState
	(UserVerificationStatus)(0),      // 18: buf.registry.owner.v1.UserVerificationStatus
}
var file_buf_registry_owner_v1_user_service_proto_depIdxs = []int32{
	13, // 0: buf.registry.owner.v1.GetUsersRequest.user_refs:type_name -> buf.registry.owner.v1.UserRef
	14, // 1: buf.registry.owner.v1.GetUsersResponse.users:type_name -> buf.registry.owner.v1.User
	15, // 2: buf.registry.owner.v1.ListUsersRequest.organization_refs:type_name -> buf.registry.owner.v1.OrganizationRef
	0,  // 3: buf.registry.owner.v1.ListUsersRequest.order:type_name -> buf.registry.owner.v1.ListUsersRequest.Order
	16, // 4: buf.registry.owner.v1.ListUsersRequest.has_types:type_name -> buf.registry.owner.v1.UserType
	17, // 5: buf.registry.owner.v1.ListUsersRequest.has_states:type_name -> buf.registry.owner.v1.UserState
	14, // 6: buf.registry.owner.v1.ListUsersResponse.users:type_name -> buf.registry.owner.v1.User
	11, // 7: buf.registry.owner.v1.CreateUsersRequest.values:type_name -> buf.registry.owner.v1.CreateUsersRequest.Value
	14, // 8: buf.registry.owner.v1.CreateUsersResponse.users:type_name -> buf.registry.owner.v1.User
	12, // 9: buf.registry.owner.v1.UpdateUsersRequest.values:type_name -> buf.registry.owner.v1.UpdateUsersRequest.Value
	14, // 10: buf.registry.owner.v1.UpdateUsersResponse.users:type_name -> buf.registry.owner.v1.User
	13, // 11: buf.registry.owner.v1.DeleteUsersRequest.user_refs:type_name -> buf.registry.owner.v1.UserRef
	16, // 12: buf.registry.owner.v1.CreateUsersRequest.Value.type:type_name -> buf.registry.owner.v1.UserType
	18, // 13: buf.registry.owner.v1.CreateUsersRequest.Value.verification_status:type_name -> buf.registry.owner.v1.UserVerificationStatus
	13, // 14: buf.registry.owner.v1.UpdateUsersRequest.Value.user_ref:type_name -> buf.registry.owner.v1.UserRef
	17, // 15: buf.registry.owner.v1.UpdateUsersRequest.Value.state:type_name -> buf.registry.owner.v1.UserState
	18, // 16: buf.registry.owner.v1.UpdateUsersRequest.Value.verification_status:type_name -> buf.registry.owner.v1.UserVerificationStatus
	1,  // 17: buf.registry.owner.v1.UserService.GetUsers:input_type -> buf.registry.owner.v1.GetUsersRequest
	3,  // 18: buf.registry.owner.v1.UserService.ListUsers:input_type -> buf.registry.owner.v1.ListUsersRequest
	5,  // 19: buf.registry.owner.v1.UserService.CreateUsers:input_type -> buf.registry.owner.v1.CreateUsersRequest
	7,  // 20: buf.registry.owner.v1.UserService.UpdateUsers:input_type -> buf.registry.owner.v1.UpdateUsersRequest
	9,  // 21: buf.registry.owner.v1.UserService.DeleteUsers:input_type -> buf.registry.owner.v1.DeleteUsersRequest
	2,  // 22: buf.registry.owner.v1.UserService.GetUsers:output_type -> buf.registry.owner.v1.GetUsersResponse
	4,  // 23: buf.registry.owner.v1.UserService.ListUsers:output_type -> buf.registry.owner.v1.ListUsersResponse
	6,  // 24: buf.registry.owner.v1.UserService.CreateUsers:output_type -> buf.registry.owner.v1.CreateUsersResponse
	8,  // 25: buf.registry.owner.v1.UserService.UpdateUsers:output_type -> buf.registry.owner.v1.UpdateUsersResponse
	10, // 26: buf.registry.owner.v1.UserService.DeleteUsers:output_type -> buf.registry.owner.v1.DeleteUsersResponse
	22, // [22:27] is the sub-list for method output_type
	17, // [17:22] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_buf_registry_owner_v1_user_service_proto_init() }
func file_buf_registry_owner_v1_user_service_proto_init() {
	if File_buf_registry_owner_v1_user_service_proto != nil {
		return
	}
	file_buf_registry_owner_v1_organization_proto_init()
	file_buf_registry_owner_v1_user_proto_init()
	file_buf_registry_owner_v1_user_service_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_owner_v1_user_service_proto_rawDesc), len(file_buf_registry_owner_v1_user_service_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_owner_v1_user_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_owner_v1_user_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_owner_v1_user_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_owner_v1_user_service_proto_msgTypes,
	}.Build()
	File_buf_registry_owner_v1_user_service_proto = out.File
	file_buf_registry_owner_v1_user_service_proto_goTypes = nil
	file_buf_registry_owner_v1_user_service_proto_depIdxs = nil
}
