// Copyright 2024-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/plugin/check/v1/check_service.proto

//go:build !protoopaque

package checkv1

import (
	v1 "buf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/descriptor/v1"
	v11 "buf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/option/v1"
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A request to check FileDescriptors.
type CheckRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The FileDescriptors to check.
	//
	// Required.
	//
	// FileDescriptors are guaranteed to be unique by file_descriptor_proto.name.
	FileDescriptors []*v1.FileDescriptor `protobuf:"bytes,1,rep,name=file_descriptors,json=fileDescriptors,proto3" json:"file_descriptors,omitempty"`
	// The FileDescriptors to check against.
	//
	// Optional.
	//
	// This is usually the state of the FileDescriptors at a previous VCS commit, or the state of
	// the FileDescriptors at a release tag.
	//
	// FileDescriptors are guaranteed to be unique by file_descriptor_proto.name.
	//
	// Note that this may be empty, even for breaking change checks, to account for
	// going from the empty state to the first set of FileDescriptors.
	AgainstFileDescriptors []*v1.FileDescriptor `protobuf:"bytes,2,rep,name=against_file_descriptors,json=againstFileDescriptors,proto3" json:"against_file_descriptors,omitempty"`
	// Options for the Rules.
	//
	// Optional.
	//
	// Options may modify the behavior of a Rule.
	//
	// For now, callers are expected to know what keys are available, and how to construct Values
	// for each key. In the future, we may add a ListOptions or otherwise to CheckService that will
	// describe the available options keys, which can then be validated against.
	//
	// It is acceptable for a plugin to return an error on an unknown or misconstructed Option.
	Options []*v11.Option `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
	// The IDs of the Rules to check.
	//
	// Optional. If not specified, all Rules returned by ListRules are checked.
	//
	// The maximum number of Rule IDs that can be sent in a single request is 250; if there are more
	// Rules that should be run, you must make multiple calls to Check.
	//
	// All IDs must be be IDs of Rules returned by ListRules.
	RuleIds       []string `protobuf:"bytes,4,rep,name=rule_ids,json=ruleIds,proto3" json:"rule_ids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CheckRequest) Reset() {
	*x = CheckRequest{}
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckRequest) ProtoMessage() {}

func (x *CheckRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CheckRequest) GetFileDescriptors() []*v1.FileDescriptor {
	if x != nil {
		return x.FileDescriptors
	}
	return nil
}

func (x *CheckRequest) GetAgainstFileDescriptors() []*v1.FileDescriptor {
	if x != nil {
		return x.AgainstFileDescriptors
	}
	return nil
}

func (x *CheckRequest) GetOptions() []*v11.Option {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *CheckRequest) GetRuleIds() []string {
	if x != nil {
		return x.RuleIds
	}
	return nil
}

func (x *CheckRequest) SetFileDescriptors(v []*v1.FileDescriptor) {
	x.FileDescriptors = v
}

func (x *CheckRequest) SetAgainstFileDescriptors(v []*v1.FileDescriptor) {
	x.AgainstFileDescriptors = v
}

func (x *CheckRequest) SetOptions(v []*v11.Option) {
	x.Options = v
}

func (x *CheckRequest) SetRuleIds(v []string) {
	x.RuleIds = v
}

type CheckRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The FileDescriptors to check.
	//
	// Required.
	//
	// FileDescriptors are guaranteed to be unique by file_descriptor_proto.name.
	FileDescriptors []*v1.FileDescriptor
	// The FileDescriptors to check against.
	//
	// Optional.
	//
	// This is usually the state of the FileDescriptors at a previous VCS commit, or the state of
	// the FileDescriptors at a release tag.
	//
	// FileDescriptors are guaranteed to be unique by file_descriptor_proto.name.
	//
	// Note that this may be empty, even for breaking change checks, to account for
	// going from the empty state to the first set of FileDescriptors.
	AgainstFileDescriptors []*v1.FileDescriptor
	// Options for the Rules.
	//
	// Optional.
	//
	// Options may modify the behavior of a Rule.
	//
	// For now, callers are expected to know what keys are available, and how to construct Values
	// for each key. In the future, we may add a ListOptions or otherwise to CheckService that will
	// describe the available options keys, which can then be validated against.
	//
	// It is acceptable for a plugin to return an error on an unknown or misconstructed Option.
	Options []*v11.Option
	// The IDs of the Rules to check.
	//
	// Optional. If not specified, all Rules returned by ListRules are checked.
	//
	// The maximum number of Rule IDs that can be sent in a single request is 250; if there are more
	// Rules that should be run, you must make multiple calls to Check.
	//
	// All IDs must be be IDs of Rules returned by ListRules.
	RuleIds []string
}

func (b0 CheckRequest_builder) Build() *CheckRequest {
	m0 := &CheckRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.FileDescriptors = b.FileDescriptors
	x.AgainstFileDescriptors = b.AgainstFileDescriptors
	x.Options = b.Options
	x.RuleIds = b.RuleIds
	return m0
}

// A response containing annotations that the check returned from failures.
type CheckResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The annotations produced from Rule failures.
	//
	// All Annotations must have IDs that match the IDs of the Rules returned by ListRules.
	Annotations   []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CheckResponse) Reset() {
	*x = CheckResponse{}
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckResponse) ProtoMessage() {}

func (x *CheckResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CheckResponse) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *CheckResponse) SetAnnotations(v []*Annotation) {
	x.Annotations = v
}

type CheckResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The annotations produced from Rule failures.
	//
	// All Annotations must have IDs that match the IDs of the Rules returned by ListRules.
	Annotations []*Annotation
}

func (b0 CheckResponse_builder) Build() *CheckResponse {
	m0 := &CheckResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Annotations = b.Annotations
	return m0
}

// A request for the rules that the service implements.
type ListRulesRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The maximum number of items to return.
	//
	// The default value is 250.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned,
	PageToken     string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListRulesRequest) Reset() {
	*x = ListRulesRequest{}
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRulesRequest) ProtoMessage() {}

func (x *ListRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRulesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRulesRequest) SetPageSize(v uint32) {
	x.PageSize = v
}

func (x *ListRulesRequest) SetPageToken(v string) {
	x.PageToken = v
}

type ListRulesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 250.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned,
	PageToken string
}

func (b0 ListRulesRequest_builder) Build() *ListRulesRequest {
	m0 := &ListRulesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.PageSize = b.PageSize
	x.PageToken = b.PageToken
	return m0
}

// A response containing the rules that the service implements.
type ListRulesResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The rules that the service implements.
	//
	// The IDs of all Rules returned will be unique.
	// The IDs will also be unique relative to the Category IDs returned from ListCategories.
	//
	// Rules will only have Category IDs that are also returned from ListCategories, and every
	// Category returned from ListCategories will have at least one Rule with its Category ID.
	//
	// It is invalid for Check to respond with an Annotation that has an ID which
	// is not also the ID of a Rule within this list.
	Rules         []*Rule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListRulesResponse) Reset() {
	*x = ListRulesResponse{}
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRulesResponse) ProtoMessage() {}

func (x *ListRulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRulesResponse) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *ListRulesResponse) SetNextPageToken(v string) {
	x.NextPageToken = v
}

func (x *ListRulesResponse) SetRules(v []*Rule) {
	x.Rules = v
}

type ListRulesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The rules that the service implements.
	//
	// The IDs of all Rules returned will be unique.
	// The IDs will also be unique relative to the Category IDs returned from ListCategories.
	//
	// Rules will only have Category IDs that are also returned from ListCategories, and every
	// Category returned from ListCategories will have at least one Rule with its Category ID.
	//
	// It is invalid for Check to respond with an Annotation that has an ID which
	// is not also the ID of a Rule within this list.
	Rules []*Rule
}

func (b0 ListRulesResponse_builder) Build() *ListRulesResponse {
	m0 := &ListRulesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.NextPageToken = b.NextPageToken
	x.Rules = b.Rules
	return m0
}

// A request for the categories that the service implements.
type ListCategoriesRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The maximum number of items to return.
	//
	// The default value is 250.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned,
	PageToken     string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListCategoriesRequest) Reset() {
	*x = ListCategoriesRequest{}
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCategoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCategoriesRequest) ProtoMessage() {}

func (x *ListCategoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListCategoriesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCategoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCategoriesRequest) SetPageSize(v uint32) {
	x.PageSize = v
}

func (x *ListCategoriesRequest) SetPageToken(v string) {
	x.PageToken = v
}

type ListCategoriesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 250.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned,
	PageToken string
}

func (b0 ListCategoriesRequest_builder) Build() *ListCategoriesRequest {
	m0 := &ListCategoriesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.PageSize = b.PageSize
	x.PageToken = b.PageToken
	return m0
}

// A response containing the categories that the service implements.
type ListCategoriesResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The categories that the service implements.
	//
	// The IDs of all Categories returned will be unique.
	// The IDs will also be unique relative to the Rule IDs returned from ListRules.
	//
	// Rules will only have Category IDs that are also returned from ListCategories, and every
	// Category returned from ListCategories will have at least one Rule with its Category ID.
	//
	// It is invalid for Check to respond with an Annotation that has an ID which
	// is not also the ID of a Category within this list.
	Categories    []*Category `protobuf:"bytes,2,rep,name=categories,proto3" json:"categories,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListCategoriesResponse) Reset() {
	*x = ListCategoriesResponse{}
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCategoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCategoriesResponse) ProtoMessage() {}

func (x *ListCategoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_check_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListCategoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCategoriesResponse) GetCategories() []*Category {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *ListCategoriesResponse) SetNextPageToken(v string) {
	x.NextPageToken = v
}

func (x *ListCategoriesResponse) SetCategories(v []*Category) {
	x.Categories = v
}

type ListCategoriesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The categories that the service implements.
	//
	// The IDs of all Categories returned will be unique.
	// The IDs will also be unique relative to the Rule IDs returned from ListRules.
	//
	// Rules will only have Category IDs that are also returned from ListCategories, and every
	// Category returned from ListCategories will have at least one Rule with its Category ID.
	//
	// It is invalid for Check to respond with an Annotation that has an ID which
	// is not also the ID of a Category within this list.
	Categories []*Category
}

func (b0 ListCategoriesResponse_builder) Build() *ListCategoriesResponse {
	m0 := &ListCategoriesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.NextPageToken = b.NextPageToken
	x.Categories = b.Categories
	return m0
}

var File_buf_plugin_check_v1_check_service_proto protoreflect.FileDescriptor

const file_buf_plugin_check_v1_check_service_proto_rawDesc = "" +
	"\n" +
	"'buf/plugin/check/v1/check_service.proto\x12\x13buf.plugin.check.v1\x1a$buf/plugin/check/v1/annotation.proto\x1a\"buf/plugin/check/v1/category.proto\x1a\x1ebuf/plugin/check/v1/rule.proto\x1a.buf/plugin/descriptor/v1/file_descriptor.proto\x1a!buf/plugin/option/v1/option.proto\x1a\x1bbuf/validate/validate.proto\"\x98\x06\n" +
	"\fCheckRequest\x12\xbb\x02\n" +
	"\x10file_descriptors\x18\x01 \x03(\v2(.buf.plugin.descriptor.v1.FileDescriptorB\xe5\x01\xbaH\xe1\x01\xba\x01\xd8\x01\n" +
	"\x1cfile_descriptor_names_unique\x12#FileDescriptor names must be unique\x1a\x92\x01this.filter(file_descriptor, has(file_descriptor.file_descriptor_proto)).map(file_descriptor, file_descriptor.file_descriptor_proto.name).unique()\x92\x01\x02\b\x01R\x0ffileDescriptors\x12\xc5\x02\n" +
	"\x18against_file_descriptors\x18\x02 \x03(\v2(.buf.plugin.descriptor.v1.FileDescriptorB\xe0\x01\xbaH\xdc\x01\xba\x01\xd8\x01\n" +
	"\x1cfile_descriptor_names_unique\x12#FileDescriptor names must be unique\x1a\x92\x01this.filter(file_descriptor, has(file_descriptor.file_descriptor_proto)).map(file_descriptor, file_descriptor.file_descriptor_proto.name).unique()R\x16againstFileDescriptors\x126\n" +
	"\aoptions\x18\x03 \x03(\v2\x1c.buf.plugin.option.v1.OptionR\aoptions\x12J\n" +
	"\brule_ids\x18\x04 \x03(\tB/\xbaH,\x92\x01)\x10\xfa\x01\"$r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\aruleIds\"R\n" +
	"\rCheckResponse\x12A\n" +
	"\vannotations\x18\x01 \x03(\v2\x1f.buf.plugin.check.v1.AnnotationR\vannotations\"b\n" +
	"\x10ListRulesRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xe8\aR\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\"\xd0\x01\n" +
	"\x11ListRulesResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x12\x88\x01\n" +
	"\x05rules\x18\x02 \x03(\v2\x19.buf.plugin.check.v1.RuleBW\xbaHT\xba\x01L\n" +
	"\x0frule_ids_unique\x12\x17rule ids must be unique\x1a this.map(rule, rule.id).unique()\x92\x01\x02\b\x01R\x05rules\"g\n" +
	"\x15ListCategoriesRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xe8\aR\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\"\xee\x01\n" +
	"\x16ListCategoriesResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x12\xa1\x01\n" +
	"\n" +
	"categories\x18\x02 \x03(\v2\x1d.buf.plugin.check.v1.CategoryBb\xbaH_\xba\x01\\\n" +
	"\x13category_ids_unique\x12\x1bcategory ids must be unique\x1a(this.map(category, category.id).unique()R\n" +
	"categories2\xb4\x02\n" +
	"\fCheckService\x12S\n" +
	"\x05Check\x12!.buf.plugin.check.v1.CheckRequest\x1a\".buf.plugin.check.v1.CheckResponse\"\x03\x90\x02\x01\x12_\n" +
	"\tListRules\x12%.buf.plugin.check.v1.ListRulesRequest\x1a&.buf.plugin.check.v1.ListRulesResponse\"\x03\x90\x02\x01\x12n\n" +
	"\x0eListCategories\x12*.buf.plugin.check.v1.ListCategoriesRequest\x1a+.buf.plugin.check.v1.ListCategoriesResponse\"\x03\x90\x02\x01BTZRbuf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/check/v1;checkv1b\x06proto3"

var file_buf_plugin_check_v1_check_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_buf_plugin_check_v1_check_service_proto_goTypes = []any{
	(*CheckRequest)(nil),           // 0: buf.plugin.check.v1.CheckRequest
	(*CheckResponse)(nil),          // 1: buf.plugin.check.v1.CheckResponse
	(*ListRulesRequest)(nil),       // 2: buf.plugin.check.v1.ListRulesRequest
	(*ListRulesResponse)(nil),      // 3: buf.plugin.check.v1.ListRulesResponse
	(*ListCategoriesRequest)(nil),  // 4: buf.plugin.check.v1.ListCategoriesRequest
	(*ListCategoriesResponse)(nil), // 5: buf.plugin.check.v1.ListCategoriesResponse
	(*v1.FileDescriptor)(nil),      // 6: buf.plugin.descriptor.v1.FileDescriptor
	(*v11.Option)(nil),             // 7: buf.plugin.option.v1.Option
	(*Annotation)(nil),             // 8: buf.plugin.check.v1.Annotation
	(*Rule)(nil),                   // 9: buf.plugin.check.v1.Rule
	(*Category)(nil),               // 10: buf.plugin.check.v1.Category
}
var file_buf_plugin_check_v1_check_service_proto_depIdxs = []int32{
	6,  // 0: buf.plugin.check.v1.CheckRequest.file_descriptors:type_name -> buf.plugin.descriptor.v1.FileDescriptor
	6,  // 1: buf.plugin.check.v1.CheckRequest.against_file_descriptors:type_name -> buf.plugin.descriptor.v1.FileDescriptor
	7,  // 2: buf.plugin.check.v1.CheckRequest.options:type_name -> buf.plugin.option.v1.Option
	8,  // 3: buf.plugin.check.v1.CheckResponse.annotations:type_name -> buf.plugin.check.v1.Annotation
	9,  // 4: buf.plugin.check.v1.ListRulesResponse.rules:type_name -> buf.plugin.check.v1.Rule
	10, // 5: buf.plugin.check.v1.ListCategoriesResponse.categories:type_name -> buf.plugin.check.v1.Category
	0,  // 6: buf.plugin.check.v1.CheckService.Check:input_type -> buf.plugin.check.v1.CheckRequest
	2,  // 7: buf.plugin.check.v1.CheckService.ListRules:input_type -> buf.plugin.check.v1.ListRulesRequest
	4,  // 8: buf.plugin.check.v1.CheckService.ListCategories:input_type -> buf.plugin.check.v1.ListCategoriesRequest
	1,  // 9: buf.plugin.check.v1.CheckService.Check:output_type -> buf.plugin.check.v1.CheckResponse
	3,  // 10: buf.plugin.check.v1.CheckService.ListRules:output_type -> buf.plugin.check.v1.ListRulesResponse
	5,  // 11: buf.plugin.check.v1.CheckService.ListCategories:output_type -> buf.plugin.check.v1.ListCategoriesResponse
	9,  // [9:12] is the sub-list for method output_type
	6,  // [6:9] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_buf_plugin_check_v1_check_service_proto_init() }
func file_buf_plugin_check_v1_check_service_proto_init() {
	if File_buf_plugin_check_v1_check_service_proto != nil {
		return
	}
	file_buf_plugin_check_v1_annotation_proto_init()
	file_buf_plugin_check_v1_category_proto_init()
	file_buf_plugin_check_v1_rule_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_plugin_check_v1_check_service_proto_rawDesc), len(file_buf_plugin_check_v1_check_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_plugin_check_v1_check_service_proto_goTypes,
		DependencyIndexes: file_buf_plugin_check_v1_check_service_proto_depIdxs,
		MessageInfos:      file_buf_plugin_check_v1_check_service_proto_msgTypes,
	}.Build()
	File_buf_plugin_check_v1_check_service_proto = out.File
	file_buf_plugin_check_v1_check_service_proto_goTypes = nil
	file_buf_plugin_check_v1_check_service_proto_depIdxs = nil
}
