/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertificateFactoryImpl;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.util.DerOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CertPathImpl
extends CertPath {
    private LinkedList certPathList = new LinkedList();
    private CertificateFactoryImpl cf = new CertificateFactoryImpl();
    static final long serialVersionUID = -1365003539579449970L;

    CertPathImpl(String type, List certs) {
        super(type);
        for (X509Certificate thisCert : certs) {
            this.certPathList.add(thisCert);
        }
    }

    CertPathImpl(String type, List certs, boolean forward) {
        super(type);
        if (forward) {
            for (X509Certificate thisCert : certs) {
                this.certPathList.add(thisCert);
            }
        } else {
            for (int i = certs.size(); i > 0; --i) {
                X509Certificate thisCert = (X509Certificate)certs.get(i);
                this.certPathList.add(thisCert);
            }
        }
    }

    public Iterator getEncodings() {
        Iterator it = this.cf.engineGetCertPathEncodings();
        return it;
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.pkiPathEncoded();
    }

    private byte[] pkcs7Encoded() throws CertificateEncodingException {
        byte[] ba_contentInfo = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Certificate[] certArray = new Certificate[this.certPathList.size()];
        CRL[] crlArray = null;
        ContentInfo contentInfo = null;
        SignedData signedData = null;
        int j = 0;
        Iterator certPathI = this.certPathList.iterator();
        while (certPathI.hasNext()) {
            certArray[j] = (Certificate)certPathI.next();
            ++j;
        }
        try {
            signedData = new SignedData(certArray, crlArray);
            contentInfo = new ContentInfo((Content)signedData);
            contentInfo.encode((OutputStream)baos);
            ba_contentInfo = baos.toByteArray();
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("Exception caught while encoding certificates in PKCS7 format: " + ex);
        }
        return ba_contentInfo;
    }

    @Override
    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        byte[] ba = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object enc = null;
        Iterator thisCertPathIterator = this.certPathList.iterator();
        if (encoding.equals("PKCS7")) {
            ba = this.pkcs7Encoded();
            return ba;
        }
        if (encoding.equals("PkiPath")) {
            ba = this.pkiPathEncoded();
            return ba;
        }
        return ba;
    }

    public List getCertificates() {
        return new LinkedList(this.certPathList);
    }

    private byte[] pkiPathEncoded() throws CertificateEncodingException {
        LinkedList list = new LinkedList(this.certPathList);
        try {
            int size = list.size();
            DerOutputStream temp = new DerOutputStream();
            for (int i = size - 1; i >= 0; --i) {
                X509Certificate cert = (X509Certificate)list.get(i);
                byte[] encoded = cert.getEncoded();
                temp.write(encoded);
            }
            DerOutputStream dos = new DerOutputStream();
            dos.write((byte)48, temp);
            return dos.toByteArray();
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("Exception caught while encoding certificates in PkiPath format: " + ex);
        }
    }
}

