/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.oti.vm.VMLangAccess;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeHelper;
import java.lang.invoke.OpenJDKCompileStub;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.Objects;
import sun.misc.Unsafe;
import sun.reflect.ConstantPool;

final class MethodHandleResolver {
    static final Unsafe UNSAFE = Unsafe.getUnsafe();
    static final JITHelpers JITHELPERS = JITHelpers.getHelpers();
    private static final int BSM_ARGUMENT_SIZE = 2;
    private static final int BSM_ARGUMENT_COUNT_OFFSET = 2;
    private static final int BSM_ARGUMENTS_OFFSET = 4;
    private static final int BSM_LOOKUP_ARGUMENT_INDEX = 0;
    private static final int BSM_NAME_ARGUMENT_INDEX = 1;
    private static final int BSM_TYPE_ARGUMENT_INDEX = 2;
    private static final int BSM_OPTIONAL_ARGUMENTS_START_INDEX = 3;

    MethodHandleResolver() {
    }

    private static final native int getCPTypeAt(Object var0, int var1);

    private static final native MethodType getCPMethodTypeAt(Object var0, int var1);

    private static final native MethodHandle getCPMethodHandleAt(Object var0, int var1);

    private static final native String getCPClassNameAt(Object var0, int var1);

    private static Object constructorPlaceHolder(Object newObjectRef) {
        return newObjectRef;
    }

    private static final Object invokeBsm(MethodHandle bsm, Object[] staticArgs) throws Throwable {
        Object result = null;
        switch (staticArgs.length) {
            case 3: {
                result = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2]);
                break;
            }
            case 4: {
                result = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3]);
                break;
            }
            case 5: {
                result = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4]);
                break;
            }
            case 6: {
                result = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4], staticArgs[5]);
                break;
            }
            case 7: {
                result = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4], staticArgs[5], staticArgs[6]);
                break;
            }
            default: {
                result = bsm.invokeWithArguments(staticArgs);
            }
        }
        return result;
    }

    private static final Object resolveInvokeDynamic(long j9class, String name, String methodDescriptor, long bsmData) throws Throwable {
        MethodHandle result = null;
        MethodType type = null;
        try {
            VMLangAccess access = VM.getVMLangAccess();
            Object internalConstantPool = access.getInternalConstantPoolFromJ9Class(j9class);
            Class<?> classObject = MethodHandleResolver.getClassFromJ9Class(j9class);
            type = MethodTypeHelper.vmResolveFromMethodDescriptorString(methodDescriptor, access.getClassloader(classObject), null);
            MethodHandles.Lookup lookup = new MethodHandles.Lookup(classObject, false);
            try {
                lookup.accessCheckArgRetTypes(type);
            }
            catch (IllegalAccessException e) {
                IllegalAccessError err = new IllegalAccessError();
                err.initCause(e);
                throw err;
            }
            short bsmIndex = UNSAFE.getShort(bsmData);
            int bsmArgCount = UNSAFE.getShort(bsmData + 2L);
            long bsmArgs = bsmData + 4L;
            MethodHandle bsm = MethodHandleResolver.getCPMethodHandleAt(internalConstantPool, bsmIndex);
            if (bsm == null) {
                throw new NullPointerException(Msg.getString("K05cd", (Object)classObject.toString(), bsmIndex));
            }
            Object[] staticArgs = new Object[3 + bsmArgCount];
            staticArgs[0] = lookup;
            staticArgs[1] = name;
            staticArgs[2] = type;
            int bsmTypeArgCount = bsm.type().parameterCount();
            for (int i = 0; i < bsmArgCount; ++i) {
                staticArgs[3 + i] = MethodHandleResolver.getAdditionalBsmArg(access, internalConstantPool, classObject, bsm, bsmArgs, bsmTypeArgCount, i);
            }
            CallSite cs = (CallSite)MethodHandleResolver.invokeBsm(bsm, staticArgs);
            if (cs != null) {
                MethodType callsiteType = cs.type();
                if (callsiteType != type) {
                    throw WrongMethodTypeException.newWrongMethodTypeException(type, callsiteType);
                }
                result = cs.dynamicInvoker();
            }
        }
        catch (Throwable e) {
            if (type == null) {
                throw new BootstrapMethodError(e);
            }
            try {
                MethodHandle thrower = MethodHandles.throwException(type.returnType(), BootstrapMethodError.class);
                MethodHandle constructor = MethodHandles.Lookup.IMPL_LOOKUP.findConstructor(BootstrapMethodError.class, MethodType.methodType(Void.TYPE, Throwable.class));
                result = MethodHandles.foldArguments(thrower, constructor.bindTo(e));
                result = MethodHandles.dropArguments(result, 0, type.parameterList());
            }
            catch (IllegalAccessException iae) {
                throw new Error(iae);
            }
            catch (NoSuchMethodException nsme) {
                throw new Error(nsme);
            }
        }
        return result;
    }

    private static final MethodHandle sendResolveMethodHandle(int cpRefKind, Class<?> currentClass, Class<?> referenceClazz, String name, String typeDescriptor, ClassLoader loader) throws Throwable {
        MethodType type = null;
        try {
            MethodHandles.Lookup lookup = new MethodHandles.Lookup(currentClass, false);
            MethodHandle result = null;
            switch (cpRefKind) {
                case 1: {
                    result = lookup.findGetter(referenceClazz, name, MethodHandleResolver.resolveFieldHandleHelper(typeDescriptor, lookup, loader));
                    break;
                }
                case 2: {
                    result = lookup.findStaticGetter(referenceClazz, name, MethodHandleResolver.resolveFieldHandleHelper(typeDescriptor, lookup, loader));
                    break;
                }
                case 3: {
                    result = lookup.findSetter(referenceClazz, name, MethodHandleResolver.resolveFieldHandleHelper(typeDescriptor, lookup, loader));
                    break;
                }
                case 4: {
                    result = lookup.findStaticSetter(referenceClazz, name, MethodHandleResolver.resolveFieldHandleHelper(typeDescriptor, lookup, loader));
                    break;
                }
                case 5: {
                    type = MethodTypeHelper.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findVirtual(referenceClazz, name, type);
                    break;
                }
                case 6: {
                    type = MethodTypeHelper.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findStatic(referenceClazz, name, type);
                    break;
                }
                case 7: {
                    type = MethodTypeHelper.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findSpecial(referenceClazz, name, type, currentClass);
                    break;
                }
                case 8: {
                    type = MethodTypeHelper.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findConstructor(referenceClazz, type);
                    break;
                }
                case 9: {
                    type = MethodTypeHelper.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findVirtual(referenceClazz, name, type);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return result;
        }
        catch (IllegalAccessException iae) {
            throw new IllegalAccessError(iae.getMessage()).initCause(iae);
        }
    }

    private static final Class<?> resolveFieldHandleHelper(String typeDescriptor, MethodHandles.Lookup lookup, ClassLoader loader) throws Throwable {
        MethodType mt = MethodTypeHelper.vmResolveFromMethodDescriptorString("(" + typeDescriptor + ")V", loader, null);
        lookup.accessCheckArgRetTypes(mt);
        return mt.parameterType(0);
    }

    private static final Class<?> getClassFromJ9Class(long j9class) throws Throwable {
        Class classObject = null;
        classObject = JITHELPERS.is32Bit() ? JITHELPERS.getClassFromJ9Class32((int)j9class) : JITHELPERS.getClassFromJ9Class64(j9class);
        Objects.requireNonNull(classObject);
        return classObject;
    }

    private static final Class<?> fromFieldDescriptorString(String fieldDescriptor, ClassLoader classLoader) {
        ArrayList classList = new ArrayList();
        int length = fieldDescriptor.length();
        if (length == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", fieldDescriptor));
        }
        char[] signature = new char[length];
        fieldDescriptor.getChars(0, length, signature, 0);
        MethodTypeHelper.parseIntoClass(signature, 0, classList, classLoader, fieldDescriptor);
        return classList.get(0);
    }

    private static final Object getAdditionalBsmArg(VMLangAccess access, Object internalConstantPool, Class<?> classObject, MethodHandle bsm, long bsmArgs, int bsmTypeArgCount, int argIndex) throws Throwable {
        boolean treatLastArgAsVarargs = bsm.isVarargsCollector();
        ConstantPool cp = access.getConstantPool(internalConstantPool);
        int staticArgIndex = 3 + argIndex;
        short index = UNSAFE.getShort(bsmArgs + (long)(argIndex * 2));
        int cpType = MethodHandleResolver.getCPTypeAt(internalConstantPool, index);
        Object cpEntry = null;
        switch (cpType) {
            case 1: {
                cpEntry = cp.getClassAt((int)index);
                if (cpEntry != null) break;
                throw MethodHandleResolver.throwNoClassDefFoundError(internalConstantPool, index);
            }
            case 2: {
                cpEntry = cp.getStringAt((int)index);
                break;
            }
            case 3: {
                int cpValue = cp.getIntAt((int)index);
                Class<?> argClass = null;
                if (treatLastArgAsVarargs && staticArgIndex >= bsmTypeArgCount - 1) {
                    argClass = bsm.type().lastParameterType().getComponentType();
                } else if (staticArgIndex < bsmTypeArgCount) {
                    argClass = bsm.type().parameterType(staticArgIndex);
                }
                if (argClass == Short.TYPE) {
                    cpEntry = (short)cpValue;
                    break;
                }
                if (argClass == Boolean.TYPE) {
                    cpEntry = cpValue == 0 ? Boolean.FALSE : Boolean.TRUE;
                    break;
                }
                if (argClass == Byte.TYPE) {
                    cpEntry = (byte)cpValue;
                    break;
                }
                if (argClass == Character.TYPE) {
                    cpEntry = Character.valueOf((char)cpValue);
                    break;
                }
                cpEntry = cpValue;
                break;
            }
            case 4: {
                cpEntry = Float.valueOf(cp.getFloatAt((int)index));
                break;
            }
            case 5: {
                cpEntry = cp.getLongAt((int)index);
                break;
            }
            case 6: {
                cpEntry = cp.getDoubleAt((int)index);
                break;
            }
            case 13: {
                cpEntry = MethodHandleResolver.getCPMethodTypeAt(internalConstantPool, index);
                break;
            }
            case 14: {
                cpEntry = MethodHandleResolver.getCPMethodHandleAt(internalConstantPool, index);
                break;
            }
        }
        cpEntry.getClass();
        return cpEntry;
    }

    private static final Throwable throwNoClassDefFoundError(Object internalConstantPool, int index) {
        String className = MethodHandleResolver.getCPClassNameAt(internalConstantPool, index);
        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(className);
        noClassDefFoundError.initCause(new ClassNotFoundException(className));
        throw noClassDefFoundError;
    }

    static long getJ9ClassFromClass(Class<?> c) {
        if (JITHELPERS.is32Bit()) {
            return JITHELPERS.getJ9ClassFromClass32(c);
        }
        return JITHELPERS.getJ9ClassFromClass64(c);
    }

    private static final Object linkCallerMethod(Class<?> callerClass, int refKind, Class<?> definingClass, String name, String type) throws Throwable {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }
}

