/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private String detailMessage;
    private transient Object walkback;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace;
    private static final Throwable[] ZeroElementArray = new Throwable[0];
    private static final StackTraceElement[] ZeroStackTraceElementArray = new StackTraceElement[0];
    private List<Throwable> suppressedExceptions = Collections.emptyList();
    private transient boolean disableWritableStackTrace;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String detailMessage) {
        this();
        this.detailMessage = detailMessage;
    }

    public Throwable(String detailMessage, Throwable throwable) {
        this();
        this.detailMessage = detailMessage;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    protected Throwable(String detailMessage, Throwable throwable, boolean enableSuppression, boolean enableWritableStackTrace) {
        this.detailMessage = detailMessage;
        this.cause = throwable;
        if (!enableSuppression) {
            this.suppressedExceptions = null;
        }
        if (!enableWritableStackTrace) {
            this.disableWritableStackTrace = true;
        } else {
            this.fillInStackTrace();
        }
    }

    public native Throwable fillInStackTrace();

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getInternalStackTrace().clone();
    }

    public void setStackTrace(StackTraceElement[] trace) {
        if (trace == null) {
            throw new NullPointerException();
        }
        StackTraceElement[] localCopy = (StackTraceElement[])trace.clone();
        for (int i = 0; i < localCopy.length; ++i) {
            if (localCopy[i] != null) continue;
            throw new NullPointerException();
        }
        if (this.disableWritableStackTrace) {
            return;
        }
        this.stackTrace = localCopy;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private static int countDuplicates(StackTraceElement[] currentStack, StackTraceElement[] parentStack) {
        StackTraceElement parentFrame;
        int duplicates = 0;
        int parentIndex = parentStack.length;
        int i = currentStack.length;
        while (--i >= 0 && --parentIndex >= 0 && (parentFrame = parentStack[parentIndex]).equals(currentStack[i])) {
            ++duplicates;
        }
        return duplicates;
    }

    StackTraceElement[] getInternalStackTrace() {
        if (this.disableWritableStackTrace) {
            return ZeroStackTraceElementArray;
        }
        StackTraceElement[] localStackTrace = this.stackTrace;
        if (localStackTrace == null) {
            localStackTrace = J9VMInternals.getStackTrace(this, true);
            this.stackTrace = localStackTrace;
        }
        return localStackTrace;
    }

    public void printStackTrace(PrintStream err) {
        this.printStackTraceHelper(err);
    }

    public void printStackTrace(PrintWriter err) {
        this.printStackTraceHelper(err);
    }

    private void printStackTraceHelper(Appendable appendable) {
        Set<Throwable> exceptionChainSet = null;
        try {
            exceptionChainSet = Collections.newSetFromMap(new IdentityHashMap());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        StackTraceElement[] stack = this.printStackTrace(appendable, null, 0, false, exceptionChainSet);
        for (Throwable throwable = this.getCause(); throwable != null && stack != null; throwable = throwable.getCause()) {
            stack = throwable.printStackTrace(appendable, stack, 0, false, exceptionChainSet);
        }
    }

    public String toString() {
        String msg = this.getLocalizedMessage();
        String name = this.getClass().getName();
        if (msg == null) {
            return name;
        }
        int length = name.length() + 2 + msg.length();
        StringBuilder buffer = new StringBuilder(length);
        return buffer.append(name).append(": ").append(msg).toString();
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException(Msg.getString("K05c9"), this);
        }
        if (throwable == this) {
            throw new IllegalArgumentException(Msg.getString("K05c8"), this);
        }
        return this.setCause(throwable);
    }

    Throwable setCause(Throwable throwable) {
        this.cause = throwable;
        return this;
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.getInternalStackTrace();
        s.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        block15: {
            s.defaultReadObject();
            boolean bl = this.disableWritableStackTrace = this.stackTrace == null;
            if (this.stackTrace != null) {
                if (this.stackTrace.length == 1) {
                    if (this.stackTrace[0] == null) {
                        throw new NullPointerException(Msg.getString("K0560"));
                    }
                    if (this.stackTrace[0].equals(new StackTraceElement("", "", null, Integer.MIN_VALUE))) {
                        this.stackTrace = null;
                    }
                } else {
                    for (int i = 0; i < this.stackTrace.length; ++i) {
                        if (this.stackTrace[i] != null) continue;
                        throw new NullPointerException(Msg.getString("K0560"));
                    }
                }
            }
            if (this.suppressedExceptions != null) {
                List newList = Collections.emptyList();
                try {
                    ClassLoader listClassLoader = this.suppressedExceptions.getClass().getClassLoader();
                    if (listClassLoader == null) {
                        int listSize = this.suppressedExceptions.size();
                        if (listSize != 0) {
                            newList = new ArrayList(listSize);
                            for (Throwable t : this.suppressedExceptions) {
                                if (t == null) {
                                    throw new NullPointerException(Msg.getString("K0561"));
                                }
                                if (t == this) {
                                    throw new IllegalArgumentException(Msg.getString("K0562"));
                                }
                                newList.add(t);
                            }
                        }
                        break block15;
                    }
                    throw new StreamCorruptedException(Msg.getString("K0C00"));
                }
                finally {
                    this.suppressedExceptions = newList;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StackTraceElement[] printStackTrace(Appendable err, StackTraceElement[] parentStack, int indents, boolean suppressed, Set<Throwable> exceptionChainSet) {
        StackTraceElement[] stack;
        if (err == null) {
            throw new NullPointerException();
        }
        boolean outOfMemory = this instanceof OutOfMemoryError;
        if (exceptionChainSet != null && exceptionChainSet.contains(this)) {
            if (!outOfMemory) {
                try {
                    Util.appendTo(err, "\t[CIRCULAR REFERENCE:" + this.toString() + "]", 0);
                }
                catch (OutOfMemoryError e) {
                    outOfMemory = true;
                }
            }
            if (outOfMemory) {
                Util.appendTo(err, "\t[CIRCULAR REFERENCE:");
                try {
                    Util.appendTo(err, this.getClass().getName());
                }
                catch (OutOfMemoryError e) {
                    Util.appendTo(err, "java.lang.OutOfMemoryError(?)");
                }
                Util.appendTo(err, "]");
            }
            Util.appendLnTo(err);
            return null;
        }
        try {
            if (exceptionChainSet != null) {
                exceptionChainSet.add(this);
            }
        }
        catch (OutOfMemoryError e) {
            // empty catch block
        }
        if (parentStack != null) {
            if (suppressed) {
                Util.appendTo(err, "Suppressed: ", indents);
            } else {
                Util.appendTo(err, "Caused by: ", indents);
            }
        }
        if (!outOfMemory) {
            try {
                Util.appendTo(err, this.toString());
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
            }
        }
        if (outOfMemory) {
            try {
                Util.appendTo(err, this.getClass().getName());
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
                Util.appendTo(err, "java.lang.OutOfMemoryError(?)");
            }
            try {
                String message = this.getLocalizedMessage();
                if (message != null) {
                    Util.appendTo(err, ": ");
                    Util.appendTo(err, message);
                }
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
            }
        }
        Util.appendLnTo(err);
        int duplicates = 0;
        try {
            stack = this.getInternalStackTrace();
            if (parentStack != null) {
                duplicates = Throwable.countDuplicates(stack, parentStack);
            }
        }
        catch (OutOfMemoryError e) {
            Util.appendTo(err, "\tat ?", indents);
            Util.appendLnTo(err);
            return null;
        }
        for (int i = 0; i < stack.length - duplicates; ++i) {
            StackTraceElement element = stack[i];
            if (!outOfMemory) {
                try {
                    Util.appendTo(err, "\tat " + element, indents);
                }
                catch (OutOfMemoryError e) {
                    outOfMemory = true;
                }
            }
            if (outOfMemory) {
                Util.appendTo(err, "\tat ", indents);
                Util.printStackTraceElement(element, null, err, false);
            }
            Util.appendLnTo(err);
        }
        if (duplicates > 0) {
            if (!outOfMemory) {
                try {
                    Util.appendTo(err, "\t... " + duplicates + " more", indents);
                }
                catch (OutOfMemoryError e) {
                    outOfMemory = true;
                }
            }
            if (outOfMemory) {
                Util.appendTo(err, "\t... ", indents);
                Util.appendTo(err, duplicates);
                Util.appendTo(err, " more");
            }
            Util.appendLnTo(err);
        }
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.suppressedExceptions != null) {
                for (Throwable t : this.suppressedExceptions) {
                    StackTraceElement[] stackSuppressed = t.printStackTrace(err, stack, indents + 1, true, exceptionChainSet);
                    for (Throwable throwableSuppressed = t.getCause(); throwableSuppressed != null && stackSuppressed != null; throwableSuppressed = throwableSuppressed.getCause()) {
                        stackSuppressed = throwableSuppressed.printStackTrace(err, stackSuppressed, indents + 1, false, exceptionChainSet);
                    }
                }
            }
        }
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSuppressed(Throwable exception) {
        if (exception == null) {
            throw new NullPointerException(Msg.getString("K0563"));
        }
        if (exception == this) {
            throw new IllegalArgumentException(Msg.getString("K0559"));
        }
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.suppressedExceptions != null) {
                if (this.suppressedExceptions.size() == 0) {
                    this.suppressedExceptions = new ArrayList<Throwable>(2);
                }
                this.suppressedExceptions.add(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable[] getSuppressed() {
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.suppressedExceptions == null || this.suppressedExceptions.size() == 0) {
                return ZeroElementArray;
            }
            return this.suppressedExceptions.toArray(new Throwable[this.suppressedExceptions.size()]);
        }
    }
}

