/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.RoundingMode;
import org.apache.harmony.math.internal.nls.Messages;

public final class MathContext
implements Serializable {
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    private static final long serialVersionUID = 5579720004786848255L;
    private int precision;
    private RoundingMode roundingMode;
    private static final char[] chPrecision = new char[]{'p', 'r', 'e', 'c', 'i', 's', 'i', 'o', 'n', '='};
    private static final char[] chRoundingMode = new char[]{'r', 'o', 'u', 'n', 'd', 'i', 'n', 'g', 'M', 'o', 'd', 'e', '='};

    public MathContext(int n) {
        this(n, RoundingMode.HALF_UP);
    }

    public MathContext(int n, RoundingMode roundingMode) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("math.0C"));
        }
        if (roundingMode == null) {
            throw new NullPointerException(Messages.getString("math.0D"));
        }
        this.precision = n;
        this.roundingMode = roundingMode;
    }

    public MathContext(String string) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        if (cArray.length < 27 || cArray.length > 45) {
            throw new IllegalArgumentException(Messages.getString("math.0E"));
        }
        for (n2 = 0; n2 < chPrecision.length && cArray[n2] == chPrecision[n2]; ++n2) {
        }
        if (n2 < chPrecision.length) {
            throw new IllegalArgumentException(Messages.getString("math.0E"));
        }
        int n3 = Character.digit(cArray[n2], 10);
        if (n3 == -1) {
            throw new IllegalArgumentException(Messages.getString("math.0E"));
        }
        this.precision = this.precision * 10 + n3;
        ++n2;
        while (true) {
            if ((n3 = Character.digit(cArray[n2], 10)) == -1) {
                if (cArray[n2] == ' ') {
                    ++n2;
                    break;
                }
                throw new IllegalArgumentException(Messages.getString("math.0E"));
            }
            this.precision = this.precision * 10 + n3;
            if (this.precision < 0) {
                throw new IllegalArgumentException(Messages.getString("math.0E"));
            }
            ++n2;
        }
        for (n = 0; n < chRoundingMode.length && cArray[n2] == chRoundingMode[n]; ++n) {
            ++n2;
        }
        if (n < chRoundingMode.length) {
            throw new IllegalArgumentException(Messages.getString("math.0E"));
        }
        this.roundingMode = RoundingMode.valueOf(String.valueOf(cArray, n2, cArray.length - n2));
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public boolean equals(Object object) {
        return object instanceof MathContext && ((MathContext)object).getPrecision() == this.precision && ((MathContext)object).getRoundingMode() == this.roundingMode;
    }

    public int hashCode() {
        return this.precision << 3 | this.roundingMode.ordinal();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(45);
        stringBuilder.append(chPrecision);
        stringBuilder.append(this.precision);
        stringBuilder.append(' ');
        stringBuilder.append(chRoundingMode);
        stringBuilder.append((Object)this.roundingMode);
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.precision < 0) {
            throw new StreamCorruptedException(Messages.getString("math.0F"));
        }
        if (this.roundingMode == null) {
            throw new StreamCorruptedException(Messages.getString("math.10"));
        }
    }
}

