/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.memory.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.memory.MemoryLabels;
import com.ibm.java.diagnostics.healthcenter.memory.Messages;
import java.text.MessageFormat;

public class LookForNativeLeaks {
    private static final int NUMBER_OF_POINTS_REQUIRED_FOR_LEAK_ANALYSIS = 100;
    private static final double ONE_HUNDRED_PERCENT = 100.0;
    private static final int DEFAULT_LEAK_THRESHOLD = 10;

    public void recommend(DataBuilder dataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.MEMORY);
        if (subsystemDataBuilder != null) {
            this.lookForLeaks(subsystemDataBuilder, structuredStringDataBuilder);
            Data data = subsystemDataBuilder.getData(MemoryLabels.BYTES_DEEP_LABEL);
            this.walkBytesDeepTree(data, structuredStringDataBuilder);
        }
    }

    private void walkBytesDeepTree(Data data, StructuredStringDataBuilder structuredStringDataBuilder) {
        if (data != null) {
            if (data.hasChildren()) {
                Data[] dataArray;
                for (Data data2 : dataArray = data.getChildren()) {
                    this.walkBytesDeepTree(data2, structuredStringDataBuilder);
                }
            } else {
                this.lookForJVMBreakdownLeaks((TwoDimensionalData)data, structuredStringDataBuilder);
            }
        }
    }

    private void lookForLeaks(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(subsystemDataBuilder, MemoryLabels.VIRTUAL_MEMORY_SIZE);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder.getMaxY().getRawY() >= 0.0) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            if (dataPointBuilderArray.length > 100) {
                this.lookForLeaksBasedOnOccupancy(twoDimensionalDataBuilder, dataPointBuilderArray, structuredStringDataBuilder, false);
            } else {
                structuredStringDataBuilder.addGoodThing(Messages.getString("LookForNativeLeaks.no.native.leak"));
            }
        }
    }

    private void lookForJVMBreakdownLeaks(TwoDimensionalData twoDimensionalData, StructuredStringDataBuilder structuredStringDataBuilder) {
        DataPointBuilder[] dataPointBuilderArray;
        if (twoDimensionalData != null && !twoDimensionalData.isEmpty() && twoDimensionalData.getMaxY().getRawY() >= 0.0 && (dataPointBuilderArray = twoDimensionalData.getDataPoints()).length > 100) {
            this.lookForLeaksBasedOnOccupancy(twoDimensionalData, dataPointBuilderArray, structuredStringDataBuilder, true);
        }
    }

    private void lookForLeaksBasedOnOccupancy(TwoDimensionalData twoDimensionalData, DataPointBuilder[] dataPointBuilderArray, StructuredStringDataBuilder structuredStringDataBuilder, boolean bl) {
        double[] dArray = new double[3];
        double d = 1.0 / (double)dArray.length;
        double d2 = twoDimensionalData.getMinX().getRawX();
        double d3 = twoDimensionalData.getMaxX().getRawX();
        double d4 = d3 - d2;
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dataPointBuilderArray.length; ++i) {
            DataPointBuilder dataPointBuilder = dataPointBuilderArray[i];
            double d5 = dataPointBuilder.getRawX();
            double d6 = dataPointBuilder.getRawY();
            int n = (int)Math.floor((d5 - d2) / (d4 * d));
            if (n >= dArray.length || n < 0) continue;
            dArray[n] = (dArray[n] * (double)nArray[n] + d6) / (double)(nArray[n] + 1);
            nArray[n] = nArray[n] + 1;
        }
        if (dArray[1] != 0.0) {
            boolean bl2;
            int n = (int)(dArray[2] / dArray[1] * 100.0 - 100.0);
            int n2 = 10;
            boolean bl3 = bl2 = n >= n2;
            if (!bl) {
                if (bl2) {
                    String string = MessageFormat.format(Messages.getString("LookForNativeLeaks.native.heap.increasing"), n);
                    structuredStringDataBuilder.addProblem(string);
                } else {
                    structuredStringDataBuilder.addGoodThing(Messages.getString("LookForNativeLeaks.no.native.leak"));
                }
            } else if (bl2) {
                String string = MessageFormat.format(Messages.getString("LookForNativeLeaks.breakdown.native.heap.increasing"), twoDimensionalData.getLabel(), n);
                structuredStringDataBuilder.addWarning(string);
            }
        }
    }

    private TwoDimensionalDataBuilder getTwoDimensionalData(Data data, String string) {
        Data data2 = data.getData(string);
        if (data2 instanceof TwoDimensionalDataBuilder) {
            return (TwoDimensionalDataBuilder)data2;
        }
        return null;
    }
}

