/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.UlimitChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.security.Security;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public class EnvironmentDataProvider {
    public static final String CAPABILITY_ULIMITS = "ulimits";
    public static final String CAPABILITY_GENERAL = "general_properties";
    public static final String CAPABILITY_SYSTEM_PROPERTIES = "system_properties";
    public static final String CAPABILITY_ENVIRONMENT_VARIABLES = "environment_variables";
    public static final String CAPABILITY_COMMAND_LINE = "command_line";
    public static final String CAPABILITY_ENVIRONMENT_SUBSYSTEM = "environment_subsystem";
    public static final String CAPABILITY_HEAP_DUMP = "capability.dump.heap";
    public static final String CAPABILITY_JAVA_DUMP = "capability.dump.java";
    public static final String CAPABILITY_SYSTEM_DUMP = "capability.dump.system";
    private static final String cacheTTL = "networkaddress.cache.ttl";
    private static final String negativeCacheTTL = "networkaddress.cache.negative.ttl";
    private static final String[] securityProps = new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"};
    public static final String ARGUMENT_SEPARATOR = "@@@";
    private static final String NEWLINE = "\n";
    public static final String TAG = "EnvironmentSource";

    public static String getJMXData() {
        EnvironmentDataProvider environmentDataProvider = new EnvironmentDataProvider();
        Properties properties = environmentDataProvider.populateProperties();
        if (properties.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#EnvironmentSource");
            stringBuffer.append(NEWLINE);
            for (String string : properties.keySet()) {
                String string2 = properties.getProperty(string);
                stringBuffer.append(string + "=" + string2);
                stringBuffer.append(NEWLINE);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private Properties populateProperties() {
        Properties properties = new Properties();
        this.reportCommandLine(properties);
        this.reportLauncherProperties(properties);
        this.reportSystemProperties(properties);
        this.reportEnvironmentVariables(properties);
        this.reportSecurityProperties(properties);
        this.reportUlimit(properties);
        return properties;
    }

    private void reportCommandLine(Properties properties) {
        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(ARGUMENT_SEPARATOR);
        }
        properties.put("command.line.arguments", stringBuffer.toString());
    }

    private void reportAgentVersion(Properties properties) {
        properties.put("jar.version", "99.99.99.29991231");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLauncherProperties(Properties properties) {
        File file;
        this.reportAgentVersion(properties);
        properties.put("number.of.processors", String.valueOf(Runtime.getRuntime().availableProcessors()));
        properties.put("maximum.memory", String.valueOf(Runtime.getRuntime().maxMemory()));
        String string = System.getProperty("java.home");
        File file2 = new File(string);
        File file3 = new File(file2, "bin");
        if (file3.exists() && (file = new File(file3, "launcher.properties")).exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                Properties properties2 = new Properties();
                properties2.load(fileInputStream);
                for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
                    Object object = entry.getValue();
                    if (object == null) continue;
                    properties.put("launcher." + entry.getKey(), object);
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.toString());
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException.toString());
                    }
                }
            }
        }
    }

    private void reportSystemProperties(Properties properties) {
        Object object;
        Object object2;
        Properties properties2;
        int n = 0;
        boolean bl = false;
        while (!bl && n < 10) {
            properties2 = System.getProperties();
            object2 = properties2.entrySet().iterator();
            try {
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    if (this.excluded(object.getKey(), object.getValue())) continue;
                    properties.put("system." + object.getKey(), object.getValue());
                }
                bl = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                System.out.println(concurrentModificationException.toString());
                ++n;
            }
        }
        if (!bl) {
            properties2 = System.getProperties();
            object2 = properties2.keys();
            while (object2.hasMoreElements()) {
                try {
                    object = object2.nextElement();
                    if (this.excluded(object, properties2.get(object))) continue;
                    properties.put("system." + object, properties2.get(object));
                }
                catch (NoSuchElementException noSuchElementException) {
                    System.out.println(noSuchElementException.toString());
                }
            }
            bl = true;
        }
    }

    private boolean excluded(Object object, Object object2) {
        if (object.toString().equals("wlp.password.encryption.key")) {
            return true;
        }
        String string = object2.toString().toLowerCase();
        if (string.startsWith("{aes}")) {
            return true;
        }
        if (string.startsWith("{xor}")) {
            return true;
        }
        return string.startsWith("{hash}");
    }

    private void reportEnvironmentVariables(Properties properties) {
        Map<String, String> map = System.getenv();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.put("environment." + entry.getKey(), entry.getValue());
        }
    }

    private void reportSecurityProperties(Properties properties) {
        for (String string : securityProps) {
            String string2 = Security.getProperty(string);
            if (string2 == null) {
                string2 = "";
            }
            properties.put("security." + string, string2);
        }
    }

    private void reportUlimit(Properties properties) {
        new UlimitChecker().writeProperties(properties);
    }
}

