/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9PortLibraryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategoryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategorySetPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRPortLibraryGlobalDataPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9PortLibrary;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OMRMemCategoryHelper {
    public static OMRMemCategoryPointer getUnusedAllocate32HeapRegionsMemoryCategory(OMRPortLibraryGlobalDataPointer portGlobals) throws CorruptDataException {
        ReflectiveOperationException exception;
        try {
            Class<OMRPortLibraryGlobalDataPointer> clazz = OMRPortLibraryGlobalDataPointer.class;
            Method method = clazz.getDeclaredMethod("unusedAllocate32HeapRegionsMemoryCategory", new Class[0]);
            return (OMRMemCategoryPointer)method.invoke((Object)portGlobals, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CorruptDataException) {
                throw (CorruptDataException)cause;
            }
            exception = e;
        }
        CorruptDataException cd = new CorruptDataException(exception.toString(), exception);
        EventManager.raiseCorruptDataEvent("Error accessing unusedAllocate32HeapRegionsMemoryCategory", cd, true);
        return null;
    }

    public static OMRMemCategoryPointer getMemoryCategory(UDATA memoryCategory) throws CorruptDataException {
        J9PortLibraryPointer portLib = J9RASHelper.getVM(DataType.getJ9RASPointer()).portLibrary();
        OMRPortLibraryGlobalDataPointer portGlobals = portLib.omrPortLibrary().portGlobals();
        if (memoryCategory.eq(J9PortLibrary.OMRMEM_CATEGORY_PORT_LIBRARY)) {
            return portGlobals.portLibraryMemoryCategory();
        }
        if (J9BuildFlags.J9VM_ENV_DATA64 && memoryCategory.eq(J9PortLibrary.OMRMEM_CATEGORY_PORT_LIBRARY_UNUSED_ALLOCATE32_REGIONS)) {
            return OMRMemCategoryHelper.getUnusedAllocate32HeapRegionsMemoryCategory(portGlobals);
        }
        OMRMemCategorySetPointer registeredSet = OMRMemCategorySetPointer.NULL;
        long index = 0L;
        if (memoryCategory.lt(new U32(Integer.MAX_VALUE))) {
            registeredSet = portGlobals.control().language_memory_categories();
            index = memoryCategory.longValue();
        } else {
            registeredSet = portGlobals.control().omr_memory_categories();
            index = Integer.MAX_VALUE & memoryCategory.longValue();
        }
        if (registeredSet.notNull()) {
            if (registeredSet.numberOfCategories().gt(index) && registeredSet.categories().at(index).notNull()) {
                return OMRMemCategoryPointer.cast(registeredSet.categories().at(index));
            }
            return portGlobals.unknownMemoryCategory();
        }
        return portGlobals.unknownMemoryCategory();
    }

    public static void visitMemoryCategoryChildren(OMRMemCategoryPointer startNode, IOMRMemCategoryVisitor visitor) throws CorruptDataException {
        visitor.visit(startNode);
        int numberOfChildren = startNode.numberOfChildren().intValue();
        for (int i = 0; i < numberOfChildren; ++i) {
            UDATA childCode = startNode.children().at(i);
            OMRMemCategoryPointer child = OMRMemCategoryHelper.getMemoryCategory(childCode);
            if (!child.categoryCode().eq(childCode)) {
                UDATA thisCategoryCode = null;
                try {
                    thisCategoryCode = startNode.categoryCode();
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
                if (thisCategoryCode == null) {
                    throw new CorruptDataException("Bad memory category child relationship. Memory Category at " + startNode.getHexAddress() + " references unknown memory category code " + childCode);
                }
                throw new CorruptDataException("Bad memory category child relationship. Memory Category at " + startNode.getHexAddress() + " code " + thisCategoryCode + " references unknown memory category code " + childCode);
            }
            OMRMemCategoryHelper.visitMemoryCategoryChildren(child, visitor);
        }
    }

    public static interface IOMRMemCategoryVisitor {
        public void visit(OMRMemCategoryPointer var1) throws CorruptDataException;
    }
}

