/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.store;

import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.store.StructureKey;
import com.ibm.j9ddr.tools.store.StructureMismatchError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class J9DDRStructureStore {
    private File directory;
    private HashMap<StructureKey, String> keyMap = new HashMap();
    HashMap<String, HashSet<String>> superset = new HashMap();
    private byte[] structureBytes;
    private String supersetFilename;
    private static final String INDEX_FILE_NAME = "keymap.idx";
    public static final String DEFAULT_SUPERSET_FILE_NAME = "superset.dat";
    private static final byte[] SUPERSET_ID;
    private static final byte[] SUPERSET_ID_EBCDIC;
    private static final String CHARSET_EBCDIC = "Cp037";

    public void add(StructureKey key, String structureFileName, boolean inService) throws IOException, StructureMismatchError {
        String digest = this.digestStructure(structureFileName);
        if (!inService) {
            return;
        }
        String existingDigest = this.keyMap.get(key);
        if (existingDigest != null) {
            if (existingDigest.equals(digest)) {
                return;
            }
            throw new StructureMismatchError(String.format("%s exists in database but is not the same as the structure being added from %s", key, structureFileName));
        }
        boolean structureAlreadyStored = this.keyMap.containsValue(digest);
        this.keyMap.put(key, digest);
        this.writeIndex();
        if (!structureAlreadyStored) {
            this.physicallyStore(key, digest);
        }
    }

    public void updateSuperset() throws IOException {
        StructureReader reader = null;
        if (this.structureBytes.length > 2 && this.structureBytes[0] == SUPERSET_ID[0] && this.structureBytes[1] == SUPERSET_ID[1]) {
            ByteArrayInputStream in = new ByteArrayInputStream(this.structureBytes);
            reader = new StructureReader(in);
        } else {
            MemoryCacheImageInputStream inputStream = new MemoryCacheImageInputStream(new ByteArrayInputStream(this.structureBytes));
            reader = new StructureReader(inputStream);
        }
        for (StructureReader.StructureDescriptor structure : reader.getStructures()) {
            String structureHeader = structure.deflate();
            HashSet<String> structureContents = this.superset.get(structureHeader);
            if (structureContents == null) {
                structureContents = new HashSet();
                this.superset.put(structureHeader, structureContents);
            }
            for (StructureReader.FieldDescriptor field : structure.getFields()) {
                this.addFieldToSuperset(structureContents, field);
            }
            for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
                String constantHeader = constant.deflate();
                structureContents.add(constantHeader);
            }
        }
        this.writeSuperset();
    }

    private boolean addFieldToSuperset(HashSet<String> structureContents, StructureReader.FieldDescriptor field) {
        if (field.getDeclaredName().startsWith("_j9padding")) {
            return false;
        }
        String newLine = null;
        Iterator<String> contents = structureContents.iterator();
        while (contents.hasNext()) {
            String line = contents.next();
            if (!line.startsWith("F|" + field.getName() + "|")) continue;
            String fieldType = StructureReader.simplifyType(field.getType());
            String fieldDeclaredType = StructureReader.simplifyType(field.getDeclaredType());
            String[] parts = line.split("\\|");
            for (int i = 3; i < parts.length; i += 2) {
                String supersetType = StructureReader.simplifyType(parts[i]);
                String supersetDeclaredType = StructureReader.simplifyType(parts[i + 1]);
                if (!supersetType.equals(fieldType) || !supersetDeclaredType.equals(fieldDeclaredType)) continue;
                return false;
            }
            contents.remove();
            newLine = line + "|" + fieldType + "|" + fieldDeclaredType;
            break;
        }
        if (newLine == null) {
            structureContents.add(field.deflate());
        } else {
            structureContents.add(newLine);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSuperset() throws IOException {
        File supersetFile = new File(this.directory, this.supersetFilename);
        try (BufferedWriter bw = null;){
            FileWriter fw = new FileWriter(supersetFile);
            bw = new BufferedWriter(fw);
            ArrayList<String> keys = new ArrayList<String>(this.superset.size());
            keys.addAll(this.superset.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                bw.write(key);
                bw.newLine();
                Object[] values = this.superset.get(key).toArray(new String[0]);
                Arrays.sort(values);
                for (Object line : values) {
                    bw.write((String)line);
                    bw.newLine();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSuperset() throws IOException {
        this.superset = new HashMap();
        File supersetFile = new File(this.directory, this.supersetFilename);
        if (!supersetFile.exists()) {
            return;
        }
        try (BufferedReader br = null;){
            FileReader fr = new FileReader(supersetFile);
            br = new BufferedReader(fr);
            String line = br.readLine();
            HashSet<String> structureContents = null;
            while (line != null) {
                if (line.charAt(0) == 'S') {
                    structureContents = new HashSet<String>();
                    this.superset.put(line, structureContents);
                } else {
                    structureContents.add(line);
                }
                line = br.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndex() throws IOException {
        File indexFile = new File(this.directory, INDEX_FILE_NAME);
        if (!indexFile.exists()) {
            return;
        }
        try (BufferedReader br = null;){
            FileReader fr = new FileReader(indexFile);
            br = new BufferedReader(fr);
            String line = br.readLine();
            this.keyMap = new HashMap();
            while (line != null) {
                int index = line.indexOf(" ");
                if (index > -1) {
                    StructureKey key = new StructureKey(line.substring(0, index));
                    String digest = line.substring(index + 1);
                    this.keyMap.put(key, digest);
                }
                line = br.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex() throws IOException {
        File indexFile = new File(this.directory, INDEX_FILE_NAME);
        try (BufferedWriter bw = null;){
            FileWriter fw = new FileWriter(indexFile);
            bw = new BufferedWriter(fw);
            for (Map.Entry<StructureKey, String> entry : this.keyMap.entrySet()) {
                bw.write(entry.getKey().toString());
                bw.write(" ");
                bw.write(entry.getValue());
                bw.write(System.getProperty("line.separator"));
            }
        }
    }

    private void physicallyStore(StructureKey key, String digest) throws IOException {
        File zipFile = this.getZipFile(key, digest);
        if (zipFile.exists()) {
            throw new IOException(String.format("Attempting to over write existing structure data %s with key %s", zipFile.getAbsolutePath(), key));
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry zipEntry = this.getZipEntry(key, digest);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(this.structureBytes);
        zipOutputStream.closeEntry();
        zipOutputStream.close();
    }

    private File getZipFile(StructureKey key, String digest) {
        return new File(this.directory, key.getPlatform() + "." + digest + ".zip");
    }

    private ZipEntry getZipEntry(StructureKey key, String digest) {
        return new ZipEntry(key.getPlatform() + "." + digest + ".ddr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String digestStructure(String structureFileName) throws IOException {
        MessageDigest md = null;
        byte[] buffer = new byte[1024];
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage());
        }
        DigestInputStream dis = null;
        FileInputStream structure = new FileInputStream(structureFileName);
        dis = new DigestInputStream(structure, md);
        ByteArrayOutputStream structureStream = new ByteArrayOutputStream();
        try {
            int bytesRead;
            while ((bytesRead = dis.read(buffer)) != -1) {
                structureStream.write(buffer, 0, bytesRead);
            }
            dis.close();
        }
        finally {
            structure.close();
        }
        this.structureBytes = structureStream.toByteArray();
        if (this.structureBytes.length > 2 && this.structureBytes[0] == SUPERSET_ID_EBCDIC[0] && this.structureBytes[1] == SUPERSET_ID_EBCDIC[1]) {
            this.convertFromEBCDIC();
        }
        byte[] digestBytes = dis.getMessageDigest().digest();
        return this.byteArrayHexString(digestBytes);
    }

    private void convertFromEBCDIC() throws IOException {
        try {
            System.out.println("Converting input file from EBCDIC to UTF-8");
            String data = new String(this.structureBytes, CHARSET_EBCDIC);
            this.structureBytes = data.getBytes("UTF-8");
        }
        catch (Exception e) {
            IOException ioe = new IOException("Failed to convert data from EBCDIC");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private String byteArrayHexString(byte[] digest) {
        StringWriter result = new StringWriter();
        for (int i = 0; i < digest.length; ++i) {
            result.write(Integer.toHexString(256 + digest[i] & 0xFF));
        }
        return result.toString();
    }

    public boolean remove(StructureKey key) throws IOException {
        String digest = this.keyMap.remove(key);
        if (digest == null) {
            return false;
        }
        if (!this.keyMap.containsValue(digest)) {
            File zipFile = this.getZipFile(key, digest);
            zipFile.delete();
        }
        this.writeIndex();
        return true;
    }

    public ImageInputStream get(StructureKey key) throws IOException {
        int bytesRead;
        String digest = this.keyMap.get(key);
        if (digest == null) {
            return null;
        }
        ZipFile zipFile = new ZipFile(this.getZipFile(key, digest));
        ZipEntry entry = zipFile.getEntry(this.getZipEntry(key, digest).getName());
        InputStream entryStream = zipFile.getInputStream(entry);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream output = new ByteArrayOutputStream((int)entry.getSize());
        while ((bytesRead = entryStream.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        zipFile.close();
        return new MemoryCacheImageInputStream(new ByteArrayInputStream(output.toByteArray()));
    }

    public InputStream getSuperset() throws FileNotFoundException {
        return new FileInputStream(new File(this.directory, this.supersetFilename));
    }

    protected J9DDRStructureStore() {
    }

    public J9DDRStructureStore(String databaseDirectory, String supersetFileName) throws IOException {
        this.supersetFilename = supersetFileName == null ? DEFAULT_SUPERSET_FILE_NAME : supersetFileName;
        this.initialize(databaseDirectory);
    }

    private void initialize(String databaseDirectory) throws IOException {
        if (databaseDirectory == null) {
            throw new IllegalArgumentException("databaseDirectory may not be null");
        }
        this.directory = new File(databaseDirectory);
        if (!this.directory.exists()) {
            this.create();
        } else {
            this.open();
        }
    }

    private void create() throws IOException {
        if (!this.directory.mkdir()) {
            throw new IOException(String.format("Unable to create directory %s", this.directory.getAbsolutePath()));
        }
        this.writeIndex();
        this.writeSuperset();
    }

    private void open() throws IOException {
        this.readIndex();
        this.readSuperset();
    }

    public String getSuperSetFileName() {
        return this.supersetFilename;
    }

    static {
        try {
            SUPERSET_ID = "S|".getBytes("ASCII");
            SUPERSET_ID_EBCDIC = "S|".getBytes(CHARSET_EBCDIC);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create SUPERSET identifier", e);
        }
    }
}

