/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFactoryFinder;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

public abstract class XPathFactory {
    public static final String DEFAULT_OBJECT_MODEL_URI = "http://java.sun.com/jaxp/xpath/dom";
    public static final String DEFAULT_PROPERTY_NAME = "javax.xml.xpath.XPathFactory";

    protected XPathFactory() {
    }

    public static XPathFactory newInstance() {
        try {
            return XPathFactory.newInstance(DEFAULT_OBJECT_MODEL_URI);
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            throw new RuntimeException(xPathFactoryConfigurationException.toString());
        }
    }

    public static XPathFactory newInstance(String string) throws XPathFactoryConfigurationException {
        XPathFactory.checkURI(string);
        try {
            return (XPathFactory)XPathFactoryFinder.find(DEFAULT_PROPERTY_NAME, string, "org.apache.xpath.jaxp.XPathFactoryImpl");
        }
        catch (XPathFactoryFinder.ConfigurationError configurationError) {
            if (configurationError.getException() != null) {
                throw new XPathFactoryConfigurationException(configurationError.getException());
            }
            throw new XPathFactoryConfigurationException(configurationError.getMessage());
        }
    }

    public static XPathFactory newInstance(String string, String string2, ClassLoader classLoader) throws XPathFactoryConfigurationException {
        XPathFactory.checkURI(string);
        if (string2 == null) {
            throw new XPathFactoryConfigurationException("factoryClassName cannot be null.");
        }
        if (classLoader == null) {
            classLoader = SecuritySupport.getContextClassLoader();
        }
        try {
            XPathFactory xPathFactory = (XPathFactory)XPathFactoryFinder.newInstance(string2, classLoader, false);
            if (xPathFactory.isObjectModelSupported(string)) {
                return xPathFactory;
            }
            throw new XPathFactoryConfigurationException(string2 + " does not support the object model: " + string);
        }
        catch (XPathFactoryFinder.ConfigurationError configurationError) {
            throw new XPathFactoryConfigurationException(configurationError);
        }
    }

    private static void checkURI(String string) {
        if (string == null) {
            throw new NullPointerException("null uri in XPathFactory.newInstance(...)");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("uri cannot be empty string in XPathFactory.newInstance(...)");
        }
    }

    public abstract boolean isObjectModelSupported(String var1);

    public abstract void setFeature(String var1, boolean var2) throws XPathFactoryConfigurationException;

    public abstract boolean getFeature(String var1) throws XPathFactoryConfigurationException;

    public abstract void setXPathVariableResolver(XPathVariableResolver var1);

    public abstract void setXPathFunctionResolver(XPathFunctionResolver var1);

    public abstract XPath newXPath();
}

