/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.utils;

import com.ibm.jvm.dtfjview.tools.utils.IMatchHandle;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MatchHandle
implements IMatchHandle {
    private final String[] matchStringList;
    private final boolean ignoreCase;
    private final boolean negated;
    private final boolean isFixedString;

    public MatchHandle(String[] matchStringList, boolean ignoreCase) {
        this(matchStringList, ignoreCase, false, false);
    }

    public MatchHandle(String[] matchStringList, boolean ignoreCase, boolean negated, boolean isFixedString) {
        this.matchStringList = matchStringList;
        this.ignoreCase = ignoreCase;
        this.negated = negated;
        this.isFixedString = isFixedString;
    }

    @Override
    public boolean matches(String s) {
        for (String match : this.matchStringList) {
            if (this.negated == this.match(s, match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String process(String s) {
        return s;
    }

    private boolean match(String s, String match) {
        if (this.isFixedString) {
            return this.matchFixedStrings(s, new String[]{match});
        }
        StringTokenizer st = new StringTokenizer(match, "*");
        ArrayList<String> ls = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            ls.add(st.nextToken());
        }
        return this.matchFixedStrings(s, ls.toArray(new String[ls.size()]));
    }

    private boolean matchFixedStrings(String s, String[] matches) {
        if (this.ignoreCase) {
            s = s.toLowerCase();
        }
        for (String match : matches) {
            int index;
            if (this.ignoreCase) {
                match = match.toLowerCase();
            }
            if ((index = s.indexOf(match)) < 0) {
                return false;
            }
            s = s.substring(index + match.length());
        }
        return true;
    }
}

