/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools;

import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ToolsRegistryOutputChannels
extends OutputStream {
    private static ToolsRegistryOutputChannels instance;
    private final List<IOutputChannel> channels;
    private ByteArrayOutputStream buffer;
    private final String charsetName;

    public static void initialize(String charsetName) {
        if (instance == null) {
            instance = new ToolsRegistryOutputChannels(charsetName);
        }
    }

    public static void addChannel(IOutputChannel out) {
        ToolsRegistryOutputChannels.instance.channels.add(out);
    }

    public static void removeChannel(IOutputChannel out) {
        ToolsRegistryOutputChannels.instance.channels.remove(out);
    }

    public static boolean contains(IOutputChannel out) {
        return ToolsRegistryOutputChannels.instance.channels.contains(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
        if (10 == b || 21 == b) {
            this.writeBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.writeBuffer();
        for (IOutputChannel channel : this.channels) {
            channel.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeBuffer();
        for (IOutputChannel channel : this.channels) {
            channel.flush();
        }
    }

    public static PrintStream newPrintStream() {
        return new PrintStream(instance, true);
    }

    private ToolsRegistryOutputChannels(String charsetName) {
        this.charsetName = charsetName;
        this.channels = new ArrayList<IOutputChannel>();
        this.buffer = new ByteArrayOutputStream();
    }

    private void writeBuffer() throws IOException {
        if (0 != this.buffer.size()) {
            String content = this.charsetName == null ? this.buffer.toString() : this.buffer.toString(this.charsetName);
            this.buffer = new ByteArrayOutputStream();
            for (IOutputChannel out : this.channels) {
                out.print(content);
            }
        }
    }
}

