/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.sequence.AConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public final class StashedPasswordProtection
implements KeyStore.ProtectionParameter,
Destroyable {
    private File stashFile = null;
    private char[] password = null;
    public static final int PASS_MAX_LEN = 129;

    public StashedPasswordProtection(File file) {
        if (file == null) {
            throw new NullPointerException("The provided Stash file object is invalid.");
        }
        if (!file.canRead()) {
            throw new RuntimeException("Cannot read from the provided stash file.");
        }
        this.stashFile = file;
    }

    private StashedPasswordProtection() {
        throw new UnsupportedOperationException();
    }

    private static void wipeArray(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
    }

    private static void wipeArray(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public char[] getPassword() throws IOException, NoSuchAlgorithmException {
        if (this.password == null && this.stashFile != null) {
            ByteBuffer byteBuffer;
            Charset charset;
            CharBuffer charBuffer;
            FileInputStream fileInputStream = new FileInputStream(this.stashFile);
            byte[] byArray = new byte[193];
            if (((InputStream)fileInputStream).read(byArray) < 129) {
                ((InputStream)fileInputStream).close();
                throw new IOException("Invalid stash file format.");
            }
            ((InputStream)fileInputStream).close();
            try {
                byArray = AConverter.rr(byArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new RuntimeException("Invalid keys", invalidKeyException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            int n = 0;
            for (int i = 0; i < 129; ++i) {
                byArray[i] = (byte)(byArray[i] ^ 0xF5);
                if (byArray[i] != 0 || n != 0) continue;
                n = i;
                break;
            }
            if (!(charBuffer = (charset = Charset.forName("UTF-8")).decode(byteBuffer = ByteBuffer.wrap(byArray, 0, n))).hasArray()) {
                throw new RuntimeException("Can't decode the password from the stash file.");
            }
            this.password = new char[n];
            System.arraycopy(charBuffer.array(), 0, this.password, 0, n);
            StashedPasswordProtection.wipeArray(byArray);
            StashedPasswordProtection.wipeArray(charBuffer.array());
        }
        return this.password;
    }

    public synchronized void destroy() throws DestroyFailedException {
        if (this.password != null && this.password.length > 0) {
            StashedPasswordProtection.wipeArray(this.password);
            this.password = null;
        }
        if (this.stashFile != null) {
            this.stashFile = null;
        }
    }

    public boolean isDestroyed() {
        return this.password == null && this.stashFile == null;
    }
}

