/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.XECKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import ibm.security.internal.interfaces.XECPrivateKey;
import ibm.security.internal.spec.NamedParameterSpec;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyRep;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Optional;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class XDHPrivateKeyImpl
extends PrivateKeyInfo
implements XECPrivateKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = 6034044314589513430L;
    private IBMJCEPlusProvider provider;
    private Optional<byte[]> scalar;
    private NamedParameterSpec params;
    BigInteger bi1;
    BigInteger bi2;
    BigInteger bi3;
    private Exception exception;
    private static final byte TAG_PARAMETERS_ATTRS = 0;
    private transient boolean destroyed;
    private transient XECKey xecKey;
    private static final String[] z;

    private void a() throws Exception {
        if (this.key == null) {
            this.key = this.a(this.xecKey.getPrivateKeyBytes());
            this.scalar = Optional.of(this.key);
            this.algid = XECKey.getAlgId(this.params.getCurve());
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, XECKey xECKey) throws InvalidKeyException {
        this.provider = null;
        this.exception = null;
        this.destroyed = false;
        this.xecKey = null;
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[3]);
        }
        if (xECKey == null) {
            throw new InvalidKeyException(z[4]);
        }
        this.xecKey = xECKey;
        this.provider = iBMJCEPlusProvider;
        try {
            this.a();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage());
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = null;
        this.exception = null;
        this.destroyed = false;
        this.xecKey = null;
        this.provider = iBMJCEPlusProvider;
        try {
            byte[] byArray2 = this.b(byArray);
            this.xecKey = XECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray2, this.params.getCurve());
            this.scalar = Optional.of(this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[2]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, AlgorithmParameterSpec algorithmParameterSpec, Optional<byte[]> optional) throws InvalidParameterException {
        block15: {
            this.provider = null;
            this.exception = null;
            this.destroyed = false;
            this.xecKey = null;
            if (iBMJCEPlusProvider == null) {
                throw new InvalidParameterException(z[7]);
            }
            if (!(algorithmParameterSpec instanceof NamedParameterSpec)) {
                throw new InvalidParameterException(z[6]);
            }
            this.params = (NamedParameterSpec)algorithmParameterSpec;
            try {
                if (XECKey.isFFDHE(this.params.getCurve())) {
                    throw new InvalidParameterException(z[8]);
                }
            }
            catch (Exception exception) {
                throw new InvalidParameterException(exception.getMessage());
            }
            this.provider = iBMJCEPlusProvider;
            this.scalar = optional;
            if (optional != null) {
                this.key = optional.get();
            }
            try {
                block14: {
                    if (this.key != null) break block14;
                    this.xecKey = XECKey.generateKeyPair(iBMJCEPlusProvider.a(), this.params.getCurve());
                    break block15;
                }
                this.algid = XECKey.getAlgId(this.params.getCurve());
                byte[] byArray = this.b();
                this.xecKey = XECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray, this.params.getCurve());
            }
            catch (Exception exception) {
                InvalidParameterException invalidParameterException = new InvalidParameterException(z[9]);
                iBMJCEPlusProvider.a(invalidParameterException, (Throwable)exception);
                throw invalidParameterException;
            }
        }
    }

    private byte[] b() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(0);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.algid.getOID());
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOctetString(this.key);
        derOutputStream.putOctetString(derOutputStream3.toByteArray());
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream);
        return derOutputStream4.toByteArray();
    }

    private byte[] a(byte[] byArray) throws IOException {
        Object object;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        DerInputStream derInputStream2 = null;
        if (derValueArray.length > 1) {
            derInputStream2 = derValueArray[1].getData();
            if (derInputStream2.tag != 0) {
                throw new IOException(z[15]);
            }
            try {
                object = this.a(derInputStream2, null);
            }
            catch (Exception exception) {
                throw new IOException(z[17]);
            }
        }
        object = null;
        if (derValueArray.length > 2) {
            object = derValueArray[2].getOctetString();
            object = this.params.getName().contains(z[16]) ? new DerInputStream(object).getInteger().toByteArray() : new DerInputStream(object).getOctetString();
            return object;
        }
        return null;
    }

    private ObjectIdentifier a(DerInputStream derInputStream, DerOutputStream derOutputStream) throws IOException {
        NamedParameterSpec.CURVE cURVE;
        ObjectIdentifier objectIdentifier;
        block5: {
            DerOutputStream derOutputStream2;
            objectIdentifier = derInputStream.getOID();
            XECKey.checkOid(objectIdentifier);
            try {
                derOutputStream2 = derInputStream.getSequence(3);
                if (((DerValue[])derOutputStream2).length < 3) {
                    throw new IOException(z[5]);
                }
                this.bi1 = derOutputStream2[0].getInteger();
                this.bi2 = derOutputStream2[1].getInteger();
                this.bi3 = derOutputStream2[2].getInteger();
                int n2 = this.bi1.bitLength();
                cURVE = XECKey.getCurve(objectIdentifier, n2);
            }
            catch (IOException iOException) {
                cURVE = XECKey.getCurve(objectIdentifier, null);
            }
            if (derOutputStream == null) break block5;
            derOutputStream.putOID(objectIdentifier);
            if (!XECKey.isFFDHE(cURVE)) break block5;
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.bi1);
            derOutputStream2.putInteger(this.bi2);
            derOutputStream2.putInteger(this.bi3);
            derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        }
        this.params = new NamedParameterSpec(cURVE);
        return objectIdentifier;
    }

    private byte[] b(byte[] byArray) throws IOException {
        BigInteger bigInteger;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        DerOutputStream derOutputStream = new DerOutputStream();
        BigInteger bigInteger2 = derValueArray[0].getInteger();
        derOutputStream.putInteger(bigInteger2);
        Object var6_6 = null;
        ObjectIdentifier objectIdentifier = null;
        if (derValueArray.length < 3) {
            throw new IOException(z[0]);
        }
        if (derValueArray[1].getTag() != 48) {
            throw new IOException(z[1]);
        }
        Object object = derValueArray[1].toDerInputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        objectIdentifier = this.a((DerInputStream)object, derOutputStream2);
        this.algid = new AlgorithmId(objectIdentifier);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        object = derValueArray[2].getOctetString();
        derOutputStream2 = new DerInputStream((byte[])object);
        try {
            this.key = derOutputStream2.getOctetString();
        }
        catch (IOException iOException) {
            this.key = (byte[])object;
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (XECKey.isFFDHE(this.params.getCurve())) {
            bigInteger = new BigInteger(this.key);
            derOutputStream3.putInteger(bigInteger);
        } else {
            derOutputStream3.putOctetString(this.key);
        }
        derOutputStream.putOctetString(derOutputStream3.toByteArray());
        bigInteger = new DerOutputStream();
        bigInteger.write((byte)48, derOutputStream);
        return bigInteger.toByteArray();
    }

    public XECKey getICCKey() {
        return this.xecKey;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public Optional<byte[]> getScalar() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return this.scalar;
    }

    public byte[] getKeyBytes() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getKeyBytes();
    }

    public AlgorithmId getAlgorithmId() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getAlgorithmId();
    }

    public String getAlgorithm() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getAlgorithm();
    }

    public static void putFFDHEIntegers(DerOutputStream derOutputStream, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(bigInteger);
        derOutputStream2.putInteger(bigInteger2);
        derOutputStream2.putInteger(bigInteger3);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode(OutputStream outputStream) throws IOException {
        try {
            this.a();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(z[11]);
            this.provider.a(iOException, (Throwable)exception);
            throw iOException;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(0);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream3.putOID(this.algid.getOID());
        switch (this.params.getCurve()) {
            case X25519: {
                derOutputStream3.putNull();
                break;
            }
            case X448: {
                derOutputStream3.putNull();
                break;
            }
            case Ed25519: {
                derOutputStream3.putNull();
                break;
            }
            case Ed448: {
                derOutputStream3.putNull();
                break;
            }
            case FFDHE2048: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE3072: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE4096: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE6144: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE8192: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
        }
        derOutputStream4.write((byte)48, derOutputStream3);
        derOutputStream.write(derOutputStream4.toByteArray());
        if (this.key != null) {
            derOutputStream.putOctetString(this.key);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (this.exception != null) {
            String string = this.exception.getMessage();
            string = string + z[12];
            StackTraceElement[] stackTraceElementArray = this.exception.getStackTrace();
            int n2 = stackTraceElementArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    throw new DestroyFailedException(z[14] + string);
                }
                StackTraceElement stackTraceElement = stackTraceElementArray[n3];
                string = string + z[13] + stackTraceElement.toString() + "\n";
                ++n3;
            }
        }
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.xecKey = null;
            this.scalar = null;
            this.params = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[10]);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "z|.\u007fWMa5z\u0012\u000ep(i\u0004\u000ez(xW]q\"aWZ{gn\u0012\u000eugz\u0016B}#,/kWhJ1j\\\u0002,\u0014[f1i";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                block28: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block28;
                    n5 = n5;
                    if (n5 <= n4) break block29;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 46;
                            break;
                        }
                        case 1: {
                            n6 = 20;
                            break;
                        }
                        case 2: {
                            n6 = 71;
                            break;
                        }
                        case 3: {
                            n6 = 12;
                            break;
                        }
                        default: {
                            n6 = 119;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "{z\"t\u0007Kw3i\u0013\u000ez(bW]q6y\u0012@w\",\u0000F}+iW^u5\u007f\u001e@sg|\u0005Gb&x\u0012\u000e\u007f\"uWLm3i\u0004";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "hu.`\u0012J43cWMf\"m\u0003K4\u001fI4\u000ed5e\u0001O`\",\u001cKm";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "^f(z\u001eJq5,\u0014Oz)c\u0003\u000ev\",\u0019[x+";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "Vq$G\u0012W4$m\u0019@{3,\u0015K4)y\u001bB";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "z|.\u007fWMa5z\u0012\u000ep(i\u0004\u000ez(xW]q\"aWZ{gn\u0012\u000eugz\u0016B}#,/kWhJ1j\\\u0002,\u0014[f1i";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "^u5m\u001a]4*y\u0004Z4%iWArgx\u000e^qgB\u0016Cq#\\\u0016\\u*i\u0003Kf\u0014|\u0012M";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "^f(z\u001eJq5,\u001a[g3,\u0019A`gn\u0012\u000ez2`\u001b";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "hR\u0003D2\u000eu+k\u0018\\}3d\u001a]4&~\u0012\u000ez(xW]a7|\u0018Kf3i\u0013";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "hu.`\u0012J43cWMf\"m\u0003K4\u001fI4\u000ed5e\u0001O`\",\u001cKm";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "z|.\u007fWEq>,\u001e]4)cWB{)k\u0012\\41m\u001bGp";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "hu.`\u0012J4.bW]q3J\u001eKx#\u007f1\\{*T\u0012M\u007f\"u";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "$G3m\u0014E.M";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u00034";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "ozgi\u000fMq7x\u001eAzgc\u0014Ma5~\u0012J4#y\u0005Gz ,\u0003Fqgi\u000fKw2x\u001eAzgc\u0011\u000e`/e\u0004\u000e{%f\u0012M`},";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u000e@/iW@q?xWKz$c\u0013Kpg\u007f\u0003\\a$x\u0002\\qga\u0002]`gn\u0012\u000eugo\u0018@`\"t\u0003\u000ew(b\u0004Zf2o\u0003KpgC>j";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "hR\u0003D";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "z|.\u007fWMa5z\u0012\u000ep(i\u0004\u000ez(xW]q\"aWZ{gn\u0012\u000eu),/kWgc\u0005\u000eR\u0001H?k4$y\u0005Xq";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

