/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptorImpl;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DescriptorType;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS12DatabaseDescriptor;
import com.ibm.gsk.ikeyman.util.FileName;
import javax.security.auth.callback.CallbackHandler;

class DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl
extends DatabaseDescriptorFactory$DatabaseDescriptorImpl
implements DatabaseDescriptorFactory$PKCS12DatabaseDescriptor {
    private boolean isPfxFile;
    private boolean useStash = false;
    private boolean useV1Stash = false;
    private boolean pqc = false;

    protected DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl(String string, String string2, CallbackHandler callbackHandler, boolean bl, DatabaseDescriptorFactory$DescriptorType databaseDescriptorFactory$DescriptorType, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        super(string, string2, callbackHandler, constants$DatabaseType, databaseDescriptorFactory$DescriptorType);
        this.isPfxFile = bl;
    }

    public DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        this(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString(), databaseDescriptorFactory$DatabaseDescriptor.getPassword(), null, false, DatabaseDescriptorFactory$DescriptorType.Source, constants$DatabaseType);
    }

    public boolean isPfxFile() {
        return this.isPfxFile;
    }

    public static DatabaseDescriptorFactory$PKCS12DatabaseDescriptor getDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        String string = commandParameters.isParameterPresent(Constants$Parameter.DatabaseName) ? commandParameters.getDatabaseName() : commandParameters.getFile();
        String string2 = null;
        if (commandParameters.isParameterPresent(Constants$Parameter.Password)) {
            string2 = commandParameters.getPassword();
        }
        boolean bl = commandParameters.isParameterPresent(Constants$Parameter.Pfx) && commandParameters.isPfx() || DatabaseDescriptorFactory.deriveDatabaseType(new FileName(string)) == Constants$DatabaseType.PFX;
        return new DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl(string, string2, callbackHandler, bl, DatabaseDescriptorFactory$DescriptorType.Source, constants$DatabaseType);
    }

    public static DatabaseDescriptorFactory$DatabaseDescriptor getTargetDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        String string = commandParameters.getTarget();
        String string2 = null;
        if (commandParameters.isParameterPresent(Constants$Parameter.TargetPassword)) {
            string2 = commandParameters.getTargetPassword();
        }
        return new DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl(string, string2, callbackHandler, false, DatabaseDescriptorFactory$DescriptorType.Target, constants$DatabaseType);
    }

    public static DatabaseDescriptorFactory$PKCS12DatabaseDescriptor getDescriptor(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        return new DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl(databaseDescriptorFactory$DatabaseDescriptor, constants$DatabaseType);
    }

    public static DatabaseDescriptorFactory$PKCS12DatabaseDescriptor getSecondaryDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler, Constants$DatabaseType constants$DatabaseType) throws KeyManagerException {
        String string = null;
        if (commandParameters.isParameterPresent(Constants$Parameter.SecondaryDbPassword)) {
            string = commandParameters.getSecondaryDbPassword();
        }
        return new DatabaseDescriptorFactory$PKCS12DatabaseDescriptorImpl(commandParameters.getSecondaryDb(), string, callbackHandler, false, DatabaseDescriptorFactory$DescriptorType.Secondary, constants$DatabaseType);
    }

    public boolean allowsAction(Constants$CommandType constants$CommandType) {
        switch (constants$CommandType) {
            case StashDBPassword: {
                return this.isPasswordProtected();
            }
        }
        return super.allowsAction(constants$CommandType);
    }

    protected void updateDescriptor(ParameterMap parameterMap) {
        super.updateDescriptor(parameterMap);
        if (parameterMap.containsKey(Constants$Parameter.StashPassword)) {
            this.useStash = (Boolean)parameterMap.get(Constants$Parameter.StashPassword);
        }
        if (parameterMap.containsKey(Constants$Parameter.StashV1Password)) {
            this.useV1Stash = (Boolean)parameterMap.get(Constants$Parameter.StashV1Password);
        }
        if (parameterMap.containsKey(Constants$Parameter.Pqc)) {
            this.pqc = (Boolean)parameterMap.get(Constants$Parameter.Pqc);
        }
    }

    public void setStash(boolean bl) {
        this.useStash = bl;
    }

    public void setV1Stash(boolean bl) {
        this.useV1Stash = bl;
    }

    public boolean isUseStash() {
        return this.useStash;
    }

    public boolean isUseV1Stash() {
        return this.useV1Stash;
    }
}

