/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.DTFJContext;
import com.ibm.java.diagnostics.utils.plugins.PackageFilteredClassloader;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginManagerLocator {
    private static final URLClassLoader asmExtendedClassLoader;
    private static final Logger logger;

    public static PluginManager getManager() {
        try {
            Class<?> loaderClass = Class.forName("com.ibm.java.diagnostics.utils.plugins.impl.PluginManagerImpl", true, asmExtendedClassLoader);
            Method method = loaderClass.getDeclaredMethod("getPluginManager", null);
            return (PluginManager)method.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Problem initialising DTFJ plugin classloader: " + e.getMessage());
            logger.log(Level.FINEST, "Problem initialising DTFJ plugin classloader: ", e);
            return null;
        }
    }

    private static URL[] getASMURLs() {
        if (System.getProperty("com.ibm.java.diagnostics.nopackagefilter") != null) {
            return new URL[0];
        }
        ArrayList<File> files = new ArrayList<File>();
        String javaHome = System.getProperty("java.home", "");
        ArrayList<URL> urls = new ArrayList<URL>();
        files.add(new File(javaHome, "lib/ext/dtfj.jar"));
        for (File file : files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.log(Level.FINE, "Problem locating necessary libraries: " + e.getMessage());
                logger.log(Level.FINEST, "Problem locating necessary libraries: ", e);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    static {
        logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
        URL[] urls = PluginManagerLocator.getASMURLs();
        asmExtendedClassLoader = new PackageFilteredClassloader(urls, DTFJContext.class.getClassLoader());
    }
}

