/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import java.util.Properties;

public class JCImagePointer
implements ImagePointer {
    private final long fUnderlyingAddress;
    private final JCImageAddressSpace fResidentDomain;
    private static final String MEMORY_READ_ERROR = "Can't read into ImageAddressSpace yet";

    public JCImagePointer(JCImageAddressSpace resident, long localAddress) throws JCInvalidArgumentsException {
        if (resident == null) {
            throw new JCInvalidArgumentsException("An image pointer must have an associated address space");
        }
        if (!resident.isValidAddressID(localAddress)) {
            throw new JCInvalidArgumentsException("Invalid address 0x" + Long.toHexString(localAddress));
        }
        this.fUnderlyingAddress = localAddress;
        this.fResidentDomain = resident;
    }

    @Override
    public ImagePointer add(long offset) {
        return this.fResidentDomain.getPointer(this.fUnderlyingAddress + offset);
    }

    @Override
    public long getAddress() {
        return this.fUnderlyingAddress;
    }

    @Override
    public ImageAddressSpace getAddressSpace() {
        return this.fResidentDomain;
    }

    @Override
    public ImagePointer getPointerAt(long index) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(index + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public short getShortAt(long index) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(index + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public boolean isExecutable() throws DataUnavailable {
        throw new DataUnavailable();
    }

    @Override
    public boolean isReadOnly() throws DataUnavailable {
        throw new DataUnavailable();
    }

    @Override
    public boolean isShared() throws DataUnavailable {
        throw new DataUnavailable();
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public byte getByteAt(long index) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(index + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public double getDoubleAt(long index) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(index + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public float getFloatAt(long index) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(index + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public int getIntAt(long index) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(index + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public long getLongAt(long index) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(index + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.fResidentDomain == null ? 0 : this.fResidentDomain.hashCode());
        result = 31 * result + (int)(this.fUnderlyingAddress ^ this.fUnderlyingAddress >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JCImagePointer other = (JCImagePointer)obj;
        if (this.fResidentDomain == null ? other.fResidentDomain != null : !this.fResidentDomain.equals(other.fResidentDomain)) {
            return false;
        }
        return this.fUnderlyingAddress == other.fUnderlyingAddress;
    }
}

