/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.MemoryAccessException;
import java.util.Properties;

public class ImagePointer
implements com.ibm.dtfj.image.ImagePointer {
    private long _underlyingAddress;
    private com.ibm.dtfj.image.j9.ImageAddressSpace _residentDomain;

    public ImagePointer(com.ibm.dtfj.image.j9.ImageAddressSpace resident, long localAddress) {
        if (null == resident) {
            throw new IllegalArgumentException("Pointer cannot exist in null address space");
        }
        this._residentDomain = resident;
        this._underlyingAddress = localAddress;
    }

    @Override
    public long getAddress() {
        return this._underlyingAddress;
    }

    @Override
    public ImageAddressSpace getAddressSpace() {
        return this._residentDomain;
    }

    @Override
    public com.ibm.dtfj.image.ImagePointer add(long offset) {
        return this._residentDomain.getPointer(this.getAddress() + offset);
    }

    @Override
    public boolean isExecutable() throws DataUnavailable {
        return this._residentDomain.isExecutableAt(this._underlyingAddress);
    }

    @Override
    public boolean isReadOnly() throws DataUnavailable {
        return this._residentDomain.isReadOnly(this._underlyingAddress);
    }

    @Override
    public boolean isShared() throws DataUnavailable {
        return this._residentDomain.isShared(this._underlyingAddress);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public com.ibm.dtfj.image.ImagePointer getPointerAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readPointerAtIndex(this.getAddress() + index);
    }

    @Override
    public long getLongAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readLongAtIndex(this.getAddress() + index);
    }

    @Override
    public int getIntAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readIntAtIndex(this.getAddress() + index);
    }

    @Override
    public short getShortAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readShortAtIndex(this.getAddress() + index);
    }

    @Override
    public byte getByteAt(long index) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readByteAtIndex(this.getAddress() + index);
    }

    @Override
    public float getFloatAt(long index) throws MemoryAccessException, CorruptDataException {
        return Float.intBitsToFloat(this.getIntAt(index));
    }

    @Override
    public double getDoubleAt(long index) throws MemoryAccessException, CorruptDataException {
        return Double.longBitsToDouble(this.getLongAt(index));
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof ImagePointer) {
            ImagePointer local = (ImagePointer)obj;
            isEqual = this._residentDomain.equals(local._residentDomain) && this._underlyingAddress == local._underlyingAddress;
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        return this._residentDomain.hashCode() ^ ((int)this._underlyingAddress ^ (int)(this._underlyingAddress >> 32));
    }

    public String toString() {
        return Long.toHexString(this._underlyingAddress);
    }
}

