/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import com.ibm.jzos.ZFile;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class ClosingFileReader
extends ImageInputStreamImpl
implements ResourceReleaser {
    private static final int PAGE_SIZE = 4096;
    private static final int BUFFER_PAGES = 4;
    private static final int BUFFER_SIZE = 16384;
    private IRandomAccessFile _file;
    private File _fileRef;
    private byte[] _buffer = new byte[16384];
    private long _bufferBase = -1L;
    private long _bufferEnd = -1L;
    private boolean deleteOnClose = false;
    private int _page_size = 4096;

    public ClosingFileReader(File file) throws IOException {
        this._fileRef = file;
        try {
            this._file = new BaseRandomAccessFile(this._fileRef, "r");
        }
        catch (FileNotFoundException e1) {
            try {
                ZosRandomAccessFile zosFile = new ZosRandomAccessFile(this._fileRef, "r");
                this._file = zosFile;
                this._page_size = zosFile._recordLength;
                this._buffer = new byte[4 * this._page_size];
            }
            catch (FileNotFoundException e2) {
                FileNotFoundException e = new FileNotFoundException("z/OS file not found");
                e.initCause(e2);
                throw e;
            }
        }
    }

    public ClosingFileReader(ImageInputStream file) throws IOException {
        this._file = new StreamRandomAccessFile(file);
    }

    public ClosingFileReader(File file, boolean deleteOnCloseOrExit) throws IOException {
        this(file);
        if (deleteOnCloseOrExit) {
            this.deleteOnClose = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        ClosingFileReader.this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] buffer = new byte[n];
        this.readFully(buffer);
        return buffer;
    }

    @Override
    public int readInt() throws IOException {
        byte[] buffer = new byte[4];
        this.readFully(buffer);
        return (int)(((long)buffer[0] & 0xFFL) << 24 | ((long)buffer[1] & 0xFFL) << 16 | ((long)buffer[2] & 0xFFL) << 8 | (long)buffer[3] & 0xFFL);
    }

    @Override
    public void seek(long position) throws IOException {
        this.streamPos = position;
    }

    @Override
    public long readLong() throws IOException {
        byte[] buffer = new byte[8];
        this.readFully(buffer);
        return ((long)buffer[0] & 0xFFL) << 56 | ((long)buffer[1] & 0xFFL) << 48 | ((long)buffer[2] & 0xFFL) << 40 | ((long)buffer[3] & 0xFFL) << 32 | ((long)buffer[4] & 0xFFL) << 24 | ((long)buffer[5] & 0xFFL) << 16 | ((long)buffer[6] & 0xFFL) << 8 | (long)buffer[7] & 0xFFL;
    }

    @Override
    public short readShort() throws IOException {
        byte[] buffer = new byte[2];
        this.readFully(buffer);
        return (short)((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF);
    }

    @Override
    public byte readByte() throws IOException {
        byte[] buffer = new byte[1];
        this.readFully(buffer);
        return buffer[0];
    }

    @Override
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void readFully(byte[] buffer) throws IOException {
        int didRead;
        for (int x = 0; x < buffer.length; x += didRead) {
            int chunk = Math.min(this._buffer.length, buffer.length - x);
            didRead = this.read(buffer, x, chunk);
            if (didRead > 0) continue;
            throw new EOFException("Read " + x + " bytes ");
        }
    }

    @Override
    public int read(byte[] buffer, int bStart, int length) throws IOException {
        int readSize = 0;
        try {
            if (-1L == this._bufferBase) {
                this._recache();
            }
            long bLow = this._bufferBase;
            long bHigh = this._bufferEnd;
            long fLow = this.streamPos;
            long fHigh = this.streamPos + (long)length;
            long overlapStart = Math.max(bLow, fLow);
            long overlapEnd = Math.min(bHigh, fHigh);
            if (overlapEnd <= overlapStart || this.streamPos < this._bufferBase) {
                this._recache();
                bLow = this._bufferBase;
                bHigh = this._bufferEnd;
                overlapStart = Math.max(bLow, fLow);
                overlapEnd = Math.min(bHigh, fHigh);
            }
            int offset = (int)(overlapStart - this._bufferBase);
            readSize = (int)(overlapEnd - overlapStart);
            try {
                System.arraycopy(this._buffer, offset, buffer, bStart, readSize);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ArrayIndexOutOfBoundsException e1 = new ArrayIndexOutOfBoundsException("System.arraycopy(" + this._buffer + " length=" + this._buffer.length + "," + offset + "," + buffer + " length=" + buffer.length + "," + bStart + "," + readSize + ")");
                e1.initCause(e);
                throw e1;
            }
            this.streamPos += (long)readSize;
            if (readSize == 0 && length > 0) {
                readSize = -1;
            }
        }
        catch (EOFException e) {
            readSize = -1;
        }
        return readSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _recache() throws IOException {
        long aligned;
        long fileLength = this._file.length();
        if (fileLength != -1L && fileLength <= this.streamPos) throw new EOFException("trying to cache beyond end of file");
        long offset = this.streamPos % (long)this._page_size;
        this._bufferBase = aligned = this.streamPos - offset;
        this._bufferEnd = aligned;
        try {
            this._file.seek(aligned);
            this._file.readFully(this._buffer);
            this._bufferEnd = aligned + (long)this._buffer.length;
            return;
        }
        catch (EORFException e) {
            this._file.seek(aligned);
            this._file.readFully(this._buffer, 0, e.bytesRead);
            this._bufferEnd = aligned + (long)e.bytesRead;
            return;
        }
        catch (EOFException e) {
            int r;
            if (fileLength != -1L) {
                this._bufferEnd = fileLength;
                this._file.seek(aligned);
                this._file.readFully(this._buffer, 0, (int)(this._bufferEnd - aligned));
                return;
            }
            this._file.seek(aligned);
            this._bufferEnd = aligned;
            for (int i = 0; i < this._buffer.length && (r = this._file.read()) != -1; ++i) {
                this._buffer[i] = (byte)r;
                ++this._bufferEnd;
            }
            if (this._bufferEnd != aligned) return;
            throw new EOFException("trying to cache beyond end of file");
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int r = this.read(b);
        if (r < 0) {
            return r;
        }
        return b[0] & 0xFF;
    }

    @Override
    public long length() {
        try {
            return this._file.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public void close() throws IOException {
        this._file.close();
        if (this.deleteOnClose) {
            this._fileRef.delete();
        }
    }

    public InputStream streamFromFile() throws FileNotFoundException {
        return new FileInputStream(this._fileRef);
    }

    public URI getURIOfFile() {
        return this._fileRef.toURI();
    }

    public String getAbsolutePath() {
        if (this._fileRef == null) {
            return null;
        }
        return this._fileRef.getAbsolutePath();
    }

    public boolean isMVSFile() {
        return this._file instanceof ZosRandomAccessFile;
    }

    @Override
    public void releaseResources() throws IOException {
        this.close();
    }

    private static class BaseRandomAccessFile
    implements IRandomAccessFile {
        private RandomAccessFile _file;

        public BaseRandomAccessFile(File file, String mode) throws FileNotFoundException {
            this._file = new RandomAccessFile(file, mode);
        }

        @Override
        public void close() throws IOException {
            this._file.close();
        }

        @Override
        public long length() throws IOException {
            return this._file.length();
        }

        @Override
        public int read() throws IOException {
            return this._file.read();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this._file.readFully(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this._file.readFully(b, off, len);
        }

        @Override
        public void seek(long pos) throws IOException {
            this._file.seek(pos);
        }
    }

    private static class EORFException
    extends EOFException {
        private static final long serialVersionUID = 1L;
        public int bytesRead;

        public EORFException(int n) {
            this.bytesRead = n;
        }
    }

    private static interface IRandomAccessFile {
        public void close() throws IOException;

        public long length() throws IOException;

        public int read() throws IOException;

        public void readFully(byte[] var1) throws IOException;

        public void readFully(byte[] var1, int var2, int var3) throws IOException;

        public void seek(long var1) throws IOException;
    }

    private static class StreamRandomAccessFile
    implements IRandomAccessFile {
        private ImageInputStream _file;

        public StreamRandomAccessFile(ImageInputStream file) {
            this._file = file;
        }

        @Override
        public void close() throws IOException {
            this._file.close();
        }

        @Override
        public long length() throws IOException {
            return this._file.length();
        }

        @Override
        public int read() throws IOException {
            return this._file.read();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            int nbytes;
            int sofar = 0;
            do {
                if ((nbytes = this._file.read(b, off + sofar, len - sofar)) > 0) continue;
                throw new EOFException();
            } while ((sofar += nbytes) < len);
        }

        @Override
        public void seek(long pos) throws IOException {
            this._file.seek(pos);
        }
    }

    private static class ZosRandomAccessFile
    implements IRandomAccessFile {
        private ZFile _zFile;
        private byte[] _recordBuffer = null;
        private int _recordLength;
        private long _seekOffset = 0L;
        private long _recordNumber = 0L;
        private long _bufferValid = 0L;

        public ZosRandomAccessFile(File file, String mode) throws IOException {
            try {
                this._zFile = new ZFile("//'" + file.getName() + "'", "rb,type=record");
                this._recordLength = this._zFile.getLrecl();
                this._recordBuffer = new byte[this._recordLength];
            }
            catch (IOException e) {
                throw new FileNotFoundException(e.toString());
            }
            catch (LinkageError e) {
                throw new FileNotFoundException(e.toString());
            }
        }

        @Override
        public void close() throws IOException {
            this._zFile.close();
        }

        @Override
        public long length() throws IOException {
            return -1L;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            try {
                this.readFully(b);
                return b[0] & 0xFF;
            }
            catch (EOFException e) {
                return -1;
            }
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            int sofar = 0;
            while (sofar < len) {
                if (this._seekOffset != 0L || len - sofar < this._recordLength) {
                    long nbytes;
                    long l = nbytes = this._bufferValid > 0L ? this._bufferValid : (long)this._zFile.read(this._recordBuffer);
                    if (nbytes < this._seekOffset) {
                        throw new EORFException(sofar);
                    }
                    long tocopy = nbytes - this._seekOffset;
                    if (tocopy > (long)(len - sofar)) {
                        System.arraycopy(this._recordBuffer, (int)this._seekOffset, b, off + sofar, len - sofar);
                        sofar = len;
                        this._seekOffset += (long)sofar;
                        this._bufferValid = nbytes;
                        continue;
                    }
                    System.arraycopy(this._recordBuffer, (int)this._seekOffset, b, off + sofar, (int)tocopy);
                    sofar = (int)((long)sofar + tocopy);
                    ++this._recordNumber;
                    this._seekOffset = 0L;
                    this._bufferValid = 0L;
                    continue;
                }
                int nbytes = this._zFile.read(b, off + sofar, len - sofar);
                if (nbytes < 0) {
                    throw new EORFException(sofar);
                }
                ++this._recordNumber;
                sofar += nbytes;
            }
        }

        @Override
        public void seek(long pos) throws IOException {
            long newRecordNumber = pos / (long)this._recordLength;
            if (newRecordNumber != this._recordNumber) {
                this._zFile.seek(newRecordNumber, 0);
                this._recordNumber = newRecordNumber;
                this._bufferValid = 0L;
            }
            this._seekOffset = pos % (long)this._recordLength;
        }
    }
}

