/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

class CanonicalPath {
    private String cpath = null;
    private String orig_path = null;
    private boolean orig_dir = false;
    private boolean cpath_set = false;

    public CanonicalPath() {
    }

    public CanonicalPath(String string, boolean bl) {
        this.init_cpath(string, bl);
    }

    public CanonicalPath(String string, boolean bl, boolean bl2) {
        if (bl2) {
            this.init_cpath(string, bl);
        } else {
            this.orig_path = string;
            this.orig_dir = bl;
        }
    }

    private void init_cpath(String string, boolean bl) {
        final boolean bl2 = bl;
        this.cpath = string;
        int n = this.cpath.length();
        if (n == 0) {
            this.cpath = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
        }
        this.cpath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    int n;
                    File file = new File(CanonicalPath.this.cpath);
                    String string = file.getCanonicalPath();
                    if (bl2 && ((n = string.length()) == 0 || string.charAt(n - 1) != File.separatorChar)) {
                        return string + File.separator;
                    }
                    return string;
                }
                catch (IOException iOException) {
                    return CanonicalPath.this.cpath;
                }
            }
        });
        this.cpath_set = true;
        this.orig_path = null;
    }

    public int hashCode() {
        if (!this.cpath_set) {
            this.init_cpath(this.orig_path, this.orig_dir);
        }
        return this.cpath.hashCode();
    }

    boolean equals(CanonicalPath canonicalPath) {
        return this.cpath.equals(canonicalPath.cpath);
    }

    boolean startsWith(CanonicalPath canonicalPath) {
        return this.cpath.length() >= canonicalPath.cpath.length() && this.cpath.startsWith(canonicalPath.cpath);
    }

    boolean startsWithAndLonger(CanonicalPath canonicalPath) {
        return this.cpath.length() > canonicalPath.cpath.length() && this.cpath.startsWith(canonicalPath.cpath);
    }

    boolean hasBaseDir(CanonicalPath canonicalPath) {
        int n = this.cpath.lastIndexOf(File.separatorChar);
        if (n == -1) {
            return false;
        }
        return canonicalPath.cpath.length() == n + 1 && canonicalPath.cpath.regionMatches(0, this.cpath, 0, n + 1);
    }
}

